/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.ide.util.Assert;
import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadInfo;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

final class DebugJDIMonitorInfo
implements DebugMonitorInfo {
    DebugJDI dj;
    ObjectReference or;
    int stoppedCount;
    private int hashCode;

    DebugJDIMonitorInfo(DebugJDI dj, ObjectReference or) {
        this.dj = dj;
        this.or = or;
        this.stoppedCount = dj.stoppedCount;
    }

    @Override
    public boolean hasExpired() {
        return this.dj.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new DataExpiredException();
        }
    }

    @Override
    public boolean isClassMonitor() {
        return this.or instanceof ClassObjectReference;
    }

    @Override
    public boolean isInstanceMonitor() {
        return !(this.or instanceof ClassObjectReference);
    }

    @Override
    public int getEntryCount() {
        this.throwIfExpired();
        try {
            return this.or.entryCount();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public int getWaiterCount() {
        this.throwIfExpired();
        try {
            int countWaiting = 0;
            List<ThreadReference> threads = this.or.waitingThreads();
            for (int i = 0; i < threads.size(); ++i) {
                ThreadReference tr = threads.get(i);
                if (tr.status() != 4) continue;
                ++countWaiting;
            }
            List otherThreads = this.dj.getOtherWaitingThreads(this.or);
            if (otherThreads != null) {
                for (int i = 0; i < otherThreads.size(); ++i) {
                    ThreadReference tr = (ThreadReference)otherThreads.get(i);
                    if (threads.contains(tr)) continue;
                    ++countWaiting;
                }
            }
            return countWaiting;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public DebugThreadInfo getOwnerThread() {
        this.throwIfExpired();
        try {
            ThreadReference tr = this.or.owningThread();
            if (tr != null) {
                return DebugJDIThreadInfo.makeThreadInfo(this.dj, tr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public DebugThreadInfo[] listWaitingThreads() {
        this.throwIfExpired();
        try {
            ArrayList<DebugJDIThreadInfo> v = new ArrayList<DebugJDIThreadInfo>();
            List<ThreadReference> threads = this.or.waitingThreads();
            for (int i = 0; i < threads.size(); ++i) {
                ThreadReference tr = threads.get(i);
                if (tr.status() != 4) continue;
                v.add(DebugJDIThreadInfo.makeThreadInfo(this.dj, tr));
            }
            List otherThreads = this.dj.getOtherWaitingThreads(this.or);
            if (otherThreads != null) {
                for (int i = 0; i < otherThreads.size(); ++i) {
                    ThreadReference tr = (ThreadReference)otherThreads.get(i);
                    if (threads.contains(tr)) continue;
                    v.add(DebugJDIThreadInfo.makeThreadInfo(this.dj, tr));
                }
            }
            DebugThreadInfo[] array = new DebugThreadInfo[v.size()];
            return v.toArray(array);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DebugThreadInfo[0];
        }
    }

    @Override
    public DebugThreadInfo[] listBlockedThreads() {
        this.throwIfExpired();
        try {
            List<ThreadReference> threads = this.or.waitingThreads();
            ArrayList<DebugJDIThreadInfo> v = new ArrayList<DebugJDIThreadInfo>();
            for (int i = 0; i < threads.size(); ++i) {
                ThreadReference tr = threads.get(i);
                if (tr.status() != 3) continue;
                v.add(DebugJDIThreadInfo.makeThreadInfo(this.dj, tr));
            }
            DebugThreadInfo[] array = new DebugThreadInfo[v.size()];
            return v.toArray(array);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DebugThreadInfo[0];
        }
    }

    @Override
    public DebugDataCompositeInfo getAssociatedObject() {
        this.throwIfExpired();
        return (DebugDataCompositeInfo)((Object)this.dj.makeData(this.or, null));
    }

    @Override
    public DebugLocation getEntryLocation() {
        return null;
    }

    @Override
    public boolean canDoNotify() {
        try {
            if (this.dj.eventThread != null && this.dj.eventThread == this.or.owningThread()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void doNotify() {
        this.invokeNotify("notify");
    }

    @Override
    public void doNotifyAll() {
        this.invokeNotify("notifyAll");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeNotify(String methodName) {
        Method method;
        DebugJDIClassInfo objectClass;
        if (this.canDoNotify() && (objectClass = this.dj.findClassByName("java.lang.Object", false)) != null && objectClass.type instanceof ClassType && (method = ((ClassType)objectClass.type).concreteMethodByName(methodName, "()V")) != null) {
            Object object = this.dj.methodCallLock;
            synchronized (object) {
                List prev = this.dj.tempDisableRequests();
                Log logger = JDebugger.logger;
                try {
                    DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
                    if (dbgSettings.isDetectMethodEvalDeadlocks()) {
                        this.dj.startMethodEvaluationWorker();
                        DebugJDI.MethodEvaluationWorker worker = this.dj.methodEvaluationWorker;
                        worker.or = this.or;
                        worker.methodEvaluationType = DebugJDI.MethodEvaluationType.VIRTUAL_CALL;
                        worker.dj = this.dj;
                        worker.m = method;
                        worker.argList = Collections.EMPTY_LIST;
                        try {
                            this.dj.evaluateMethodCheckForHang();
                        }
                        catch (Exception ex) {}
                    } else {
                        try {
                            if (logger.isEnabled()) {
                                ClassType ctClass = (ClassType)this.or.referenceType();
                                logger.trace("Invoking method: {0}.{1}", (Object)(ctClass != null ? ctClass.name() : "<unknown>"), (Object)method.name());
                            }
                            int flag = DebugJDI.MULTI_THREADED_METHOD_EVALUATIONS ? 0 : 1;
                            this.or.invokeMethod(this.dj.eventThread, method, Collections.EMPTY_LIST, flag);
                        }
                        catch (Exception e) {
                            Assert.printStackTrace((Throwable)e);
                        }
                    }
                    logger.trace("Method return is void");
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this.dj);
                    this.dj.tempReenableRequests(prev);
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.or.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIMonitorInfo) {
            DebugJDIMonitorInfo other = (DebugJDIMonitorInfo)o;
            return this.or.equals(other.or);
        }
        return false;
    }
}

