/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;

final class DebugJDIThreadGroupInfo
extends JDIInformationProvider
implements DebugThreadGroupInfo {
    DebugJDI dj;
    ThreadGroupReference tgr;
    int stoppedCount;
    private int hashCode;

    DebugJDIThreadGroupInfo(DebugJDI dj, ThreadGroupReference tgr) {
        this.dj = dj;
        this.tgr = tgr;
        this.stoppedCount = dj.stoppedCount;
    }

    @Override
    public boolean hasExpired() {
        return this.stoppedCount != this.dj.stoppedCount;
    }

    @Override
    public String getName() {
        return this.tgr.name();
    }

    @Override
    public DebugDataObjectInfo getThreadGroupObject() {
        return (DebugDataObjectInfo)((Object)this.dj.makeData(this.tgr, null));
    }

    @Override
    public DebugThreadGroupInfo getParent() {
        ThreadGroupReference parent = this.tgr.parent();
        if (parent == null) {
            return null;
        }
        return new DebugJDIThreadGroupInfo(this.dj, parent);
    }

    @Override
    public DebugThreadGroupInfo[] listGroups() {
        List<ThreadGroupReference> groups = this.tgr.threadGroups();
        DebugThreadGroupInfo[] a = new DebugThreadGroupInfo[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            a[i] = new DebugJDIThreadGroupInfo(this.dj, groups.get(i));
        }
        return a;
    }

    @Override
    public DebugThreadInfo[] listThreads() {
        List<ThreadReference> threads = this.tgr.threads();
        DebugThreadInfo[] a = new DebugThreadInfo[threads.size()];
        for (int i = 0; i < threads.size(); ++i) {
            a[i] = DebugJDIThreadInfo.makeThreadInfo(this.dj, threads.get(i));
        }
        return a;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.tgr.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIThreadGroupInfo) {
            DebugJDIThreadGroupInfo other = (DebugJDIThreadGroupInfo)o;
            return this.tgr.equals(other.tgr);
        }
        return false;
    }

    @Override
    public Value getJDIValue() {
        return this.tgr;
    }
}

