/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.LongType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.event.MethodExitEvent;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassLoaderInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMethodInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMonitorInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadGroupInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedDisassemble;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugRegisterInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.debugger.support.MethodVisitationInfoRetrievalKey;
import oracle.jdevimpl.debugger.support.TargetMethod;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

final class DebugJDIThreadInfo
extends JDIInformationProvider
implements DebugThreadInfo {
    private static final String CONSTR_NAME = "<init>";
    private static final String EMPTY_PARAM_SIGNATURE = "()";
    DebugJDI dj;
    ThreadReference tr;
    boolean suspended;
    boolean interruptRequested = false;
    boolean debuggerStopped = false;
    private int hashCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DebugJDIThreadInfo makeThreadInfo(DebugJDI dj, ThreadReference tr) {
        Map<ThreadReference, SoftReference<DebugJDIThreadInfo>> map = dj.threadInfos;
        synchronized (map) {
            DebugJDIThreadInfo threadInfo;
            SoftReference<DebugJDIThreadInfo> soft = dj.threadInfos.get(tr);
            if (soft != null && (threadInfo = soft.get()) != null) {
                return threadInfo;
            }
            threadInfo = new DebugJDIThreadInfo(dj, tr);
            dj.threadInfos.put(tr, new SoftReference<DebugJDIThreadInfo>(threadInfo));
            return threadInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getThreadContextClassLoaders(DebugJDI dj) {
        Map<ThreadReference, SoftReference<DebugJDIThreadInfo>> map = dj.threadInfos;
        synchronized (map) {
            if (dj.stoppedCountThreadContextClassLoaders == dj.stoppedCount) {
                return;
            }
            ArrayList<ThreadReference> temp = new ArrayList<ThreadReference>();
            Iterator<ThreadReference> i = dj.threadInfos.keySet().iterator();
            while (i.hasNext()) {
                temp.add(i.next());
            }
            for (ThreadReference tr : temp) {
                DebugJDIThreadInfo threadInfo = DebugJDIThreadInfo.makeThreadInfo(dj, tr);
                threadInfo.getContextClassLoader();
            }
            dj.stoppedCountThreadContextClassLoaders = dj.stoppedCount;
        }
    }

    private DebugJDIThreadInfo(DebugJDI dj, ThreadReference tr) {
        this.dj = dj;
        this.tr = tr;
    }

    @Override
    public boolean hasExited() {
        try {
            return this.tr.status() == 0;
        }
        catch (VMDisconnectedException e) {
            return true;
        }
        catch (ObjectCollectedException e) {
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public long getThreadId() {
        return this.tr.uniqueID();
    }

    @Override
    public String getName() {
        try {
            return this.tr.name();
        }
        catch (ObjectCollectedException e) {
            return "";
        }
        catch (IllegalThreadStateException e) {
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getGroupName() {
        return this.tr.threadGroup().name();
    }

    @Override
    public DebugThreadGroupInfo getThreadGroup() {
        return new DebugJDIThreadGroupInfo(this.dj, this.tr.threadGroup());
    }

    @Override
    public int getStatus() {
        try {
            switch (this.tr.status()) {
                default: {
                    return 0;
                }
                case 5: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
                case 1: {
                    return 5;
                }
                case 0: 
            }
            return 6;
        }
        catch (ObjectCollectedException e) {
            return 6;
        }
        catch (IllegalThreadStateException e) {
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean isThreadSuspended() {
        return this.suspended;
    }

    @Override
    public void suspendThread() {
        if (!this.suspended) {
            this.suspended = true;
            this.tr.suspend();
        }
    }

    @Override
    public void resumeThread() {
        if (this.suspended) {
            this.suspended = false;
            this.tr.resume();
        }
    }

    @Override
    public void interruptThread() {
        if (this.interruptRequested) {
            return;
        }
        if (this.suspended) {
            this.suspended = false;
            this.tr.resume();
        }
        this.interruptRequested = true;
        this.tr.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopThread() {
        DebugJDIClassInfo classInfo = (DebugJDIClassInfo)this.dj.findFirstClassByName("java.lang.Throwable");
        if (classInfo == null) {
            DebugClassInfo[] list = this.dj.listClasses();
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].getName().equals("java.lang.Throwable")) continue;
                classInfo = (DebugJDIClassInfo)list[i];
                break;
            }
        }
        if (classInfo != null) {
            DebugMethodInfo[] meths = classInfo.getMethods();
            DebugJDIMethodInfo meth = null;
            for (int i = 0; i < meths.length; ++i) {
                if (!meths[i].getNameWithoutClassOrSignature().equals(CONSTR_NAME) || !meths[i].getParameterSignature().equals(EMPTY_PARAM_SIGNATURE)) continue;
                meth = (DebugJDIMethodInfo)meths[i];
                break;
            }
            if (meth != null) {
                this.debuggerStopped = true;
                Type type = ((DebugJDIClassInfo)meth.getClassInfo()).getJDIType();
                if (type instanceof ClassType) {
                    ClassType ct = (ClassType)type;
                    ObjectReference or = null;
                    Object object = this.dj.methodCallLock;
                    synchronized (object) {
                        block22: {
                            List prev = this.dj.tempDisableRequests();
                            try {
                                DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
                                if (dbgSettings.isDetectMethodEvalDeadlocks()) {
                                    this.dj.startMethodEvaluationWorker();
                                    DebugJDI.MethodEvaluationWorker worker = this.dj.methodEvaluationWorker;
                                    worker.ct = ct;
                                    worker.methodEvaluationType = DebugJDI.MethodEvaluationType.NEW_INSTANCE;
                                    worker.dj = this.dj;
                                    worker.m = meth.getJDIMethod();
                                    worker.argList = Collections.emptyList();
                                    try {
                                        or = (ObjectReference)this.dj.evaluateMethodCheckForHang();
                                    }
                                    catch (Exception ex) {}
                                    break block22;
                                }
                                Log logger = JDebugger.logger;
                                if (logger.isEnabled()) {
                                    logger.trace("Invoking newInstance method: {0}.{1}", (Object)ct.name(), (Object)meth.getJDIMethod().name());
                                }
                                int flag = DebugJDI.MULTI_THREADED_METHOD_EVALUATIONS ? 0 : 1;
                                try {
                                    or = ct.newInstance(this.tr, meth.getJDIMethod(), Collections.emptyList(), flag);
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                if (logger.isEnabled()) {
                                    logger.trace("Method return is {0}", (Object)(or == null ? "null" : "not null"));
                                }
                            }
                            finally {
                                DebugJDIStackFrameInfo.rebuildCache(this.dj);
                                this.dj.tempReenableRequests(prev);
                            }
                        }
                    }
                    if (or != null) {
                        try {
                            this.tr.stop(or);
                        }
                        catch (InvalidTypeException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    @Override
    public DebugDataObjectInfo getThreadObject() {
        return (DebugDataObjectInfo)((Object)this.dj.makeData(this.tr, null));
    }

    @Override
    public void stepInto() {
        this.dj.stepInto(this);
    }

    @Override
    public void stepOver() {
        this.dj.stepOver(this);
    }

    @Override
    public void stepIntoBC() {
        this.dj.stepIntoBC(this);
    }

    @Override
    public void stepOverBC() {
        this.dj.stepOverBC(this);
    }

    @Override
    public void stepOut() {
        this.dj.stepOut(this);
    }

    @Override
    public boolean isAtEndOfMethod() {
        try {
            short opcode;
            StackFrame sf = this.tr.frame(0);
            Location location = sf.location();
            Method m = location.method();
            long bc = location.codeIndex();
            byte[] bytecodes = m.bytecodes();
            if (bc >= 0L && bc < (long)bytecodes.length && DebugSharedDisassemble.isReturnBytecode(opcode = (short)(bytecodes[(int)bc] & 0xFF))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void stepToEndOfMethod() {
        this.dj.stepToEndOfMethod(this);
    }

    @Override
    public void stepIntoMethod(String methodName, String callerPackage, String callerFileName, int callerLine) {
        this.dj.stepIntoMethod(this, methodName, callerPackage, callerFileName, callerLine);
    }

    @Override
    public MethodVisitationInfoRetrievalKey stepIntoMethod(TargetMethod targetMethod, Map<TargetMethod, TargetMethod.VisitationTrackingInfo> methodsToTrack) {
        return this.dj.stepIntoMethod(this, targetMethod, methodsToTrack);
    }

    @Override
    public Map<TargetMethod, TargetMethod.VisitationTrackingInfo> getMethodVisitationInfo(MethodVisitationInfoRetrievalKey key) {
        return this.dj.getMethodVisitationInfo(key);
    }

    @Override
    public void clearMethodVisitationInfo(MethodVisitationInfoRetrievalKey retrievalKey) {
        this.dj.clearMethodVisitationInfo(retrievalKey);
    }

    @Override
    public int getStackFrameCount() {
        try {
            return this.tr.frameCount();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public DebugStackFrameInfo getStackFrame(int frame) {
        try {
            if (frame < this.tr.frameCount()) {
                return DebugJDIStackFrameInfo.makeStackFrameInfo(this.dj, this, frame, this.tr.frame(frame));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public DebugStackFrameInfo[] listStack() {
        try {
            List<StackFrame> frames = this.tr.frames();
            int size = frames.size();
            DebugStackFrameInfo[] a = new DebugStackFrameInfo[size];
            for (int i = 0; i < size; ++i) {
                a[i] = DebugJDIStackFrameInfo.makeStackFrameInfo(this.dj, this, i, frames.get(i));
            }
            return a;
        }
        catch (Throwable throwable) {
            return new DebugStackFrameInfo[0];
        }
    }

    @Override
    public DebugMonitorInfo[] listOwnedMonitors() {
        if (this.dj.canGetMonitors()) {
            try {
                List<ObjectReference> monitors = this.tr.ownedMonitors();
                DebugMonitorInfo[] a = new DebugMonitorInfo[monitors.size()];
                for (int i = 0; i < monitors.size(); ++i) {
                    ObjectReference or = monitors.get(i);
                    a[i] = new DebugJDIMonitorInfo(this.dj, or);
                }
                return a;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new DebugMonitorInfo[0];
    }

    @Override
    public DebugMonitorInfo getMonitorThreadWaitingFor() {
        if (this.dj.canGetMonitors()) {
            try {
                ObjectReference or = this.dj.getWaitMonitor(this.tr);
                if (or != null) {
                    return new DebugJDIMonitorInfo(this.dj, or);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public DebugMonitorInfo getMonitorThreadBlockedFor() {
        if (this.dj.canGetMonitors()) {
            try {
                ObjectReference or;
                if (this.tr.status() == 3 && (or = this.tr.currentContendedMonitor()) != null) {
                    return new DebugJDIMonitorInfo(this.dj, or);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public DebugRegisterInfo[] listRegisters() {
        return new DebugRegisterInfo[0];
    }

    @Override
    public DebugRegisterInfo[] listFloatRegisters() {
        return new DebugRegisterInfo[0];
    }

    @Override
    public DebugVariableInfo getReturnValue() {
        return this.getReturnOrReturnedValue(false);
    }

    @Override
    public DebugVariableInfo getReturnedValue() {
        return this.getReturnOrReturnedValue(true);
    }

    private DebugVariableInfo getReturnOrReturnedValue(boolean isReturned) {
        if (this.tr == null) {
            return null;
        }
        try {
            Value retVal;
            Value value = retVal = isReturned ? this.dj.getReturnedValueForThread(this.tr.uniqueID()) : this.dj.getReturnValueForThread(this.tr.uniqueID());
            if (retVal != null) {
                MethodExitEvent meeForThread = this.dj.getMethodExitEventForThread(this.tr.uniqueID());
                DebugJDIDataInfo dataReturnedDataInfo = this.dj.makeData(retVal, null);
                return this.makeReturnOrReturnedVariableInfo(meeForThread, dataReturnedDataInfo, isReturned);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean setLocation(DebugLocation location) {
        return false;
    }

    @Override
    public DebugDataObjectInfo getContextClassLoaderObject() {
        return DebugShared.getContextClassLoaderObject(this);
    }

    @Override
    public DebugClassLoaderInfo getContextClassLoader() {
        DebugJDIDataObjectInfo classLoaderObject = (DebugJDIDataObjectInfo)this.getContextClassLoaderObject();
        if (classLoaderObject != null) {
            ClassLoaderReference clr = (ClassLoaderReference)classLoaderObject.value;
            return DebugJDIClassLoaderInfo.makeClassLoaderInfo(this.dj, clr);
        }
        return null;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.tr.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIThreadInfo) {
            DebugJDIThreadInfo other = (DebugJDIThreadInfo)o;
            return this.tr.equals(other.tr);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache(DebugJDI dj, boolean stopped) {
        Map<ThreadReference, SoftReference<DebugJDIThreadInfo>> map = dj.threadInfos;
        synchronized (map) {
            ArrayList<ThreadReference> list = new ArrayList<ThreadReference>();
            boolean removeCollectedThreads = stopped && dj.isConnected();
            for (Map.Entry<ThreadReference, SoftReference<DebugJDIThreadInfo>> entry : dj.threadInfos.entrySet()) {
                ThreadReference tr = entry.getKey();
                if (removeCollectedThreads && dj.isObjectCollected(tr)) {
                    list.add(tr);
                    continue;
                }
                SoftReference<DebugJDIThreadInfo> soft = entry.getValue();
                if (soft == null) continue;
                DebugJDIThreadInfo threadInfo = soft.get();
                if (threadInfo == null) {
                    list.add(tr);
                    continue;
                }
                threadInfo.interruptRequested = false;
            }
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                dj.threadInfos.remove(list.get(i));
            }
        }
    }

    @Override
    public boolean isThreadInterrupted() {
        return this.interruptRequested;
    }

    @Override
    public boolean isThreadDebuggerStopped() {
        return this.debuggerStopped;
    }

    private DebugVariableInfo makeReturnOrReturnedVariableInfo(MethodExitEvent mee, DebugDataInfo dataInfo, boolean isReturned) {
        Method m = mee.method();
        return new ReturnDebugVariableInfo(m, dataInfo, isReturned);
    }

    @Override
    public Value getJDIValue() {
        return this.tr;
    }

    @Override
    public boolean canDebuggerStopThread() {
        try {
            if (this.dj.eventThread != null && this.dj.eventThread == this.tr) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    class ReturnDebugVariableInfo
    implements DebugVariableInfo {
        private boolean isReturned = false;
        private Method m;
        private DebugDataInfo dataInfo;

        ReturnDebugVariableInfo(Method m, DebugDataInfo dataInfo, boolean isReturned) {
            this.isReturned = isReturned;
            this.m = m;
            this.dataInfo = dataInfo;
        }

        private void throwIfExpired() {
            if (this.hasExpired()) {
                throw new DataExpiredException();
            }
        }

        @Override
        public boolean hasExpired() {
            return this.dataInfo.hasExpired();
        }

        @Override
        public DebugClassInfo getClassInfo() {
            this.throwIfExpired();
            try {
                return DebugJDIThreadInfo.this.dj.findClassByType(this.m.returnType());
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public String getGenericSignature() {
            this.throwIfExpired();
            return this.m.genericSignature();
        }

        @Override
        public String getName() {
            if (this.isReturned()) {
                return this.m.name();
            }
            return "";
        }

        @Override
        public boolean isInScope() {
            return true;
        }

        @Override
        public boolean isArgument() {
            return false;
        }

        @Override
        public boolean isLocal() {
            return false;
        }

        @Override
        public boolean isReturn() {
            return !this.isReturned;
        }

        @Override
        public boolean isReturned() {
            return this.isReturned;
        }

        @Override
        public DebugDataInfo getDataInfo() {
            this.throwIfExpired();
            return this.dataInfo;
        }

        @Override
        public int getSlotSize() {
            this.throwIfExpired();
            try {
                Type type = this.m.returnType();
                if (type instanceof LongType || type instanceof DoubleType) {
                    return 2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 1;
        }
    }
}

