/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.shared;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

public final class GenericSignature {
    private final boolean showPackage;
    private final ReadTextBuffer buffer;
    private final JavaLexer lexer;
    private int curToken;

    public static String processTypeArguments(String genericSignature, boolean showPackage) {
        try {
            return new GenericSignature(genericSignature, showPackage).parseTypeArguments_opt0();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String processGenericSignature(String genericSignature, boolean showPackage) {
        try {
            return new GenericSignature(genericSignature, showPackage).parseTypeSignature0();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private GenericSignature(String genericSignature, boolean showPackage) {
        this.buffer = TextBufferFactory.createReadTextBuffer((String)genericSignature);
        this.showPackage = showPackage;
        this.lexer = new JavaLexer(JdkVersion.JDK_1_5);
        this.lexer.setTextBuffer(this.buffer);
        this.lexer.setPosition(0);
        this.skipToken();
    }

    private void nextToken(short tk) {
        if (this.curToken == tk) {
            this.skipToken();
        } else {
            this.error();
        }
    }

    private void nextToken(short tk1, short tk2) {
        if (this.curToken == tk1 || this.curToken == tk2) {
            this.skipToken();
        } else {
            this.error();
        }
    }

    private boolean optionalToken(short tk) {
        if (this.curToken != tk) {
            return false;
        }
        this.skipToken();
        return true;
    }

    private boolean optionalToken(short tk1, short tk2) {
        if (this.curToken != tk1 && this.curToken != tk2) {
            return false;
        }
        this.skipToken();
        return true;
    }

    private void skipToken() {
        this.curToken = this.lexer.lex();
    }

    private final String getToken(short tk) {
        if (this.curToken == tk) {
            int nameStart = this.lexer.getStartOffset();
            int nameEnd = this.lexer.getEndOffset();
            String name = this.buffer.getString(nameStart, nameEnd - nameStart);
            this.skipToken();
            return name;
        }
        this.error();
        return null;
    }

    private String parseTypeArgument0() {
        switch (this.curToken) {
            case 63: {
                this.skipToken();
                return "*";
            }
            case 67: {
                this.skipToken();
                break;
            }
            case 59: {
                this.skipToken();
            }
        }
        return this.parseTypeSignature0();
    }

    private String parseTypeArguments_opt0() {
        StringBuffer sb = new StringBuffer();
        if (this.optionalToken((short)58)) {
            ArrayList<String> arguments = new ArrayList<String>();
            while (this.curToken != 46 && this.curToken != 0) {
                arguments.add(this.parseTypeArgument0());
            }
            this.nextToken((short)46);
            sb.append("<");
            Iterator it = arguments.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                sb.append(s);
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            sb.append(">");
        }
        return sb.toString();
    }

    private String parseTypeSignature0() {
        int start = this.lexer.getStartOffset();
        if (start == -1) {
            GenericSignature.panic("No token");
        }
        char ch = this.buffer.getChar(start);
        this.lexer.setPosition(start + 1);
        this.skipToken();
        switch (ch) {
            case 'L': {
                int i;
                int nameEnd;
                StringBuffer sb = new StringBuffer();
                int nameStart = start + 1;
                do {
                    if (this.curToken != 4) {
                        this.error();
                    }
                    nameEnd = this.lexer.getEndOffset();
                    this.skipToken();
                } while (this.optionalToken((short)41));
                String name = this.buffer.getString(nameStart, nameEnd - nameStart);
                name = name.replace('/', '.');
                if (!this.showPackage && (i = name.lastIndexOf(46)) != -1) {
                    name = name.substring(i + 1);
                }
                sb.append(name);
                sb.append(this.parseTypeArguments_opt0());
                while (this.optionalToken((short)43)) {
                    sb.append("$");
                    sb.append(this.getToken((short)4));
                    sb.append(this.parseTypeArguments_opt0());
                }
                this.nextToken((short)75);
                return sb.toString();
            }
            case 'T': {
                StringBuffer sb = new StringBuffer();
                int nameStart = start + 1;
                if (this.curToken != 4) {
                    this.error();
                }
                int nameEnd = this.lexer.getEndOffset();
                String name = this.buffer.getString(nameStart, nameEnd - nameStart);
                this.skipToken();
                this.nextToken((short)75);
                sb.append(name);
                return sb.toString();
            }
            case '[': {
                StringBuffer sb = new StringBuffer();
                sb.append(this.parseTypeSignature0());
                sb.append("[]");
                return sb.toString();
            }
        }
        if (ch < 'A' || 'Z' < ch) {
            this.error();
        }
        PrimitiveType primitive = PrimitiveType.PRIMITIVE_alpha[ch - 65];
        if (this.optionalToken((short)38)) {
            return this.parseTypeSignature0();
        }
        return primitive.getName();
    }

    private void error() {
        String message = this.buffer.getString(0, this.buffer.getLength());
        GenericSignature.panic(message);
    }

    private static void panic(String message) {
        throw new IllegalStateException(message);
    }
}

