/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.support;

public class TargetMethod {
    private String methodName;
    private String callerPackage;
    private String callerFile;
    private int callerLine;

    public TargetMethod(String methodName, String callerPackage, String callerFile, int callerLine) {
        this.methodName = methodName;
        this.callerPackage = callerPackage;
        this.callerFile = callerFile;
        this.callerLine = callerLine;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getCallerPackage() {
        return this.callerPackage;
    }

    public String getCallerFile() {
        return this.callerFile;
    }

    public String getCallerFileMinusExtension() {
        return this.callerFile.replaceAll(".java", "");
    }

    public int getCallerLine() {
        return this.callerLine;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TargetMethod)) {
            return false;
        }
        TargetMethod om = (TargetMethod)other;
        return om.methodName.equals(this.methodName) && om.callerPackage.equals(this.callerPackage) && om.callerFile.equals(this.callerFile) && om.callerLine == this.callerLine;
    }

    public int hashCode() {
        return this.callerFile.hashCode() + this.methodName.hashCode() + this.callerLine;
    }

    public String toString() {
        return this.callerPackage + "." + this.callerFile + "." + this.methodName + ":" + this.callerLine;
    }

    public static class VisitationTrackingInfo {
        private int occurrencesOnLine = 1;
        private int occurrencesExecuted = 0;
        private int occurrenceToStopAt = -1;

        public VisitationTrackingInfo(boolean stop) {
            if (stop) {
                this.occurrenceToStopAt = 0;
            }
        }

        public int getNumberOfOccurrences() {
            return this.occurrencesOnLine;
        }

        public void incrementOccurrences() {
            ++this.occurrencesOnLine;
        }

        public int getStopAtOccurrence() {
            return this.occurrenceToStopAt;
        }

        public void setStopAtOccurence(int occurrenceToStopAt) {
            this.occurrenceToStopAt = occurrenceToStopAt;
        }

        public int getVisitationCount() {
            return this.occurrencesExecuted;
        }

        public void incrementVisitationCount() {
            ++this.occurrencesExecuted;
        }

        public String toString() {
            return "Occurences: " + this.occurrencesOnLine + " Seen: " + this.occurrencesExecuted + " Stop: " + this.occurrenceToStopAt;
        }
    }
}

