/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ideimpl.runner.StarterFactoryDescriptionImpl;
import oracle.javatools.data.HashStructure;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaNode;
import oracle.jdevimpl.java.annotation.AnnotationSearcher;
import oracle.jdevimpl.java.annotation.HookJavaAnnotation;

public final class JavaStarterFactoryDescription
extends StarterFactoryDescriptionImpl {
    private static final String JAVA_SUPER_CLASS = "java-has-superclass";
    private static final String JAVA_INTERFACE = "java-has-interface";
    private static final String JAVA_REQUIRED_MODIFIER = "java-has-modifier";
    private static final String JAVA_DISALLOWED_MODIFIER = "java-misses-modifier";
    private static final String JAVA_ANNOTATION = "java-annotation";
    private JavaFile javaFile;

    public JavaStarterFactoryDescription(HashStructure hash, String extensionId) {
        super(hash, extensionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAcceptableNode(Project project, Node node) {
        if (project == null || node == null) {
            return true;
        }
        if (!(node instanceof JavaNode)) {
            return false;
        }
        JavaNode javaNode = (JavaNode)node;
        try {
            if (!this.hasRequiredSuperClass(project, (Node)javaNode)) {
                boolean bl = false;
                return bl;
            }
            if (!this.hasRequiredInterfaces(project, (Node)javaNode)) {
                boolean bl = false;
                return bl;
            }
            if (!this.checkModifiers(true, JAVA_REQUIRED_MODIFIER, project, (Node)javaNode)) {
                boolean bl = false;
                return bl;
            }
            if (!this.checkModifiers(false, JAVA_DISALLOWED_MODIFIER, project, (Node)javaNode)) {
                boolean bl = false;
                return bl;
            }
            if (!this.hasCorrectAnnotations(project, javaNode)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.javaFile = null;
        }
        return true;
    }

    private boolean hasRequiredSuperClass(Project project, Node node) {
        if (this.getHash() == null || !this.getHash().containsKey(JAVA_SUPER_CLASS)) {
            return true;
        }
        List superClassDefs = this.getHash().getAsList(JAVA_SUPER_CLASS);
        for (Object superClassDefObject : superClassDefs) {
            if (!(superClassDefObject instanceof HashStructure)) {
                this.logError("Incorrect java-super-class definition in java-starter-factory");
                return false;
            }
            HashStructure superClassDef = (HashStructure)superClassDefObject;
            String superClass = this.getElementValue(superClassDef, JAVA_SUPER_CLASS);
            if (superClass == null) {
                return false;
            }
            if (this.hasSuperClass(superClass, project, node)) continue;
            return false;
        }
        return true;
    }

    private boolean hasSuperClass(String superClass, Project project, Node node) {
        if (!this.primeJavaFile(project, node)) {
            return false;
        }
        for (JavaClass javaClass = this.javaFile.getPrimaryClass(); javaClass != null; javaClass = javaClass.getSuperclass()) {
            if (!superClass.equals(javaClass.getRawName())) continue;
            return true;
        }
        return false;
    }

    private boolean hasRequiredInterfaces(Project project, Node node) {
        if (this.getHash() == null || !this.getHash().containsKey(JAVA_INTERFACE)) {
            return true;
        }
        List interfaceDefs = this.getHash().getAsList(JAVA_INTERFACE);
        for (Object interfaceDefObject : interfaceDefs) {
            if (!(interfaceDefObject instanceof HashStructure)) {
                this.logError("Incorrect java-interface definition in java-starter-factory");
                return false;
            }
            HashStructure interfaceDef = (HashStructure)interfaceDefObject;
            String interfaceName = this.getElementValue(interfaceDef, JAVA_INTERFACE);
            if (interfaceName == null) {
                return false;
            }
            if (this.hasInterface(interfaceName, project, node)) continue;
            return false;
        }
        return true;
    }

    private boolean hasInterface(String interfaceName, Project project, Node node) {
        if (!this.primeJavaFile(project, node)) {
            return false;
        }
        JavaClass javaClass = this.javaFile.getPrimaryClass();
        if (javaClass == null) {
            return false;
        }
        Set hierarchy = javaClass.getHierarchy();
        for (JavaClass parent : hierarchy) {
            if (!interfaceName.equals(parent.getRawName())) continue;
            return true;
        }
        return false;
    }

    private boolean checkModifiers(boolean required, String key, Project project, Node node) {
        if (this.getHash() == null || !this.getHash().containsKey(key)) {
            return true;
        }
        List modifierDefs = this.getHash().getAsList(key);
        for (Object modifierDefObject : modifierDefs) {
            if (!(modifierDefObject instanceof HashStructure)) {
                this.logError("Incorrect modifier definition in java-starter-factory");
                return false;
            }
            HashStructure modifierDef = (HashStructure)modifierDefObject;
            String modifier = this.getElementValue(modifierDef, key);
            if (modifier == null) {
                return false;
            }
            if (this.checkModifier(modifier, required, project, node)) continue;
            return false;
        }
        return true;
    }

    private boolean checkModifier(String modifier, boolean required, Project project, Node node) {
        if (!this.primeJavaFile(project, node)) {
            return false;
        }
        JavaClass javaClass = this.javaFile.getPrimaryClass();
        if (javaClass == null) {
            return false;
        }
        if ("public".equals(modifier)) {
            if (javaClass.isPublic() != required) {
                return false;
            }
        } else if ("private".equals(modifier)) {
            if (javaClass.isPrivate() != required) {
                return false;
            }
        } else if ("protected".equals(modifier)) {
            if (javaClass.isProtected() != required) {
                return false;
            }
        } else if ("static".equals(modifier)) {
            if (javaClass.isStatic() != required) {
                return false;
            }
        } else if ("final".equals(modifier)) {
            if (javaClass.isFinal() != required) {
                return false;
            }
        } else if ("abstract".equals(modifier)) {
            if (javaClass.isAbstract() != required) {
                return false;
            }
        } else if ("strictfp".equals(modifier)) {
            boolean isStrictfp;
            boolean bl = isStrictfp = (javaClass.getModifiers() & 0x10) != 0;
            if (isStrictfp != required) {
                return false;
            }
        } else {
            this.logError("Incorrect modifier " + modifier + " in java-starter-factory");
            return false;
        }
        return true;
    }

    private boolean hasCorrectAnnotations(Project project, JavaNode javaNode) {
        if (this.getHash() == null || !this.getHash().containsKey(JAVA_ANNOTATION)) {
            return true;
        }
        List annotationDefs = this.getHash().getAsList(JAVA_ANNOTATION);
        ArrayList<HookJavaAnnotation> hookJavaAnnotations = new ArrayList<HookJavaAnnotation>();
        for (Object annotationDefObject : annotationDefs) {
            if (!(annotationDefObject instanceof HashStructure)) {
                this.logError("Incorrect java-annotation definition in java-starter-factory");
                return false;
            }
            HashStructure annotationDef = (HashStructure)annotationDefObject;
            hookJavaAnnotations.add(new HookJavaAnnotation(annotationDef));
        }
        List searchers = AnnotationSearcher.makeSearchers(hookJavaAnnotations);
        JavaManager javaManager = JavaManager.getInstance((Project)project);
        for (AnnotationSearcher searcher : searchers) {
            if (searcher.confirmAnnotations(javaManager, javaNode, true)) continue;
            return false;
        }
        return true;
    }

    private boolean primeJavaFile(Project project, Node node) {
        if (this.javaFile == null) {
            URL url = node.getURL();
            if (url == null) {
                return false;
            }
            JavaManager javaManager = JavaManager.getInstance((Project)project);
            this.javaFile = javaManager.getFile(node.getURL());
        }
        return this.javaFile != null;
    }

    private String getElementValue(HashStructure hash, String elementName) {
        String value = null;
        if (hash.containsKey("#text")) {
            value = hash.getObject("#text").toString();
        }
        if (value == null) {
            this.logError("Missing value for " + elementName + " in java-starter-factory");
        }
        return value;
    }
}

