/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.util.ArrayList;
import java.util.List;
import javax.ide.extension.ElementName;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.runner.StarterFactoryDescription;
import oracle.ide.runner.StarterFactoryProvider;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.runner.JavaStarterFactoryDescription;

public class JavaStarterFactoryHook
implements StarterFactoryProvider {
    private static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension/runner", "java-starter-factory-hook");
    private HashStructureHook hashStructureHook;
    private List<StarterFactoryDescription> newStarterFactories;
    private static final String ELEMENT_NAME = "java-starter-factory";

    public synchronized List<StarterFactoryDescription> getNewStarterFactories() {
        this.primeHook();
        ArrayList<StarterFactoryDescription> factories = new ArrayList<StarterFactoryDescription>(this.newStarterFactories);
        this.newStarterFactories.clear();
        return factories;
    }

    private void primeHook() {
        if (this.hashStructureHook == null) {
            this.newStarterFactories = new ArrayList<StarterFactoryDescription>();
            this.hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(HOOK_NAME);
            if (this.hashStructureHook == null) {
                return;
            }
            this.hashStructureHook.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    JavaStarterFactoryHook.this.addItemsFromHook(e.getNewElementHashStructure());
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    JavaStarterFactoryHook.this.addItemsFromHook(e.getCombinedHashStructure());
                }
            });
        }
    }

    private synchronized void addItemsFromHook(HashStructure hashStructure) {
        List definitions = hashStructure.getAsList(ELEMENT_NAME);
        if (definitions != null && definitions.size() > 0) {
            for (Object definition : definitions) {
                HashStructure defHash = (HashStructure)definition;
                String extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                JavaStarterFactoryDescription desc = new JavaStarterFactoryDescription(defHash, extensionId);
                if (desc.getTargetClassName() == null || desc.getStarterFactoryClassName() == null) continue;
                this.newStarterFactories.add((StarterFactoryDescription)desc);
            }
        }
    }
}

