/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.DbgArb;

final class AdjustRangeDialog
extends JPanel
implements ChangeListener {
    private JEWTDialog dlg;
    private int arrayStart;
    private int arrayCount;
    private int start;
    private int count;
    private NumericSpinBox startBox;
    private NumericSpinBox countBox;

    static AdjustRangeDialog showAdjustRangeDialog(String type, String name, int arrayStart, int arrayCount, int start, int count) {
        String title = DbgArb.getString(481);
        AdjustRangeDialog panel = new AdjustRangeDialog(type, name, arrayStart, arrayCount, start, count);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.startBox, (String)title);
        panel.setJEWTDialog(dlg);
        dlg.setOKButtonEnabled(panel.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_deb_adjustrangedialog_html");
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            return panel;
        }
        return null;
    }

    private AdjustRangeDialog(String type, String name, int arrayStart, int arrayCount, int start, int count) {
        super(new GridBagLayout());
        this.arrayStart = arrayStart;
        this.arrayCount = arrayCount;
        this.start = start;
        this.count = count;
        JLabel typeNameLabel = new JLabel(type + " " + name);
        JLabel previousStartLabel = new JLabel(DbgArb.getString(482));
        JLabel previousStartBox = new JLabel(Integer.toString(start), 4);
        JLabel previousCountLabel = new JLabel(DbgArb.getString(483));
        JLabel previousCountBox = new JLabel(Integer.toString(count), 4);
        JLabel startLabel = new JLabel();
        JLabel countLabel = new JLabel();
        if (arrayCount == -1) {
            this.startBox = new NumericSpinBox(arrayStart, Integer.MAX_VALUE);
            this.countBox = new NumericSpinBox(0, Integer.MAX_VALUE);
        } else {
            this.startBox = new NumericSpinBox(arrayStart, arrayStart + arrayCount - 1);
            this.countBox = new NumericSpinBox(0, arrayCount);
        }
        ResourceUtils.resLabel((JLabel)startLabel, (Component)this.startBox, (String)DbgArb.getString(484));
        ResourceUtils.resLabel((JLabel)countLabel, (Component)this.countBox, (String)DbgArb.getString(485));
        this.startBox.setIntValue(start);
        this.countBox.setIntValue(count);
        SpinBuddy buddy = this.startBox.getSpinBuddy();
        if (buddy instanceof JTextField) {
            ((JTextField)buddy).setHorizontalAlignment(4);
        }
        if ((buddy = this.countBox.getSpinBuddy()) instanceof JTextField) {
            ((JTextField)buddy).setHorizontalAlignment(4);
        }
        int widthOfSpinButton = 0;
        if (buddy instanceof Component) {
            int widthOfSpinBox = this.countBox.getPreferredSize().width;
            int widthOfSpinBuddy = ((Component)buddy).getPreferredSize().width;
            widthOfSpinButton = widthOfSpinBox - widthOfSpinBuddy;
        }
        int y = 0;
        this.add((Component)typeNameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)previousStartLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)previousStartBox, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 5 + widthOfSpinButton), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(2, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)previousCountLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)previousCountBox, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 5 + widthOfSpinButton), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(2, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)startLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.startBox, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
        this.add((Component)countLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.countBox, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.startBox.addChangeListener((ChangeListener)this);
        this.countBox.addChangeListener((ChangeListener)this);
    }

    private void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
    }

    private boolean canOk() {
        if (this.start >= this.arrayStart && this.count >= 0) {
            if (this.arrayCount == -1) {
                return true;
            }
            if (this.start + this.count <= this.arrayCount) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.startBox) {
            this.start = this.startBox.getIntValue();
            this.dlg.setOKButtonEnabled(this.canOk());
        } else if (source == this.countBox) {
            this.count = this.countBox.getIntValue();
            this.dlg.setOKButtonEnabled(this.canOk());
        }
    }

    int getStart() {
        return this.start;
    }

    int getCount() {
        return this.count;
    }
}

