/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import javax.swing.JPanel;
import oracle.ide.runner.DebuggerBreakpoint;
import oracle.ide.runner.DebuggerBreakpointPanel;
import oracle.jdevimpl.debugger.Breakpoint;
import oracle.jdevimpl.runner.debug.ExtenderBreakpoint;
import oracle.jdevimpl.runner.debug.ExtenderCallback;
import oracle.jdevimpl.runner.debug.ExtenderManager;

class BreakpointDefinitionPanel {
    private DebuggerBreakpointPanel dbp;
    private Breakpoint existingBp;
    private ExtenderCallback callback;

    BreakpointDefinitionPanel(DebuggerBreakpointPanel dbp, Breakpoint existingBp, ExtenderCallback callback) {
        this.dbp = dbp;
        this.existingBp = existingBp;
        this.callback = callback;
    }

    JPanel getPanel() {
        return this.dbp.getPanel();
    }

    String canOk() {
        return this.dbp.canOk();
    }

    boolean veto() {
        return this.dbp.veto();
    }

    Breakpoint onOk() {
        DebuggerBreakpoint debuggerBreakpoint = this.dbp.onOk();
        if (debuggerBreakpoint != null) {
            Breakpoint newBp = ExtenderManager.createBreakpoint(debuggerBreakpoint, null, this.callback.getExtenderId());
            if (this.existingBp == null) {
                ExtenderBreakpoint extenderBp = new ExtenderBreakpoint(newBp);
                this.callback.addExtenderBreakpoint(extenderBp);
                return newBp;
            }
            this.existingBp.copyInto(newBp);
            return this.existingBp;
        }
        return null;
    }
}

