/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.ClassesWindowSettings;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

public final class ClassesWindowSettingsPanel
extends DefaultTraversablePanel
implements ItemListener,
ActionListener {
    private JCheckBox showClassLoadersCheckBox;
    private JRadioButton showClassLoadersTreeRadio;
    private JRadioButton showClassLoadersListRadio;
    private JCheckBox showPackagesCheckBox;
    private JRadioButton showPackagesTreeRadio;
    private JRadioButton showPackagesListRadio;
    private JLabel sortLabel;
    private JComboBox sortColumnComboBox;
    private JCheckBox sortAscendingCheckBox;
    private JComboBox vmChooser;
    private JLabel vmChooserLabel;
    private MultiLineLabel disclaimerLabel;
    private transient ClassesWindowSettings settings;
    private JPanel spacer;
    private JPanel optionPanel;
    private JPanel chooseColumnsPanel;
    private JCheckBox[] showColumnCheckBoxes;
    private Map<String, boolean[]> showColumnsMap = new HashMap<String, boolean[]>();

    public ClassesWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_classwinsetpanel_html");
        this.setLayout(new GridBagLayout());
        this.showColumnCheckBoxes = new JCheckBox[4];
        for (int i = 0; i < 4; ++i) {
            this.showColumnCheckBoxes[i] = new JCheckBox();
            this.showColumnCheckBoxes[i].addActionListener(this);
        }
        this.showClassLoadersCheckBox = new JCheckBox();
        this.showClassLoadersTreeRadio = new JRadioButton();
        this.showClassLoadersListRadio = new JRadioButton();
        this.showPackagesCheckBox = new JCheckBox();
        this.showPackagesTreeRadio = new JRadioButton();
        this.showPackagesListRadio = new JRadioButton();
        this.sortLabel = new JLabel();
        this.sortColumnComboBox = new JComboBox();
        this.sortAscendingCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.showClassLoadersCheckBox, (String)DbgArb.getString(698));
        this.showClassLoadersCheckBox.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this.showClassLoadersTreeRadio, (String)DbgArb.getString(699));
        ResourceUtils.resButton((AbstractButton)this.showClassLoadersListRadio, (String)DbgArb.getString(700));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.showClassLoadersTreeRadio);
        buttonGroup2.add(this.showClassLoadersListRadio);
        ResourceUtils.resButton((AbstractButton)this.showPackagesCheckBox, (String)DbgArb.getString(695));
        this.showPackagesCheckBox.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this.showPackagesTreeRadio, (String)DbgArb.getString(696));
        ResourceUtils.resButton((AbstractButton)this.showPackagesListRadio, (String)DbgArb.getString(697));
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.showPackagesTreeRadio);
        buttonGroup1.add(this.showPackagesListRadio);
        ResourceUtils.resLabel((JLabel)this.sortLabel, (Component)this.sortColumnComboBox, (String)DbgArb.getString(701));
        Object[] sortColumns = new String[3];
        int i = 0;
        sortColumns[i++] = DbgArb.getString(510);
        sortColumns[i++] = DbgArb.getString(511);
        sortColumns[i++] = DbgArb.getString(513);
        this.sortColumnComboBox.setModel(new NonNullableComboBoxModel(sortColumns));
        ResourceUtils.resButton((AbstractButton)this.sortAscendingCheckBox, (String)DbgArb.getString(702));
        this.spacer = new JPanel();
        this.optionPanel = new JPanel(new GridBagLayout());
        this.chooseColumnsPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        this.disclaimerLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), DbgArb.format(852, DbgArb.getString(505)));
        this.vmChooser = new JComboBox();
        this.vmChooserLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.vmChooserLabel, (Component)this.vmChooser, (String)DbgArb.getString(851));
    }

    private JPanel makeChooseColumnsPanel(String vmName, Insets borderInsets) {
        this.chooseColumnsPanel.removeAll();
        TitledBorder border = BorderFactory.createTitledBorder(RunMgrArb.getString(91));
        this.chooseColumnsPanel.setBorder(border);
        if (borderInsets != null) {
            Insets temp = border.getBorderInsets(this.chooseColumnsPanel);
            borderInsets.top = temp.top;
            borderInsets.left = temp.left;
            borderInsets.bottom = temp.bottom;
            borderInsets.right = temp.right;
        }
        boolean[] columnsVisible = this.showColumnsMap.get(vmName);
        HashStructure hash = this.settings.getHash();
        List<String> columnNames = WindowSettingsColumnManager.getColumnNamesInPreferences(hash, vmName);
        for (int i = 0; i < columnNames.size(); ++i) {
            if (columnNames.get(i) == null) continue;
            ResourceUtils.resButton((AbstractButton)this.showColumnCheckBoxes[i], (String)columnNames.get(i));
            this.showColumnCheckBoxes[i].setSelected(columnsVisible[i]);
            this.chooseColumnsPanel.add(this.showColumnCheckBoxes[i]);
        }
        return this.chooseColumnsPanel;
    }

    private JPanel makeMiscPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridLayout(0, 2, 0, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(0, borderInsets.left, 0, borderInsets.right));
        JPanel panel1 = new JPanel(new GridBagLayout());
        int y = 0;
        panel1.add((Component)this.showClassLoadersCheckBox, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel1.add((Component)new JLabel(), new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel1.add((Component)this.showClassLoadersTreeRadio, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 5), 0, 0));
        panel1.add((Component)this.showClassLoadersListRadio, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 5), 0, 0));
        panel.add(panel1);
        JPanel panel2 = new JPanel(new GridBagLayout());
        y = 0;
        panel2.add((Component)this.showPackagesCheckBox, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel2.add((Component)new JLabel(), new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel2.add((Component)this.showPackagesTreeRadio, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 5), 0, 0));
        panel2.add((Component)this.showPackagesListRadio, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 5), 0, 0));
        panel.add(panel2);
        return panel;
    }

    private JPanel makeSortPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, borderInsets.left, 0, borderInsets.right));
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
        panel.add((Component)this.sortLabel, constraints);
        ++constraints.gridx;
        panel.add((Component)this.sortColumnComboBox, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        panel.add((Component)this.sortAscendingCheckBox, constraints);
        return panel;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.showClassLoadersCheckBox) {
            this.enableClassLoadersRadios();
        } else if (source == this.showPackagesCheckBox) {
            this.enablePackagesRadios();
        }
    }

    private void enableClassLoadersRadios() {
        boolean enable = this.showClassLoadersCheckBox.isSelected();
        this.showClassLoadersTreeRadio.setEnabled(enable);
        this.showClassLoadersListRadio.setEnabled(enable);
    }

    private void enablePackagesRadios() {
        boolean enable = this.showPackagesCheckBox.isSelected();
        this.showPackagesTreeRadio.setEnabled(enable);
        this.showPackagesListRadio.setEnabled(enable);
    }

    private ClassesWindowSettings getSettings(TraversableContext tc) {
        return ClassesWindowSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        this.settings = this.getSettings(tc);
        HashStructure hash = this.settings.getHash();
        this.showColumnsMap.clear();
        this.removeAll();
        this.add((Component)this.disclaimerLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(6, 0, 16, 0), 0, 0));
        this.vmChooser.removeActionListener(this);
        this.vmChooser.removeAllItems();
        int y = 1;
        List<String> vmNames = WindowSettingsColumnManager.getVMNames(hash);
        if (vmNames.size() > 0) {
            for (String vmName : vmNames) {
                this.vmChooser.addItem(vmName);
                boolean[] visibilities = new boolean[4];
                for (int j = 0; j < 4; ++j) {
                    visibilities[j] = WindowSettingsColumnManager.getColumnVisible(hash, vmName, j);
                }
                this.showColumnsMap.put(vmName, visibilities);
            }
            this.vmChooser.setEditable(false);
            if (vmNames.size() > 1) {
                this.add(this.vmChooserLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 8, 8), 0, 0));
                this.add(this.vmChooser, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 8, 0), 0, 0));
            }
            this.add(this.optionPanel, new GridBagConstraints(0, y++, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            Insets borderInsets = new Insets(0, 0, 0, 0);
            this.add(this.makeMiscPanel(borderInsets), new GridBagConstraints(0, y++, 18, 1, 1.0, 0.0, 17, 2, new Insets(15, 5, 0, 5), 0, 0));
            this.add(this.makeSortPanel(borderInsets), new GridBagConstraints(0, y++, 18, 1, 1.0, 0.0, 17, 2, new Insets(15, 5, 0, 5), 0, 0));
            this.add(new JLabel(), new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.vmChooser.addActionListener(this);
            this.vmChooser.setSelectedIndex(0);
            for (int i = 0; i < 4; ++i) {
                this.showColumnCheckBoxes[i].addActionListener(this);
            }
        } else {
            this.add(this.spacer, new GridBagConstraints(0, y, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.showClassLoadersCheckBox.setSelected(this.settings.isShowClassLoaders());
        if (this.settings.isShowClassLoadersAsTree()) {
            this.showClassLoadersTreeRadio.setSelected(true);
        } else {
            this.showClassLoadersListRadio.setSelected(true);
        }
        this.enableClassLoadersRadios();
        this.showPackagesCheckBox.setSelected(this.settings.isShowPackages());
        if (this.settings.isShowPackagesAsTree()) {
            this.showPackagesTreeRadio.setSelected(true);
        } else {
            this.showPackagesListRadio.setSelected(true);
        }
        this.enablePackagesRadios();
        int savedIndex = this.settings.getSortColumn();
        if (savedIndex == 3) {
            savedIndex = 2;
        }
        if (savedIndex > this.sortColumnComboBox.getItemCount()) {
            this.sortColumnComboBox.setSelectedIndex(0);
        } else {
            this.sortColumnComboBox.setSelectedIndex(savedIndex);
        }
        this.sortAscendingCheckBox.setSelected(this.settings.isSortAscending());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        ClassesWindowSettings settings = this.getSettings(tc);
        HashStructure hash = settings.getHash();
        for (String vmName : this.showColumnsMap.keySet()) {
            boolean[] columnVisibilities = this.showColumnsMap.get(vmName);
            for (int i = 0; i < columnVisibilities.length; ++i) {
                WindowSettingsColumnManager.setColumnVisible(hash, vmName, i, columnVisibilities[i]);
            }
        }
        for (int i = 0; i < 4; ++i) {
            this.showColumnCheckBoxes[i].removeActionListener(this);
        }
        settings.setShowClassLoaders(this.showClassLoadersCheckBox.isSelected());
        settings.setShowClassLoadersAsTree(this.showClassLoadersTreeRadio.isSelected());
        settings.setShowPackages(this.showPackagesCheckBox.isSelected());
        settings.setShowPackagesAsTree(this.showPackagesTreeRadio.isSelected());
        int sortColumn = this.sortColumnComboBox.getSelectedIndex();
        if (sortColumn != -1) {
            if (sortColumn >= 2) {
                ++sortColumn;
            }
            settings.setSortColumn(sortColumn);
        }
        settings.setSortAscending(this.sortAscendingCheckBox.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.vmChooser && this.vmChooser.getSelectedIndex() != -1) {
            String newVM = this.vmChooser.getSelectedItem().toString();
            String window = DbgArb.getString(505);
            String title = DbgArb.format(853, window, newVM);
            TitledBorder border = BorderFactory.createTitledBorder(title);
            this.optionPanel.setBorder(border);
            this.optionPanel.removeAll();
            int y = 0;
            Insets borderInsets = new Insets(0, 0, 0, 0);
            this.optionPanel.add((Component)this.makeChooseColumnsPanel(newVM, borderInsets), new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        } else {
            for (int i = 0; i < this.showColumnCheckBoxes.length; ++i) {
                if (e.getSource() != this.showColumnCheckBoxes[i]) continue;
                String currentVM = this.vmChooser.getSelectedItem().toString();
                boolean[] visibilities = this.showColumnsMap.get(currentVM);
                visibilities[i] = this.showColumnCheckBoxes[i].isSelected();
                break;
            }
        }
    }
}

