/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import com.sun.jdi.Field;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.EventObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.view.View;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

class ContextBuilder {
    ContextBuilder() {
    }

    static Context buildContext(Element element, View view, EventObject event, DebuggingProcess debuggingProcess) {
        return ContextBuilder.buildContext(element, view, event, debuggingProcess, null);
    }

    static Context buildContext(Element element, View view, EventObject event, DebuggingProcess debuggingProcess, JDIInformationProvider jdiInformationProvider) {
        Workspace workspace = null;
        Project project = null;
        if (debuggingProcess != null) {
            workspace = debuggingProcess.getWorkspace();
            project = debuggingProcess.getProject();
        }
        Context context = ContextBuilder.buildContext(element, view, event, workspace, project);
        if (jdiInformationProvider != null) {
            ContextBuilder.addJDIInformation(context, jdiInformationProvider);
        }
        return context;
    }

    static Context buildContext(Element element, View view, EventObject event, Workspace workspace, Project project) {
        Context context = Context.newIdeContext((Element)element);
        if (view != null) {
            context.setView(view);
        }
        if (event != null) {
            context.setEvent(event);
        }
        if (workspace != null && workspace != Ide.getDefaultWorkspace()) {
            context.setWorkspace(workspace);
        }
        if (project != null && project != Ide.getDefaultProject()) {
            context.setProject(project);
        }
        return context;
    }

    static void addJDIInformation(Context context, JDIInformationProvider jdiInformationProvider) {
        Value value;
        Type type;
        StackFrame stackFrame;
        Method method;
        Location location;
        LocalVariable localVariable;
        Field field = jdiInformationProvider.getJDIField();
        if (field != null) {
            context.setProperty("com.sun.jdi.Field", (Object)field);
        }
        if ((localVariable = jdiInformationProvider.getJDILocalVariable()) != null) {
            context.setProperty("com.sun.jdi.LocalVariable", (Object)localVariable);
        }
        if ((location = jdiInformationProvider.getJDILocation()) != null) {
            context.setProperty("com.sun.jdi.Location", (Object)location);
        }
        if ((method = jdiInformationProvider.getJDIMethod()) != null) {
            context.setProperty("com.sun.jdi.Method", (Object)method);
        }
        if ((stackFrame = jdiInformationProvider.getJDIStackFrame()) != null) {
            context.setProperty("com.sun.jdi.StackFrame", (Object)stackFrame);
        }
        if ((type = jdiInformationProvider.getJDIType()) != null) {
            context.setProperty("com.sun.jdi.Type", (Object)type);
        }
        if ((value = jdiInformationProvider.getJDIValue()) != null) {
            context.setProperty("com.sun.jdi.Value", (Object)value);
        }
    }
}

