/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import com.sun.jdi.VMDisconnectedException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.jdevimpl.runner.debug.DataInfoPath;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataTreeTableModel;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

final class DataPanelExpansionTracker
implements TreeExpansionListener {
    private List<DataInfoPath> expanded = Collections.synchronizedList(new ArrayList());
    private JTree tree;
    private DataTreeTableModel model;

    DataPanelExpansionTracker(JTree tree, DataTreeTableModel model) {
        this.tree = tree;
        this.model = model;
        model.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                final TreePath treePath = new TreePath(e.getPath());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DataPanelExpansionTracker.this.restoreExpanded(treePath);
                    }
                });
            }
        });
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        try {
            this.branchExpanded(event.getPath());
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.branchCollapsed(event.getPath());
    }

    void restoreExpanded(TreePath treePath) {
        if (this.tree.isExpanded(treePath)) {
            Object node = treePath.getLastPathComponent();
            Iterator<DataItem> children = this.model.getChildren(node);
            while (children.hasNext()) {
                DataItem child = children.next();
                TreePath childTreePath = treePath.pathByAddingChild(child);
                DataInfoPath dataInfoPath = DataInfoPath.convertTreePathToDataInfoPath(childTreePath, this.model.getDebuggingProcess());
                if (!this.expanded.contains(dataInfoPath)) continue;
                this.tree.expandPath(childTreePath);
            }
        }
    }

    void branchExpanded(TreePath treePath) {
        DataInfoPath dataInfoPath;
        DataItem dataItem = DataPanel.getDataItemForTreePath(treePath);
        if (dataItem != null) {
            dataItem.setIsExpanded(true);
        }
        if ((dataInfoPath = DataInfoPath.convertTreePathToDataInfoPath(treePath, this.model.getDebuggingProcess())) != null) {
            int i = this.expanded.indexOf(dataInfoPath);
            if (i != -1) {
                this.expanded.remove(i);
            }
            this.expanded.add(dataInfoPath);
            this.restoreExpanded(treePath);
        }
    }

    void branchCollapsed(TreePath treePath) {
        DataInfoPath dataInfoPath;
        DataItem dataItem = DataPanel.getDataItemForTreePath(treePath);
        if (dataItem != null) {
            dataItem.setIsExpanded(false);
        }
        if ((dataInfoPath = DataInfoPath.convertTreePathToDataInfoPath(treePath, this.model.getDebuggingProcess())) != null) {
            this.expanded.remove(dataInfoPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collapseAll() {
        WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
        wc.show();
        try {
            this.collapseAll(new TreePath(this.model.getRoot()));
        }
        finally {
            wc.hide();
        }
    }

    private void collapseAll(TreePath treePath) {
        Object node = treePath.getLastPathComponent();
        Iterator<DataItem> children = this.model.getLazyChildren(node);
        while (children.hasNext()) {
            DataItem child = children.next();
            this.collapseAll(treePath.pathByAddingChild(child));
        }
        if (!node.equals(this.model.getRoot())) {
            this.tree.collapsePath(treePath);
        }
    }

    void removeAll(DebuggingProcess debuggingProcess) {
        ArrayList<DataInfoPath> remove = new ArrayList<DataInfoPath>();
        for (DataInfoPath dataInfoPath : this.expanded) {
            if (dataInfoPath.getDebuggingProcess() != debuggingProcess) continue;
            remove.add(dataInfoPath);
        }
        for (DataInfoPath o : remove) {
            this.expanded.remove(o);
        }
    }
}

