/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.HyperlinkButton;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.jdevimpl.runner.debug.DataArrayNavigationPanel;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataTreeCellRenderer;
import oracle.jdevimpl.runner.debug.DataTreeTableModel;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.VersionedDataItem;

final class DataTableCellRenderer
implements TableCellRenderer {
    private final DataPanel dataPanel;
    private int modelColumn;
    private DataArrayNavigationPanel buttonPanel;
    private DefaultTableCellRenderer defaultRenderer;
    private DefaultTableCellRenderer valueRenderer = new DefaultTableCellRenderer();
    private JPanel valueColumnPanel;
    private int row;
    private HyperlinkButton hyperlinkButton = new HyperlinkButton();
    private JPanel hyperlinkButtonPanel;
    static final Class[] rendererForClasses = new Class[]{String.class, JButton.class};

    DataTableCellRenderer(final DataPanel dataPanel) {
        this.dataPanel = dataPanel;
        this.defaultRenderer = new DefaultTableCellRenderer(){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                return DataTableCellRenderer.this.getToolTipText();
            }
        };
        this.valueColumnPanel = new JPanel(new BorderLayout()){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                int colWidth = dataPanel.getDataTable().getTable().getColumnModel().getColumn(1).getWidth();
                DataItem dataItem = dataPanel.getDataItemForRow(DataTableCellRenderer.this.row);
                DataTableCellRenderer.this.buttonPanel.updatePanel(dataItem);
                DataTableCellRenderer.this.buttonPanel.doLayout();
                Dimension dimension = DataTableCellRenderer.this.buttonPanel.getPreferredSize();
                int xInButtonPanel = mouseEvent.getX() - (colWidth - dimension.width);
                if (xInButtonPanel > 0) {
                    MouseEvent adjustedMe = new MouseEvent(DataTableCellRenderer.this.buttonPanel, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), xInButtonPanel, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    String tooltip = DataTableCellRenderer.this.buttonPanel.getToolTipText(adjustedMe);
                    if (tooltip != null) {
                        return tooltip;
                    }
                }
                return DataTableCellRenderer.this.getToolTipText();
            }
        };
        this.valueColumnPanel.add((Component)this.valueRenderer, "Center");
        this.buttonPanel = new DataArrayNavigationPanel();
        this.buttonPanel.setOpaque(true);
        this.valueColumnPanel.add((Component)this.buttonPanel, "East");
        this.hyperlinkButtonPanel = new JPanel(new BorderLayout(0, 0));
        this.hyperlinkButton.setOpaque(true);
        this.hyperlinkButtonPanel.add((Component)this.hyperlinkButton, "West");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        VersionedDataItem vitem;
        this.row = row;
        this.modelColumn = table.convertColumnIndexToModel(column);
        Component result = this.modelColumn == 1 ? this.valueRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        DataItem dataItem = this.dataPanel.getDataItemForRow(row);
        if (dataItem != null) {
            result.setFont(dataItem.getFont(this.modelColumn));
        }
        String accessibleName = null;
        if (dataItem != null) {
            AccessibleContext ac = result.getAccessibleContext();
            DataTreeTableModel model = this.dataPanel.getModel();
            accessibleName = DataTreeCellRenderer.getAccessibleNameAt((TreeTableModel)model, dataItem, this.modelColumn);
            if (accessibleName != null) {
                ac.setAccessibleName(accessibleName);
            }
        }
        if (this.modelColumn == 1) {
            VersionedDataItem vitem2;
            String dataItemTypeName = null;
            try {
                dataItemTypeName = dataItem.getFullyQualifiedActualType();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (dataItem != null && "java.lang.StackTraceElement".equals(dataItemTypeName)) {
                return this.configureHyperlinkButton(table, dataItem, accessibleName, isSelected);
            }
            this.buttonPanel.setOpaque(true);
            this.buttonPanel.updatePanel(dataItem);
            this.buttonPanel.setForeground(table.getSelectionForeground());
            this.buttonPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            if (accessibleName != null) {
                this.valueColumnPanel.getAccessibleContext().setAccessibleName(accessibleName);
            }
            this.valueRenderer.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            if (dataItem instanceof VersionedDataItem && ((vitem2 = (VersionedDataItem)dataItem).getChange() == VersionedDataItem.Change.ADDED || vitem2.getChange() == VersionedDataItem.Change.CHANGED)) {
                this.valueRenderer.setBackground(isSelected ? JDebugger.changedCellSelectedBackground : JDebugger.changedCellBackground);
                this.valueRenderer.setForeground(JDebugger.changedCellForeground);
                this.buttonPanel.setBackground(isSelected ? JDebugger.changedCellSelectedBackground : JDebugger.changedCellBackground);
            }
            return this.valueColumnPanel;
        }
        result.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        if (dataItem instanceof VersionedDataItem && (vitem = (VersionedDataItem)dataItem).getChange() == VersionedDataItem.Change.ADDED) {
            result.setBackground(isSelected ? JDebugger.changedCellSelectedBackground : JDebugger.changedCellBackground);
            result.setForeground(JDebugger.changedCellForeground);
        }
        return result;
    }

    private JPanel configureHyperlinkButton(JTable table, DataItem dataItem, String accessibleName, boolean isSelected) {
        VersionedDataItem vitem;
        this.hyperlinkButton.setText(dataItem.getValue());
        this.hyperlinkButton.setToolTipText(dataItem.getValue());
        this.hyperlinkButton.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        if (dataItem instanceof VersionedDataItem && (vitem = (VersionedDataItem)dataItem).getChange() == VersionedDataItem.Change.ADDED) {
            this.hyperlinkButton.setBackground(isSelected ? JDebugger.changedCellSelectedBackground : JDebugger.changedCellBackground);
        }
        this.hyperlinkButtonPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        this.hyperlinkButton.setForegroundOnHover(isSelected ? Colors.HYPERLINK_SELECTED_HOVER : Colors.HYPERLINK_HOVER);
        this.hyperlinkButton.setForeground(isSelected ? Colors.HYPERLINK_SELECTED : Colors.HYPERLINK);
        if (accessibleName != null) {
            this.hyperlinkButtonPanel.getAccessibleContext().setAccessibleName(accessibleName);
            this.hyperlinkButton.getAccessibleContext().setAccessibleName(accessibleName);
        }
        return this.hyperlinkButtonPanel;
    }

    private String getToolTipText() {
        DataItem dataItem = this.dataPanel.getDataItemForRow(this.row);
        if (dataItem != null && this.row > -1) {
            TreePath treePath = this.dataPanel.getDataTable().getPathForRow(this.row);
            return dataItem.getToolTip(this.modelColumn, treePath);
        }
        return null;
    }

    void setNavigationButtonsPermitted(boolean navigationButtonsPermitted) {
        this.buttonPanel.setNavigationButtonsPermitted(navigationButtonsPermitted);
    }
}

