/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.VersionedDataItem;

final class DataTreeCellRenderer
extends DefaultTreeCellRenderer {
    private TreePath treePath;
    private DataItem dataItem;

    public DataTreeCellRenderer() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof DataItem) {
            VersionedDataItem vitem;
            this.dataItem = (DataItem)value;
            this.treePath = tree.getPathForRow(row);
            this.setIcon(this.dataItem.getIcon());
            this.setFont(this.dataItem.getFont(0));
            this.setEnabled(!this.dataItem.isUnrelated());
            this.setToolTipText(this.dataItem.getToolTipText());
            this.setOpaque(false);
            if (this.dataItem instanceof VersionedDataItem && (vitem = (VersionedDataItem)this.dataItem).getChange() == VersionedDataItem.Change.ADDED) {
                this.setOpaque(true);
                this.setBackground(sel ? JDebugger.changedCellSelectedBackground : JDebugger.changedCellBackground);
                this.setForeground(JDebugger.changedCellForeground);
            }
            try {
                AccessibleContext ac = this.getAccessibleContext();
                String accessibleName = DataTreeCellRenderer.getAccessibleNameAt((TreeTableModel)tree.getModel(), this.dataItem, 0);
                if (this.dataItem.mayHaveChildren()) {
                    accessibleName = JDebugger.fixTreeCellAccessibleName(accessibleName, expanded);
                }
                if (accessibleName != null) {
                    ac.setAccessibleName(accessibleName);
                }
            }
            catch (DataExpiredException e) {}
        } else {
            this.dataItem = null;
            this.setIcon(null);
            this.setFont(tree.getFont());
            this.setEnabled(true);
            this.setToolTipText(null);
        }
        return this;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.dataItem != null && this.treePath != null) {
            return this.dataItem.getToolTip(0, this.treePath);
        }
        return null;
    }

    void clear() {
        this.treePath = null;
        this.dataItem = null;
    }

    static String getAccessibleNameAt(TreeTableModel model, DataItem dataItem, int column) {
        String value = (String)model.getValueAt((Object)dataItem, column);
        if (value == null || value.length() == 0) {
            value = DbgArb.getString(787);
        }
        return value;
    }
}

