/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.treetable.AbstractTreeTableModel;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.javatools.util.Log;
import oracle.jdeveloper.debugger.support.DebuggerDataWindowOptions;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DataArrayRange;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorDataItem;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.VersionedDataItem;
import oracle.jdevimpl.runner.debug.WatchPanel;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

final class DataTreeTableModel
extends AbstractTreeTableModel {
    private PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    static final String PROPERTY_DATA_ITEM_EXPRESSION = "DataItemExpression";
    private DebuggingProcess debuggingProcess;
    private Map<String, DataArrayRange> arrayRanges = new HashMap<String, DataArrayRange>();
    private List<DataItem> root;
    private int versionedRootDepth;
    private String versionedRootMethodName;
    private DebugLocation versionedRootStateLocation;
    private long versionedRootDebuggeeStoppedCount;
    private Map<String, VersionedDataItem> versionedRoot;
    private Set<DataItem> backgroundLoadsInProgress = new HashSet<DataItem>();
    private DebuggerDataWindowOptions windowOptions = null;
    private DataPanelSettings dataPanelSettings = null;
    private Log logger = JDebugger.logger;

    DataTreeTableModel(List<DataItem> root) {
        super(root);
        this.root = root;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setWindowOptions(DebuggerDataWindowOptions options) {
        this.windowOptions = options;
    }

    public DebuggerDataWindowOptions getWindowOptions() {
        return this.windowOptions;
    }

    public void setDataPanelSettings(DataPanelSettings settings) {
        this.dataPanelSettings = settings;
    }

    DebuggingProcess getDebuggingProcess() {
        return this.debuggingProcess;
    }

    void setDebuggingProcess(DebuggingProcess debuggingProcess) {
        this.debuggingProcess = debuggingProcess;
        if (debuggingProcess == null) {
            this.versionedRoot = null;
            this.versionedRootDepth = -1;
            this.versionedRootMethodName = null;
            this.versionedRootStateLocation = null;
            this.versionedRootDebuggeeStoppedCount = -1L;
        } else {
            this.versionedRootDebuggeeStoppedCount = debuggingProcess.getStoppedCount();
        }
    }

    public void updateChangeTracking() {
        if (!DebugWindowSettings.getInstance().isChangeTrackingEnabled()) {
            return;
        }
        if (this.debuggingProcess == null) {
            return;
        }
        DebugThreadInfo currentThread = this.debuggingProcess.vm.getCurrentThread();
        if (currentThread != null) {
            this.versionedRootStateLocation = currentThread.getStackFrame(0).getLocation();
            if (this.versionedRootDepth != currentThread.getStackFrameCount() || !this.versionedRootMethodName.equals(this.versionedRootStateLocation.getMethod().getName())) {
                long start = System.currentTimeMillis();
                this.versionedRoot = new HashMap<String, VersionedDataItem>(this.root.size());
                this.versionedRootDepth = currentThread.getStackFrameCount();
                this.versionedRootMethodName = this.versionedRootStateLocation.getMethod().getName();
                for (DataItem item : this.root) {
                    VersionedDataItem vitem = new VersionedDataItem(item, this.debuggingProcess.vm, this.versionedRootDebuggeeStoppedCount);
                    if (item instanceof EvaluatorDataItem) {
                        vitem.setEvaluatorDataItem((EvaluatorDataItem)item);
                    }
                    vitem.setNew();
                    this.versionedRoot.put(vitem.getDisplayName(), vitem);
                }
                this.logger.trace(System.currentTimeMillis() - start + " ms to init versioned root");
            } else {
                long start = System.currentTimeMillis();
                this.versionedRootDepth = currentThread.getStackFrameCount();
                this.versionedRootMethodName = this.versionedRootStateLocation.getMethod().getName();
                for (DataItem item : this.root) {
                    VersionedDataItem vItem = this.versionedRoot.get(item.getDisplayName());
                    if (vItem != null) {
                        vItem.updateVDI(item, this.versionedRootDebuggeeStoppedCount);
                    } else {
                        vItem = new VersionedDataItem(item, this.debuggingProcess.vm, this.versionedRootDebuggeeStoppedCount);
                        if (item instanceof EvaluatorDataItem) {
                            vItem.setEvaluatorDataItem((EvaluatorDataItem)item);
                        }
                    }
                    this.versionedRoot.put(item.getDisplayName(), vItem);
                }
                this.logger.trace(System.currentTimeMillis() - start + " ms to update versioned root");
            }
        }
    }

    void fireChanged() {
        TreePath rootTreePath = new TreePath(this.root);
        this.fireTreeStructureChanged((Object)this, rootTreePath.getPath(), null, null);
    }

    void fireChanged(TreePath path) {
        this.fireTreeStructureChanged((Object)this, path.getPath(), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTopDataItem(DataItem dataItem) {
        DataTreeTableModel dataTreeTableModel = this;
        synchronized (dataTreeTableModel) {
            this.root.add(dataItem);
            this.fireChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTopDataItem(int i) {
        DataTreeTableModel dataTreeTableModel = this;
        synchronized (dataTreeTableModel) {
            DataItem item = this.root.remove(i);
            String key = null;
            if (item instanceof EvaluatorDataItem) {
                key = ((EvaluatorDataItem)item).getExpressionPart();
            } else if (item instanceof VersionedDataItem) {
                key = ((VersionedDataItem)item).getDisplayName();
            }
            if (key != null) {
                this.versionedRoot.remove(key);
            }
            this.fireChanged();
        }
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        ArrayList<String> needToRemove = new ArrayList<String>();
        for (String key : this.arrayRanges.keySet()) {
            DataArrayRange arrayRange = this.arrayRanges.get(key);
            if (arrayRange.getDebuggingProcess() != debuggingProcess) continue;
            needToRemove.add(key);
        }
        for (int i = needToRemove.size() - 1; i >= 0; --i) {
            this.arrayRanges.remove(needToRemove.get(i));
        }
    }

    public boolean isLeaf(Object node) {
        try {
            if (node == this.root || node == null) {
                return false;
            }
            DataItem dataItem = (DataItem)node;
            return !dataItem.mayHaveChildren();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private boolean shouldLoadChildLazily(DataItem parent, int index) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return false;
        }
        if (parent instanceof VersionedDataItem) {
            return false;
        }
        if (index == -2) {
            if (parent == null || !(parent.getDataInfo() instanceof DebugDataArrayInfo)) {
                return false;
            }
            if (parent.isEmpty()) {
                return false;
            }
            return parent.numberOfCachedChildren() <= 0;
        }
        if (parent.getDataInfo() instanceof DebugDataArrayInfo) {
            return index >= parent.numberOfCachedChildren();
        }
        return false;
    }

    private void loadChildInBackground(final DataItem parent, final int index) {
        SwingWorker<DataItem, Object> bgLoader = new SwingWorker<DataItem, Object>(){

            @Override
            protected DataItem doInBackground() throws Exception {
                DataTreeTableModel.this.backgroundLoadsInProgress.add(parent);
                DataItem[] childNodes = parent.getChildNodes(true);
                return childNodes[index];
            }

            @Override
            protected void done() {
                DataTreeTableModel.this.backgroundLoadsInProgress.remove(parent);
                DataTreeTableModel.this.fireChanged();
            }
        };
        bgLoader.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<DataItem> getChildren(Object parent) {
        boolean changeTracking = DebugWindowSettings.getInstance().isChangeTrackingEnabled();
        if (parent == this.root) {
            DataTreeTableModel dataTreeTableModel = this;
            synchronized (dataTreeTableModel) {
                if (changeTracking && this.versionedRoot != null) {
                    return this.getDataItemsWithChangeVersioning(this.root);
                }
                ArrayList<DataItem> copy = new ArrayList<DataItem>(this.root);
                return copy.iterator();
            }
        }
        DataItem dataItem = (DataItem)parent;
        if (dataItem instanceof VersionedDataItem || !changeTracking || this.versionedRoot == null) {
            return dataItem.getChildren();
        }
        boolean lazy = false;
        return this.getChildrenWithChangeVersioning(dataItem, lazy);
    }

    Iterator<DataItem> getLazyChildren(Object parent) {
        boolean changeTracking = DebugWindowSettings.getInstance().isChangeTrackingEnabled();
        if (parent == this.root) {
            if (changeTracking && this.versionedRoot != null) {
                return this.getDataItemsWithChangeVersioning(this.root);
            }
            return this.root.iterator();
        }
        DataItem dataItem = (DataItem)parent;
        if (dataItem instanceof VersionedDataItem || !changeTracking || this.versionedRoot == null) {
            return dataItem.getLazyChildren();
        }
        boolean lazy = true;
        return this.getChildrenWithChangeVersioning(dataItem, lazy);
    }

    public Object getChild(Object parent, int index) {
        boolean changeTracking = DebugWindowSettings.getInstance().isChangeTrackingEnabled();
        try {
            if (parent == this.root) {
                if (changeTracking && this.versionedRoot != null) {
                    return this.getDataItemWithChangeVersioning(this.root.get(index));
                }
                return this.root.get(index);
            }
            DataItem dataItem = (DataItem)parent;
            if (this.shouldLoadChildLazily(dataItem, index)) {
                String lazyLoadString = DbgArb.getString(866);
                EvaluatorItem dummyInfo = new EvaluatorItem(lazyLoadString);
                DataItem placeholder = new DataItem(dataItem.dataPanel, dummyInfo, lazyLoadString, null);
                if (!this.backgroundLoadsInProgress.contains(dataItem)) {
                    this.loadChildInBackground(dataItem, index);
                }
                return placeholder;
            }
            return dataItem.getChildNodes(false)[index];
        }
        catch (Exception e) {
            return null;
        }
    }

    private DataItem getDataItemWithChangeVersioning(DataItem item) {
        if (item == null || this.versionedRoot == null) {
            return null;
        }
        VersionedDataItem vItem = this.versionedRoot.get(item.getDisplayName());
        if (vItem != null) {
            return vItem;
        }
        vItem = new VersionedDataItem(item, this.debuggingProcess.vm, this.versionedRootDebuggeeStoppedCount);
        if (item instanceof EvaluatorDataItem) {
            vItem.setEvaluatorDataItem((EvaluatorDataItem)item);
        }
        if (item.getDisplayName() != null && item.getDisplayName().length() > 0) {
            this.versionedRoot.put(item.getDisplayName(), vItem);
        }
        return vItem;
    }

    private Iterator getDataItemsWithChangeVersioning(List<DataItem> items) {
        ArrayList<DataItem> versionedItems = new ArrayList<DataItem>(items.size());
        for (DataItem item : items) {
            versionedItems.add(this.getDataItemWithChangeVersioning(item));
        }
        return versionedItems.iterator();
    }

    private Iterator getChildrenWithChangeVersioning(DataItem parent, boolean lazy) {
        Iterator dii = lazy ? parent.getLazyChildren() : parent.getChildren();
        ArrayList<DataItem> versionedItems = new ArrayList<DataItem>();
        while (dii.hasNext()) {
            DataItem dchild = (DataItem)dii.next();
            versionedItems.add(this.getDataItemWithChangeVersioning(dchild));
        }
        return versionedItems.iterator();
    }

    public int getChildCount(Object parent) {
        try {
            if (parent == this.root) {
                return this.root.size();
            }
            DataItem dataItem = (DataItem)parent;
            if (this.shouldLoadChildLazily(dataItem, -2)) {
                return 1;
            }
            return dataItem.countChildNodes();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getColumnCount() {
        return 8;
    }

    public String getColumnName(int column) {
        if (this.debuggingProcess != null && this.debuggingProcess.getVM() != null && this.dataPanelSettings != null) {
            DebugVirtualMachine vm = this.debuggingProcess.getVM();
            List<String> columnNames = WindowSettingsColumnManager.getColumnNames(this.dataPanelSettings.getHash(), vm.getID());
            if (column < columnNames.size()) {
                return columnNames.get(column);
            }
        }
        return DataPanel.getDefaultColumnName(column);
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return TreeTableModel.class;
        }
        return String.class;
    }

    public boolean isCellEditable(Object node, int column) {
        try {
            if (node != this.root) {
                DataItem dataItem;
                if (column == 0 && node instanceof EvaluatorDataItem) {
                    if (!this.root.contains(node)) {
                        return false;
                    }
                    EvaluatorDataItem dataItem2 = (EvaluatorDataItem)node;
                    if (!dataItem2.canEditExpression()) {
                        return false;
                    }
                    if (dataItem2.dataPanel instanceof WatchPanel) {
                        return true;
                    }
                } else if (column == 1 && ((dataItem = (DataItem)node).canAdjustObjectPreferences() || dataItem.shouldShowArrayNavigationButtons())) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.isCellEditable(node, column);
    }

    public Object getValueAt(Object node, int column) {
        try {
            if (node == this.root) {
                return "";
            }
            DataItem item = (DataItem)node;
            return item.getValueOfColumn(column);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setValueAt(Object aValue, Object node, int column) {
        if (column == 0) {
            try {
                if (node == this.root) {
                    return;
                }
                EvaluatorDataItem item = null;
                if (node instanceof EvaluatorDataItem) {
                    item = (EvaluatorDataItem)node;
                } else if (node instanceof VersionedDataItem) {
                    if (this.versionedRoot.containsKey(aValue.toString())) {
                        return;
                    }
                    item = ((VersionedDataItem)node).getEvaluatorDataItem();
                }
                if (item == null) {
                    return;
                }
                TreePath treePath = new TreePath(this.getRoot());
                treePath.pathByAddingChild(node);
                String oldExpression = item.getExpressionPart();
                item.editExpression(aValue.toString(), treePath);
                this.pcs.firePropertyChange(PROPERTY_DATA_ITEM_EXPRESSION, oldExpression, aValue.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    void addArrayRange(DataArrayRange arrayRange) {
        this.arrayRanges.put(arrayRange.getKey(), arrayRange);
    }

    protected DataArrayRange getArrayRange(DebuggingProcess debuggingProcess, DebugDataArrayInfo array, String key) {
        DataArrayRange arrayRange = this.arrayRanges.get(key);
        if (arrayRange == null) {
            arrayRange = new DataArrayRange(debuggingProcess, array);
            arrayRange.setKey(key);
        } else {
            arrayRange.setArray(array);
        }
        return arrayRange;
    }

    public List<DataItem> getRoot() {
        return this.root;
    }
}

