/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.HashSet;
import java.util.Set;
import oracle.ide.util.Encodings;
import oracle.ide.util.FastStringBuffer;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugDataPrimitiveInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.EvaluationInfo;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ObjectPreferences;

final class DataValueHelper {
    private DataValueHelper() {
    }

    private static String evaluateDataValue(DebugDataObjectInfo dataObject, Set setOfEvaluatedDataObjects, String[] expressionUsed) {
        ObjectPreferences objectPreferences;
        String expression;
        if (setOfEvaluatedDataObjects.add(dataObject) && (expression = (objectPreferences = JDebugger.getInstance().getObjectPreferences()).getValueExpression(dataObject)) != null) {
            Evaluator evaluator = new Evaluator(true);
            evaluator.setDebugContext(dataObject);
            Object info = evaluator.evaluate(expression);
            if (info != null) {
                String actualClassName;
                DebugDataInfo data = Evaluator.getDataInfo(info);
                String s = DataValueHelper.makeDataValue(info, data, setOfEvaluatedDataObjects);
                if (s != null && s.startsWith("\"") && s.endsWith("\"") && !(actualClassName = dataObject.getClassInfo().getName()).equals("java.lang.String") && !actualClassName.equals("java.lang.StringBuffer") && !actualClassName.equals("java.lang.StringBuilder")) {
                    s = s.substring(1, s.length() - 1);
                }
                if (expressionUsed != null && expressionUsed.length == 1) {
                    expressionUsed[0] = expression;
                }
                return s;
            }
        }
        return null;
    }

    static String makeDataValue(DebugDataInfo data) {
        return DataValueHelper.makeDataValue(null, data);
    }

    static String makeDataValue(Object info, DebugDataInfo data) {
        return DataValueHelper.makeDataValue(info, data, new HashSet(), null);
    }

    static String makeDataValue(Object info, DebugDataInfo data, Set setOfEvaluatedDataObjects) {
        return DataValueHelper.makeDataValue(info, data, setOfEvaluatedDataObjects, null);
    }

    static String makeDataValue(Object info, DebugDataInfo data, String[] expressionUsed) {
        return DataValueHelper.makeDataValue(info, data, new HashSet(), expressionUsed, true);
    }

    static String makeDataValue(Object info, DebugDataInfo data, Set setOfEvaluatedDataObjects, String[] expressionUsed) {
        return DataValueHelper.makeDataValue(info, data, setOfEvaluatedDataObjects, expressionUsed, true);
    }

    static String makeDataValue(Object info, DebugDataInfo data, String[] expressionUsed, boolean getExtendedValue) {
        return DataValueHelper.makeDataValue(info, data, new HashSet(), expressionUsed, getExtendedValue);
    }

    static String makeDataValue(Object info, DebugDataInfo data, Set setOfEvaluatedDataObjects, String[] expressionUsed, boolean getExtendedValue) {
        return DataValueHelper.makeDataValue(info, data, setOfEvaluatedDataObjects, expressionUsed, getExtendedValue, true);
    }

    static String makeDataValue(Object info, DebugDataInfo data, Set setOfEvaluatedDataObjects, String[] expressionUsed, boolean getExtendedValue, boolean addQuotes) {
        if (data != null) {
            String v = null;
            if (data instanceof DebugDataCompositeInfo) {
                if (data instanceof DebugDataObjectInfo) {
                    v = DataValueHelper.evaluateDataValue((DebugDataObjectInfo)data, setOfEvaluatedDataObjects, expressionUsed);
                }
                if (v == null) {
                    v = DebugShared.makeCourtesyValue((DebugDataCompositeInfo)data, addQuotes, false);
                }
                if (v == null) {
                    v = data.getValue();
                }
            } else {
                v = data.getValue();
                if (data instanceof DebugDataPrimitiveInfo && getExtendedValue && getExtendedValue) {
                    try {
                        DebugClassInfo ci = data.getClassInfo();
                        if (ci != null) {
                            byte[] b;
                            String s;
                            String hex;
                            String className = ci.getName();
                            if (className.equals("char")) {
                                String hex2 = data.getHexValue();
                                if (hex2 != null && hex2.length() > 0) {
                                    int num = Integer.parseInt(hex2, 16);
                                    v = v + "    " + num;
                                }
                            } else if (className.equals("byte") && (hex = data.getHexValue()) != null && hex.length() > 0 && (s = new String(b = new byte[]{Byte.parseByte(hex, 16)}, Encodings.getDefaultEncoding())).length() == 1) {
                                FastStringBuffer fsb = new FastStringBuffer(v);
                                fsb.append(' ');
                                for (int i = v.length() + 1; i < 7; ++i) {
                                    fsb.append(' ');
                                }
                                fsb.append('\'');
                                fsb.append(s);
                                fsb.append('\'');
                                v = fsb.toString();
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (v != null) {
                return v;
            }
        } else {
            if (info instanceof EvaluationInfo) {
                return ((EvaluationInfo)info).getValue();
            }
            if (info instanceof DebugVariableInfo) {
                return DbgArb.getString(257);
            }
            if (info instanceof DebugStackSlotInfo) {
                return ((DebugStackSlotInfo)info).getValue();
            }
        }
        return "";
    }
}

