/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.EditorManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.IdeLayout;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.DebuggerEvent;
import oracle.ide.runner.DebuggerEventSource;
import oracle.ide.runner.DebuggerListener;
import oracle.ide.runner.DebuggerStartCallback;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Runner;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.VersionNumber;
import oracle.ideimpl.runner.DebuggerHook;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSynchStatement;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.NamedTimer;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.PackagedSource;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdeveloper.runner.RemoteConnectDialog;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.Breakpoint;
import oracle.jdevimpl.debugger.BreakpointConditionEvaluationResult;
import oracle.jdevimpl.debugger.SourceIcon;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointLogListener;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugListener;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.DebuggerEngine;
import oracle.jdevimpl.debugger.support.TargetMethod;
import oracle.jdevimpl.debugger.support.XSLTDebugHelper;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.BreakpointDetails;
import oracle.jdevimpl.runner.debug.BreakpointRuntimeSupport;
import oracle.jdevimpl.runner.debug.BytecodeFileSystemHelper;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.DatabaseDebuggingHelper;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebugFilesHandler;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingListener;
import oracle.jdevimpl.runner.debug.EvaluatorHandle;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.ExtenderManager;
import oracle.jdevimpl.runner.debug.HeapWindow;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.MonitorsWindow;
import oracle.jdevimpl.runner.debug.RunWhilePaused;
import oracle.jdevimpl.runner.debug.SmartWindow;
import oracle.jdevimpl.runner.debug.ThreadsWindow;
import oracle.jdevimpl.runner.debug.TracingPanel;
import oracle.jdevimpl.xml.JDevXmlIntegrationUtils;

public class DebuggingProcess
extends JRunProcess
implements DebugListener,
DebugBreakpointLogListener,
DebuggerEngine {
    private static final String BYTE_CODE_BUTTON_GROUP = "DebuggingProcess.byte-code-button-group";
    private static final String DEBUGGER_BUTTON_GROUP = "DebuggingProcess.debugger-button-group";
    private long timeProgramStopped;
    private long timeWindowsUpdated;
    private long timeBeforeConnect;
    private long timeAfterConnect;
    private String localPort;
    private static final boolean socketRelay = false;
    private boolean skipCompile;
    private DatabaseDebuggingHelper databaseDebuggingHelper;
    private boolean databaseDebugging;
    private boolean xsltDebugging = false;
    private DebugFilesHandler debugfilesHandler;
    private volatile Thread connectionThread;
    protected volatile DebugVirtualMachine vm;
    private final Object vmSync = new Object();
    private DebugThreadInfo currentThread;
    private DebugThreadInfo lastKnownGoodThread;
    private DebugStackFrameInfo currentStackFrame;
    private DebugLocation currentLocation;
    private BreakpointDetails currentBreakpoint;
    private DebugThreadInfo[][] deadlocks;
    private List runAfterSelectedList;
    private boolean stopped;
    private int stoppedCount;
    private int loadedClassesCount;
    private boolean resuming;
    private boolean stepping;
    private boolean executingRunWhilePausedTask = false;
    private final boolean[] pause = new boolean[2];
    private List runWhilePausedList;
    private List runAfterPausedList;
    private static final int INTERNAL = 0;
    private static final int USER = 1;
    private DebugBreakpoint temporaryBreakpoint;
    private SourceIcon sourceIconForIP;
    private SourceIcon sourceIconForIPBytecode;
    private List messages;
    private String disconnectedMessage;
    private long updateNormalWindowsEndTime;
    private long stepRequestTime;
    private TimerTask timerTaskUpdateNormalWindows;
    private TimerTask timerTaskUpdateOtherWindows;
    private EventSource debuggerEventSource;
    private DebuggerStartCallback debuggerStartCallback;
    private Boolean isRemoteDebuggingProfiling = null;
    private static Timer timer = null;
    private static Class databaseDebuggingHelperClass = null;
    private static final int EXTRA_CONNECT_ARGS = 3;
    private ArrayList<DebuggingProcess> detachStartedProcesses;
    private boolean attachedToCreatedProcess = false;
    private List<EvaluatorHandle> evaluatorHandles = new ArrayList<EvaluatorHandle>();
    private DebugConfiguration debugConfiguration;
    private int localDebuggingFactory = -1;
    private String locationOfLastShownNavigationPoint;
    private List<DebuggerListener> debuggerListeners;
    private boolean fastSwapEnabled;
    private Map<String, HashMap<String, Object>> _overrides = new HashMap<String, HashMap<String, Object>>();
    private static HelpInfo helpInfo;
    static final Class starterFactorySubClass;
    private static int classLoadTracking;
    private static final int PRINT_SYSTEM_OUT = 1;
    private static final int PRINT_SYSTEM_ERR = 2;
    private static final int PRINT_LOG_WINDOW = 4;
    static String statusText;

    public DebuggingProcess(Context context) {
        this(context, null);
    }

    public DebuggingProcess(Context context, DebuggerStartCallback debuggerStartCallback) {
        super(context);
        this.debugConfiguration = DebugConfiguration.getInstance(this.getRunConfiguration());
        try {
            if (databaseDebuggingHelperClass != null) {
                this.databaseDebuggingHelper = (DatabaseDebuggingHelper)databaseDebuggingHelperClass.newInstance();
                this.databaseDebuggingHelper.setDebuggingProcess(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JDebugger.getInstance().debuggingProcessCreated();
        this.runAfterSelectedList = new ArrayList();
        this.runWhilePausedList = new ArrayList();
        this.runAfterPausedList = new ArrayList();
        this.messages = new ArrayList();
        this.debuggerStartCallback = debuggerStartCallback;
    }

    DebugConfiguration getDebugConfiguration() {
        return this.debugConfiguration;
    }

    public boolean canRun(String runType, Object cookie, Node node, List errors) {
        if ("Java".equals(runType)) {
            return this.canRunJava(node, errors);
        }
        if ("Database".equals(runType)) {
            return this.canRunInDatabase(node, cookie, errors);
        }
        if ("XSLT".equals(runType)) {
            return true;
        }
        if ("XQuery".equals(runType)) {
            errors.add(DbgArb.format(760, node.getShortLabel()));
            return false;
        }
        return false;
    }

    private boolean canRunJava(Node node, List errors) {
        if (!this.isRemoteDebuggingProfiling()) {
            JDK jdkDefinition = this.getJdkDefinition();
            if (this.runConfiguration.usingOJVM(jdkDefinition)) {
                return true;
            }
            if (this.runConfiguration.usingMinimal(jdkDefinition) || this.runConfiguration.usingVanilla(jdkDefinition)) {
                errors.add(DbgArb.format(754, node.getShortLabel()));
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean canRunInDatabase(Node node, Object db, List errors) {
        if (!this.isRemoteDebuggingProfiling() && this.databaseDebuggingHelper != null) {
            return this.databaseDebuggingHelper.canRunInDatabase(node, db, errors);
        }
        return false;
    }

    public void setValue(String runType, String key, Object overrideValue) {
        if (runType == null || key == null || overrideValue == null) {
            return;
        }
        HashMap<String, Object> runTypeOverrides = this._overrides.get(runType);
        if (runTypeOverrides == null) {
            runTypeOverrides = new HashMap();
            this._overrides.put(runType, runTypeOverrides);
        }
        runTypeOverrides.put(key, overrideValue);
    }

    public Object getOverrideValue(String runType, String key) {
        HashMap<String, Object> runTypeOverrides;
        if (runType != null && this._overrides.containsKey(runType) && (runTypeOverrides = this._overrides.get(runType)).containsKey(key)) {
            return runTypeOverrides.get(key);
        }
        return null;
    }

    public boolean isOverridden(String runType, String key) {
        return this.getOverrideValue(runType, key) != null;
    }

    public Object getValue(String runType, Object cookie, String key) {
        Object overrideValue = this.getOverrideValue(runType, key);
        if (overrideValue != null) {
            return overrideValue;
        }
        if ("Java".equals(runType) && "FirstJavaCommandOptions".equals(key)) {
            ArrayList<String> javaFirstCommandOptions = new ArrayList<String>();
            String[] javaDebugArguments = this.getJavaDebugArguments();
            if (javaDebugArguments != null) {
                for (String javaDebugArgument : javaDebugArguments) {
                    javaFirstCommandOptions.add(javaDebugArgument);
                }
            }
            javaFirstCommandOptions.add("-Dcom.sun.xml.bind.v2.bytecode.ClassTailor.noOptimize=true");
            return javaFirstCommandOptions.toArray(new String[javaFirstCommandOptions.size()]);
        }
        if ("Database".equals(runType) && "DatabaseRunHelper".equals(key)) {
            this.databaseDebugging = true;
            this.localDebuggingFactory = this.databaseDebuggingHelper.getDebuggerFactory();
            return this.databaseDebuggingHelper;
        }
        if ("XSLT".equals(runType)) {
            if ("FirstXSLTCommandOptions".equals(key)) {
                return this.getFirstXSLTCommandOptions();
            }
            if ("LastXSLTCommandOptions".equals(key)) {
                return this.getLastXSLTCommandOptions();
            }
        }
        return null;
    }

    private String[] getJavaDebugArguments() {
        String portArg = this.localPort == null ? this.getLocalPort() : this.localPort;
        JDK jdkDefinition = this.getJdkDefinition();
        DebugConfiguration debugConfiguration = this.getDebugConfiguration();
        if (this.runConfiguration.usingMinimal(jdkDefinition) || this.runConfiguration.usingVanilla(jdkDefinition)) {
            return null;
        }
        if (this.runConfiguration.usingOJVM(jdkDefinition)) {
            return debugConfiguration.getOJVMDebugArguments(portArg);
        }
        if (this.runConfiguration.usingClassic(jdkDefinition)) {
            return debugConfiguration.getJPDAClassicDebugArguments(portArg);
        }
        VersionNumber fiveO = new VersionNumber("1.5.0");
        if (jdkDefinition.getJavaVersion().isAfter(fiveO, true)) {
            return debugConfiguration.getJPDADebugArguments(portArg);
        }
        return debugConfiguration.getPre50JPDADebugArguments(portArg);
    }

    public void addDebugFileHandler(DebugFilesHandler fileHandler) {
        this.debugfilesHandler = fileHandler;
    }

    private String[] getFirstXSLTCommandOptions() {
        this.xsltDebugging = true;
        this.localDebuggingFactory = DebugFactory.FACTORY_JPDA_Attach;
        this.getLocalPort();
        String[] options = new String[]{XSLTDebugHelper.getFirstXSLTDebugOption(this.localPort)};
        return options;
    }

    private String[] getLastXSLTCommandOptions() {
        String[] options = new String[]{XSLTDebugHelper.getLastXSLTDebugOption()};
        return options;
    }

    public String getProcessLabelPrefix() {
        return this.labelPrefixOverride != null ? this.labelPrefixOverride : DbgArb.getString(147);
    }

    public IdeLayout getProcessLayout() {
        return JDebugger.getInstance().getDebugLayout();
    }

    public void selected() {
        MonitorsWindow monitorsWindow;
        HeapWindow heapWindow;
        ClassesWindow classesWindow;
        SmartWindow smartWindow;
        DebugStackFrameInfo currentStackFrame;
        DebugThreadInfo currentThread;
        DebugVirtualMachine vm;
        super.selected();
        JDebugger jdebugger = JDebugger.getInstance();
        jdebugger.processSelected(this);
        if (this.vm != null && this.stopped) {
            vm = this.vm;
            currentThread = this.currentThread;
            currentStackFrame = this.currentStackFrame;
        } else {
            vm = null;
            currentThread = null;
            currentStackFrame = null;
        }
        this.showSourceIPIcon(false);
        ThreadsWindow threadWindow = jdebugger.getThreadsWindow(false);
        if (threadWindow != null) {
            threadWindow.updateThreads(this, vm, currentThread);
        }
        if ((smartWindow = jdebugger.getSmartWindow(false)) != null) {
            smartWindow.updateData(this, vm, currentThread, currentStackFrame);
        }
        if ((classesWindow = jdebugger.getClassesWindow(false)) != null) {
            classesWindow.updateClasses(this, vm);
        }
        if ((heapWindow = jdebugger.getHeapWindow(false)) != null) {
            heapWindow.updateData(this, vm, null, null);
        }
        if ((monitorsWindow = jdebugger.getMonitorsWindow(false)) != null) {
            monitorsWindow.updateMonitors(this, vm);
        }
        while (this.runAfterSelectedList.size() > 0) {
            Runnable runAfterSelected = (Runnable)this.runAfterSelectedList.remove(0);
            runAfterSelected.run();
        }
    }

    public void doubleClicked() {
        super.doubleClicked();
        this.showIP();
    }

    public void unselected() {
        MonitorsWindow monitorsWindow;
        HeapWindow heapWindow;
        ClassesWindow classesWindow;
        super.unselected();
        JDebugger jdebugger = JDebugger.getInstance();
        jdebugger.processUnselected(this);
        this.hideSourceIPIcon();
        jdebugger.getThreadsWindow(true).clearThreads();
        SmartWindow smartWindow = jdebugger.getSmartWindow(false);
        if (smartWindow != null) {
            smartWindow.clearData();
        }
        if ((classesWindow = jdebugger.getClassesWindow(false)) != null) {
            classesWindow.clearClasses();
        }
        if ((heapWindow = jdebugger.getHeapWindow(false)) != null) {
            heapWindow.clearData();
        }
        if ((monitorsWindow = jdebugger.getMonitorsWindow(false)) != null) {
            monitorsWindow.clearMonitors();
        }
    }

    public Icon getIcon() {
        return this.iconOverride != null ? this.iconOverride : OracleIcons.getIcon((String)"debug.png");
    }

    public HelpInfo getHelpInfo() {
        if (helpInfo == null) {
            helpInfo = new HelpInfo("f1_deb_log_debuggerprocess_html");
        }
        return helpInfo;
    }

    @Override
    protected boolean compile() {
        if (this.skipCompile) {
            return true;
        }
        if (this.isRemoteDebuggingProfiling()) {
            return true;
        }
        return super.compile();
    }

    protected Class getStarterFactorySubClass() {
        return starterFactorySubClass;
    }

    @Override
    protected void determineTargetAndStarter(Class starterFactorySubClass) {
        if (!this.isRemoteDebuggingProfiling()) {
            super.determineTargetAndStarter(starterFactorySubClass);
        }
    }

    @Override
    protected boolean startTarget() {
        this.skipCompile = false;
        LogPage logPage = this.getLogPage();
        if (logPage instanceof RunLogPage) {
            ((RunLogPage)logPage).show();
        }
        if (this.isRemoteDebuggingProfiling()) {
            DebugConfiguration debugConfiguration = this.getDebugConfiguration();
            if (debugConfiguration.getRemoteProtocol().equals("jpdalisten")) {
                DebuggingListener debuggingListener = new DebuggingListener(this, true);
                if (!debuggingListener.startListening()) {
                    return false;
                }
                if (this.debuggerStartCallback != null) {
                    this.debuggerStartCallback.readyToStart();
                }
                Runner.getRunner().viewRunManager();
            } else {
                if (this.runConfiguration.isClearLogBeforeRun()) {
                    this.getLogPage().clearAll();
                }
                if (!this.connectRemoteDebugging()) {
                    return false;
                }
                if (this.debuggerStartCallback != null) {
                    this.debuggerStartCallback.readyToStart();
                }
            }
        } else {
            if (!this.determineTargetAndStarterAlready) {
                this.determineTargetAndStarter();
            }
            if (this.starter != null && this.debuggerStartCallback != null) {
                this.debuggerStartCallback.readyToStart();
            }
            if (!super.startTarget()) {
                if (this.databaseDebugging) {
                    this.databaseDebuggingHelper.startTargetFailed();
                }
                return false;
            }
            if (!this.databaseDebugging && !this.isStartOnly()) {
                this.connectLocalDebugging();
            }
        }
        return true;
    }

    public void addDetachFromStartedProcess(DebuggingProcess startedProcess) {
        if (this.detachStartedProcesses == null) {
            this.detachStartedProcesses = new ArrayList();
        }
        this.detachStartedProcesses.add(startedProcess);
    }

    public void setAttachToCreatedProcess(boolean b) {
        this.attachedToCreatedProcess = b;
    }

    public String getLocalPort() {
        if (this.localPort == null) {
            DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
            if (dbgSettings.isLocalPortRange()) {
                int min = dbgSettings.getLocalPortRangeMin();
                int max = dbgSettings.getLocalPortRangeMax();
                this.localPort = Integer.toString(Helpers.getLocalPort(min, max));
            } else {
                this.localPort = Integer.toString(Helpers.getLocalPort());
            }
        }
        return this.localPort;
    }

    private boolean connectRemoteDebugging() {
        this.updateProgressHandle(DbgArb.getString(860));
        int debugFactory = this.getDebuggerFactory();
        DebugConnector connector = DebugFactory.newInstance(debugFactory);
        DebugConnectArg[] connectArgs = this.getDebugConnectArgs(connector);
        int count = connectArgs.length;
        DebugConfiguration debugConfiguration = this.getDebugConfiguration();
        String protocol = debugConfiguration.getRemoteProtocol();
        boolean needDialog = debugConfiguration.isPromptForRemoteDebugging();
        for (int i = 0; i < count; ++i) {
            DebugConnectArg connectArg = connectArgs[i];
            String value = debugConfiguration.getRemoteParameterValue(protocol, connectArg.getName(), connectArg.getValue());
            if (value != null) {
                connectArg.setValue(value);
                value = connectArg.getValue();
                if (value.length() != 0 || connectArg.allowBlank()) continue;
                needDialog = true;
                continue;
            }
            if (connectArg.allowBlank()) continue;
            needDialog = true;
        }
        if (needDialog) {
            boolean ok;
            String title = DebugFactory.getDebugConnectorRemoteConnectDialogTitle(debugFactory);
            if (title == null) {
                title = DebugFactory.getDefaultRemoteDialogTitle();
            }
            String helpId = "f1_deb_attachtojpda_html";
            boolean[] save = new boolean[1];
            boolean[] attachPid = null;
            if (debugFactory == DebugFactory.FACTORY_JPDA_Attach) {
                attachPid = new boolean[]{debugFactory == DebugFactory.FACTORY_JPDA_Attach, false, false};
            }
            if (!(ok = RemoteConnectDialog.showRemoteConnectDialog(title, connectArgs, save, helpId, attachPid))) {
                return false;
            }
            for (int i = 0; i < count; ++i) {
                DebugConnectArg connectArg = connectArgs[i];
                connectArg.setValue(connectArgs[i].getValue());
                if (!save[0] && !debugConfiguration.isCustom()) continue;
                debugConfiguration.putRemoteParameterValue(protocol, connectArg.getName(), connectArgs[i].getValue());
            }
            if (save[0]) {
                debugConfiguration.setPromptForRemoteDebugging(false);
            }
        }
        String host = this.findHostValue(connectArgs);
        String port = this.findPortValue(connectArgs);
        Runnable successRunnable = new Runnable(){

            @Override
            public void run() {
                String vmName = DebuggingProcess.this.vm.getName();
                if (vmName != null) {
                    String msg = DbgArb.format(163, vmName);
                    DebuggingProcess.this.log(msg);
                    DebuggingProcess.this.updateProgressHandle(msg);
                }
                DebuggingProcess.this.afterConnection(DbgArb.getString(162));
            }
        };
        Runnable failureRunnable = new Runnable(){

            @Override
            public void run() {
                String msg = DbgArb.getString(178);
                DebuggingProcess.this.log(msg);
                DebuggingProcess.this.updateProgressHandle(msg);
                DebuggingProcess.this.finishProgressHandle();
            }
        };
        Runnable canceledRunnable = new Runnable(){

            @Override
            public void run() {
                String msg = DbgArb.getString(158);
                DebuggingProcess.this.log(msg);
                DebuggingProcess.this.updateProgressHandle(msg);
                DebuggingProcess.this.finishProgressHandle();
            }
        };
        String tryMsg = needDialog ? DbgArb.format(159, host, port) : DbgArb.format(160, host, port);
        String successMsg = DbgArb.format(161, host, port);
        this.connectToDebuggee(connector, connectArgs, tryMsg, successMsg, successRunnable, failureRunnable, canceledRunnable);
        return true;
    }

    protected DebugConnectArg[] getDebugConnectArgs(DebugConnector connector) {
        DebugConnectArg[] connectArgs = connector.getConnectArgs();
        return connectArgs;
    }

    protected String findHostValue(DebugConnectArg[] connectArgs) {
        DebugConnectArg connectArg = DebugShared.findConnectArg(connectArgs, "hostname");
        if (connectArg != null) {
            String host = connectArg.getValue();
            if (host == null || host.length() == 0) {
                host = DbgArb.getString(188);
            }
            return host;
        }
        int connectArgsLength = connectArgs.length;
        if (connectArgsLength >= 2) {
            int hostIndex = connectArgsLength - 2;
            String host = connectArgs[hostIndex].getValue();
            if (host == null || host.length() == 0) {
                host = DbgArb.getString(188);
            }
            return host;
        }
        return "";
    }

    private String findPortValue(DebugConnectArg[] connectArgs) {
        DebugConnectArg connectArg = DebugShared.findConnectArg(connectArgs, "port");
        if (connectArg != null) {
            return connectArg.getValue();
        }
        int connectArgsLength = connectArgs.length;
        if (connectArgsLength >= 1) {
            int portIndex = connectArgsLength - 1;
            return connectArgs[portIndex].getValue();
        }
        return "";
    }

    protected boolean isRemoteDebuggingProfiling() {
        if (this.isRemoteDebuggingProfiling == null) {
            this.isRemoteDebuggingProfiling = this.runConfiguration.isRemoteDebuggingProfiling();
        }
        return this.isRemoteDebuggingProfiling != false || this.attachedToCreatedProcess;
    }

    public boolean setLocalDebuggingProtocol(String protocol) {
        int cookie = DebugFactory.getDebugConnectorCookie(protocol);
        if (cookie >= 0) {
            this.localDebuggingFactory = cookie;
            return true;
        }
        return false;
    }

    public String getLocalDebuggingProtocol() {
        String protocol;
        if (this.localDebuggingFactory >= 0 && (protocol = DebugFactory.getDebugConnectorProtocol(this.localDebuggingFactory)) != null) {
            return protocol;
        }
        return "jpda";
    }

    private void connectLocalDebugging() {
        this.updateProgressHandle(DbgArb.getString(859));
        Runnable failureRunnable = new Runnable(){

            @Override
            public void run() {
                String failedMsg = DbgArb.getString(156);
                DebuggingProcess.this.log(failedMsg);
                DebuggingProcess.this.updateProgressHandle(failedMsg);
                DebuggingProcess.this.finishProgressHandle();
                DebuggingProcess.this.superTerminate();
            }
        };
        DebugConnector connector = null;
        int debuggerFactory = this.getDebuggerFactory();
        try {
            connector = DebugFactory.newInstance(debuggerFactory);
        }
        catch (NoClassDefFoundError e) {
            if (DebugFactory.debugConnectorNeedsToolsJar(debuggerFactory)) {
                try {
                    Class.forName("com.sun.jdi.VirtualMachine");
                }
                catch (ClassNotFoundException f) {
                    this.log(DbgArb.getString(829));
                }
            }
            failureRunnable.run();
            return;
        }
        DebugConnectArg[] connectArgs = connector.getConnectArgs();
        DebugConnectArg connectArg = DebugShared.findConnectArg(connectArgs, "port");
        if (connectArg != null && this.localPort != null) {
            connectArg.setValue(this.localPort);
        }
        Runnable successRunnable = new Runnable(){

            @Override
            public void run() {
                DebuggingProcess.this.afterConnection(DbgArb.getString(155));
            }
        };
        Runnable canceledRunnable = new Runnable(){

            @Override
            public void run() {
                DebuggingProcess.this.superTerminate();
            }
        };
        String tryMsg = null;
        String successMsg = DbgArb.getString(154);
        this.connectToDebuggee(connector, connectArgs, tryMsg, successMsg, successRunnable, failureRunnable, canceledRunnable);
    }

    public void connectToDebuggee(final DebugConnector connector, final DebugConnectArg[] connectArgs, final String tryMsg, final String successMsg, final Runnable successRunnable, final Runnable failureRunnable, final Runnable canceledRunnable) {
        DebuggingProcess.showStatus(DbgArb.getString(179));
        if (tryMsg != null) {
            StringBuffer sb = new StringBuffer(tryMsg);
            this.log(sb);
        }
        final int maxRetries = DebugWindowSettings.getInstance().getConnectionRetries();
        this.showLogPageToolbar(true);
        this.connectionThread = new Thread("DebugConnection"){

            @Override
            public void run() {
                int countRetries = 0;
                boolean keepTrying = true;
                boolean canceled = false;
                Character dotCharacter = new Character('.');
                DebuggingProcess.this.timeBeforeConnect = System.currentTimeMillis();
                while (true) {
                    try {
                        DebugConnectArg[] connArgs = connectArgs;
                        final DebugVirtualMachine vm = connector.connect(connArgs, DebuggingProcess.this);
                        DebuggingProcess.this.connectionThread = null;
                        DebuggingProcess.clearStatus();
                        if (successMsg != null) {
                            DebuggingProcess.this.log(successMsg);
                        }
                        MessagePage mp = null;
                        LogPage lp = DebuggingProcess.this.getLogPage();
                        if (lp instanceof MessagePage) {
                            mp = (MessagePage)lp;
                        }
                        vm.afterConnection(mp);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DebuggingProcess.this.vm = vm;
                                JDebugger.getInstance().debuggingProcessAfterConnecting(DebuggingProcess.this);
                                DebuggingProcess.this.clearProcessActionButtonsFromToolbar();
                                successRunnable.run();
                            }
                        });
                        return;
                    }
                    catch (Exception e) {
                        String msg;
                        if (e instanceof IOException && (msg = e.getMessage()) != null && msg.equals("Target failed to handshake.")) {
                            keepTrying = false;
                        }
                        if (tryMsg != null) {
                            DebuggingProcess.this.log(dotCharacter);
                        }
                        if (++countRetries > maxRetries) {
                            keepTrying = false;
                        }
                        if (!keepTrying) continue;
                        if (countRetries > maxRetries / 2) {
                            DebuggingProcess.showStatus(DbgArb.getString(180));
                        }
                        try {
                            Thread.sleep(250L);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            DebuggingProcess.this.log(DbgArb.getString(158));
                            canceled = true;
                            keepTrying = false;
                        }
                        if (keepTrying) continue;
                        DebuggingProcess.this.connectionThread = null;
                        DebuggingProcess.clearStatus();
                        if (canceled) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JDebugger.getInstance().debuggingProcessAfterConnecting(DebuggingProcess.this);
                                    DebuggingProcess.this.clearProcessActionButtonsFromToolbar();
                                    if (canceledRunnable != null) {
                                        canceledRunnable.run();
                                    }
                                }
                            });
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JDebugger.getInstance().debuggingProcessAfterConnecting(DebuggingProcess.this);
                                    DebuggingProcess.this.clearProcessActionButtonsFromToolbar();
                                    failureRunnable.run();
                                }
                            });
                        }
                        return;
                    }
                    break;
                }
            }
        };
        JDebugger.getInstance().debuggingProcessBeforeConnecting(this);
        this.connectionThread.start();
    }

    boolean canCancelConnection() {
        return this.connectionThread != null;
    }

    void cancelConnection() {
        Thread connectionThread = this.connectionThread;
        if (connectionThread != null) {
            this.log(new StringBuffer(DbgArb.getString(157)));
            connectionThread.interrupt();
        }
    }

    private String isApplicationServer() {
        boolean foundTomcat = false;
        DebugClassInfo[] loadedClasses = this.vm.listClasses(true);
        for (int i = 0; i < loadedClasses.length; ++i) {
            String name;
            DebugClassInfo clazz = loadedClasses[i];
            if (!clazz.isObject() || (name = clazz.getName()).startsWith("java") || name.startsWith("sun")) continue;
            if (name.startsWith("com.evermind") || name.startsWith("oracle.oc4j")) {
                return DbgArb.getString(164);
            }
            if (name.startsWith("org.jboss.")) {
                return DbgArb.getString(166);
            }
            if (name.startsWith("com.ibm.websphere.")) {
                return DbgArb.getString(170);
            }
            if (name.startsWith("weblogic.")) {
                return DbgArb.getString(169);
            }
            if (!name.startsWith("org.apache.tomcat.")) continue;
            foundTomcat = true;
        }
        if (foundTomcat) {
            return DbgArb.getString(168);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnection(String disconnectedMsg) {
        Object object = this.vmSync;
        synchronized (object) {
            if (this.vm == null) {
                return;
            }
        }
        this.disconnectedMessage = disconnectedMsg;
        WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
        wc.show();
        try {
            super.started();
            if (this.debugfilesHandler != null) {
                this.debugfilesHandler.showInputFile();
            }
            if (this.isRemoteDebuggingProfiling()) {
                String appServer;
                boolean isRunning = false;
                Object object2 = this.vmSync;
                synchronized (object2) {
                    block27: {
                        if (this.vm != null) break block27;
                        return;
                    }
                    isRunning = this.vm.isRunning();
                }
                if (isRunning && (appServer = this.isApplicationServer()) != null) {
                    this.log(DbgArb.format(171, appServer));
                    this.log(DbgArb.getString(172));
                }
            }
            Object isRunning = this.vmSync;
            synchronized (isRunning) {
                block28: {
                    if (this.vm != null) break block28;
                    return;
                }
                this.vm.addDebugListener(this);
                this.vm.addBreakpointLogListener(this);
            }
            this.setTracing();
            isRunning = this.vmSync;
            synchronized (isRunning) {
                block29: {
                    if (this.vm != null) break block29;
                    return;
                }
                this.vm.setPauseInterval(100);
            }
            this.setBreakpointsAndStartDebuggee();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            wc.hide();
        }
    }

    private void setBreakpointsAndStartDebuggee() {
        SwingWorker worker = new SwingWorker(){
            private WaitCursor wc = null;

            protected Object doInBackground() {
                this.wc = new WaitCursor((Component)Ide.getMainWindow());
                this.wc.show();
                DebuggingProcess.this.stopped = true;
                DebuggingProcess.this.stoppedCount = 0;
                DebuggingProcess.this.setBreakpointsInVm(true);
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                DebuggingProcess.this.stopped = false;
                try {
                    if (DebuggingProcess.this.timeBeforeConnect != 0L) {
                        DebuggingProcess.this.timeAfterConnect = System.currentTimeMillis();
                        Assert.println((String)("Time to attach debugger to debuggee: " + (DebuggingProcess.this.timeAfterConnect - DebuggingProcess.this.timeBeforeConnect) + " ms"));
                    }
                    DebuggingProcess.this.sendDebuggerEvent(1, 100);
                    String startOption = DebugWindowSettings.getInstance().getStartOption();
                    if (startOption.equals("stepover")) {
                        Object object = DebuggingProcess.this.vmSync;
                        synchronized (object) {
                            block22: {
                                if (DebuggingProcess.this.vm != null) break block22;
                                return;
                            }
                            DebuggingProcess.this.vm.start(true);
                        }
                    }
                    if (startOption.equals("stepinto")) {
                        Object object = DebuggingProcess.this.vmSync;
                        synchronized (object) {
                            block23: {
                                if (DebuggingProcess.this.vm != null) break block23;
                                return;
                            }
                            DebuggingProcess.this.vm.start(false);
                        }
                    }
                    Object object = DebuggingProcess.this.vmSync;
                    synchronized (object) {
                        block24: {
                            if (DebuggingProcess.this.vm != null) break block24;
                            return;
                        }
                        DebuggingProcess.this.vm.resume();
                    }
                    DebuggingProcess.this.showLogPageToolbar(true);
                    JDebugger.getInstance().debuggingProcessStarted(DebuggingProcess.this);
                    Runner.getRunner().selectProcess((RunProcess)DebuggingProcess.this);
                }
                finally {
                    if (this.wc != null) {
                        this.wc.hide();
                    }
                }
            }
        };
        worker.execute();
    }

    private List<DebuggerListener> getDebuggerListeners() {
        if (this.debuggerListeners == null) {
            this.debuggerListeners = DebuggerHook.getDebuggerListeners((Project)this.getProject());
        }
        return this.debuggerListeners;
    }

    private void sendDebuggerEvent(int eventType, int state) {
        try {
            if (this.debuggerEventSource == null) {
                this.debuggerEventSource = new EventSource();
            }
            this.debuggerEventSource.eventOccurring(eventType, state);
            List<DebuggerListener> debuggerListeners = this.getDebuggerListeners();
            DebuggerEvent event = new DebuggerEvent((Object)this.debuggerEventSource, eventType);
            for (DebuggerListener debuggerListener : debuggerListeners) {
                try {
                    switch (eventType) {
                        case 1: {
                            debuggerListener.debuggerStarted(event);
                            break;
                        }
                        case 2: {
                            debuggerListener.debuggerStopping(event);
                            break;
                        }
                        case 3: {
                            debuggerListener.debuggerResuming(event);
                            break;
                        }
                        case 4: {
                            debuggerListener.debuggerFinished(event);
                        }
                    }
                }
                catch (Exception ex) {
                    FeedbackManager.reportException((Throwable)ex);
                }
            }
            switch (eventType) {
                case 3: 
                case 4: {
                    this.clearEvaluatorHandles();
                }
            }
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
    }

    DebuggerEventSource getLastEventSource() {
        return this.debuggerEventSource;
    }

    boolean canPop1StackFrame(Context context) {
        return this.pop1StackFrame(false, context);
    }

    void pop1StackFrame(Context context) {
        this.pop1StackFrame(true, context);
    }

    private boolean pop1StackFrame(boolean doIt, Context context) {
        try {
            DebugMethodInfo method;
            DebugLocation location;
            DebugStackFrameInfo popTo;
            int sfCount;
            DebugCapabilities capabilities;
            if (this.vm != null && this.stopped && this.vm.getCapabilities().canPopFrames() && (capabilities = this.vm.getCapabilities()).canPopFrames() && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread) && (sfCount = this.currentThread.getStackFrameCount()) > 1 && (popTo = this.currentThread.getStackFrame(1)) != null && (location = popTo.getLocation()) != null && (method = location.getMethod()) != null && (method.getAccess() & 0x100) == 0) {
                if (doIt) {
                    popTo.popBackToHere();
                    this.stackFramesPopped(this.currentThread);
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    boolean canRestartMethod(int frameNumber, Context context) {
        return this.restartMethod(false, frameNumber, context);
    }

    boolean restartMethod(int frameNumber, Context context) {
        return this.restartMethod(true, frameNumber, context);
    }

    boolean restartCurrentMethod(Context context) {
        return this.restartMethod(true, 0, context);
    }

    private boolean restartMethod(boolean doIt, int frameNumber, Context context) {
        try {
            DebugMethodInfo method;
            DebugLocation location;
            DebugStackFrameInfo popTo;
            int sfCount;
            DebugCapabilities capabilities;
            if (this.vm != null && this.stopped && this.vm.getCapabilities().canPopFrames() && (capabilities = this.vm.getCapabilities()).canPopFrames() && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread) && (sfCount = this.currentThread.getStackFrameCount()) > 1 && (popTo = this.currentThread.getStackFrame(frameNumber + 1)) != null && (location = popTo.getLocation()) != null && (method = location.getMethod()) != null && (method.getAccess() & 0x100) == 0) {
                if (doIt) {
                    popTo.popBackToHere();
                    JDebugger debugger = JDebugger.getInstance();
                    IdeAction stepInto = debugger.getActionDebugStepInto();
                    debugger.handleEvent(stepInto, context);
                    this.stackFramesPopped(this.currentThread);
                }
                return true;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return false;
    }

    boolean canSetTracing() {
        try {
            return this.vm != null && this.vm.getCapabilities().canSetDebuggablePackages();
        }
        catch (Exception exception) {
            return false;
        }
    }

    void setTracing() {
        DebugConfiguration debugConfiguration = this.getDebugConfiguration();
        this.vm.setDebuggablePackages(debugConfiguration.getTracingInclude(), debugConfiguration.getTracingExclude());
    }

    protected final List getTracingIncludeList() {
        return this.getDebugConfiguration().getTracingIncludeList();
    }

    protected final List getTracingExcludeList() {
        return this.getDebugConfiguration().getTracingExcludeList();
    }

    public boolean canTerminate() {
        if (this.vm != null) {
            return true;
        }
        return super.canTerminate();
    }

    public void started() {
        if (this.isStartOnly()) {
            super.started();
        }
    }

    void accept(DebugVirtualMachine vm, DebugConnectArg[] connectArgs) {
        String disconnectedMsg;
        String acceptedMsg;
        this.skipCompile = true;
        this.vm = vm;
        String port = this.findPortValue(connectArgs);
        if (this.databaseDebugging) {
            this.databaseDebuggingHelper.connectionAccepted();
            acceptedMsg = DbgArb.format(176, port);
            disconnectedMsg = DbgArb.getString(151);
        } else {
            acceptedMsg = DbgArb.format(177, port);
            disconnectedMsg = DbgArb.getString(162);
        }
        this.log(acceptedMsg);
        MessagePage mp = null;
        LogPage lp = this.getLogPage();
        if (lp instanceof MessagePage) {
            mp = (MessagePage)lp;
        }
        vm.afterConnection(mp);
        this.afterConnection(disconnectedMsg);
    }

    void listenerStopped() {
        if (this.databaseDebugging) {
            this.databaseDebuggingHelper.listenerStopped();
        }
    }

    long getStoppedCount() {
        return this.stoppedCount;
    }

    @Override
    public void programStopped() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String msg = null;
                Object object = DebuggingProcess.this.vmSync;
                synchronized (object) {
                    if (DebuggingProcess.this.checkForInternalPause(DebuggingProcess.this.vm != null)) {
                        return;
                    }
                    boolean[] blArray = DebuggingProcess.this.pause;
                    synchronized (blArray) {
                        ((DebuggingProcess)DebuggingProcess.this).pause[1] = false;
                    }
                    if (DebuggingProcess.this.vm == null) {
                        return;
                    }
                    if (DebuggingProcess.this.timeProgramStopped == 0L) {
                        DebuggingProcess.this.timeProgramStopped = System.currentTimeMillis();
                    }
                    if (DebuggingProcess.this.vm.getCurrentStatus() == 8) {
                        msg = DbgArb.getString(309);
                    }
                }
                DebuggingProcess.this.logMessages();
                if (msg != null) {
                    DebuggingProcess.this.logMessage(msg);
                }
                if (DebuggingProcess.this.vm == null) {
                    return;
                }
                if (JDebugger.getInstance().isActiveDebuggingProcess(DebuggingProcess.this)) {
                    DebuggingProcess.this.activeProgramStopped();
                } else {
                    Runnable runAfterSelected = new Runnable(){

                        @Override
                        public void run() {
                            DebuggingProcess.this.activeProgramStopped();
                        }
                    };
                    DebuggingProcess.this.runAfterSelectedList.add(runAfterSelected);
                    Runner.getRunner().selectProcess((RunProcess)DebuggingProcess.this);
                }
            }
        });
    }

    @Override
    public void breakpointChanged(final DebugBreakpoint dbp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DebuggingProcess.this.vm == null) {
                    return;
                }
                if (dbp != DebuggingProcess.this.temporaryBreakpoint) {
                    JDebugger.getInstance().breakpointChanged(DebuggingProcess.this, dbp);
                }
            }
        });
    }

    @Override
    public void programTerminating() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void programTerminated() {
        Object object = this.vmSync;
        synchronized (object) {
            this.vm = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DebuggingProcess.this.logMessages();
                Object object = DebuggingProcess.this.vmSync;
                synchronized (object) {
                    DebuggingProcess.this.checkForInternalPause(false);
                }
                if (DebuggingProcess.this.debugfilesHandler != null) {
                    DebuggingProcess.this.debugfilesHandler.openOutputFile(true);
                }
                DebuggingProcess.this.sendDebuggerEvent(4, 400);
                if (DebuggingProcess.this.isRemoteDebuggingProfiling()) {
                    DebuggingProcess.this.finished();
                } else {
                    DebuggingProcess.this.superTerminate();
                }
                DebuggingProcess.this.checkCommands();
                DebuggingProcess.this.doRunAfterPause(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionLost() {
        if (this.detachStartedProcesses != null) {
            for (DebuggingProcess debProc : this.detachStartedProcesses) {
                if (debProc == null) continue;
                debProc.detach();
            }
        }
        Object object = this.vmSync;
        synchronized (object) {
            this.vm = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DebuggingProcess.this.logMessages();
                DebuggingProcess.this.logMessage(DbgArb.getString(181));
                Object object = DebuggingProcess.this.vmSync;
                synchronized (object) {
                    DebuggingProcess.this.checkForInternalPause(false);
                }
                if (DebuggingProcess.this.debugfilesHandler != null) {
                    DebuggingProcess.this.debugfilesHandler.openOutputFile(true);
                }
                DebuggingProcess.this.sendDebuggerEvent(4, 401);
                if (DebuggingProcess.this.isRemoteDebuggingProfiling()) {
                    DebuggingProcess.this.finished();
                } else {
                    DebuggingProcess.this.superTerminate();
                }
                DebuggingProcess.this.checkCommands();
                DebuggingProcess.this.doRunAfterPause(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logBreakpoint(DebugBreakpoint dbp, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        String msg = null;
        Object object = this.vmSync;
        synchronized (object) {
            if (this.vm == null) {
                return;
            }
            Breakpoint bp = JDebugger.getInstance().findBreakpoint(dbp);
            msg = BreakpointRuntimeSupport.logBreakpoint(bp, dbp.getLogMessage(thread, stack), this.vm, thread, stack);
        }
        this.logMessages();
        if (msg != null) {
            this.logMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logException(DebugBreakpoint dbp, String classname, String detail, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        String msg = null;
        Object object = this.vmSync;
        synchronized (object) {
            if (this.vm == null) {
                return;
            }
            Breakpoint bp = JDebugger.getInstance().findBreakpoint(dbp);
            msg = BreakpointRuntimeSupport.logException(bp, dbp.getLogMessage(thread, stack), this.vm, thread, stack, classname, detail);
        }
        this.logMessages();
        if (msg != null) {
            this.logMessage(msg);
        }
    }

    @Override
    public void logClassLoad(DebugBreakpoint dbp, String classname, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
    }

    @Override
    public void logAllocation(DebugBreakpoint dbp, DebugHeapObjectInfo heapObject, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logDeadlock(DebugBreakpoint dbp, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        String msg = null;
        Object object = this.vmSync;
        synchronized (object) {
            if (this.vm == null) {
                return;
            }
            Breakpoint bp = JDebugger.getInstance().findBreakpoint(dbp);
            msg = BreakpointRuntimeSupport.logDeadlock(bp, dbp.getLogMessage(thread, stack), this.vm, thread, stack);
        }
        this.logMessages();
        if (msg != null) {
            this.logMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logWatchpoint(DebugBreakpoint dbp, DebugFieldInfo field, DebugDataInfo futureValue, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        String msg = null;
        Object object = this.vmSync;
        synchronized (object) {
            if (this.vm == null) {
                return;
            }
            Breakpoint bp = JDebugger.getInstance().findBreakpoint(dbp);
            msg = BreakpointRuntimeSupport.logWatchpoint(bp, dbp.getLogMessage(thread, stack), this.vm, thread, stack, field, futureValue);
        }
        this.logMessages();
        if (msg != null) {
            this.logMessage(msg);
        }
    }

    private void logMessage(final String msg) {
        this.waitForRedirectOutput();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggingProcess.this.log(msg);
            }
        });
    }

    public DebugVirtualMachine getVM() {
        return this.vm;
    }

    DebugThreadInfo[][] getDeadlocks() {
        if (this.deadlocks == null && this.vm != null) {
            this.deadlocks = this.vm.getDeadlockedThreads();
        }
        return this.deadlocks;
    }

    boolean isStopped() {
        return this.vm != null && this.stopped && !this.resuming;
    }

    private boolean isLocationDebuggable() {
        DebugClassInfo clazz;
        return this.currentLocation != null && (clazz = this.currentLocation.getClassInfo()).isDebuggable();
    }

    void stackFramesPopped(DebugThreadInfo thread) {
        if (thread == this.currentThread) {
            this.updateCurrentLocation(true);
        }
        JDebugger.getInstance().stackFramesPopped();
    }

    void setCurrentThread(DebugThreadInfo thread) {
        this.setCurrentThread(thread, true);
    }

    private static boolean isThreadGood(DebugThreadInfo thread) {
        int status = thread.getStatus();
        return (status == 2 || status == 3 || status == 4 || status == 5) && thread.getStackFrameCount() > 0;
    }

    private void setCurrentThread(DebugThreadInfo thread, boolean updateSource) {
        if (thread != null) {
            this.currentThread = thread;
        } else if (this.lastKnownGoodThread != null && DebuggingProcess.isThreadGood(this.lastKnownGoodThread)) {
            this.currentThread = this.lastKnownGoodThread;
        } else {
            DebugThreadInfo mainThread = null;
            DebugThreadInfo eventThread = null;
            DebugThreadInfo mainGroupThread = null;
            DebugThreadInfo otherThread = null;
            for (DebugThreadInfo t : this.vm.listThreads()) {
                if (t.getGroupName().equals("main")) {
                    String name = t.getName();
                    if (mainThread == null && name.equals("main")) {
                        if (!DebuggingProcess.isThreadGood(t)) continue;
                        mainThread = t;
                        continue;
                    }
                    if (eventThread == null && name.startsWith("AWT-Event")) {
                        if (!DebuggingProcess.isThreadGood(t)) continue;
                        eventThread = t;
                        continue;
                    }
                    if (mainGroupThread != null || !DebuggingProcess.isThreadGood(t)) continue;
                    mainGroupThread = t;
                    continue;
                }
                if (otherThread != null || !DebuggingProcess.isThreadGood(t)) continue;
                otherThread = t;
            }
            if (mainThread != null) {
                this.currentThread = mainThread;
            } else if (eventThread != null) {
                this.currentThread = eventThread;
            } else if (mainGroupThread != null) {
                this.currentThread = mainGroupThread;
            } else if (otherThread != null) {
                this.currentThread = otherThread;
            }
        }
        if (this.currentThread != null) {
            this.lastKnownGoodThread = this.currentThread;
        }
        this.updateCurrentLocation(updateSource);
    }

    DebugLocation getCurrentLocation() {
        return this.currentLocation;
    }

    private void updateCurrentLocation(boolean updateSource) {
        if (updateSource) {
            this.hideSourceIPIcon();
        }
        this.currentStackFrame = null;
        this.currentLocation = null;
        if (this.currentThread != null) {
            this.currentStackFrame = DebuggingProcess.getNonNativeStackFrame(this.currentThread);
            DebugLocation debugLocation = this.currentLocation = this.currentStackFrame != null ? this.currentStackFrame.getLocation() : null;
        }
        if (updateSource) {
            if (this.currentStackFrame != null && this.currentStackFrame.getFrameNumber() == 0 && this.debuggerExtenderShowIPLocation()) {
                this.showSourceIPIcon(false);
            } else {
                this.showSourceIPIcon(true);
            }
            SmartWindow smartWindow = JDebugger.getInstance().getSmartWindow(false);
            if (smartWindow != null) {
                smartWindow.updateData(this, this.vm, this.currentThread, this.currentStackFrame);
            }
        }
    }

    boolean isCurrentThread(DebugThreadInfo thread) {
        return this.currentThread != null && this.currentThread.equals(thread);
    }

    public void superTerminate() {
        super.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (this.detachStartedProcesses != null) {
            for (DebuggingProcess debProc : this.detachStartedProcesses) {
                if (debProc == null) continue;
                debProc.detach();
            }
        }
        if (this.starter != null && this.starter.canTerminateGracefully()) {
            Object i$;
            if (this.vm != null) {
                this.sendDebuggerEvent(4, 402);
                this.debuggeeResuming(false, true);
                this.vm.disconnect(false);
                i$ = this.vmSync;
                synchronized (i$) {
                    this.vm = null;
                }
                this.clearProcessActionButtonsFromToolbar();
            }
            this.starter.terminateGracefully();
            i$ = this.vmSync;
            synchronized (i$) {
                this.vm = null;
            }
            return;
        }
        if (this.vm != null) {
            if (this.isRemoteDebuggingProfiling() && this.vm.wasRunning()) {
                String[] messages = new String[]{DbgArb.getString(734), DbgArb.getString(735), DbgArb.getString(736), DbgArb.getString(737)};
                Object[] answers = new String[]{DbgArb.getString(738), DbgArb.getString(739), DbgArb.getString(740)};
                int answer = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), messages, DbgArb.getString(733), -1, 2, null, answers, answers[0]);
                if (answer == -1 || answer == 2) {
                    return;
                }
                if (answer == 0) {
                    this.detach();
                    return;
                }
            }
            this.sendDebuggerEvent(4, 402);
            this.debuggeeResuming(false, true);
            final DebugVirtualMachine vmFinal = this.vm;
            Thread disconnectThread = new Thread("DebugDisconnect"){

                @Override
                public void run() {
                    if (vmFinal != null) {
                        vmFinal.disconnect(true);
                    }
                }
            };
            Object object = this.vmSync;
            synchronized (object) {
                this.vm = null;
            }
            this.clearProcessActionButtonsFromToolbar();
            if (this.isRemoteDebuggingProfiling()) {
                this.finished();
            }
            disconnectThread.start();
        } else {
            super.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        if (!this.isStartOnly()) {
            BytecodeFileSystemHelper bytecodeHelper = BytecodeFileSystemHelper.getInstance(false);
            if (bytecodeHelper != null) {
                bytecodeHelper.removeStaleMethods();
            }
            DebuggingProcess.clearStatus();
            if (this.databaseDebugging) {
                this.databaseDebuggingHelper.finished();
            }
            Object object = this.vmSync;
            synchronized (object) {
                this.vm = null;
            }
            this.lastKnownGoodThread = null;
            if (this.disconnectedMessage != null) {
                this.logMessage(this.disconnectedMessage);
                this.disconnectedMessage = null;
            }
            if (this.temporaryBreakpoint != null) {
                this.temporaryBreakpoint = null;
            }
            JDebugger.getInstance().clearTempBreakpoint(this);
            this.currentBreakpoint = null;
            List[] breakpoints = Breakpoint.getBreakpoints((Workspace)this.getWorkspace(), (Project)this.getProject());
            int length = breakpoints.length;
            for (int i = 0; i < length; ++i) {
                for (Breakpoint bp : breakpoints[i]) {
                    BreakpointRuntimeSupport.processFinished(bp, this);
                }
            }
            JDebugger.getInstance().debuggingProcessFinished(this);
            this.clearProcessActionButtonsFromToolbar();
        }
        super.finished();
    }

    protected void showLocation(DebugLocation location, boolean selectLine) {
        if (location != null) {
            if (this.vm != null && this.vm.getCapabilities().canShowDebugLocations() && this.vm.showDebugLocation(location)) {
                return;
            }
            int line = location.getLine();
            if (line != 0) {
                DebugClassInfo clazz = location.getClassInfo();
                String filename = location.getFilename();
                this.showSourceFile(clazz, filename, line, selectLine);
            } else {
                this.showSourceFile(location.getMethod());
            }
        }
    }

    protected void showSourceFile(DebugMethodInfo method) {
        try {
            SourceClass sourceClass;
            String className = method.getClassInfo().getName();
            className = className.replace('$', '.');
            String methodName = method.getNameWithoutClassOrSignature();
            String fullMethodName = method.getName();
            Project jproject = this.getJProject();
            JavaManager javaManager = JavaManager.getAnyJavaManager((Project)jproject);
            JavaClass javaClass = javaManager.getClass(className);
            if (javaClass != null && (sourceClass = (SourceClass)javaClass.getSourceElement()) != null) {
                if (methodName.equals("<clinit>")) {
                    JavaMethod javaMethod = javaClass.getClinitMethod();
                    if (javaMethod instanceof SourceMethod) {
                        int n;
                        SourceMethod sourceMethod = (SourceMethod)javaMethod;
                        URL url = sourceClass.getURL();
                        int n2 = -sourceMethod.getStartOffset();
                        SourceName sourceName = sourceMethod.getNameElement();
                        if (sourceName != null) {
                            n = -sourceName.getStartOffset();
                        }
                        boolean showNavigationPointInHistory = this.shouldShowNavigationPointInHistory();
                        Source.showSourceFile(this.getWorkspace(), this.getProject(), url, n, true, showNavigationPointInHistory);
                        return;
                    }
                    List l = sourceClass.getSourceInitializers();
                    if (l != null && l.size() > 0) {
                        SourceClassInitializer sourceClassInitializer = (SourceClassInitializer)l.get(0);
                        URL uRL = sourceClass.getURL();
                        int line = -sourceClassInitializer.getStartOffset();
                        boolean showNavigationPointInHistory = this.shouldShowNavigationPointInHistory();
                        Source.showSourceFile(this.getWorkspace(), this.getProject(), uRL, line, true, showNavigationPointInHistory);
                        return;
                    }
                }
                ArrayList<JavaMethod> methods = null;
                if (methodName.equals("<init>")) {
                    methods = sourceClass.getDeclaredConstructors();
                } else {
                    Collection c = sourceClass.getDeclaredMethods();
                    if (c != null && c.size() > 0) {
                        methods = new ArrayList<JavaMethod>();
                        for (JavaMethod javaMethod : c) {
                            if (!javaMethod.getName().equals(methodName)) continue;
                            methods.add(javaMethod);
                        }
                    }
                }
                if (methods != null) {
                    int iSignature = fullMethodName.indexOf(40);
                    ++iSignature;
                    for (Object e : methods) {
                        if (!(e instanceof SourceMethod)) continue;
                        SourceMethod sourceMethod = (SourceMethod)e;
                        boolean parametersMatch = true;
                        Iterator itP = sourceMethod.getParameters().iterator();
                        while (itP.hasNext()) {
                            String parameter = ((JavaVariable)itP.next()).getResolvedType().getQualifiedName();
                            if (!fullMethodName.startsWith(parameter, iSignature)) {
                                parametersMatch = false;
                                break;
                            }
                            if (fullMethodName.charAt(iSignature += parameter.length()) != ',') continue;
                            ++iSignature;
                        }
                        if (fullMethodName.charAt(iSignature) != ')') {
                            parametersMatch = false;
                        }
                        if (!parametersMatch) continue;
                        URL url = sourceClass.getURL();
                        int line = -sourceMethod.getStartOffset();
                        SourceName sourceName = sourceMethod.getNameElement();
                        if (sourceName != null) {
                            line = -sourceName.getStartOffset();
                        }
                        boolean showNavigationPointInHistory = this.shouldShowNavigationPointInHistory();
                        Source.showSourceFile(this.getWorkspace(), this.getProject(), url, line, true, showNavigationPointInHistory);
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int line = 1;
        int[] lineRange = method.getMethodLineRange();
        if (lineRange != null) {
            line = lineRange[0];
        }
        DebugClassInfo clazz = method.getClassInfo();
        this.showSourceFile(clazz, clazz.getPrimarySourceFilename(), line, false);
    }

    protected void showSourceFile(DebugFieldInfo field) {
        try {
            JavaField javaField;
            SourceClass sourceClass;
            String className = field.getDeclaringClassInfo().getName();
            className = className.replace('$', '.');
            String fieldName = field.getName();
            className = className.replace('$', '.');
            Project jproject = this.getJProject();
            JavaManager javaManager = JavaManager.getAnyJavaManager((Project)jproject);
            JavaClass javaClass = javaManager.getClass(className);
            if (javaClass != null && (sourceClass = (SourceClass)javaClass.getSourceElement()) != null && (javaField = sourceClass.getDeclaredField(fieldName)) instanceof SourceElement) {
                SourceName sourceName;
                SourceElement sourceField = (SourceElement)javaField;
                URL url = sourceClass.getURL();
                int line = -sourceField.getStartOffset();
                if (sourceField instanceof SourceHasName && (sourceName = ((SourceHasName)sourceField).getNameElement()) != null) {
                    line = -sourceName.getStartOffset();
                }
                boolean showNavigationPointInHistory = this.shouldShowNavigationPointInHistory();
                Source.showSourceFile(this.getWorkspace(), this.getProject(), url, line, true, showNavigationPointInHistory);
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        DebugClassInfo clazz = field.getDeclaringClassInfo();
        this.showSourceFile(clazz, clazz.getPrimarySourceFilename(), 1, false);
    }

    private boolean shouldShowNavigationPointInHistory() {
        if (this.currentLocation == null || this.currentLocation.getMethod() == null) {
            return true;
        }
        String currentMethodSig = this.currentLocation.getMethod().getName();
        if (currentMethodSig.equals(this.locationOfLastShownNavigationPoint)) {
            return false;
        }
        this.locationOfLastShownNavigationPoint = currentMethodSig;
        return true;
    }

    protected void showSourceFile(DebugClassInfo clazz) {
        try {
            SourceClass sourceClass;
            String className = clazz.getName();
            className = className.replace('$', '.');
            Project jproject = this.getJProject();
            JavaManager javaManager = JavaManager.getAnyJavaManager((Project)jproject);
            JavaClass javaClass = javaManager.getClass(className);
            if (javaClass != null && (sourceClass = (SourceClass)javaClass.getSourceElement()) != null) {
                URL url = sourceClass.getURL();
                SourceName sourceName = sourceClass.getNameElement();
                int line = sourceName != null ? -sourceName.getStartOffset() : -sourceClass.getStartOffset();
                boolean showNavigationPointInHistory = this.shouldShowNavigationPointInHistory();
                Source.showSourceFile(this.getWorkspace(), this.getProject(), url, line, true, showNavigationPointInHistory);
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        DebugMethodInfo[] methods = clazz.getMethods();
        if (methods != null) {
            int methodsLength = methods.length;
            DebugLocation firstLocation = null;
            for (int i = 0; i < methodsLength; ++i) {
                DebugLocation location = methods[i].getFirstLocation();
                if (location == null) continue;
                int line = location.getLine();
                if (firstLocation != null && (line == 0 || line >= firstLocation.getLine())) continue;
                firstLocation = location;
            }
            if (firstLocation != null) {
                this.showLocation(firstLocation, false);
                return;
            }
        }
        this.showSourceFile(clazz, clazz.getPrimarySourceFilename(), 1, false);
    }

    private Node findSourceFile(DebugClassInfo clazz, String filename) {
        try {
            if (clazz != null && filename != null && filename.length() > 0) {
                Node node;
                String pkg = clazz.getPackage();
                Workspace workspace = this.getWorkspace();
                Project project = this.getProject();
                URL url = null;
                if (this.databaseDebugging) {
                    url = this.databaseDebuggingHelper.findSourceFile(workspace, project, pkg, filename);
                }
                if (url == null) {
                    url = Source.findSourceFile(workspace, project, pkg, filename);
                }
                if (url != null && (node = NodeFactory.findOrCreate(url)) != null) {
                    return node;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected Node showSourceFile(DebugClassInfo clazz, String filename, int line, boolean selectLine) {
        return this.showSourceFile(clazz, filename, line, selectLine, null);
    }

    protected Node showSourceFile(DebugClassInfo clazz, String filename, int line, boolean selectLine, String sourceNotFoundMessage) {
        if (clazz != null) {
            Node node = this.findSourceFile(clazz, filename);
            if (node != null) {
                boolean showNavigationPointInHistory = this.shouldShowNavigationPointInHistory();
                if (Source.showSourceFile(this.getWorkspace(), this.getProject(), node, line, selectLine, showNavigationPointInHistory)) {
                    return node;
                }
            }
            Source.showSourceFile(this.getWorkspace(), this.getProject(), clazz.getPackage(), clazz.getName(), filename, line, selectLine, sourceNotFoundMessage, this.vm);
        }
        return null;
    }

    boolean canDebuggerExtenderShowIPLocation() {
        return this.canDebuggerExtenderShowIPBreakpointLocation() || this.canDebuggerExtenderShowIPStepLocation();
    }

    boolean canDebuggerExtenderShowIPBreakpointLocation() {
        if (this.vm == null || !this.stopped) {
            return false;
        }
        ExtenderManager extenderManager = ExtenderManager.getInstance();
        if (extenderManager.stoppedAtExtenderBreakpoint(this.currentBreakpoint)) {
            return extenderManager.canShowIPLocation(this.getContext(), this.currentBreakpoint);
        }
        return false;
    }

    boolean canDebuggerExtenderShowIPStepLocation() {
        if (this.vm == null || !this.stopped || this.vm.getCurrentStackFrame() == null || this.vm.getCurrentStackFrame().getLocation() == null) {
            return false;
        }
        ExtenderManager extenderManager = ExtenderManager.getInstance();
        DebugLocation currentLocation = this.vm.getCurrentStackFrame().getLocation();
        return extenderManager.canShowIPLocation(this.getContext(), currentLocation);
    }

    boolean debuggerExtenderShowIPLocation() {
        if (this.vm == null || !this.stopped) {
            return false;
        }
        return this.canDebuggerExtenderShowIPBreakpointLocation() ? ExtenderManager.getInstance().showIPLocation(this.getContext(), this.currentBreakpoint) : this.canDebuggerExtenderShowIPStepLocation() && ExtenderManager.getInstance().showIPLocation(this.getContext(), this.currentLocation);
    }

    private void showSourceIPIcon(boolean openCodeEditor) {
        this.showSourceIPIcon(openCodeEditor, null);
    }

    private void showSourceIPIcon(boolean openCodeEditor, String sourceNotFoundMessage) {
        boolean javaLineNotAvailable = false;
        try {
            if (this.currentLocation != null) {
                if (openCodeEditor && this.vm != null && this.vm.getCapabilities().canShowDebugLocations() && this.vm.showDebugLocation(this.currentLocation)) {
                    return;
                }
                int line = this.currentLocation.getLine();
                if (line > 0) {
                    DebugClassInfo clazz = this.currentLocation.getClassInfo();
                    String filename = this.currentLocation.getFilename();
                    Node node = null;
                    node = openCodeEditor ? this.showSourceFile(clazz, filename, line, false, sourceNotFoundMessage) : this.findSourceFile(clazz, filename);
                    if (filename.length() > 0) {
                        String pkg = clazz.getPackage();
                        Workspace workspace = this.getWorkspace();
                        URL workspaceURL = workspace != null && workspace != Ide.getDefaultWorkspace() ? workspace.getURL() : null;
                        this.sourceIconForIP = new SourceIcon(workspaceURL, null, pkg, filename, line, node, OracleIcons.getIcon((String)"debugger/show_ip.gif"), SourceIcon.ipStyle, 2, null);
                    }
                } else {
                    javaLineNotAvailable = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.showSourceIconForIPBytecode(openCodeEditor && javaLineNotAvailable);
    }

    void showSourceIconForIPBytecode(boolean openBytecode) {
        block5: {
            try {
                int line;
                URL url;
                int offset;
                BytecodeFileSystemHelper bytecodeHelper;
                if (this.sourceIconForIPBytecode != null || this.currentLocation == null || (bytecodeHelper = BytecodeFileSystemHelper.getInstance(false)) == null || (offset = this.currentLocation.getBytecodeOffset()) == -1) break block5;
                DebugMethodInfo method = this.currentLocation.getMethod();
                if (openBytecode) {
                    this.showBytecode(method, offset);
                    if (this.sourceIconForIPBytecode != null) {
                        return;
                    }
                }
                if ((url = bytecodeHelper.getURL(this, method)) == null || (line = bytecodeHelper.getLineFromBytecodeOffset(url, offset)) == 0) break block5;
                Node node = NodeFactory.find((URL)url);
                Workspace workspace = this.getWorkspace();
                URL workspaceURL = workspace != null && workspace != Ide.getDefaultWorkspace() ? workspace.getURL() : null;
                this.sourceIconForIPBytecode = new SourceIcon(workspaceURL, null, url, line, node, OracleIcons.getIcon((String)"debugger/show_ip.gif"), SourceIcon.ipStyle, 2, null);
                if (node == null) break block5;
                Context context = Context.newIdeContext((Node)node);
                Project project = this.getProject();
                List editors = EditorManager.getEditorManager().findEditors(context);
                if (editors == null) break block5;
                for (Object o : editors) {
                    if (!(o instanceof CodeEditor)) continue;
                    Source.showSourceFile(workspace, project, node, line, false);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    SourceIcon getSourceIconForIP() {
        return this.sourceIconForIP;
    }

    void showBytecode(DebugMethodInfo method, int offset) {
        BytecodeFileSystemHelper bytecodeHelper = BytecodeFileSystemHelper.getInstance(true);
        URL url = bytecodeHelper.addMethod(this, method);
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node != null) {
                Workspace workspace = this.getWorkspace();
                Project project = this.getProject();
                int line = bytecodeHelper.getLineFromBytecodeOffset(url, offset);
                Source.showSourceFile(workspace, project, node, line, false);
                this.showSourceIconForIPBytecode(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void hideSourceIPIcon() {
        if (this.sourceIconForIP != null) {
            this.sourceIconForIP.hide();
            this.sourceIconForIP = null;
        }
        if (this.sourceIconForIPBytecode != null) {
            this.sourceIconForIPBytecode.hide();
            this.sourceIconForIPBytecode = null;
        }
    }

    private void debuggeeResuming(boolean stepping, boolean aboutToDisconnect) {
        if (this.timerTaskUpdateNormalWindows != null) {
            this.timerTaskUpdateNormalWindows.cancel();
            this.timerTaskUpdateNormalWindows = null;
        }
        if (this.timerTaskUpdateOtherWindows != null) {
            this.timerTaskUpdateOtherWindows.cancel();
            this.timerTaskUpdateOtherWindows = null;
        }
        this.stepRequestTime = 0L;
        this.resuming = true;
        JDebugger jdebugger = JDebugger.getInstance();
        if (jdebugger.isActiveDebuggingProcess(this)) {
            this.hideSourceIPIcon();
            ThreadsWindow threadsWindow = jdebugger.getThreadsWindow(true);
            SmartWindow smartWindow = jdebugger.getSmartWindow(false);
            ClassesWindow classesWindow = jdebugger.getClassesWindow(false);
            HeapWindow heapWindow = jdebugger.getHeapWindow(false);
            MonitorsWindow monitorsWindow = jdebugger.getMonitorsWindow(false);
            if (aboutToDisconnect) {
                threadsWindow.updateThreads(this, null, null);
                if (smartWindow != null) {
                    smartWindow.updateData(this, null, null, null);
                }
                if (classesWindow != null) {
                    classesWindow.updateClasses(this, null);
                }
                if (heapWindow != null) {
                    heapWindow.updateData(this, null, null, null);
                }
                if (monitorsWindow != null) {
                    monitorsWindow.updateMonitors(this, null);
                }
            } else {
                threadsWindow.clearThreads();
                if (smartWindow != null) {
                    smartWindow.clearData();
                }
                if (classesWindow != null) {
                    classesWindow.clearClasses();
                }
                if (heapWindow != null) {
                    heapWindow.clearData();
                }
                if (monitorsWindow != null) {
                    monitorsWindow.clearMonitors();
                }
            }
        }
        this.currentThread = null;
        this.currentStackFrame = null;
        this.currentLocation = null;
        this.deadlocks = null;
        this.stepping = stepping;
    }

    private void debuggeeResumed() {
        this.resuming = false;
        this.stopped = false;
        this.checkCommands();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeProgramStopped() {
        DebuggingProcess.clearStatus();
        boolean useTimerToUpdateOtherWindows = true;
        boolean[] blArray = this.pause;
        synchronized (this.pause) {
            if (this.runAfterPausedList.size() > 0) {
                useTimerToUpdateOtherWindows = false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                this.debuggeeStopped(useTimerToUpdateOtherWindows);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.debugfilesHandler != null) {
                this.debugfilesHandler.openOutputFile(false);
            }
            this.doRunAfterPause(true);
            return;
        }
    }

    private void debuggeeStopped(boolean useTimerToUpdateOtherWindows) {
        this.stopped = true;
        ++this.stoppedCount;
        this.currentBreakpoint = null;
        JDebugger jdebugger = JDebugger.getInstance();
        if (this.temporaryBreakpoint != null) {
            this.temporaryBreakpoint.remove();
            this.temporaryBreakpoint = null;
        } else {
            jdebugger.clearTempBreakpoint(this);
        }
        DebugBreakpoint debugBreakpoint = this.vm.getCurrentBreakpoint();
        if (debugBreakpoint != null) {
            this.currentBreakpoint = jdebugger.debuggeeStoppedAtBreakpoint(this, debugBreakpoint);
            Ide.getMainWindow().toFront();
        }
        try {
            this.setCurrentThread(this.vm.getCurrentThread(), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int status = this.vm.getCurrentStatus();
        BytecodeFileSystemHelper bytecodeHelper = BytecodeFileSystemHelper.getInstance(false);
        if (bytecodeHelper != null) {
            bytecodeHelper.updateMethods(this);
        }
        if (jdebugger.isActiveDebuggingProcess(this)) {
            boolean showedIP = false;
            if (this.debuggerExtenderShowIPLocation()) {
                showedIP = true;
                this.showSourceIPIcon(false);
            }
            if (!showedIP) {
                try {
                    boolean openCodeEditor = true;
                    String sourceNotFoundMessage = null;
                    switch (status) {
                        case 1: {
                            sourceNotFoundMessage = DbgArb.getString(311);
                            break;
                        }
                        case 2: {
                            sourceNotFoundMessage = DbgArb.getString(312);
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 5: {
                            sourceNotFoundMessage = DbgArb.getString(313);
                            break;
                        }
                        case 7: {
                            sourceNotFoundMessage = DbgArb.getString(314);
                            break;
                        }
                        case 8: {
                            openCodeEditor = false;
                            break;
                        }
                        case 10: {
                            sourceNotFoundMessage = DbgArb.getString(315);
                            break;
                        }
                        case 11: {
                            sourceNotFoundMessage = DbgArb.getString(842);
                        }
                    }
                    this.showSourceIPIcon(openCodeEditor, sourceNotFoundMessage);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                jdebugger.setExecutionPointOffsetMark(this.getContext());
                try {
                    if (status != 8 && this.currentLocation != null && !this.isLocationDebuggable() && this.vm.getCapabilities().canSetDebuggablePackages()) {
                        String message = DbgArb.format(781, this.runConfiguration.getName(), DbgArb.getString(14));
                        message = message + DbgArb.getString(783);
                        if (!this.runConfiguration.isCustom()) {
                            message = message + DbgArb.format(784, this.runConfiguration.getName());
                        }
                        message = message + DbgArb.getString(785);
                        String title = this.getLogPage().getTitleName();
                        boolean answer = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)title, null);
                        if (answer) {
                            DebugConfiguration debugConfiguration = this.getDebugConfiguration();
                            TracingPanel.showTracingDialog(debugConfiguration);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (debugBreakpoint != null && debugBreakpoint.getCondition() != null && debugBreakpoint instanceof BreakpointConditionEvaluationResult) {
                CodeEditor editor = this.sourceIconForIP == null ? null : this.sourceIconForIP.getCodeEditor();
                jdebugger.showConditionalBreakpointResultInHover(this, editor, debugBreakpoint);
            }
            try {
                this.checkCommands();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.classLoadTracking();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            switch (status) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 10: {
                    this.sendDebuggerEvent(2, 200);
                    break;
                }
                case 7: {
                    this.sendDebuggerEvent(2, 201);
                    break;
                }
                case 8: {
                    this.sendDebuggerEvent(2, 202);
                }
            }
            try {
                if (this.timeWindowsUpdated != 0L) {
                    // empty if block
                }
                this.updateNormalWindows();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.timeWindowsUpdated != 0L && useTimerToUpdateOtherWindows) {
                    this.timerTaskUpdateOtherWindows = new TimerTask(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (DebuggingProcess.this.stopped && !DebuggingProcess.this.resuming && DebuggingProcess.this.timerTaskUpdateOtherWindows != null) {
                                        DebuggingProcess.this.updateOtherWindows();
                                    }
                                    DebuggingProcess.this.timerTaskUpdateOtherWindows = null;
                                }
                            });
                        }
                    };
                    if (timer == null) {
                        timer = new NamedTimer("DebuggingProcessTimer");
                    }
                    timer.schedule(this.timerTaskUpdateOtherWindows, 500L);
                } else {
                    this.updateOtherWindows();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (status == 5) {
                jdebugger.viewMonitors();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.timeWindowsUpdated == 0L) {
            this.timeWindowsUpdated = System.currentTimeMillis();
            long timeAfterCompile = this.getTimeAfterCompile();
            Assert.println((String)"Time to debug and hit breakpoint:");
            Assert.println((String)("    " + IdeUtil.prepad((String)Long.toString(this.timeProgramStopped - timeAfterCompile), (char)' ', (int)6) + " ms (measured from compiler finished to breakpoint hit)"));
            Assert.println((String)("    " + IdeUtil.prepad((String)Long.toString(this.timeWindowsUpdated - this.timeProgramStopped), (char)' ', (int)6) + " ms (measured from breakpoint hit to debugger windows updated)"));
            Assert.println((String)"    ---------");
            Assert.println((String)("    " + IdeUtil.prepad((String)Long.toString(this.timeWindowsUpdated - timeAfterCompile), (char)' ', (int)6) + " ms (total measured from compiler finished to debugger windows updated)"));
        }
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){
            boolean shouldResume = false;

            @Override
            public Boolean doInBackground() {
                this.shouldResume = DebuggingProcess.this.checkForPotentialClipboardDeadlock();
                return this.shouldResume;
            }

            @Override
            public void done() {
                try {
                    this.shouldResume = (Boolean)this.get();
                    if (this.shouldResume) {
                        DebuggingProcess.this.resume();
                    }
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        };
        worker.execute();
    }

    private void updateNormalWindows() {
        JDebugger jdebugger = JDebugger.getInstance();
        try {
            jdebugger.getThreadsWindow(true).updateThreads(this, this.vm, this.currentThread);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            SmartWindow smartWindow = jdebugger.getSmartWindow(false);
            if (smartWindow != null) {
                smartWindow.updateData(this, this.vm, this.currentThread, this.currentStackFrame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateNormalWindowsEndTime = System.currentTimeMillis();
    }

    private void updateOtherWindows() {
        MonitorsWindow monitorsWindow;
        HeapWindow heapWindow;
        JDebugger jdebugger = JDebugger.getInstance();
        ClassesWindow classesWindow = jdebugger.getClassesWindow(false);
        if (classesWindow != null) {
            classesWindow.updateClasses(this, this.vm);
        }
        if ((heapWindow = jdebugger.getHeapWindow(false)) != null) {
            heapWindow.updateData(this, this.vm, null, null);
        }
        if ((monitorsWindow = jdebugger.getMonitorsWindow(false)) != null) {
            monitorsWindow.updateMonitors(this, this.vm);
        }
    }

    private void classLoadTracking() {
        if (classLoadTracking == -1) {
            String debuggerClassLoadTracking = Ide.getProperty((String)"DebuggerClassLoadTracking");
            classLoadTracking = debuggerClassLoadTracking != null ? DebuggingProcess.parsePrint(debuggerClassLoadTracking) : 0;
        }
        if (classLoadTracking != 0 && this.vm.countClasses() != this.loadedClassesCount) {
            int i;
            DebugClassInfo[] loadedClasses = this.vm.listClasses();
            int loadedClassesLength = loadedClasses.length;
            String s = this.loadedClassesCount == 0 ? DbgArb.format(766, Integer.toString(loadedClassesLength)) : DbgArb.format(767, Integer.toString(loadedClassesLength - this.loadedClassesCount));
            this.print(classLoadTracking, s);
            int length = loadedClassesLength - this.loadedClassesCount;
            Object[] classNames = new String[length];
            for (i = 0; i < length; ++i) {
                classNames[i] = loadedClasses[i + this.loadedClassesCount].getName();
            }
            Arrays.sort(classNames);
            for (i = 0; i < length; ++i) {
                s = DbgArb.format(768, classNames[i]);
                this.print(classLoadTracking, s);
            }
            this.loadedClassesCount = loadedClassesLength;
            if (this.currentLocation != null) {
                String filename = this.currentLocation.getFilename();
                int line = this.currentLocation.getLine();
                s = DbgArb.format(770, Integer.toString(line), filename, Integer.toString(this.loadedClassesCount));
            } else {
                s = DbgArb.format(769, Integer.toString(this.loadedClassesCount));
            }
            this.print(classLoadTracking, s);
        }
    }

    private static int parsePrint(String s) {
        int print = 0;
        StringTokenizer st = new StringTokenizer(s, ",;| \t");
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            if (s.equalsIgnoreCase("System.out")) {
                print |= 1;
                continue;
            }
            if (s.equalsIgnoreCase("System.err")) {
                print |= 2;
                continue;
            }
            if (!s.equalsIgnoreCase("LogWindow")) continue;
            print |= 4;
        }
        return print;
    }

    private void print(int print, String s) {
        if ((print & 1) != 0) {
            System.out.println(s);
        }
        if ((print & 2) != 0) {
            System.err.println(s);
        }
        if ((print & 4) != 0) {
            this.log(s);
        }
    }

    protected void checkCommands() {
        JDebugger.getInstance().checkCommandsBecauseDebuggingProcessStateChanged(this);
    }

    protected boolean commonCommandEnablementChecks() {
        return this.vm != null && this.stopped && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread) && !this.executingRunWhilePausedTask;
    }

    public boolean canPause() {
        return this.pause(false);
    }

    protected void pause() {
        this.pause(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean pause(boolean doIt) {
        try {
            if (this.vm == null || this.stopped || !this.vm.getCapabilities().canPauseProgram()) return false;
            if (!doIt) return true;
            boolean[] blArray = this.pause;
            synchronized (this.pause) {
                this.pause[1] = true;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.vm.pauseProgram();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean canResume() {
        return this.resume(false);
    }

    public void resume() {
        this.resume(true);
    }

    private boolean resume(boolean doIt) {
        try {
            if (this.vm != null && this.stopped) {
                if (doIt) {
                    this.sendDebuggerEvent(3, 300);
                    this.debuggeeResuming(false, false);
                    this.vm.resume();
                    this.debuggeeResumed();
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean canDetach() {
        return this.detach(false);
    }

    void detach() {
        this.detach(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detach(boolean doIt) {
        block8: {
            if (this.detachStartedProcesses != null) {
                for (DebuggingProcess debProc : this.detachStartedProcesses) {
                    if (debProc == null) continue;
                    debProc.detach();
                }
            }
            try {
                if (this.vm == null || !this.isRemoteDebuggingProfiling()) break block8;
                if (doIt) {
                    this.sendDebuggerEvent(4, 403);
                    this.debuggeeResuming(false, true);
                    this.vm.disconnect(false);
                    Object i$ = this.vmSync;
                    synchronized (i$) {
                        this.vm = null;
                    }
                    this.finished();
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    boolean canStepOver() {
        try {
            return this.commonCommandEnablementChecks() && this.isLocationDebuggable();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean canDebuggerExtenderStepOver() {
        ExtenderManager extenderManager = ExtenderManager.getInstance();
        if (extenderManager.stoppedAtExtenderBreakpoint(this.currentBreakpoint)) {
            return extenderManager.canStepOver(this, this.currentBreakpoint);
        }
        return false;
    }

    void stepOver(long time) {
        if (this.canStepOver()) {
            JDebugger jDebugger = JDebugger.getInstance();
            if (!this.canDebuggerExtenderStepOver()) {
                this.sendDebuggerEvent(3, 301);
                DebugThreadInfo thread = this.currentThread;
                this.debuggeeResuming(true, false);
                this.stepRequestTime = time;
                thread.stepOver();
            } else {
                this.temporaryBreakpoint = jDebugger.debuggerExtenderStepOver(this, this.currentBreakpoint);
                this.sendDebuggerEvent(3, 301);
                this.debuggeeResuming(false, false);
                this.vm.resume();
            }
            this.debuggeeResumed();
        }
    }

    void stepOverBC(long time) {
        if (this.canStepOver()) {
            DebugThreadInfo thread = this.currentThread;
            this.sendDebuggerEvent(3, 301);
            this.debuggeeResuming(true, false);
            this.stepRequestTime = time;
            thread.stepOverBC();
            this.debuggeeResumed();
        }
    }

    boolean canStepInto() {
        try {
            if (this.commonCommandEnablementChecks()) {
                ExtenderManager extenderManager = ExtenderManager.getInstance();
                if (extenderManager.stoppedAtExtenderBreakpoint(this.currentBreakpoint)) {
                    return extenderManager.canStepInto(this, this.currentBreakpoint);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    void stepInto(long time) {
        if (this.canStepInto()) {
            JDebugger jDebugger = JDebugger.getInstance();
            this.temporaryBreakpoint = jDebugger.debuggerExtenderStepInto(this, this.currentBreakpoint);
            this.sendDebuggerEvent(3, 302);
            if (this.temporaryBreakpoint != null) {
                this.debuggeeResuming(false, false);
                this.vm.resume();
            } else {
                DebugThreadInfo thread = this.currentThread;
                this.debuggeeResuming(true, false);
                this.stepRequestTime = time;
                thread.stepInto();
            }
            this.debuggeeResumed();
        }
    }

    void stepIntoBC(long time) {
        if (this.canStepInto()) {
            DebugThreadInfo thread = this.currentThread;
            this.sendDebuggerEvent(3, 302);
            this.debuggeeResuming(true, false);
            this.stepRequestTime = time;
            thread.stepIntoBC();
            this.debuggeeResumed();
        }
    }

    boolean canStepOut() {
        try {
            if (this.commonCommandEnablementChecks()) {
                ExtenderManager extenderManager = ExtenderManager.getInstance();
                if (extenderManager.stoppedAtExtenderBreakpoint(this.currentBreakpoint)) {
                    return extenderManager.canStepOut(this, this.currentBreakpoint);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    void stepOut(long time) {
        if (this.canStepOut()) {
            this.temporaryBreakpoint = JDebugger.getInstance().debuggerExtenderStepOut(this, this.currentBreakpoint);
            this.sendDebuggerEvent(3, 303);
            if (this.temporaryBreakpoint != null) {
                this.debuggeeResuming(false, false);
                this.vm.resume();
            } else {
                DebugThreadInfo thread = this.currentThread;
                this.debuggeeResuming(true, false);
                this.stepRequestTime = time;
                thread.stepOut();
            }
            this.debuggeeResumed();
        }
    }

    boolean canStepToEndOfMethod() {
        try {
            if (this.commonCommandEnablementChecks() && this.vm.getCapabilities().canStepToEndOfMethod() && this.isLocationDebuggable()) {
                ExtenderManager extenderManager = ExtenderManager.getInstance();
                if (extenderManager.stoppedAtExtenderBreakpoint(this.currentBreakpoint)) {
                    return extenderManager.canStepToEndOfMethod(this, this.currentBreakpoint);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    void stepToEndOfMethod(long time) {
        if (this.canStepToEndOfMethod()) {
            this.temporaryBreakpoint = JDebugger.getInstance().debuggerExtenderStepToEndOfMethod(this, this.currentBreakpoint);
            this.sendDebuggerEvent(3, 304);
            if (this.temporaryBreakpoint != null) {
                this.debuggeeResuming(false, false);
                this.vm.resume();
            }
            DebugThreadInfo thread = this.currentThread;
            this.debuggeeResuming(true, false);
            this.stepRequestTime = time;
            thread.stepToEndOfMethod();
            this.debuggeeResumed();
        }
    }

    boolean canContinueStep() {
        if (this.xsltDebugging) {
            return false;
        }
        try {
            return this.vm != null && this.stopped && !this.executingRunWhilePausedTask && this.vm.getCapabilities().canContinueStep() && this.stepping && !this.vm.didStepFinish();
        }
        catch (Exception exception) {
            return false;
        }
    }

    void continueStep() {
        if (this.canContinueStep()) {
            this.sendDebuggerEvent(3, 305);
            this.debuggeeResuming(true, false);
            this.vm.continueStep();
            this.debuggeeResumed();
        }
    }

    boolean canRunToCursor(Context context) {
        return this.runToCursor(false, context);
    }

    void runToCursor(Context context) {
        this.runToCursor(true, context);
    }

    private boolean runToCursor(boolean doIt, Context context) {
        try {
            if (this.commonCommandEnablementChecks()) {
                String[] packageAndFile;
                int editorLine;
                Node editorNode;
                DebugLocation location;
                boolean stoppedAtDebuggerExtenderBP = false;
                boolean canDebuggerExtenderRunToCursor = false;
                ExtenderManager extenderManager = ExtenderManager.getInstance();
                if (extenderManager.stoppedAtExtenderBreakpoint(this.currentBreakpoint)) {
                    stoppedAtDebuggerExtenderBP = true;
                    canDebuggerExtenderRunToCursor = extenderManager.canRunToCursor(this, this.currentBreakpoint);
                }
                if (stoppedAtDebuggerExtenderBP) {
                    if (!canDebuggerExtenderRunToCursor) {
                        return false;
                    }
                    if (!doIt) {
                        return true;
                    }
                    JDebugger jdebugger = JDebugger.getInstance();
                    this.temporaryBreakpoint = jdebugger.debuggerExtenderRunToCursor(this, this.currentBreakpoint);
                    if (this.temporaryBreakpoint != null) {
                        this.sendDebuggerEvent(3, 306);
                        this.debuggeeResuming(false, false);
                        this.vm.resume();
                        this.debuggeeResumed();
                        return true;
                    }
                }
                if ((location = this.currentLocation) != null && (editorNode = Source.getNodeFromCodeEditor(context)) != null && (editorLine = Source.getLineFromCodeEditor(context)) != 0 && (packageAndFile = this.node_to_packageAndFile(editorNode)) != null && packageAndFile.length == 2) {
                    if (doIt) {
                        String editorPackage = packageAndFile[0];
                        String editorFilename = packageAndFile[1];
                        this.temporaryBreakpoint = this.vm.putBreakpointPackageFileLine(editorPackage, editorFilename, editorLine);
                        if (this.temporaryBreakpoint != null) {
                            this.sendDebuggerEvent(3, 306);
                            this.debuggeeResuming(false, false);
                            this.vm.resume();
                            this.debuggeeResumed();
                        }
                    }
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean canStepIntoMethod(Context context) {
        return this.stepIntoMethod(false, context, null);
    }

    boolean canStepIntoOuterMethod(Context context) {
        return this.vm.getCapabilities().canStepIntoOuterMethod();
    }

    void stepIntoMethod(Context context) {
        this.stepIntoMethod(true, context, null);
    }

    void stepIntoMethod(Context context, Map<TargetMethod, TargetMethod.VisitationTrackingInfo> methodsToTrack) {
        this.stepIntoMethod(true, context, methodsToTrack);
    }

    private boolean stepIntoMethod(boolean doIt, Context context, Map<TargetMethod, TargetMethod.VisitationTrackingInfo> methodsToTrack) {
        try {
            CodeEditor codeEditor;
            if (this.commonCommandEnablementChecks() && context != null && this.currentLocation != null && (codeEditor = Source.getCodeEditorFromContext(context)) != null && this.codeEditorHasIP(codeEditor)) {
                SourceElement sourceElement;
                JavaManager javaManager;
                SourceFile sourceFile;
                String[] packageAndFile;
                int caretPosition = codeEditor.getCaretPosition();
                int executableLine = this.getExecutableLineAtCaret(codeEditor.getCaretLine());
                Node editorNode = Source.getNodeFromCodeEditor(context);
                if (editorNode == null) {
                    Context cecontext = CodeEditor.getContext((BasicEditorPane)codeEditor.getFocusedEditorPane());
                    editorNode = Source.getNodeFromCodeEditor(cecontext);
                }
                if ((packageAndFile = this.node_to_packageAndFile(editorNode)) != null && packageAndFile.length == 2 && executableLine > 0 && (sourceFile = (javaManager = JavaManager.getAnyJavaManager((Project)this.getJProject())).getSourceFile(editorNode.getURL())) != null && (sourceElement = sourceFile.getElementAt(caretPosition)) instanceof SourceName) {
                    SourceElement parent;
                    String methodName = null;
                    if ((sourceElement = sourceElement.getParent()) instanceof SourceMethodCallExpression) {
                        SourceMethodCallExpression expr = (SourceMethodCallExpression)sourceElement;
                        methodName = expr.getName();
                    } else if (sourceElement instanceof TypeSym && (parent = sourceElement.getParent()) instanceof ClassCreatorExpr) {
                        methodName = "<init>" + ((TypeSym)sourceElement).getName();
                    }
                    if (methodName != null) {
                        if (doIt) {
                            DebugThreadInfo thread = this.currentThread;
                            this.sendDebuggerEvent(3, 307);
                            this.debuggeeResuming(true, false);
                            if (methodsToTrack == null) {
                                thread.stepIntoMethod(methodName, packageAndFile[0], packageAndFile[1], executableLine);
                            } else {
                                TargetMethod target = new TargetMethod(methodName, packageAndFile[0], packageAndFile[1], executableLine);
                                thread.stepIntoMethod(target, methodsToTrack);
                            }
                            this.debuggeeResumed();
                        }
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    private boolean codeEditorHasIP(CodeEditor codeEditor) {
        SourceIcon sourceIconForIP = this.getSourceIconForIP();
        if (sourceIconForIP != null) {
            return codeEditor == sourceIconForIP.getCodeEditor();
        }
        return false;
    }

    private int getExecutableLineAtCaret(int caretLine) {
        DebugMethodInfo method = this.currentLocation.getMethod();
        int[] executableLines = method.getMethodLines();
        int len = executableLines.length - 1;
        if (executableLines.length > 0 && executableLines[0] <= caretLine && executableLines[len] >= caretLine) {
            for (int x = len; x >= 0; --x) {
                if (caretLine < executableLines[x]) continue;
                return executableLines[x];
            }
        }
        return -1;
    }

    boolean canSetNextStatement(Context context) {
        return this.setNextStatement(false, context);
    }

    void setNextStatement(Context context) {
        this.setNextStatement(true, context);
    }

    private boolean setNextStatement(boolean doIt, Context context) {
        try {
            String[] packageAndFile;
            int editorLine;
            Node editorNode;
            DebugLocation location;
            DebugCapabilities capabilities;
            if (this.vm != null && this.stopped && !this.executingRunWhilePausedTask && (capabilities = this.vm.getCapabilities()).canSetLocation() && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread) && (location = this.currentLocation) != null && (editorNode = Source.getNodeFromCodeEditor(context)) != null && (editorLine = Source.getLineFromCodeEditor(context)) != 0 && (packageAndFile = this.node_to_packageAndFile(editorNode)) != null && packageAndFile.length == 2) {
                String editorPackage = packageAndFile[0];
                String locationPackage = location.getClassInfo().getPackage();
                if (Source.packageMatches(locationPackage, editorPackage)) {
                    DebugMethodInfo method;
                    DebugLocation newLocation;
                    int locationLine;
                    String editorFilename = packageAndFile[1];
                    String locationFilename = location.getFilename();
                    if (locationFilename.equals(editorFilename) && editorLine != (locationLine = location.getLine()) && (newLocation = (method = location.getMethod()).getLocation(editorFilename, editorLine)) != null) {
                        SourceSynchStatement editorSync;
                        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
                        JavaManager javaManager = JavaManager.getAnyJavaManager((Project)this.getJProject());
                        SourceFile sourceFile = javaManager.getSourceFile(editorNode.getURL());
                        SourceSynchStatement locationSync = this.getSourceSynchStatement(sourceFile, JDebugger.getLineStartOffsetSkipWhite(codeEditor, locationLine));
                        if (ModelUtil.areEqual((Object)locationSync, (Object)(editorSync = this.getSourceSynchStatement(sourceFile, JDebugger.getLineStartOffsetSkipWhite(codeEditor, editorLine))))) {
                            if (doIt && this.currentThread.setLocation(newLocation)) {
                                this.hideSourceIPIcon();
                                this.currentStackFrame = DebuggingProcess.getNonNativeStackFrame(this.currentThread);
                                this.currentLocation = this.currentStackFrame != null ? this.currentStackFrame.getLocation() : null;
                                this.showSourceIPIcon(true);
                                JDebugger jdebugger = JDebugger.getInstance();
                                jdebugger.getThreadsWindow(true).updateThreads(this, this.vm, this.currentThread);
                                SmartWindow smartWindow = jdebugger.getSmartWindow(false);
                                if (smartWindow != null) {
                                    smartWindow.updateData(this, this.vm, this.currentThread, this.currentStackFrame);
                                }
                            }
                            return true;
                        }
                        if (locationSync != null) {
                            System.out.println("locationSync is from " + locationSync.getStartOffset() + " to " + locationSync.getEndOffset());
                        } else {
                            System.out.println("locationSync is null");
                        }
                        if (editorSync != null) {
                            System.out.println("editorSync is from " + editorSync.getStartOffset() + " to " + editorSync.getEndOffset());
                        } else {
                            System.out.println("editorSync is null");
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private SourceSynchStatement getSourceSynchStatement(SourceFile sourceFile, int offset) {
        if (sourceFile != null) {
            for (SourceElement sourceElement = sourceFile.getElementAt(offset); sourceElement != null; sourceElement = sourceElement.getParent()) {
                SourceSynchStatement sourceSynchStatement;
                SourceStatement primaryClause;
                if (!(sourceElement instanceof SourceSynchStatement) || (primaryClause = (sourceSynchStatement = (SourceSynchStatement)sourceElement).getPrimaryClause()) == null || primaryClause.getStartOffset() > offset || offset >= primaryClause.getEndOffset()) continue;
                return sourceSynchStatement;
            }
        }
        return null;
    }

    boolean canShowIP() {
        try {
            if (this.vm != null && this.stopped && !this.executingRunWhilePausedTask) {
                if (this.canDebuggerExtenderShowIPLocation()) {
                    return true;
                }
                return this.currentLocation != null && this.currentLocation.getLine() > 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    void showIP() {
        if (!(!this.canShowIP() || this.canDebuggerExtenderShowIPLocation() && this.debuggerExtenderShowIPLocation())) {
            this.showLocation(this.currentLocation, false);
        }
    }

    boolean canGC() {
        try {
            return this.vm != null && this.stopped && !this.executingRunWhilePausedTask && this.vm.getCapabilities().canDoGarbageCollection();
        }
        catch (Exception exception) {
            return false;
        }
    }

    void gc() {
        if (this.canGC()) {
            this.vm.doGarbageCollection();
            JDebugger.getInstance().dataHasBeenModified();
        }
    }

    void redefineClasses(Map nameToGuts) {
        if (this.vm != null) {
            if (this.vm.getCapabilities().canRedefineClasses()) {
                String[] errors = this.vm.redefineClasses(nameToGuts);
                if (errors == null) {
                    this.log(DbgArb.getString(776));
                    DebuggingProcess.showStatus(DbgArb.getString(776));
                    this.suggestPopFrame(nameToGuts);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DockUtil.showDockableWindow((DockableView)LogManager.getIdeLogWindow());
                            DebuggingProcess.this.getLogPage().getLogPageView().show();
                        }
                    });
                    this.log(DbgArb.getString(777));
                    DebuggingProcess.showStatus(DbgArb.getString(777));
                    int errorsLength = errors.length;
                    for (int i = 0; i < errorsLength; ++i) {
                        this.log("    " + errors[i] + "\n");
                    }
                }
            } else {
                this.log(DbgArb.getString(775));
                DebuggingProcess.showStatus(DbgArb.getString(775));
            }
        }
    }

    private void suggestPopFrame(Map nameToGuts) {
        if (this.vm != null && this.vm.getCurrentStatus() != 8) {
            ArrayList<String> logged = new ArrayList<String>();
            boolean suggestPopFrame = true;
            DebugThreadInfo currentThreadCopy = this.currentThread;
            if (currentThreadCopy != null) {
                DebugStackFrameInfo[] stack = currentThreadCopy.listStack();
                int stackLength = stack.length;
                for (int istack = 0; istack < stackLength; ++istack) {
                    String className;
                    DebugClassInfo clazz;
                    DebugLocation location = stack[istack].getLocation();
                    if (location == null || (clazz = location.getClassInfo()) == null || !nameToGuts.containsKey(className = clazz.getName())) continue;
                    String niceClassName = DebugShared.makeCourtesyClassName(clazz, true);
                    String s = DbgArb.format(778, currentThreadCopy.getName(), niceClassName);
                    if (logged.contains(s)) continue;
                    this.log(s);
                    logged.add(s);
                    if (stackLength != 1) continue;
                    suggestPopFrame = false;
                }
            }
            if (!logged.isEmpty()) {
                if (suggestPopFrame) {
                    this.log(DbgArb.getString(779));
                } else {
                    this.log(DbgArb.getString(780));
                }
            }
        }
    }

    void classesWindowCreated(ClassesWindow classesWindow) {
        if (classesWindow != null) {
            if (this.vm != null && this.stopped) {
                classesWindow.updateClasses(this, this.vm);
            } else {
                classesWindow.updateClasses(this, null);
            }
        }
    }

    void smartWindowCreated(SmartWindow smartWindow) {
        if (smartWindow != null) {
            if (this.vm != null && this.stopped) {
                smartWindow.updateData(this, this.vm, this.currentThread, this.currentStackFrame);
            } else {
                smartWindow.updateData(this, null, null, null);
            }
        }
    }

    void heapWindowCreated(HeapWindow heapWindow) {
        if (heapWindow != null) {
            if (this.vm != null && this.stopped) {
                heapWindow.updateData(this, this.vm, null, null);
            } else {
                heapWindow.updateData(this, null, null, null);
            }
        }
    }

    void monitorsWindowCreated(MonitorsWindow monitorsWindow) {
        if (monitorsWindow != null) {
            if (this.vm != null && this.stopped) {
                monitorsWindow.updateMonitors(this, this.vm);
            } else {
                monitorsWindow.updateMonitors(this, null);
            }
        }
    }

    private int getDebuggerFactory() {
        if (this.isRemoteDebuggingProfiling()) {
            DebugConfiguration debugConfiguration = this.getDebugConfiguration();
            String protocol = debugConfiguration.getRemoteProtocol();
            return DebugConfiguration.getDebuggerFactory(protocol);
        }
        if (this.localDebuggingFactory >= 0) {
            return this.localDebuggingFactory;
        }
        return DebugFactory.FACTORY_JPDA_Attach;
    }

    static DebugLocation getNonNativeLocation(DebugThreadInfo thread) {
        DebugStackFrameInfo[] frames = thread.listStack();
        return DebuggingProcess.getNonNativeLocation(frames);
    }

    static DebugLocation getNonNativeLocation(DebugStackFrameInfo[] frames) {
        DebugStackFrameInfo stackFrame = DebuggingProcess.getNonNativeStackFrame(frames);
        if (stackFrame != null) {
            return stackFrame.getLocation();
        }
        return null;
    }

    static DebugStackFrameInfo getNonNativeStackFrame(DebugThreadInfo thread) {
        DebugStackFrameInfo[] frames = thread.listStack();
        return DebuggingProcess.getNonNativeStackFrame(frames);
    }

    static DebugStackFrameInfo getNonNativeStackFrame(DebugStackFrameInfo[] frames) {
        for (DebugStackFrameInfo stackFrame : frames) {
            DebugMethodInfo method;
            DebugLocation location;
            if (stackFrame == null || (location = stackFrame.getLocation()) == null || Modifier.isNative((method = location.getMethod()).getAccess())) continue;
            return stackFrame;
        }
        return null;
    }

    static void showStatus(String text) {
        statusText = text;
        Ide.getStatusBar().setText(statusText);
    }

    static void clearStatus() {
        StatusBar statusBar = Ide.getStatusBar();
        if (statusText != null && statusText.equals(statusBar.getText())) {
            statusBar.setText("");
        }
        statusText = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWhilePaused(RunWhilePaused runWhilePaused) {
        if (this.vm != null) {
            if (this.stopped || !this.vm.getCapabilities().canPauseProgram()) {
                this.executingRunWhilePausedTask = true;
                runWhilePaused.run(this, true);
                this.executingRunWhilePausedTask = false;
            } else {
                boolean[] blArray = this.pause;
                synchronized (this.pause) {
                    this.pause[0] = true;
                    this.runWhilePausedList.add(runWhilePaused);
                    this.vm.pauseProgram();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
        } else {
            this.executingRunWhilePausedTask = true;
            runWhilePaused.run(this, false);
            this.executingRunWhilePausedTask = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAfterPaused(final RunWhilePaused runAfterPaused) {
        if (this.vm != null) {
            if (this.stopped || !this.vm.getCapabilities().canPauseProgram()) {
                if (JDebugger.getInstance().isActiveDebuggingProcess(this)) {
                    runAfterPaused.run(this, true);
                } else {
                    Runnable runAfterSelected = new Runnable(){

                        @Override
                        public void run() {
                            runAfterPaused.run(DebuggingProcess.this, true);
                        }
                    };
                    this.runAfterSelectedList.add(runAfterSelected);
                    Runner.getRunner().selectProcess((RunProcess)this);
                }
            } else {
                boolean[] blArray = this.pause;
                synchronized (this.pause) {
                    this.pause[0] = true;
                    this.runAfterPausedList.add(runAfterPaused);
                    this.vm.pauseProgram();
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                }
            }
        } else {
            runAfterPaused.run(this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForInternalPause(boolean live) {
        boolean internalPauseOnly = false;
        RunWhilePaused[] runnables = null;
        boolean[] blArray = this.pause;
        synchronized (this.pause) {
            if (this.pause[0]) {
                if (live) {
                    internalPauseOnly = !this.pause[1] && this.vm.getCurrentStatus() == 8 && this.runAfterPausedList.size() == 0;
                    this.vm.cancelPauseProgram();
                }
                runnables = this.runWhilePausedList.toArray(new RunWhilePaused[this.runWhilePausedList.size()]);
                this.runWhilePausedList.clear();
                this.pause[0] = false;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (runnables != null) {
                try {
                    RunWhilePaused[] finalRunnables = runnables;
                    int length = finalRunnables.length;
                    this.executingRunWhilePausedTask = true;
                    for (int i = 0; i < length; ++i) {
                        finalRunnables[i].run(this, live);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.executingRunWhilePausedTask = false;
                }
                if (internalPauseOnly) {
                    if (this.vm.getCapabilities().canContinueStep() && this.stepping && !this.vm.didStepFinish()) {
                        this.vm.continueStep();
                    } else {
                        this.vm.resume();
                    }
                }
            }
            return internalPauseOnly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunAfterPause(boolean live) {
        boolean[] blArray = this.pause;
        synchronized (this.pause) {
            RunWhilePaused[] runnables = this.runAfterPausedList.toArray(new RunWhilePaused[this.runAfterPausedList.size()]);
            this.runAfterPausedList.clear();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (runnables != null) {
                int length = runnables.length;
                for (int i = 0; i < length; ++i) {
                    runnables[i].run(this, live);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessage(String message) {
        List list = this.messages;
        synchronized (list) {
            this.messages.add(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessages() {
        List list = this.messages;
        synchronized (list) {
            while (this.messages.size() > 0) {
                String message = (String)this.messages.remove(0);
                this.logMessage(message);
            }
        }
    }

    EvaluatorItem makeTemporaryEvaluatorItem(String name, DebugDataCompositeInfo data) {
        EvaluatorItem ei = new EvaluatorItem((String)null);
        ei.pin(this, data);
        ei.setCanUnpin(false);
        ei.setOptions(name, false, this);
        return ei;
    }

    String[] url_to_packageAndFile(URL url) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            return this.node_to_packageAndFile(node);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String[] node_to_packageAndFile(Node node) {
        try {
            String pkg = null;
            String file = null;
            if (node instanceof PackagedSource) {
                pkg = Source.getPackageFromNode(node, this.getJProject());
                file = Source.getFilenameFromNode(node);
            } else if (JDevXmlIntegrationUtils.getInstance().isXmlSource(node)) {
                URL url = node.getURL();
                if (this.xsltDebugging) {
                    pkg = XSLTDebugHelper.getXSLTPackage(url);
                    file = URLFileSystem.getFileName((URL)url);
                }
            }
            if (pkg != null && file != null && file.length() > 0) {
                String[] packageAndFile = new String[]{pkg, file};
                return packageAndFile;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void setDatabaseDebuggingHelperClass(Class helperClass) {
        databaseDebuggingHelperClass = helperClass;
    }

    public final void setPort(String port) {
        this.localPort = port;
    }

    public final String getPort() {
        return this.localPort;
    }

    final void forceDetach() {
        if (this.vm != null) {
            this.vm.disconnect(false);
            this.vm = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkForPotentialClipboardDeadlock() {
        try {
            DebugDataObjectInfo contentFieldData;
            DebugDataObjectInfo clipboardFieldData;
            DebugDataObjectInfo toolkitFieldData;
            DebugClassInfo toolkitClass;
            if (this.vm == null || (toolkitClass = this.vm.findFirstClassByName("java.awt.Toolkit")) == null || (toolkitFieldData = (DebugDataObjectInfo)DebugShared.findStaticFieldData(toolkitClass, "toolkit")) == null || (clipboardFieldData = (DebugDataObjectInfo)DebugShared.findFieldData(toolkitFieldData, "clipboard")) == null || (contentFieldData = (DebugDataObjectInfo)DebugShared.findFieldData(clipboardFieldData, "contents")) == null || contentFieldData.isNull()) return false;
            if (clipboardFieldData.getClassInfo().getName().equals("sun.awt.motif.X11Clipboard")) {
                StringBuffer message = new StringBuffer();
                message.append(DbgArb.getString(791));
                message.append("\n\n");
                message.append(DbgArb.format(792, Ide.getProgramShortName()));
                message.append("\n\n");
                message.append(DbgArb.getString(793));
                final String msg = message.toString();
                if (SwingUtilities.isEventDispatchThread()) {
                    if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)msg, (String)DbgArb.getString(790), null)) return false;
                    return true;
                }
                final boolean[] dialogResult = new boolean[1];
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)msg, (String)DbgArb.getString(790), null)) {
                            dialogResult[0] = true;
                        }
                    }
                });
                return dialogResult[0];
            }
            StringBuffer message = new StringBuffer();
            message.append(DbgArb.getString(791));
            message.append("\n");
            message.append(DbgArb.format(792, Ide.getProgramShortName()));
            message.append("\n");
            this.log(message);
            return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean canStopOnException() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getCapabilities().canStopOnException();
    }

    public boolean canStopOnError() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getCapabilities().canStopOnError();
    }

    public boolean canStopOnDebuggerStatement() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getCapabilities().canStopOnDebuggerStatement();
    }

    public boolean canTransferErrors() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getCapabilities().canTransferErrors();
    }

    public boolean getStopOnException() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getStopOnException();
    }

    public boolean getStopOnError() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getStopOnError();
    }

    public boolean getStopOnDebuggerStatement() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getStopOnDebuggerStatement();
    }

    public boolean getTransferErrors() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getTransferErrors();
    }

    public void setStopOnException(boolean b) {
        if (this.vm == null) {
            return;
        }
        this.vm.setStopOnException(b);
    }

    public void setStopOnError(boolean b) {
        if (this.vm == null) {
            return;
        }
        this.vm.setStopOnError(b);
    }

    public void setStopOnDebuggerStatement(boolean b) {
        if (this.vm == null) {
            return;
        }
        this.vm.setStopOnDebuggerStatement(b);
    }

    public void setTransferErrors(boolean b) {
        if (this.vm == null) {
            return;
        }
        this.vm.setTransferErrors(b);
    }

    public boolean getStopInChrome() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getStopInChrome();
    }

    public void setStopInChrome(boolean b) {
        if (this.vm == null) {
            return;
        }
        this.vm.setStopInChrome(b);
    }

    public void doGarbageCollection() {
        if (this.vm == null) {
            return;
        }
        this.vm.doGarbageCollection();
    }

    public boolean canStopInChrome() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getCapabilities().canStopInChrome();
    }

    public boolean canGarbageCollect() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getCapabilities().canDoGarbageCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerEvaluatorHandle(EvaluatorHandle handle) {
        List<EvaluatorHandle> list = this.evaluatorHandles;
        synchronized (list) {
            this.evaluatorHandles.add(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearEvaluatorHandles() {
        List<EvaluatorHandle> list = this.evaluatorHandles;
        synchronized (list) {
            for (EvaluatorHandle handle : this.evaluatorHandles) {
                handle.expire();
            }
            this.evaluatorHandles.clear();
        }
    }

    protected ToolButton addProcessActionButtonToToolbar(IdeAction action) {
        return this.addProcessActionButtonToToolbar(action, DEBUGGER_BUTTON_GROUP);
    }

    protected boolean addProcessActionButtonToToolbar(JComponent actionButton) {
        return this.addProcessActionButtonToToolbar(actionButton, null);
    }

    protected ToolButton addByteCodeActionButtonToToolbar(IdeAction action) {
        ToolButton button = this.addProcessActionButtonToToolbar(action, BYTE_CODE_BUTTON_GROUP);
        if (button != null) {
            button.setVisible(false);
        }
        return button;
    }

    protected void enableByteCodeButtonsOnToolbar() {
        Toolbar logPageToolbar = this.getLogPageToolbar();
        if (logPageToolbar != null) {
            for (Component component : logPageToolbar.getComponents()) {
                JComponent jcomponent;
                if (!(component instanceof JComponent) || this.getProcessActionButtonGroup(jcomponent = (JComponent)component) != BYTE_CODE_BUTTON_GROUP) continue;
                this.setProcessActionButtonGroup(jcomponent, DEBUGGER_BUTTON_GROUP);
            }
        }
    }

    protected void showProcessActionButtonsOnToolbar(boolean visible) {
        super.showProcessActionButtonsOnToolbar(DEBUGGER_BUTTON_GROUP, visible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSuspendBreakpoints(boolean suspended) {
        Object object = this.vmSync;
        synchronized (object) {
            if (this.vm != null && this.vm.getCapabilities().canSuspendBreakpoints()) {
                this.vm.setSuspendBreakpoints(suspended);
                return true;
            }
            return false;
        }
    }

    public boolean getSuspendBreakpoints() {
        if (this.vm != null && this.vm.getCapabilities().canSuspendBreakpoints()) {
            return this.vm.getSuspendBreakpoints();
        }
        return false;
    }

    public boolean canSuspendBreakpoints() {
        if (this.vm != null) {
            return this.vm.getCapabilities().canSuspendBreakpoints();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBreakpointsInVm(boolean includePersistentBps) {
        Object object = this.vmSync;
        synchronized (object) {
            JDebugger debugger = JDebugger.getInstance();
            if (this.vm != null && debugger != null) {
                debugger.setBreakpointsInVm(this, includePersistentBps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBreakpointsInVm() {
        Object object = this.vmSync;
        synchronized (object) {
            JDebugger debugger = JDebugger.getInstance();
            if (this.vm != null && debugger != null) {
                debugger.removeBreakpointsFromVm(this);
                this.setBreakpointsInVm(false);
            }
        }
    }

    boolean isFastSwapEnabled() {
        return this.fastSwapEnabled;
    }

    public void setFastSwapEnabled(boolean fastSwapEnabled) {
        this.fastSwapEnabled = fastSwapEnabled;
    }

    static {
        starterFactorySubClass = JStarterFactory.class;
        classLoadTracking = -1;
    }

    class EventSource
    extends DebuggerEventSource {
        int languages = 0;
        int eventType;
        int state;
        boolean isPrepared;
        DebuggerEventSource.StackFrame[] stackFrames;
        boolean mayBeStale = false;

        EventSource() {
            if (DebuggingProcess.this.vm != null) {
                this.languages = DebuggingProcess.this.vm.getLanguages();
            }
        }

        synchronized void eventOccurring(int eventType, int state) {
            this.eventType = eventType;
            this.state = state;
            this.isPrepared = false;
            this.stackFrames = null;
        }

        void markAsPossiblyStale() {
            this.mayBeStale = true;
        }

        synchronized void prepareStackFrames() {
            if (this.mayBeStale) {
                throw new UnsupportedOperationException("Cannot call prepareStackFrames on an EventSource returned by getDebuggerState()");
            }
            if (!this.isPrepared) {
                DebuggerEventSource.StackFrame[] stackFrames;
                if (this.eventType == 2) {
                    if (DebuggingProcess.this.currentThread != null) {
                        DebugStackFrameInfo[] dsfi = DebuggingProcess.this.currentThread.listStack();
                        stackFrames = new DebuggerEventSource.StackFrame[dsfi.length];
                        for (int i = 0; i < dsfi.length; ++i) {
                            DebugDataInfo dataThis;
                            DebugVariableInfo argThis;
                            DebugLocation location = dsfi[i].getLocation();
                            DebugClassInfo locationClassInfo = location.getClassInfo();
                            String className = locationClassInfo.getName();
                            String prettyClassName = DebugShared.makeCourtesyClassName(locationClassInfo, true);
                            DebugMethodInfo method = location.getMethod();
                            String methodName = method.getNameWithoutClassOrSignature();
                            String prettyMethodName = DebugShared.makeCourtesyMethodName(method, false, false, dsfi[i]);
                            String methodSignature = method.getParameterSignature();
                            String prettyMethodSignature = DebugShared.makeCourtesyMethodSignature(method, DebuggingProcess.this.vm);
                            int methodAccess = method.getAccess();
                            long thisID = 0L;
                            String thisClassName = null;
                            String prettyThisClassName = null;
                            int language = dsfi[i].getLanguage();
                            if (!Modifier.isStatic(methodAccess) && !Modifier.isNative(methodAccess) && DebuggingProcess.this.vm.getCapabilities().canGetUniqueIDs() && (argThis = BaseEvaluator.findThis(dsfi[i].listArguments())) != null && (dataThis = argThis.getDataInfo()) instanceof DebugDataCompositeInfo) {
                                DebugDataCompositeInfo ddci = (DebugDataCompositeInfo)dataThis;
                                thisID = JDebugger.getObjectNumber(ddci);
                                DebugClassInfo thisClassInfo = ddci.getClassInfo();
                                thisClassName = thisClassInfo.getName();
                                prettyThisClassName = DebugShared.makeCourtesyClassName(thisClassInfo, true);
                            }
                            String filename = location.getFilename();
                            int lineNumber = location.getLine();
                            stackFrames[i] = new DebuggerEventSource.StackFrame(className, prettyClassName, methodName, prettyMethodName, methodSignature, prettyMethodSignature, methodAccess, thisID, thisClassName, prettyThisClassName, filename, lineNumber, language);
                        }
                    } else {
                        stackFrames = new DebuggerEventSource.StackFrame[]{};
                    }
                } else {
                    stackFrames = null;
                }
                this.stackFrames = stackFrames;
                this.isPrepared = true;
            }
        }

        public int getLanguages() {
            return this.languages;
        }

        public int getState() {
            return this.state;
        }

        public DebuggerEventSource.StackFrame[] getStackFrames() {
            this.prepareStackFrames();
            return this.stackFrames;
        }

        public Context getContext() {
            return DebuggingProcess.this.getContext();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("EventSource[");
            sb.append("state=");
            sb.append(this.state);
            sb.append("]");
            return sb.toString();
        }
    }
}

