/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.jdevimpl.debugger.BreakpointConditionEvaluationResult;
import oracle.jdevimpl.debugger.SingleConditionEvaluationResult;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugEvaluator;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugContext;
import oracle.jdevimpl.runner.debug.ExpressionEvaluationException;
import oracle.jdevimpl.runner.debug.JavaEvaluator;
import oracle.jdevimpl.runner.debug.PlsqlEvaluator;
import oracle.jdevimpl.runner.debug.XsltEvaluator;

public class Evaluator
extends DebugContext {
    private JavaEvaluator javaEvaluator;
    private PlsqlEvaluator plsqlEvaluator;
    private XsltEvaluator xsltEvaluator;
    private boolean allowMethodInvocation;
    Set<DebugEvaluator> evaluators = new LinkedHashSet<DebugEvaluator>();

    public Evaluator(boolean allowMethodInvocation) {
        this.allowMethodInvocation = allowMethodInvocation;
    }

    @Override
    public boolean setDebugContext(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        if (super.setDebugContext(vm, thread, frame)) {
            this.clearCache();
            this.setEvaluators();
            return true;
        }
        return false;
    }

    @Override
    boolean setDebugContext(DebugDataObjectInfo dataObject) {
        if (super.setDebugContext(dataObject)) {
            this.clearCache();
            this.setEvaluators();
            return true;
        }
        return false;
    }

    void clearCache() {
        if (this.vm != null) {
            this.vm.clearEvaluators();
        }
        if (this.javaEvaluator != null) {
            this.javaEvaluator.clearCache();
        }
        if (this.plsqlEvaluator != null) {
            this.plsqlEvaluator.clearCache();
        }
        if (this.xsltEvaluator != null) {
            this.xsltEvaluator.clearCache();
        }
    }

    private void setEvaluators() {
        if (this.vm != null) {
            int languages;
            this.evaluators.clear();
            DebugEvaluator[] debuggerEvaluators = this.vm.getEvaluators();
            if (debuggerEvaluators != null) {
                this.evaluators.addAll(Arrays.asList(debuggerEvaluators));
            }
            if (!(((languages = this.vm.getLanguages()) & 1) == 0 || this.javaEvaluator != null && this.evaluators.contains(this.javaEvaluator))) {
                this.evaluators.add(this.getJavaEvaluator());
            }
            if (!((languages & 2) == 0 || this.plsqlEvaluator != null && this.evaluators.contains(this.plsqlEvaluator))) {
                this.evaluators.add(this.getPlsqlEvaluator());
            }
            if (!((languages & 4) == 0 || this.xsltEvaluator != null && this.evaluators.contains(this.xsltEvaluator))) {
                this.evaluators.add(this.getXsltEvaluator());
            }
        }
    }

    static boolean validate(String exp) {
        if (JavaEvaluator.validate(exp)) {
            return true;
        }
        if (PlsqlEvaluator.validate(exp)) {
            return true;
        }
        return XsltEvaluator.validate(exp);
    }

    SingleConditionEvaluationResult evaluateCondition(String condition) {
        SingleConditionEvaluationResult result = new SingleConditionEvaluationResult();
        DebugEvaluator[] evaluatorUsed = new DebugEvaluator[1];
        Object o = this.evaluate(condition, evaluatorUsed);
        if (o instanceof ExpressionEvaluationException) {
            ExpressionEvaluationException eee = (ExpressionEvaluationException)o;
            if (eee.getRetriable()) {
                result.setResultType(BreakpointConditionEvaluationResult.ResultType.RETRIABLE_EXCEPTION);
                result.setException((Throwable)eee);
                return result;
            }
            result.setResultType(BreakpointConditionEvaluationResult.ResultType.COULD_NOT_EVALUATE);
            result.setException((Throwable)eee);
            return result;
        }
        if (o != null && evaluatorUsed[0] != null) {
            int conditionResult = evaluatorUsed[0].evaluateConditionResult(o, this.allowMethodInvocation);
            switch (conditionResult) {
                case -2: {
                    break;
                }
                case -1: {
                    String msg = DbgArb.format(477, condition);
                    result.setResultType(BreakpointConditionEvaluationResult.ResultType.NOT_BOOLEAN);
                    result.setMessage(msg);
                    return result;
                }
                case 1: {
                    result.setResultType(BreakpointConditionEvaluationResult.ResultType.TRUE);
                    result.setMessage(DbgArb.getString(478));
                    return result;
                }
                case 0: {
                    result.setResultType(BreakpointConditionEvaluationResult.ResultType.FALSE);
                    result.setMessage(DbgArb.getString(479));
                    return result;
                }
            }
        }
        String msg = DbgArb.format(476, condition);
        result.setResultType(BreakpointConditionEvaluationResult.ResultType.COULD_NOT_EVALUATE);
        result.setMessage(msg);
        if (o instanceof Throwable) {
            result.setException((Throwable)o);
        }
        return result;
    }

    public Object evaluate(String exp) {
        return this.evaluate(exp, null);
    }

    private Object evaluate(String exp, DebugEvaluator[] evaluatorUsed) {
        if (this.vm != null) {
            LinkedHashSet<DebugEvaluator> currentEvaluators = new LinkedHashSet<DebugEvaluator>();
            if (this.frame != null) {
                DebugEvaluator frameEvaluator = this.frame.getEvaluator();
                if (frameEvaluator == null) {
                    switch (this.frame.getLanguage()) {
                        case 1: {
                            frameEvaluator = this.getJavaEvaluator();
                            break;
                        }
                        case 2: {
                            frameEvaluator = this.getPlsqlEvaluator();
                            break;
                        }
                        case 4: {
                            frameEvaluator = this.getXsltEvaluator();
                        }
                    }
                }
                if (frameEvaluator != null) {
                    currentEvaluators.add(frameEvaluator);
                }
            }
            for (DebugEvaluator evaluator : this.evaluators) {
                if (currentEvaluators.contains(evaluator)) continue;
                currentEvaluators.add(evaluator);
            }
            ExpressionEvaluationException evaluationException = null;
            for (DebugEvaluator evaluator : currentEvaluators) {
                Object o = evaluator.evaluate(exp, this.allowMethodInvocation);
                if (o instanceof ExpressionEvaluationException) {
                    evaluationException = (ExpressionEvaluationException)o;
                    continue;
                }
                if (o == null) continue;
                if (evaluatorUsed != null) {
                    evaluatorUsed[0] = evaluator;
                }
                return o;
            }
            if (evaluationException != null) {
                return evaluationException;
            }
        }
        return null;
    }

    private JavaEvaluator getJavaEvaluator() {
        if (this.javaEvaluator == null) {
            this.javaEvaluator = new JavaEvaluator(this, this.allowMethodInvocation);
        }
        return this.javaEvaluator;
    }

    private PlsqlEvaluator getPlsqlEvaluator() {
        if (this.plsqlEvaluator == null) {
            this.plsqlEvaluator = new PlsqlEvaluator(this);
        }
        return this.plsqlEvaluator;
    }

    private XsltEvaluator getXsltEvaluator() {
        if (this.xsltEvaluator == null) {
            this.xsltEvaluator = new XsltEvaluator(this);
        }
        return this.xsltEvaluator;
    }

    static DebugDataInfo getDataInfo(Object o) {
        return BaseEvaluator.getDataInfo(o);
    }
}

