/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.runner.debug.DataController;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataTable;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.EvaluatorDataItem;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.EvaluatorPanel;

abstract class EvaluatorController
extends DataController {
    protected IdeAction _actionPin;
    protected IdeAction _actionUnpin;
    protected JMenuItem _menuitemPin;
    protected JMenuItem _menuitemUnpin;
    protected int _PIN_CMD_ID;
    protected int _UNPIN_CMD_ID;
    protected Evaluator evaluator = new Evaluator(true);

    public EvaluatorController(DataPanelSettings dataPanelSettings, DataPanel dataPanel) {
        super(dataPanelSettings, dataPanel);
    }

    @Override
    protected void addPopupMenuItemsForDataItem(ContextMenu popup, Context context) {
        this.addPopupItem(popup, context, this._actionPin, this._menuitemPin, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionUnpin, this._menuitemUnpin, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        super.addPopupMenuItemsForDataItem(popup, context);
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        DataItem dataItem;
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            DataTable dataTable = this.getDataPanel().getDataTable();
            if (dataTable == null || !this.getDataPanel().getDockableWindow().isVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!dataTable.getTable().isEnabled() || this.getDebuggingProcess() == null || this.vm == null) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == this._PIN_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            if (dataItem instanceof EvaluatorDataItem) {
                EvaluatorDataItem evaluatorDataItem = (EvaluatorDataItem)dataItem;
                action.setEnabled(evaluatorDataItem.canPin());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._UNPIN_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            if (dataItem instanceof EvaluatorDataItem) {
                EvaluatorDataItem evaluatorDataItem = (EvaluatorDataItem)dataItem;
                action.setEnabled(evaluatorDataItem.canUnpin());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        return super.update(action, context);
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == this._PIN_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem instanceof EvaluatorDataItem && treePath != null) {
                EvaluatorDataItem evaluatorDataItem = (EvaluatorDataItem)dataItem;
                evaluatorDataItem.pin(treePath);
            }
            return true;
        }
        if (cmdId == this._UNPIN_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem instanceof EvaluatorDataItem && treePath != null) {
                EvaluatorDataItem evaluatorDataItem = (EvaluatorDataItem)dataItem;
                evaluatorDataItem.unpin(treePath);
            }
            return true;
        }
        return super.handleEvent(action, context);
    }

    protected void addDataItem(List root, EvaluatorItem ei, boolean skipIfBad, boolean skipIfClass) {
        Object info;
        if (this.thread != null && this.frame != null) {
            this.frame = this.thread.getStackFrame(this.frame.getFrameNumber());
            this.debugContextChanged();
        }
        if ((info = ei.evaluate(this.getDebuggingProcess(), this.evaluator)) == null) {
            if (skipIfBad) {
                return;
            }
            info = ei;
        }
        if (info instanceof DebugClassInfo && skipIfClass) {
            return;
        }
        String name = ei.getName(this.getDebuggingProcess());
        EvaluatorDataItem evaluatorDataItem = new EvaluatorDataItem(ei, name, info, (EvaluatorPanel)this.getDataPanel(), this);
        if (root != null) {
            root.add(new DataItem(this.getDataPanel(), evaluatorDataItem));
        } else {
            this.getDataPanel().addTopDataItem(evaluatorDataItem);
        }
    }

    protected void removeTopDataItem(int i) {
        this.getDataPanel().removeTopDataItem(i);
    }

    @Override
    void everythingChanged() {
        DebugStackFrameInfo curFrame = this.frame;
        DebugThreadInfo curThread = this.thread;
        if (curFrame != null && curThread != null) {
            this.frame = curThread.getStackFrame(curFrame.getFrameNumber());
            this.debugContextChanged();
        }
        this.evaluator.clearCache();
        this.everythingChanged(true);
    }

    @Override
    protected void debugContextChanged() {
        super.debugContextChanged();
        this.evaluator.setDebugContext(this.vm, this.thread, this.frame);
    }
}

