/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Ide;
import oracle.ide.docking.DockableWindow;
import oracle.ide.util.HistoryList;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ButtonMenu;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.MultiViewPanel;

abstract class EvaluatorPanel
extends MultiViewPanel {
    protected HistoryList historyList = Ide.loadHistoryList((String)this.getWindowId());
    protected JComponent historyButton;

    EvaluatorPanel(DockableWindow dockableWindow, DataPanelSettings dataPanelSettings) {
        super(dockableWindow, dataPanelSettings);
    }

    protected JComponent createHistoryButton(final ActionListener listener) {
        final ArrayList historyItems = new ArrayList();
        this.historyButton = ButtonMenu.createButtonMenu(null, (Icon)OracleIcons.getIcon((String)"history.png"), historyItems, (PopupMenuListener)new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                historyItems.clear();
                for (String historyItem : EvaluatorPanel.this.historyList.getHistoryList()) {
                    JMenuItem item = new JMenuItem(historyItem);
                    historyItems.add(item);
                    item.addActionListener(listener);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                historyItems.clear();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                historyItems.clear();
            }
        });
        this.historyButton.setToolTipText(DbgArb.getString(863));
        this.historyButton.setEnabled(this.historyList.getSize() > 0);
        return this.historyButton;
    }

    protected void enableHistoryButton() {
        if (this.historyButton != null) {
            this.historyButton.setEnabled(true);
        }
    }
}

