/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.runner.DebuggerLocation;
import oracle.ide.runner.ExecutionEvent;
import oracle.ide.runner.ExecutionListener;
import oracle.ide.runner.ExecutionTracker;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public class ExecutionTrackerImpl
implements ExecutionTracker {
    private String endAtMethodExit;
    private List<DebugBreakpoint> endAtBreakpoint = new ArrayList<DebugBreakpoint>();
    private DebugLocation currentLocation;
    private long lastExecutionTimestamp;
    private List<ExecutionListener> listeners = new ArrayList<ExecutionListener>();
    private DebugThreadInfo threadToTrack;
    private DebugVirtualMachine vm;
    private int depthWhereStarted;

    public ExecutionTrackerImpl(DebugVirtualMachine vm) {
        this.vm = vm;
        this.threadToTrack = vm.getCurrentThread();
        this.depthWhereStarted = this.threadToTrack.getStackFrameCount();
    }

    public void addListener(ExecutionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ExecutionListener listener) {
        this.listeners.remove(listener);
    }

    public boolean recordExecutionStep(DebugLocation stepToLocation, DebugBreakpoint breakpoint) {
        long endTime = System.currentTimeMillis();
        ExecutionEvent event = new ExecutionEvent();
        event.setEventType(ExecutionEvent.ExecutionEventType.EXECUTION_STEP);
        event.setFromLocation((DebuggerLocation)this.currentLocation);
        event.setToLocation((DebuggerLocation)stepToLocation);
        event.setElapsedStepTime(endTime - this.lastExecutionTimestamp);
        this.fireEvent(event);
        this.currentLocation = stepToLocation;
        this.lastExecutionTimestamp = endTime;
        boolean endConditionSatisified = false;
        if (breakpoint != null && this.endAtBreakpoint.contains(breakpoint)) {
            endConditionSatisified = true;
        }
        if (stepToLocation != null) {
            for (DebugBreakpoint bp : this.endAtBreakpoint) {
                DebugMethodInfo method;
                String reachedFilename;
                DebugBreakpointFileLine bpfl;
                String targetFilename;
                if (bp instanceof DebugBreakpointFileLine && (targetFilename = (bpfl = (DebugBreakpointFileLine)bp).getFilename()).equals(reachedFilename = stepToLocation.getFilename().replaceAll(".java", "")) && bpfl.getLine() == stepToLocation.getLine()) {
                    endConditionSatisified = true;
                }
                if ((method = stepToLocation.getMethod()) == null) continue;
                String methodName = method.getName();
            }
        }
        if (endConditionSatisified) {
            ((DebugJDI)this.vm).stopExecutionTracking();
            ExecutionEvent endEvent = new ExecutionEvent();
            endEvent.setEventType(ExecutionEvent.ExecutionEventType.EXECUTION_ENDPOINT_REACHED);
            this.fireEvent(endEvent);
        }
        return endConditionSatisified;
    }

    public void setEndpoint(Object endpoint) {
        if (endpoint instanceof DebugBreakpointFileLine) {
            DebugBreakpointFileLine breakpoint = (DebugBreakpointFileLine)endpoint;
            this.endAtBreakpoint.add(breakpoint);
        }
    }

    private void fireEvent(ExecutionEvent event) {
        for (ExecutionListener l : this.listeners) {
            l.executionEvent(event);
        }
    }

    public DebugThreadInfo getThreadToTrack() {
        return this.threadToTrack;
    }

    public int getInitialStackDepth() {
        return this.depthWhereStarted;
    }
}

