/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Font;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.Project;
import oracle.ide.util.PropertyAccess;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugHeapAncestor;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetAncestors;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetClasses;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DataController;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataTable;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EditHeapClassDialog;
import oracle.jdevimpl.runner.debug.HeapPanel;
import oracle.jdevimpl.runner.debug.HeapWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.VersionedDataItem;

final class HeapController
extends DataController
implements DebugPinListener {
    private static final String HEAP_KEY_COUNT = "Heap.Count";
    private static final String HEAP_KEY_PREFIX = "Heap.";
    private static final String HEAP_KEY_DOT = ".";
    private static final String HEAP_KEY_SCOPE = "scope";
    private static final String HEAP_KEY_CLASS = "class";
    private static final String GlobalHeapScope = "GlobalHeapScope";
    private List pins;
    private List pinDebuggingProcesses;
    private List pinSubsets;
    private Map<String, List<String>> mapProjectHeapFolders = new HashMap<String, List<String>>();
    private Map<DebuggingProcess, List<String>> mapProcessHeapFolders = new HashMap<DebuggingProcess, List<String>>();
    private static IdeAction actionAddNewClass;
    private static IdeAction actionEditClass;
    private static IdeAction actionRemoveFolder;
    private static IdeAction actionShowAncestors;
    private static IdeAction actionExpandAncestor;
    private static IdeAction actionViewWhole;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionViewAnnotationsForClass;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatch;
    private static IdeAction actionInspect;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionRemoveAllFolders;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemAddNewClass;
    private static JMenuItem menuitemEditClass;
    private static JMenuItem menuitemRemoveFolder;
    private static JMenuItem menuitemShowAncestors;
    private static JMenuItem menuitemExpandAncestor;
    private static JMenuItem menuitemRemoveAllFolders;
    private static JMenuItem menuitemSettings;
    private static final int ADD_NEW_CLASS_CMD_ID;
    private static final int EDIT_CLASS_CMD_ID;
    private static final int REMOVE_FOLDER_CMD_ID;
    private static final int SHOW_ANCESTORS_CMD_ID;
    private static final int EXPAND_ANCESTOR_CMD_ID;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int VIEW_ANNOTATIONS_CMD_ID;
    private static final int VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CMD_ID;
    private static final int INSPECT_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int REMOVE_ALL_FOLDERS_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;

    HeapController(DataPanelSettings dataPanelSettings, HeapPanel heapPanel) {
        super(dataPanelSettings, heapPanel);
        HeapController.createActions();
        this.setControllerForActions();
        this.assignSuperClassActions();
        this.loadHeap((PropertyAccess)Ide.getIdeProperties());
    }

    private void assignSuperClassActions() {
        this._actionViewWhole = actionViewWhole;
        this._actionViewAnnotations = actionViewAnnotations;
        this._actionViewAnnotationsForClass = actionViewAnnotationsForClass;
        this._actionAdjustRange = actionAdjustRange;
        this._actionToggleValue = actionToggleValue;
        this._actionModifyValue = actionModifyValue;
        this._actionWatch = actionWatch;
        this._actionInspect = actionInspect;
        this._actionWatchClassLoader = actionWatchClassLoader;
        this._actionInspectClassLoader = actionInspectClassLoader;
        this._actionGoto = actionGoto;
        this._actionGotoDeclared = actionGotoDeclared;
        this._actionGotoField = actionGotoField;
        this._actionUseFilters = actionUseFilters;
        this._actionObjectPreferences = actionObjectPreferences;
        this._actionCollapseAll = actionCollapseAll;
        this._actionSave = actionSave;
        this._actionSettings = actionSettings;
        this._VIEW_WHOLE_CMD_ID = VIEW_WHOLE_CMD_ID;
        this._VIEW_ANNOTATIONS_CMD_ID = VIEW_ANNOTATIONS_CMD_ID;
        this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
        this._ADJUST_RANGE_CMD_ID = ADJUST_RANGE_CMD_ID;
        this._TOGGLE_VALUE_CMD_ID = TOGGLE_VALUE_CMD_ID;
        this._MODIFY_VALUE_CMD_ID = MODIFY_VALUE_CMD_ID;
        this._WATCH_CMD_ID = WATCH_CMD_ID;
        this._INSPECT_CMD_ID = INSPECT_CMD_ID;
        this._WATCH_CLASSLOADER_CMD_ID = WATCH_CLASSLOADER_CMD_ID;
        this._INSPECT_CLASSLOADER_CMD_ID = INSPECT_CLASSLOADER_CMD_ID;
        this._GOTO_CMD_ID = GOTO_CMD_ID;
        this._GOTO_DECLARED_CMD_ID = GOTO_DECLARED_CMD_ID;
        this._GOTO_FIELD_CMD_ID = GOTO_FIELD_CMD_ID;
        this._USE_FILTERS_CMD_ID = USE_FILTERS_CMD_ID;
        this._OBJECT_PREFERENCES_CMD_ID = OBJECT_PREFERENCES_CMD_ID;
        this._COLLAPSE_ALL_CMD_ID = COLLAPSE_ALL_CMD_ID;
        this._SAVE_CMD_ID = SAVE_CMD_ID;
    }

    private static void createActions() {
        if (actionShowAncestors == null) {
            actionShowAncestors = IdeAction.get((int)SHOW_ANCESTORS_CMD_ID, null, (String)DbgArb.getString(574), null, (Integer)DbgArb.getInteger(575), null, null, (boolean)false);
            actionShowAncestors.setEnabled(false);
            actionExpandAncestor = IdeAction.get((int)EXPAND_ANCESTOR_CMD_ID, null, (String)DbgArb.getString(576), null, (Integer)DbgArb.getInteger(577), null, null, (boolean)false);
            actionExpandAncestor.setEnabled(false);
            actionEditClass = IdeAction.get((int)EDIT_CLASS_CMD_ID, null, (String)DbgArb.getString(566), null, (Integer)DbgArb.getInteger(567), null, null, (boolean)false);
            actionEditClass.setEnabled(false);
            actionRemoveFolder = IdeAction.get((int)REMOVE_FOLDER_CMD_ID, null, (String)DbgArb.getString(570), null, (Integer)DbgArb.getInteger(571), null, null, (boolean)false);
            actionRemoveFolder.setEnabled(false);
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(270), null, (Integer)DbgArb.getInteger(271), null, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionViewAnnotations = IdeAction.get((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(264), null, (Integer)DbgArb.getInteger(267), null, null, (boolean)false);
            actionViewAnnotations.putValue("NoCtxName", (Object)DbgArb.getString(264));
            actionViewAnnotations.setEnabled(false);
            actionViewAnnotationsForClass = IdeAction.get((int)VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID, null, (String)DbgArb.getString(268), null, (Integer)DbgArb.getInteger(269), null, null, (boolean)false);
            actionViewAnnotationsForClass.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(272), null, (Integer)DbgArb.getInteger(273), null, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(274), null, (Integer)DbgArb.getInteger(275), null, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(276), null, (Integer)DbgArb.getInteger(277), null, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatch = IdeAction.get((int)WATCH_CMD_ID, null, (String)DbgArb.getString(280), null, (Integer)DbgArb.getInteger(281), (Icon)OracleIcons.getIcon((String)"watch.png"), null, (boolean)false);
            actionWatch.setEnabled(false);
            actionInspect = IdeAction.get((int)INSPECT_CMD_ID, null, (String)DbgArb.getString(282), null, (Integer)DbgArb.getInteger(283), (Icon)OracleIcons.getIcon((String)"properties.png"), null, (boolean)false);
            actionInspect.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(296), null, (Integer)DbgArb.getInteger(297), null, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(298), null, (Integer)DbgArb.getInteger(299), null, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(284), null, (Integer)DbgArb.getInteger(286), null, null, (boolean)false);
            actionGoto.putValue("NoCtxName", (Object)DbgArb.getString(284));
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(287), null, (Integer)DbgArb.getInteger(289), null, null, (boolean)false);
            actionGotoDeclared.putValue("NoCtxName", (Object)DbgArb.getString(287));
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(290), null, (Integer)DbgArb.getInteger(292), null, null, (boolean)false);
            actionGotoField.putValue("NoCtxName", (Object)DbgArb.getString(290));
            actionGotoField.setEnabled(false);
            actionAddNewClass = IdeAction.get((int)ADD_NEW_CLASS_CMD_ID, null, (String)DbgArb.getString(568), null, (Integer)DbgArb.getInteger(569), null, null, (boolean)false);
            actionAddNewClass.setEnabled(false);
            actionRemoveAllFolders = IdeAction.get((int)REMOVE_ALL_FOLDERS_CMD_ID, null, (String)DbgArb.getString(572), null, (Integer)DbgArb.getInteger(573), null, null, (boolean)false);
            actionRemoveAllFolders.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(300), null, (Integer)DbgArb.getInteger(301), null, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(302, ""), null, (Integer)DbgArb.getInteger(303), null, null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(98), null, (Integer)RunMgrArb.getInteger(99), (Icon)OracleIcons.getIcon((String)"settings.png"), null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(94), null, (Integer)RunMgrArb.getInteger(95), null, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(96), null, (Integer)RunMgrArb.getInteger(97), (Icon)OracleIcons.getIcon((String)"export.png"), null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionShowAncestors, actionExpandAncestor, actionEditClass, actionRemoveFolder, actionViewWhole, actionViewAnnotations, actionViewAnnotationsForClass, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatch, actionInspect, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionAddNewClass, actionRemoveAllFolders, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(actions, this);
    }

    @Override
    protected void addPopupMenuItemsForNew(ContextMenu popup, Context context) {
        this.addPopupItem(popup, context, actionAddNewClass, menuitemAddNewClass, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_NEW_ITEM_CTXT_MENU);
        super.addPopupMenuItemsForNew(popup, context);
    }

    @Override
    protected void addPopupMenuItemsForDataItem(ContextMenu popup, Context context) {
        this.addPopupItem(popup, context, actionEditClass, menuitemEditClass, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, actionRemoveFolder, menuitemRemoveFolder, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, actionShowAncestors, menuitemShowAncestors, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, actionExpandAncestor, menuitemExpandAncestor, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        super.addPopupMenuItemsForDataItem(popup, context);
    }

    @Override
    protected void addPopupMenuItemsForData(ContextMenu popup, Context context) {
        this.addPopupItem(popup, context, actionRemoveAllFolders, menuitemRemoveAllFolders, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        super.addPopupMenuItemsForData(popup, context);
    }

    @Override
    protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        super.addPopupMenuItemsForCommon(popup, context);
        this.addPopupItem(popup, context, actionSettings, menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        DataItem dataItem;
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            DataTable dataTable = this.getDataPanel().getDataTable();
            if (dataTable == null || !this.getDataPanel().getDockableWindow().isVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!(dataTable.getTable().isEnabled() && this.getDebuggingProcess() != null && this.vm != null || cmdId == SETTINGS_CMD_ID)) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == SHOW_ANCESTORS_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(this.canShowAncestors(dataItem));
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == EXPAND_ANCESTOR_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                action.setEnabled(this.canExpandAncestor(dataItem));
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == EDIT_CLASS_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem instanceof HeapClassFolderDataItem && treePath != null) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == REMOVE_FOLDER_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            if (dataItem instanceof VersionedDataItem) {
                if (dataItem.getData() instanceof HeapDataItem) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (dataItem instanceof HeapDataItem) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == ADD_NEW_CLASS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == REMOVE_ALL_FOLDERS_CMD_ID) {
            action.setEnabled(this.canRemoveAllFolders());
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        return super.update(action, context);
    }

    private HeapPanel getHeapPanel() {
        return (HeapPanel)this.getDataPanel();
    }

    boolean delete(EventObject e) {
        Context context = this.getContext(e);
        this.update(actionRemoveFolder, context);
        if (actionRemoveFolder.isEnabled()) {
            this.handleEvent(actionRemoveFolder, context);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == SHOW_ANCESTORS_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                WaitCursor wc = Ide.getWaitCursor();
                wc.show();
                try {
                    this.showAncestors(dataItem);
                }
                finally {
                    wc.hide();
                }
            }
            return true;
        }
        if (cmdId == EXPAND_ANCESTOR_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                WaitCursor wc = Ide.getWaitCursor();
                wc.show();
                try {
                    this.expandAncestor(dataItem, treePath);
                }
                finally {
                    wc.hide();
                }
            }
            return true;
        }
        if (cmdId == EDIT_CLASS_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem instanceof HeapClassFolderDataItem && treePath != null) {
                this.editClass((HeapClassFolderDataItem)dataItem, treePath);
            }
            return true;
        }
        if (cmdId == REMOVE_FOLDER_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem instanceof VersionedDataItem) {
                Object item = dataItem.getData();
                if (item instanceof HeapDataItem) {
                    this.removeFolder((HeapDataItem)item);
                }
            } else if (dataItem instanceof HeapDataItem) {
                this.removeFolder((HeapDataItem)dataItem);
            }
            return true;
        }
        if (cmdId == ADD_NEW_CLASS_CMD_ID) {
            this.addNewClass();
            return true;
        }
        if (cmdId == REMOVE_ALL_FOLDERS_CMD_ID) {
            this.removeAllFolders();
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            String[] path = new String[]{DbgArb.getString(620), DbgArb.getString(714)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
            return true;
        }
        return super.handleEvent(action, context);
    }

    private void editClass(HeapClassFolderDataItem heapClassFolderDataItem, TreePath treePath) {
        List processHeapFolders;
        int i = this.getRoot().indexOf(heapClassFolderDataItem);
        if (i != -1 && (processHeapFolders = this.getProcessHeapFolders(this.getDebuggingProcess())) != null) {
            int index = this.convertProcessHeapFolderIndexToProjectHeapFolderIndex(processHeapFolders, i);
            String name = (String)processHeapFolders.get(i);
            String title = DbgArb.getString(578);
            String prompt = DbgArb.getString(579);
            String helpId = "f1_deb_edit_heap_classdialog_html";
            if ((name = EditHeapClassDialog.showEditHeapClassDialog(title, prompt, name, this.getDebuggingProcess().getProject(), helpId)) != null) {
                processHeapFolders.set(i, name);
                List projectHeapFolders = this.getProjectHeapFolders(this.getDebuggingProcess());
                projectHeapFolders.set(index, name);
                Object subset = this.makeHeapSubsetForClass(name);
                heapClassFolderDataItem.modifyClass(subset, treePath);
            }
        }
    }

    private Object makeHeapSubsetForClass(String name) {
        DebugHeapSubsetClasses subset = new DebugHeapSubsetClasses(name, null);
        subset.addClass(name, false);
        if (this.vm != null) {
            DebugHeapInfo heap = null;
            try {
                heap = this.vm.getHeap(subset);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (heap != null) {
                return heap;
            }
        }
        return subset;
    }

    private void removeFolder(HeapDataItem heapDataItem) {
        List processHeapFolders;
        int i = this.getRoot().indexOf(heapDataItem);
        if (i != -1 && (processHeapFolders = this.getProcessHeapFolders(this.getDebuggingProcess())) != null) {
            int size;
            int index = -1;
            if (heapDataItem instanceof HeapClassFolderDataItem) {
                index = this.convertProcessHeapFolderIndexToProjectHeapFolderIndex(processHeapFolders, i);
            }
            this.getDataPanel().removeTopDataItem(i);
            processHeapFolders.remove(i);
            if (heapDataItem instanceof HeapClassFolderDataItem) {
                List projectHeapFolders = this.getProjectHeapFolders(this.getDebuggingProcess());
                projectHeapFolders.remove(index);
            }
            if (heapDataItem instanceof HeapAncestorsFolderDataItem) {
                HeapAncestorsFolderDataItem hasFolder = (HeapAncestorsFolderDataItem)heapDataItem;
                hasFolder.has.unpin();
            }
            if (i < (size = processHeapFolders.size())) {
                this.getDataPanel().selectTopDataItem(i);
            } else if (0 <= --i && i < size) {
                this.getDataPanel().selectTopDataItem(i);
            }
        }
    }

    private List getProcessHeapFolders(DebuggingProcess debuggingProcess) {
        if (debuggingProcess != null) {
            List<String> list = this.mapProcessHeapFolders.get(debuggingProcess);
            if (list == null) {
                list = new ArrayList<String>(this.getProjectHeapFolders(debuggingProcess));
                this.mapProcessHeapFolders.put(debuggingProcess, list);
            }
            return list;
        }
        return null;
    }

    private List getProjectHeapFolders(DebuggingProcess debuggingProcess) {
        if (debuggingProcess != null) {
            Project project = debuggingProcess.getProject();
            String scope = project != null && project != Ide.getDefaultProject() ? project.getURL().toString() : GlobalHeapScope;
            List<String> list = this.mapProjectHeapFolders.get(scope);
            if (list == null) {
                list = new ArrayList<String>();
                this.mapProjectHeapFolders.put(scope, list);
            }
            return list;
        }
        return null;
    }

    private int convertProcessHeapFolderIndexToProjectHeapFolderIndex(List processHeapFolders, int index) {
        int count = 0;
        for (int i = 0; i < index; ++i) {
            Object o = processHeapFolders.get(i);
            if (!(o instanceof String)) continue;
            ++count;
        }
        return count;
    }

    private void pin(DebugDataCompositeInfo datac, HeapAncestorSubset has) {
        DebugPinnedInfo pin = datac.pinObject(this);
        if (this.pins == null) {
            this.pins = new ArrayList();
        }
        if (this.pinDebuggingProcesses == null) {
            this.pinDebuggingProcesses = new ArrayList();
        }
        if (this.pinSubsets == null) {
            this.pinSubsets = new ArrayList();
        }
        this.pins.add(pin);
        this.pinDebuggingProcesses.add(this.getDebuggingProcess());
        this.pinSubsets.add(has);
    }

    private void unpinAncestorFolders() {
        List processHeapFolders = this.getProcessHeapFolders(this.getDebuggingProcess());
        if (processHeapFolders != null) {
            for (Object o : processHeapFolders) {
                if (!(o instanceof HeapAncestorSubset)) continue;
                HeapAncestorSubset has = (HeapAncestorSubset)o;
                has.unpin();
            }
        }
    }

    private boolean canShowAncestors(DataItem dataItem) {
        return dataItem.getAddressOfObject() != 0L;
    }

    private boolean canExpandAncestor(DataItem dataItem) {
        return dataItem.ancestorHeapInfo != null && (dataItem.info instanceof DebugHeapAncestor || dataItem.ancestorDepth != 0);
    }

    private void expandAncestor(DataItem dataItem, TreePath treePath) {
        if (this.canExpandAncestor(dataItem)) {
            Iterator i = dataItem.getChildren();
            while (i.hasNext()) {
                DataItem child = (DataItem)i.next();
                if (!child.ancestorShortestDepth) continue;
                this.getDataPanel().getDataTable().expandPath(treePath);
                this.expandAncestor(child, treePath.pathByAddingChild(child));
                break;
            }
        }
    }

    void showAncestors(DataItem dataItem) {
        DebugDataInfo data = dataItem.getDataInfo();
        if (data instanceof DebugDataCompositeInfo) {
            DebugDataCompositeInfo datac = (DebugDataCompositeInfo)data;
            this.showAncestors(datac);
        }
    }

    void showAncestors(DebugDataCompositeInfo datac) {
        long address = datac.getAddressOfObject();
        HeapAncestorSubset has = new HeapAncestorSubset(address, datac.getClassInfo());
        List processHeapFolders = this.getProcessHeapFolders(this.getDebuggingProcess());
        if (processHeapFolders != null) {
            int index = processHeapFolders.indexOf(has);
            if (index == -1) {
                processHeapFolders.add(has);
                index = processHeapFolders.size() - 1;
                this.pin(datac, has);
                Object subset = this.makeHeapSubsetForAncestors(has);
                HeapAncestorsFolderDataItem heapAncestorsFolderDataItem = new HeapAncestorsFolderDataItem(subset, has);
                this.getDataPanel().addTopDataItem(heapAncestorsFolderDataItem);
            } else {
                this.getDataPanel().selectTopDataItem(index);
            }
        }
    }

    private Object makeHeapSubsetForAncestors(HeapAncestorSubset has) {
        DebugHeapInfo heap;
        HeapWindowSettings heapWindowSettings;
        String name = DbgArb.format(604, "@" + Long.toHexString(has.address).toUpperCase());
        if (has.discarded) {
            name = name + " " + DbgArb.getString(605);
        }
        int ignoreLevel = (heapWindowSettings = ((HeapPanel)this.getDataPanel()).getHeapWindowSettings()).isIgnoreSoftWeak() ? 4 : 2;
        int depth = heapWindowSettings.getMaximumDepth();
        DebugHeapSubsetAncestors subset = new DebugHeapSubsetAncestors(name, has.address, depth, ignoreLevel, has.classInfo);
        if (!has.discarded && this.vm != null && (heap = this.vm.getHeap(subset)) != null) {
            return heap;
        }
        return subset;
    }

    @Override
    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.pinDebuggingProcesses != null) {
            for (int i = this.pinDebuggingProcesses.size() - 1; i >= 0; --i) {
                if (!debuggingProcess.equals(this.pinDebuggingProcesses.get(i))) continue;
                this.pins.remove(i);
                this.pinDebuggingProcesses.remove(i);
                this.pinSubsets.remove(i);
            }
        }
        this.mapProcessHeapFolders.remove(debuggingProcess);
        super.processFinished(debuggingProcess);
    }

    @Override
    protected void addDataItems() {
        List processHeapFolders = this.getProcessHeapFolders(this.getDebuggingProcess());
        if (processHeapFolders != null) {
            List<DataItem> root = this.getRoot();
            for (Object o : processHeapFolders) {
                Object subset;
                if (o instanceof String) {
                    String name = (String)o;
                    subset = this.makeHeapSubsetForClass(name);
                    HeapClassFolderDataItem heapClassFolderDataItem = new HeapClassFolderDataItem(subset);
                    root.add(heapClassFolderDataItem);
                    continue;
                }
                if (!(o instanceof HeapAncestorSubset)) continue;
                HeapAncestorSubset has = (HeapAncestorSubset)o;
                subset = this.makeHeapSubsetForAncestors(has);
                HeapAncestorsFolderDataItem heapAncestorsFolderDataItem = new HeapAncestorsFolderDataItem(subset, has);
                root.add(heapAncestorsFolderDataItem);
            }
        }
        if (this.vm != null) {
            this.updateInstanceCounts(this.vm);
        }
        this.model.updateChangeTracking();
    }

    HeapClassFolderDataItem addClass(String name) {
        return this.addClass(name, true);
    }

    HeapClassFolderDataItem addClass(String name, boolean highlight) {
        List processHeapFolders = this.getProcessHeapFolders(this.getDebuggingProcess());
        if (processHeapFolders != null) {
            int index = processHeapFolders.indexOf(name);
            if (index == -1) {
                index = processHeapFolders.size();
                processHeapFolders.add(name);
                index = processHeapFolders.size() - 1;
                List projectHeapFolders = this.getProjectHeapFolders(this.getDebuggingProcess());
                projectHeapFolders.add(name);
                Object subset = this.makeHeapSubsetForClass(name);
                HeapClassFolderDataItem heapClassFolderDataItem = new HeapClassFolderDataItem(subset);
                this.getDataPanel().addTopDataItem(heapClassFolderDataItem, highlight);
                return heapClassFolderDataItem;
            }
            try {
                if (highlight) {
                    this.getDataPanel().selectTopDataItem(index);
                }
                return (HeapClassFolderDataItem)this.getRoot().get(index);
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        return null;
    }

    private void loadHeap(PropertyAccess properties) {
        String s = properties.getProperty(HEAP_KEY_COUNT, null);
        if (s != null) {
            try {
                int count = Integer.parseInt(s);
                for (int i = 0; i < count; ++i) {
                    this.loadHeapItem(properties, i);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean loadHeapItem(PropertyAccess properties, int number) {
        String prefix = HEAP_KEY_PREFIX + number + HEAP_KEY_DOT;
        String scope = properties.getProperty(prefix + HEAP_KEY_SCOPE, GlobalHeapScope);
        String s = properties.getProperty(prefix + HEAP_KEY_CLASS, null);
        if (s != null && s.length() > 0) {
            List<String> list = this.mapProjectHeapFolders.get(scope);
            if (list == null) {
                list = new ArrayList<String>();
                this.mapProjectHeapFolders.put(scope, list);
            }
            list.add(s);
            return true;
        }
        return false;
    }

    void saveClasses(PropertyAccess properties) {
        int previousCount = 0;
        String s = properties.getProperty(HEAP_KEY_COUNT, null);
        if (s != null) {
            try {
                previousCount = Integer.parseInt(s);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int count = 0;
        for (String scope : this.mapProjectHeapFolders.keySet()) {
            List<String> list = this.mapProjectHeapFolders.get(scope);
            for (String name : list) {
                this.saveClass(properties, count, scope, name);
                ++count;
            }
        }
        for (int i = count; i < previousCount; ++i) {
            this.removeSavedClass(properties, i);
        }
        properties.setProperty(HEAP_KEY_COUNT, Integer.toString(count));
    }

    private void saveClass(PropertyAccess properties, int number, String scope, String name) {
        String prefix = HEAP_KEY_PREFIX + number + HEAP_KEY_DOT;
        properties.setProperty(prefix + HEAP_KEY_SCOPE, scope);
        properties.setProperty(prefix + HEAP_KEY_CLASS, name);
    }

    private void removeSavedClass(PropertyAccess properties, int number) {
        String prefix = HEAP_KEY_PREFIX + number + HEAP_KEY_DOT;
        properties.setProperty(prefix + HEAP_KEY_SCOPE, null);
        properties.setProperty(prefix + HEAP_KEY_CLASS, null);
    }

    @Override
    public void pinnedObjectDiscarded(DebugVirtualMachine vm, DebugPinnedInfo pin) {
        List processHeapFolders;
        long address = pin.getAddressOfObject();
        DebuggingProcess debuggingProcess = JDebugger.getInstance().findDebuggingProcess(vm);
        if (debuggingProcess != null && (processHeapFolders = this.getProcessHeapFolders(debuggingProcess)) != null) {
            for (Object o : processHeapFolders) {
                if (!(o instanceof HeapAncestorSubset)) continue;
                HeapAncestorSubset has = (HeapAncestorSubset)o;
                if (has.address != address) continue;
                has.discarded();
            }
        }
    }

    private void addNewClass() {
        String title = DbgArb.getString(580);
        String prompt = DbgArb.getString(581);
        String helpId = "f1_deb_add_class_folder_dialog_html";
        String name = EditHeapClassDialog.showEditHeapClassDialog(title, prompt, null, this.getDebuggingProcess().getProject(), helpId);
        if (name != null) {
            this.addClass(name);
        }
    }

    private boolean canRemoveAllFolders() {
        List processHeapFolders = this.getProcessHeapFolders(this.getDebuggingProcess());
        return processHeapFolders != null && processHeapFolders.size() > 0;
    }

    private void removeAllFolders() {
        List projectHeapFolders;
        this.unpinAncestorFolders();
        List processHeapFolders = this.getProcessHeapFolders(this.getDebuggingProcess());
        if (processHeapFolders != null) {
            processHeapFolders.clear();
        }
        if ((projectHeapFolders = this.getProjectHeapFolders(this.getDebuggingProcess())) != null) {
            projectHeapFolders.clear();
        }
        this.everythingChanged();
    }

    static {
        ADD_NEW_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapAddNewClass");
        EDIT_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapEditClass");
        REMOVE_FOLDER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapRemoveFolder");
        SHOW_ANCESTORS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapShowAncestors");
        EXPAND_ANCESTOR_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapExpandAncestor");
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapViewWhole");
        VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapViewAnnotations");
        VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapViewAnnotationsForClass");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapModifyValue");
        WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapWatch");
        INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapInspect");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapGotoField");
        REMOVE_ALL_FOLDERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapRemoveAllFolders");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapSettings");
    }

    final class HeapAncestorSubset {
        final long address;
        final DebugClassInfo classInfo;
        boolean discarded;

        HeapAncestorSubset(long address, DebugClassInfo classInfo) {
            this.address = address;
            this.discarded = false;
            this.classInfo = classInfo;
        }

        private void unpin() {
            int i = HeapController.this.pinSubsets.indexOf(this);
            if (i != -1) {
                DebugPinnedInfo pin = (DebugPinnedInfo)HeapController.this.pins.get(i);
                pin.unpinObject();
                HeapController.this.pins.remove(i);
                HeapController.this.pinDebuggingProcesses.remove(i);
                HeapController.this.pinSubsets.remove(i);
            }
        }

        private void discarded() {
            this.discarded = true;
            int i = HeapController.this.pinSubsets.indexOf(this);
            if (i != -1) {
                HeapController.this.pins.remove(i);
                HeapController.this.pinDebuggingProcesses.remove(i);
                HeapController.this.pinSubsets.remove(i);
            }
        }

        public int hashCode() {
            return (int)this.address;
        }

        public boolean equals(Object o) {
            if (o instanceof HeapAncestorSubset) {
                return this.address == ((HeapAncestorSubset)o).address;
            }
            return false;
        }
    }

    protected final class HeapAncestorsFolderDataItem
    extends HeapDataItem {
        HeapAncestorSubset has;

        HeapAncestorsFolderDataItem(Object info, HeapAncestorSubset has) {
            super(info);
            this.has = has;
        }
    }

    protected final class HeapClassFolderDataItem
    extends HeapDataItem {
        HeapClassFolderDataItem(Object info) {
            super(info);
        }

        void modifyClass(Object info, TreePath treePath) {
            this.modifyInfo(info, null, null, treePath);
        }
    }

    protected abstract class HeapDataItem
    extends DataItem {
        private boolean isDebugHeapAncestor;
        private boolean isDebugHeapAncestorOutsideHeap;

        HeapDataItem(Object info) {
            super(HeapController.this.getDataPanel(), info);
        }

        @Override
        protected void setInfo(Object info, String displayNameOverride, String expressionPartOverride) {
            this.isDebugHeapAncestor = info instanceof DebugHeapAncestor;
            this.isDebugHeapAncestorOutsideHeap = info instanceof DebugHeapAncestorOutsideHeap;
            super.setInfo(info, displayNameOverride, expressionPartOverride);
        }

        @Override
        protected Font getFont(int column) {
            if (column == 0) {
                if (HeapController.this.ancestorDepthZeroFont != null && this.ancestorDepth == 0 && !this.isDebugHeapAncestor) {
                    return HeapController.this.ancestorDepthZeroFont;
                }
                if (HeapController.this.heapAncestorOutsideHeapFont != null && this.isDebugHeapAncestorOutsideHeap) {
                    return HeapController.this.heapAncestorOutsideHeapFont;
                }
            }
            return super.getFont(column);
        }
    }
}

