/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeEditorGutterView;
import oracle.ide.ceditor.CursorListener;
import oracle.ide.ceditor.keymap.IdeEditorPane;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.compiler.Compiler;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverProvider;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutResetEvent;
import oracle.ide.layout.LayoutResetListener;
import oracle.ide.layout.Layouts;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.markers.Markable;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerException;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.peek.Peek;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.DebuggerBreakpointGutterToggleHandler;
import oracle.ide.runner.DebuggerEventSource;
import oracle.ide.runner.DebuggerExtender;
import oracle.ide.runner.DebuggerExtenderCallback;
import oracle.ide.runner.DebuggerExtenderDeclarator;
import oracle.ide.runner.DebuggerInspectorExpressionProvider;
import oracle.ide.runner.DebuggerListener;
import oracle.ide.runner.DebuggerStartCallback;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.runner.DebuggerWindowProviderCallback;
import oracle.ide.runner.DebuggerWindowProviderDeclarator;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.RunnableItem;
import oracle.ide.runner.Runner;
import oracle.ide.runner.SmartDataProvider;
import oracle.ide.runner.ToolTipExpressionProvider;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ideimpl.runner.DebuggerHook;
import oracle.ideimpl.runner.TerminateRunProcessButtons;
import oracle.ideri.util.Product;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.TextRange;
import oracle.javatools.editor.TextTabber;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceQuestionExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.util.SourceVisitor;
import oracle.javatools.ui.ColorUtils2;
import oracle.javatools.ui.treetable.JFastTreeTable;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Log;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.debugger.DebuggerConstants;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PackagedSource;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.Breakpoint;
import oracle.jdevimpl.debugger.BreakpointConditionEvaluationResult;
import oracle.jdevimpl.debugger.BreakpointConditionHoverBuilder;
import oracle.jdevimpl.debugger.BreakpointMarkerAPI;
import oracle.jdevimpl.debugger.BreakpointRuntimeCallback;
import oracle.jdevimpl.debugger.BreakpointsWindowSettings;
import oracle.jdevimpl.debugger.DebuggerContextMenuListener;
import oracle.jdevimpl.debugger.SourceIcon;
import oracle.jdevimpl.debugger.SourceIconRuntimeCallback;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.MethodVisitationInfoRetrievalKey;
import oracle.jdevimpl.debugger.support.TargetMethod;
import oracle.jdevimpl.runner.JRunnerContextMenuListener;
import oracle.jdevimpl.runner.RunItemController;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BreakpointDetails;
import oracle.jdevimpl.runner.debug.BreakpointMarker;
import oracle.jdevimpl.runner.debug.BreakpointRuntimeSupport;
import oracle.jdevimpl.runner.debug.BreakpointsWindow;
import oracle.jdevimpl.runner.debug.BytecodeFileSystemHelper;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.ClassesWindowSettings;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebugContext;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.DebuggingListener;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluationInfo;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.ExpressionProvider;
import oracle.jdevimpl.runner.debug.ExtenderCallback;
import oracle.jdevimpl.runner.debug.ExtenderManager;
import oracle.jdevimpl.runner.debug.HeapWindow;
import oracle.jdevimpl.runner.debug.HeapWindowSettings;
import oracle.jdevimpl.runner.debug.InspectorWindow;
import oracle.jdevimpl.runner.debug.InspectorWindowSettings;
import oracle.jdevimpl.runner.debug.JavaEvaluator;
import oracle.jdevimpl.runner.debug.LocalsWindow;
import oracle.jdevimpl.runner.debug.LocalsWindowSettings;
import oracle.jdevimpl.runner.debug.MonitorsWindow;
import oracle.jdevimpl.runner.debug.MonitorsWindowSettings;
import oracle.jdevimpl.runner.debug.ObjectPreferences;
import oracle.jdevimpl.runner.debug.PackageFileLineCheck;
import oracle.jdevimpl.runner.debug.PackageFileLineChecker;
import oracle.jdevimpl.runner.debug.RunWhilePaused;
import oracle.jdevimpl.runner.debug.SharedActions;
import oracle.jdevimpl.runner.debug.SmartWindow;
import oracle.jdevimpl.runner.debug.SmartWindowSettings;
import oracle.jdevimpl.runner.debug.SourceIconRuntime;
import oracle.jdevimpl.runner.debug.StackWindow;
import oracle.jdevimpl.runner.debug.StackWindowSettings;
import oracle.jdevimpl.runner.debug.ThreadsWindow;
import oracle.jdevimpl.runner.debug.ThreadsWindowSettings;
import oracle.jdevimpl.runner.debug.ToolTipEvaluator;
import oracle.jdevimpl.runner.debug.TracingPanel;
import oracle.jdevimpl.runner.debug.Utils;
import oracle.jdevimpl.runner.debug.WatchWindow;
import oracle.jdevimpl.runner.debug.WatchWindowSettings;
import oracle.jdevimpl.runner.debug.WindowManager;
import oracle.jdevimpl.runner.debug.WindowProviderCallback;
import oracle.jdevimpl.runner.res.ExtensionResources;
import oracle.jdevimpl.runner.run.JRunner;

public final class JDebugger
implements ActiveViewListener,
ContextMenuListener,
Controller,
EditorListener,
MenuListener,
Observer,
CursorListener,
ShutdownHook,
HoverProvider,
DebuggerBreakpointGutterToggleHandler {
    public static final Log logger = new Log("JDebugger");
    private static JDebugger instance;
    private IdeLayout debugLayout;
    private DebugWindowSettings dbgSettings;
    private static ContextMenu contextMenu;
    static URL lastSavedFile;
    private Workspace activeWorkspace;
    private Project activeProject;
    private View activeView;
    private CodeEditor activeCodeEditor;
    private InspectorWindow activeInspector;
    private DebuggingProcess activeDebuggingProcess;
    private volatile int duringClassRedefinition;
    private boolean isToolTipProvider;
    private ToolTipEvaluator toolTipEvaluator;
    private Map<DebugBreakpoint, Breakpoint> breakpointForDebugBreakpoint;
    private List<DebuggingProcess> debuggingProcesses;
    private List<DebuggingProcess> debuggingProcessesConnecting;
    private List<DebuggingListener> debuggingListeners;
    private Map<DebuggingProcess, DebugBreakpoint> temporaryBreakpoints;
    private WindowManager windowManager = new WindowManager();
    private ExtenderManager extenderManager = ExtenderManager.getInstance();
    private List<Breakpoint> cachedNewBreakpoints;
    private Boolean cacheNewBreakpoints = Boolean.FALSE;
    private BreakpointsWindow breakpointsWindow;
    private ThreadsWindow threadsWindow;
    private StackWindow stackWindow;
    private SmartWindow smartWindow;
    private LocalsWindow localsWindow;
    private WatchWindow watchWindow;
    private ClassesWindow classesWindow;
    private HeapWindow heapWindow;
    private MonitorsWindow monitorsWindow;
    private List inspectorWindows;
    public static Color changedCellBackground;
    public static Color changedCellForeground;
    public static Color changedCellSelectedBackground;
    private ObjectPreferences objectPreferences;
    private static JMenu runMenu;
    private static JMenu viewMenu;
    private static boolean debugMenuBuilt;
    private static JMenu viewDebuggerSubMenu;
    private static final String VIEW_DEBUGGER_MENU_ID = "ViewDebuggerMenu";
    private static IdeAction actionDebugToggleBreakpoint;
    private static IdeAction actionDebugSuspendAllBreakpoints;
    private static IdeAction actionDebugProject;
    private static IdeAction actionEmpty;
    private static IdeAction actionDebugSelection;
    private static IdeAction actionDebugPause;
    private static IdeAction actionDebugResume;
    private static IdeAction actionDebugDetach;
    private static IdeAction actionDebugReset;
    private static IdeAction actionDebugStepOver;
    private static IdeAction actionDebugStepOverBC;
    private static IdeAction actionDebugStepInto;
    private static IdeAction actionDebugStepIntoBC;
    private static IdeAction actionDebugStepOut;
    private static IdeAction actionDebugStepToEndOfMethod;
    private static IdeAction actionDebugContinueStep;
    private static IdeAction actionDebugRunToCursor;
    private static IdeAction actionDebugStepIntoMethod;
    private static IdeAction actionDebugSetNextStatement;
    private static IdeAction actionDebugShowIP;
    private static IdeAction actionDebugGC;
    private static IdeAction actionContextMenuDebug;
    private static IdeAction actionDebugRestartMethod;
    private static AbstractButton suspendAllBreakpointsToolbarButton;
    private static IdeAction actionMruDebug;
    @Deprecated
    public static Component debugContextMenu;
    private static IdeAction actionNavigatorStopListening;
    private static IdeAction actionNavigatorDetachDebugger;
    private static JMenuItem menuitemNavigatorStopListening;
    private static JMenuItem menuitemNavigatorDetachDebugger;
    private static IdeAction actionCodeEditorToggleWatchpoint;
    private static IdeAction actionCodeEditorWatch;
    private static IdeAction actionCodeEditorInspect;
    private static JMenuItem menuitemCodeEditorToggleWatchpoint;
    private static JMenuItem menuitemCodeEditorRunToCursor;
    private static JMenuItem menuitemCodeEditorStepIntoMethod;
    private static JMenuItem menuitemCodeEditorSetNextStatement;
    private static JMenuItem menuitemCodeEditorWatch;
    private static JMenuItem menuitemCodeEditorInspect;
    private static JMenuItem menuitemCodeEditorRestartMethod;
    private static IdeAction actionStructureCreateWatchpoint;
    private static JMenuItem menuitemStructureCreateWatchpoint;
    private static IdeAction actionLogWindowCancelDebugConnection;
    private static IdeAction actionLogWindowShowIP;
    private static IdeAction actionLogWindowResume;
    private static IdeAction actionLogWindowStepOver;
    private static IdeAction actionLogWindowStepInto;
    private static IdeAction actionLogWindowStepOut;
    private static IdeAction actionLogWindowStepToEndOfMethod;
    private static IdeAction actionLogWindowStepOverBC;
    private static IdeAction actionLogWindowStepIntoBC;
    private static IdeAction actionLogWindowPause;
    private static IdeAction actionLogWindowGC;
    private static IdeAction actionLogWindowReset;
    private static JMenuItem menuitemLogWindowCancelDebugConnection;
    private static final String VIEW_BREAKPOINTS_CMD_NAME = "ViewDebugBreakpointsCommand";
    private static final String VIEW_THREADS_CMD_NAME = "ViewDebugThreadsCommand";
    private static final String VIEW_STACK_CMD_NAME = "ViewDebugStackCommand";
    private static final String VIEW_SMART_CMD_NAME = "ViewDebugSmartCommand";
    private static final String VIEW_LOCALS_CMD_NAME = "ViewDebugLocalsCommand";
    private static final String VIEW_WATCHES_CMD_NAME = "ViewDebugWatchesCommand";
    private static final String VIEW_CLASSES_CMD_NAME = "ViewDebugClassesCommand";
    private static final String VIEW_HEAP_CMD_NAME = "ViewDebugHeapCommand";
    private static final String VIEW_MONITORS_CMD_NAME = "ViewDebugMonitorsCommand";
    private static final String VIEW_LOG_CMD_NAME = "ViewDebugLogCommand";
    private static final int VIEW_BREAKPOINTS_CMD_ID;
    private static final int VIEW_THREADS_CMD_ID;
    private static final int VIEW_STACK_CMD_ID;
    private static final int VIEW_SMART_CMD_ID;
    private static final int VIEW_LOCALS_CMD_ID;
    private static final int VIEW_WATCHES_CMD_ID;
    private static final int VIEW_CLASSES_CMD_ID;
    private static final int VIEW_HEAP_CMD_ID;
    private static final int VIEW_MONITORS_CMD_ID;
    private static final int VIEW_LOG_CMD_ID;
    private static final String DEBUG_PROJECT_CMD_PREFIX = "DebugProjectCommand";
    private static final int DEBUG_PROJECT_CMD_ID;
    private static final int DEBUG_PAUSE_CMD_ID;
    private static final int DEBUG_RESUME_CMD_ID;
    private static final int DEBUG_DETACH_CMD_ID;
    private static final int DEBUG_RESET_CMD_ID;
    private static final int DEBUG_STEPOVER_CMD_ID;
    private static final int DEBUG_STEPOVERBC_CMD_ID;
    private static final int DEBUG_STEPINTO_CMD_ID;
    private static final int DEBUG_STEPINTOBC_CMD_ID;
    private static final int DEBUG_STEPOUT_CMD_ID;
    private static final int DEBUG_STEPTOENDOFMETHOD_CMD_ID;
    private static final int DEBUG_CONTINUESTEP_CMD_ID;
    private static final int DEBUG_RUNTOCURSOR_CMD_ID;
    private static final int DEBUG_STEPINTOMETHOD_CMD_ID;
    private static final int DEBUG_SETNEXTSTATEMENT_CMD_ID;
    private static final int DEBUG_SHOWIP_CMD_ID;
    private static final int DEBUG_GC_CMD_ID;
    private static final int DEBUG_POP_1_STACK_FRAME_CMD_ID;
    private static final int DEBUG_SUSPEND_ALL_BREAKPOINTS_CMD_ID;
    private static final int DEBUG_RESTARTMETHOD_CMD_ID;
    private static final int NAVIGATOR_STOPLISTENING_CMD_ID;
    private static final int NAVIGATOR_DETACHDEBUGGER_CMD_ID;
    private static final int CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID;
    private static final int CODE_EDITOR_WATCH_CMD_ID;
    private static final int CODE_EDITOR_INSPECT_CMD_ID;
    private static final int STRUCTURE_CREATEWATCHPOINT_CMD_ID;
    private static final int LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID;
    static final String ACTION_OWNER = "Debugger.actionOwner";
    static final String DEBUGGER_ID = "Debugger";
    static final String DEBUG_LAYOUT_KEY = "debugLayout";
    private List<DebuggerInspectorExpressionProvider> inspectorExpressionProviders = Collections.emptyList();
    private List<ToolTipExpressionProvider> toolTipExpressionProviders = Collections.emptyList();
    private List<SmartDataProvider> smartDataProviders = Collections.emptyList();
    private Map<String, DebuggerBreakpointGutterToggleHandler> gutterToggleHandlers = Collections.emptyMap();
    private boolean stepIntoMethodsAreHighlighted = false;
    private TextTabber textTabberForStepIntoMethods;
    private OffsetMark executionPointOffsetMark = null;
    public static final String DEBUGGER_STEP_INTO_OUTER_HELP_ID = "id_step_into_choice";
    private TextRange selectedRange = null;
    private Map<DebuggingProcess, Map<StepIntoLocationKey, Set<MethodRange>>> processToStepIntoStateMap = new HashMap<DebuggingProcess, Map<StepIntoLocationKey, Set<MethodRange>>>();
    private boolean escapedFromTextTabber = false;
    private Peek conditionalBreakpointPeek;
    private volatile boolean firstDebuggingProcessCreated = false;

    private JDebugger() {
        this.initializeIDESettings();
        Layouts.getLayouts().addLayoutResetListener(new LayoutResetListener(){

            public void beforeLayoutActivation(LayoutResetEvent e) {
                if (!Debugger.getDebugger().isDebugging()) {
                    return;
                }
                LogManager logManager = LogManager.getLogManager();
                if (logManager.isLogVisible()) {
                    return;
                }
                logManager.showLog();
            }
        });
        this.dbgSettings = DebugWindowSettings.getInstance();
        this.dbgSettings.addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent e) {
                if (Utils.structureReallyChanged(e)) {
                    JDebugger.this.debugWindowSettingsChanged();
                }
            }
        });
        changedCellBackground = this.dbgSettings.getChangedCellBackgroundColor();
        changedCellForeground = this.dbgSettings.getChangedCellForegroundColor();
        this.makeActions();
        runMenu = MenuManager.getJMenu((String)"Run");
        runMenu.addMenuListener(this);
        viewMenu = MenuManager.getJMenu((String)"View");
        viewMenu.addMenuListener(this);
        this.getDebugLayout();
        ExitCommand.addShutdownHook((ShutdownHook)this);
        LogManager.getLogManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        CodeEditorGutter.getGutterContextMenu().addContextMenuListener((ContextMenuListener)this);
        Ide.getSystem().attach((Observer)this);
        Project.addProjectChangeListener((String)"", (ProjectChangeListener)new ProjectChangeListener(){

            public void projectOpened(Project project) {
                if (project == JDebugger.this.getActiveProject()) {
                    this.updateNowOrLater();
                }
            }

            public void projectPropertiesChanged(ProjectChangeEvent e) {
                if (e.getProject() == JDebugger.this.getActiveProject()) {
                    this.updateNowOrLater();
                }
            }

            private void updateNowOrLater() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        JDebugger.this.tracingChanged();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IdeMainWindow mainWindow = Ide.getMainWindow();
                mainWindow.addActiveViewListener((ActiveViewListener)JDebugger.this);
                for (Object e : EditorManager.getEditorManager().getAllEditors()) {
                    if (!(e instanceof CodeEditor)) continue;
                    JDebugger.this.editorOpened((Editor)((CodeEditor)e));
                }
                EditorManager.getEditorManager().addEditorListener((EditorListener)JDebugger.this);
                Breakpoint.setBreakpointRuntimeCallback((BreakpointRuntimeCallback)new BreakpointRuntimeSupport());
                SourceIcon.setRuntimeCallback((SourceIconRuntimeCallback)new SourceIconRuntime());
                RunItemController.setJdevRunnerLoaded();
                JDebugger.this.activeProjectChanged();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JDebugger.this.activeViewChanged(null);
                        JDebugger.this.updateActiveBreakpoints();
                    }
                });
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    static synchronized JDebugger getInstance() {
        if (instance == null && Ide.getIdeArgs().getCreateUI()) {
            instance = new JDebugger();
        }
        return instance;
    }

    WindowManager getWindowManager() {
        return this.windowManager;
    }

    public static int getContextMenuDebugCommandID() {
        return JDebugger.getActionContextMenuDebug().getCommandId();
    }

    private Project getActiveProject() {
        if (this.activeProject == null) {
            this.activeProjectChanged();
        }
        return this.activeProject;
    }

    private Workspace getActiveWorkspace() {
        if (this.activeWorkspace == null) {
            this.activeProjectChanged();
        }
        return this.activeWorkspace;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Assert.check((boolean)action.isEnabled());
        int cmdId = action.getCommandId();
        if (action.isLocalAction() && (cmdId == DEBUG_SHOWIP_CMD_ID || cmdId == DEBUG_STEPOVER_CMD_ID || cmdId == DEBUG_STEPINTO_CMD_ID || cmdId == DEBUG_STEPOUT_CMD_ID || cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID || cmdId == DEBUG_STEPOVERBC_CMD_ID || cmdId == DEBUG_STEPINTOBC_CMD_ID || cmdId == DEBUG_RESUME_CMD_ID || cmdId == DEBUG_PAUSE_CMD_ID || cmdId == DEBUG_GC_CMD_ID || cmdId == DEBUG_RESET_CMD_ID)) {
            this.doLogWindowAction(context, cmdId);
            return true;
        }
        if (cmdId == DEBUG_STEPOVER_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepOver(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_STEPINTO_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                if (this.activeDebuggingProcess.canStepIntoOuterMethod(context)) {
                    this.handleStepInto(context);
                } else {
                    this.activeDebuggingProcess.stepInto(JDebugger.getEventTime(context));
                }
            }
            return true;
        }
        if (cmdId == DEBUG_STEPOUT_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepOut(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepToEndOfMethod(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DebuggerConstants.TOGGLEBREAKPOINT_CMD_ID) {
            return this.toggleBreakpointFromCodeEditor(context, null);
        }
        if (cmdId == DEBUG_SUSPEND_ALL_BREAKPOINTS_CMD_ID) {
            return this.toggleBreakpointSuspensionSetting(context);
        }
        if (cmdId == DebuggerConstants.ENABLEBREAKPOINT_CMD_ID) {
            return this.enableBreakpointFromCodeEditor(context, null);
        }
        if (cmdId == DebuggerConstants.DISABLEBREAKPOINT_CMD_ID) {
            return this.disableBreakpointFromCodeEditor(context, null);
        }
        if (cmdId == DebuggerConstants.EDITBREAKPOINT_CMD_ID) {
            return this.editBreakpointFromCodeEditor(context, null);
        }
        if (cmdId == DEBUG_STEPOVERBC_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepOverBC(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_STEPINTOBC_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepIntoBC(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_CONTINUESTEP_CMD_ID) {
            this.clearExecutionPointOffsetMark(context);
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.continueStep();
            }
            return true;
        }
        if (cmdId == DEBUG_RUNTOCURSOR_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.runToCursor(context);
            }
            return true;
        }
        if (cmdId == DEBUG_STEPINTOMETHOD_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepIntoMethod(context);
            }
            return true;
        }
        if (cmdId == DEBUG_SHOWIP_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.showIP();
            }
            return true;
        }
        if (cmdId == CODE_EDITOR_WATCH_CMD_ID) {
            this.watchFromCodeEditor(context);
            return true;
        }
        if (cmdId == CODE_EDITOR_INSPECT_CMD_ID) {
            this.inspectFromCodeEditor(context);
            return true;
        }
        if (cmdId == CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID) {
            this.toggleWatchpointFromCodeEditor(context, null);
            return true;
        }
        if (cmdId == DEBUG_PROJECT_CMD_ID) {
            if (this.canStartProcess(null)) {
                this.startMruProcess(context);
            }
            return true;
        }
        if (action == this.getActionMruDebug()) {
            if (this.canStartProcess(null)) {
                this.startMruProcess(context);
            }
            return true;
        }
        if (action.getValue("UserData") != null && action.getValue("UserData").toString().startsWith("RunConfigurationName:")) {
            RunConfiguration runConfiguration;
            String runConfigurationName = action.getValue("UserData").toString().substring(21);
            if (runConfigurationName != null && (runConfiguration = RunConfigurations.getRunConfigurationByName(this.getActiveProject(), runConfigurationName)) != null) {
                RunConfigurations.setActiveRunConfiguration(this.getActiveProject(), this.getActiveWorkspace(), runConfiguration);
                if (this.canStartProcess(null)) {
                    this.startProcess(null, true);
                }
            }
            return true;
        }
        if (action == JDebugger.getActionDebugSelection()) {
            Node contextNode = RunProcess.getContextNodeForRun((Context)context);
            if (contextNode != null && !(contextNode instanceof Workspace) && !(contextNode instanceof Project)) {
                context.setProperty(RunProcess.RUN_PROCESS_DO_NOT_CONSIDER_DEFAULT, (Object)Boolean.TRUE);
            }
            this.startProcess(context, false);
            return true;
        }
        if (action == JDebugger.getActionContextMenuDebug()) {
            context = (Context)action.getValue("UserData");
            action.putValue("UserData", null);
            Node contextNode = RunProcess.getContextNodeForRun((Context)context);
            if (contextNode != null && !(contextNode instanceof Workspace) && !(contextNode instanceof Project)) {
                context.setProperty(RunProcess.RUN_PROCESS_DO_NOT_CONSIDER_DEFAULT, (Object)Boolean.TRUE);
            }
            this.startProcess(context, false);
            return true;
        }
        if (cmdId == VIEW_BREAKPOINTS_CMD_ID) {
            this.viewBreakpoints();
            return true;
        }
        if (cmdId == VIEW_THREADS_CMD_ID) {
            this.safelyShowDockable(this.getThreadsWindow(true));
            return true;
        }
        if (cmdId == VIEW_STACK_CMD_ID) {
            this.safelyShowDockable(this.getStackWindow(true));
            return true;
        }
        if (cmdId == VIEW_SMART_CMD_ID) {
            this.safelyShowDockable(this.getSmartWindow(true));
            return true;
        }
        if (cmdId == VIEW_LOCALS_CMD_ID) {
            this.safelyShowDockable(this.getLocalsWindow(true));
            return true;
        }
        if (cmdId == VIEW_WATCHES_CMD_ID) {
            this.viewWatches();
            return true;
        }
        if (cmdId == VIEW_CLASSES_CMD_ID) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DockUtil.showDockableWindow((DockableView)JDebugger.this.getClassesWindow(true));
                }
            };
            SwingUtilities.invokeLater(runnable);
            return true;
        }
        if (cmdId == VIEW_HEAP_CMD_ID) {
            this.viewHeap();
            return true;
        }
        if (cmdId == VIEW_MONITORS_CMD_ID) {
            this.viewMonitors();
            return true;
        }
        if (cmdId == VIEW_LOG_CMD_ID) {
            this.viewLog();
            return true;
        }
        if (cmdId == DEBUG_PAUSE_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.pause();
            }
            return true;
        }
        if (cmdId == DEBUG_RESUME_CMD_ID) {
            this.clearExecutionPointOffsetMark(context);
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.resume();
            }
            return true;
        }
        if (cmdId == DEBUG_DETACH_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.detach();
            }
            return true;
        }
        if (cmdId == DEBUG_RESET_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.terminate();
            }
            return true;
        }
        if (cmdId == DEBUG_POP_1_STACK_FRAME_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.pop1StackFrame(context);
            }
            return true;
        }
        if (cmdId == DEBUG_RESTARTMETHOD_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.restartCurrentMethod(context);
            }
            return true;
        }
        if (cmdId == DEBUG_SETNEXTSTATEMENT_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.setNextStatement(context);
            }
            return true;
        }
        if (cmdId == DEBUG_GC_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.gc();
            }
            return true;
        }
        if (cmdId == NAVIGATOR_STOPLISTENING_CMD_ID) {
            this.stopListening(context);
            return true;
        }
        if (cmdId == NAVIGATOR_DETACHDEBUGGER_CMD_ID) {
            this.detachDebugger(context);
            return true;
        }
        if (cmdId == STRUCTURE_CREATEWATCHPOINT_CMD_ID) {
            this.createWatchpointFromStructure(context, null);
            return true;
        }
        if (cmdId == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID) {
            this.doLogWindowAction(context, cmdId);
            return true;
        }
        return cmdId == 5 || cmdId == 6 || cmdId == 18 || cmdId == 17 || cmdId == 78 || cmdId == 19;
    }

    private void safelyShowDockable(DebuggerWindow dw) {
        try {
            DockUtil.showDockableWindow((DockableView)dw);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private boolean toggleBreakpointSuspensionSetting(Context context) {
        if (this.activeDebuggingProcess != null && this.activeDebuggingProcess.canSuspendBreakpoints()) {
            List[] bps;
            this.activeDebuggingProcess.setSuspendBreakpoints(!this.activeDebuggingProcess.getSuspendBreakpoints());
            boolean bpsNowSuspended = this.activeDebuggingProcess.getSuspendBreakpoints();
            if (bpsNowSuspended) {
                actionDebugSuspendAllBreakpoints.setState(true);
            } else {
                actionDebugSuspendAllBreakpoints.setState(false);
            }
            if (suspendAllBreakpointsToolbarButton == null) {
                for (Component c : Ide.getToolbar().getComponents()) {
                    AbstractButton button;
                    if (!(c instanceof AbstractButton) || (button = (AbstractButton)c).getAction() != actionDebugSuspendAllBreakpoints) continue;
                    suspendAllBreakpointsToolbarButton = button;
                }
            }
            if (suspendAllBreakpointsToolbarButton != null) {
                suspendAllBreakpointsToolbarButton.setSelected(bpsNowSuspended);
            }
            for (List bpList : bps = Breakpoint.getBreakpoints((Workspace)context.getWorkspace(), (Project)context.getProject())) {
                for (Breakpoint bp : bpList) {
                    bp.setSuspended(bpsNowSuspended);
                }
            }
            this.updateBreakpointsWindow();
        }
        return true;
    }

    private void startMruProcess(Context context) {
        context = JRunner.prepareMruProcess(context);
        this.startProcess(context, true);
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.isLocalAction() && (cmdId == DEBUG_SHOWIP_CMD_ID || cmdId == DEBUG_STEPOVER_CMD_ID || cmdId == DEBUG_STEPINTO_CMD_ID || cmdId == DEBUG_STEPOUT_CMD_ID || cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID || cmdId == DEBUG_STEPOVERBC_CMD_ID || cmdId == DEBUG_STEPINTOBC_CMD_ID || cmdId == DEBUG_RESUME_CMD_ID || cmdId == DEBUG_PAUSE_CMD_ID || cmdId == DEBUG_GC_CMD_ID || cmdId == DEBUG_RESET_CMD_ID)) {
            action.setEnabled(this.canDoLogWindowAction(context, cmdId));
            return true;
        }
        if (cmdId == DEBUG_PROJECT_CMD_ID) {
            this.updateDebugProjectAction(action, context);
            return true;
        }
        if (cmdId == DEBUG_PAUSE_CMD_ID) {
            this.setActionName(action, DbgArb.getString(7));
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canPause());
            return true;
        }
        if (cmdId == DEBUG_RESUME_CMD_ID) {
            this.setActionName(action, DbgArb.getString(9));
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canResume());
            return true;
        }
        if (cmdId == DEBUG_DETACH_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canDetach());
            return true;
        }
        if (cmdId == DEBUG_RESET_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canTerminate());
            return true;
        }
        if (cmdId == DEBUG_STEPOVER_CMD_ID || cmdId == DEBUG_STEPOVERBC_CMD_ID) {
            if (cmdId == DEBUG_STEPOVER_CMD_ID) {
                this.setActionName(action, DbgArb.getString(14));
            } else {
                this.setActionName(action, DbgArb.getString(16));
            }
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepOver());
            return true;
        }
        if (cmdId == DEBUG_STEPINTO_CMD_ID || cmdId == DEBUG_STEPINTOBC_CMD_ID) {
            if (cmdId == DEBUG_STEPINTO_CMD_ID) {
                this.setActionName(action, DbgArb.getString(18));
            } else {
                this.setActionName(action, DbgArb.getString(20));
            }
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepInto());
            return true;
        }
        if (cmdId == DEBUG_STEPOUT_CMD_ID) {
            this.setActionName(action, DbgArb.getString(22));
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepOut());
            return true;
        }
        if (cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID) {
            this.setActionName(action, DbgArb.getString(24));
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepToEndOfMethod());
            return true;
        }
        if (cmdId == DEBUG_CONTINUESTEP_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canContinueStep());
            return true;
        }
        if (cmdId == DEBUG_RUNTOCURSOR_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canRunToCursor(context));
            return true;
        }
        if (cmdId == DEBUG_STEPINTOMETHOD_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepIntoMethod(context));
            return true;
        }
        if (cmdId == DEBUG_SETNEXTSTATEMENT_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canSetNextStatement(context));
            return true;
        }
        if (cmdId == DEBUG_POP_1_STACK_FRAME_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canPop1StackFrame(context));
            return true;
        }
        if (cmdId == DEBUG_RESTARTMETHOD_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canPop1StackFrame(context));
            return true;
        }
        if (cmdId == DEBUG_SHOWIP_CMD_ID) {
            this.setActionName(action, DbgArb.getString(37));
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canShowIP());
            return true;
        }
        if (cmdId == DEBUG_GC_CMD_ID) {
            this.setActionName(action, DbgArb.getString(39));
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canGC());
            return true;
        }
        if (cmdId == DEBUG_SUSPEND_ALL_BREAKPOINTS_CMD_ID) {
            this.setActionName(action, DbgArb.getString(41));
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canSuspendBreakpoints());
            return true;
        }
        if (cmdId == VIEW_BREAKPOINTS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == VIEW_THREADS_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_CLASSES_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_STACK_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_SMART_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_LOCALS_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_WATCHES_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_HEAP_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows() && this.canShowHeapWindow());
            return true;
        }
        if (cmdId == VIEW_MONITORS_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows() && this.canShowMonitorsWindow());
            return true;
        }
        if (cmdId == VIEW_LOG_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == NAVIGATOR_STOPLISTENING_CMD_ID) {
            action.setEnabled(this.canStopListening(context));
            return true;
        }
        if (cmdId == NAVIGATOR_DETACHDEBUGGER_CMD_ID) {
            action.setEnabled(this.canDetachDebugger(context));
            return true;
        }
        if (cmdId == DebuggerConstants.TOGGLEBREAKPOINT_CMD_ID) {
            return this.toggleBreakpointFromCodeEditor(context, action);
        }
        if (cmdId == CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID) {
            action.setEnabled(this.toggleWatchpointFromCodeEditor(context, action));
            return true;
        }
        if (cmdId == DebuggerConstants.ENABLEBREAKPOINT_CMD_ID) {
            return this.enableBreakpointFromCodeEditor(context, action);
        }
        if (cmdId == DebuggerConstants.DISABLEBREAKPOINT_CMD_ID) {
            return this.disableBreakpointFromCodeEditor(context, action);
        }
        if (cmdId == DebuggerConstants.EDITBREAKPOINT_CMD_ID) {
            return this.editBreakpointFromCodeEditor(context, action);
        }
        if (cmdId == CODE_EDITOR_WATCH_CMD_ID || cmdId == CODE_EDITOR_INSPECT_CMD_ID) {
            boolean enable;
            boolean bl = enable = this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped();
            if (enable) {
                enable = Source.getCodeEditorFromContext(context) != null;
            }
            action.setEnabled(enable);
            return true;
        }
        if (cmdId == STRUCTURE_CREATEWATCHPOINT_CMD_ID) {
            action.setEnabled(this.createWatchpointFromStructure(context, action));
            return true;
        }
        if (cmdId == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID) {
            action.setEnabled(this.canDoLogWindowAction(context, cmdId));
            return true;
        }
        if (cmdId == 5 || cmdId == 6 || cmdId == 18 || cmdId == 17 || cmdId == 78 || cmdId == 19) {
            action.setEnabled(false);
            return true;
        }
        return false;
    }

    private void setActionName(IdeAction action, String actionName) {
        if (this.activeDebuggingProcess != null) {
            Object[] strs = new String[]{actionName, this.activeDebuggingProcess.getShortLabel()};
            action.setName(DbgArb.format(831, strs));
        } else {
            action.setName(actionName);
        }
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        View view = context.getView();
        if (view instanceof NavigatorWindow) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            if (actionNavigatorStopListening != null) {
                this.update(actionNavigatorStopListening, context);
                if (actionNavigatorStopListening.isEnabled()) {
                    if (menuitemNavigatorStopListening == null) {
                        menuitemNavigatorStopListening = popup.createMenuItem((ToggleAction)actionNavigatorStopListening);
                    }
                    popup.add((Component)menuitemNavigatorStopListening, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
            if (actionNavigatorDetachDebugger != null) {
                this.update(actionNavigatorDetachDebugger, context);
                if (actionNavigatorDetachDebugger.isEnabled()) {
                    if (menuitemNavigatorDetachDebugger == null) {
                        menuitemNavigatorDetachDebugger = popup.createMenuItem((ToggleAction)actionNavigatorDetachDebugger);
                    }
                    popup.add((Component)menuitemNavigatorDetachDebugger, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
        } else if (view instanceof Editor) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            if (actionCodeEditorToggleWatchpoint != null) {
                this.update(actionCodeEditorToggleWatchpoint, context);
                if (actionCodeEditorToggleWatchpoint.isEnabled()) {
                    if (menuitemCodeEditorToggleWatchpoint == null) {
                        menuitemCodeEditorToggleWatchpoint = popup.createMenuItem((ToggleAction)actionCodeEditorToggleWatchpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT);
                    }
                    popup.add((Component)menuitemCodeEditorToggleWatchpoint, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
            if (actionDebugRestartMethod != null) {
                this.update(actionDebugRestartMethod, context);
                if (actionDebugRestartMethod.isEnabled()) {
                    if (menuitemCodeEditorRestartMethod == null) {
                        menuitemCodeEditorRestartMethod = popup.createMenuItem((ToggleAction)actionDebugRestartMethod, JDeveloperMenuConstants.WEIGHT_DEBUG_RESTART_METHOD);
                    }
                    popup.add((Component)menuitemCodeEditorRestartMethod, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
            if (actionDebugRunToCursor != null) {
                this.update(actionDebugRunToCursor, context);
                if (actionDebugRunToCursor.isEnabled()) {
                    if (menuitemCodeEditorRunToCursor == null) {
                        menuitemCodeEditorRunToCursor = popup.createMenuItem((ToggleAction)actionDebugRunToCursor, JDeveloperMenuConstants.WEIGHT_DEBUG_RUN_TO_CURSOR);
                    }
                    popup.add((Component)menuitemCodeEditorRunToCursor, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
            if (actionDebugStepIntoMethod != null) {
                this.update(actionDebugStepIntoMethod, context);
                if (actionDebugStepIntoMethod.isEnabled()) {
                    if (menuitemCodeEditorStepIntoMethod == null) {
                        menuitemCodeEditorStepIntoMethod = popup.createMenuItem((ToggleAction)actionDebugStepIntoMethod, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_INTO_METHOD_AT_CURSOR);
                    }
                    popup.add((Component)menuitemCodeEditorStepIntoMethod, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
            if (actionDebugSetNextStatement != null) {
                this.update(actionDebugSetNextStatement, context);
                if (actionDebugSetNextStatement.isEnabled()) {
                    if (menuitemCodeEditorSetNextStatement == null) {
                        menuitemCodeEditorSetNextStatement = popup.createMenuItem((ToggleAction)actionDebugSetNextStatement, JDeveloperMenuConstants.WEIGHT_DEBUG_SET_NEXT_STATEMENT);
                    }
                    popup.add((Component)menuitemCodeEditorSetNextStatement, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
            if (actionCodeEditorWatch != null) {
                this.update(actionCodeEditorWatch, context);
                if (actionCodeEditorWatch.isEnabled()) {
                    if (menuitemCodeEditorWatch == null) {
                        menuitemCodeEditorWatch = popup.createMenuItem((ToggleAction)actionCodeEditorWatch, JDeveloperMenuConstants.WEIGHT_DEBUG_VIEW_WATCH);
                    }
                    popup.add((Component)menuitemCodeEditorWatch, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
            if (actionCodeEditorInspect != null) {
                this.update(actionCodeEditorInspect, context);
                if (actionCodeEditorInspect.isEnabled()) {
                    if (menuitemCodeEditorInspect == null) {
                        menuitemCodeEditorInspect = popup.createMenuItem((ToggleAction)actionCodeEditorInspect, JDeveloperMenuConstants.WEIGHT_DEBUG_VIEW_INSPECT);
                    }
                    popup.add((Component)menuitemCodeEditorInspect, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
        } else if (!(view instanceof CodeEditorGutterView)) {
            DebuggingProcess connectingDebuggingProcess;
            if (view instanceof ExplorerWindow) {
                if (context.getElement() == null && context.getNode() == null) {
                    return;
                }
                this.update(actionStructureCreateWatchpoint, context);
                if (actionStructureCreateWatchpoint.isEnabled()) {
                    if (menuitemStructureCreateWatchpoint == null) {
                        menuitemStructureCreateWatchpoint = popup.createMenuItem((ToggleAction)actionStructureCreateWatchpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT);
                    }
                    popup.add((Component)menuitemStructureCreateWatchpoint, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            } else if (view instanceof RunLogPage && (connectingDebuggingProcess = this.findDebuggingProcess((RunLogPage)view, true)) != null) {
                this.update(actionLogWindowCancelDebugConnection, context);
                if (actionLogWindowCancelDebugConnection.isEnabled()) {
                    if (menuitemLogWindowCancelDebugConnection == null) {
                        menuitemLogWindowCancelDebugConnection = popup.createMenuItem((ToggleAction)actionLogWindowCancelDebugConnection);
                    }
                    popup.add((Component)menuitemLogWindowCancelDebugConnection, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
        RunnableItem.reset();
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void editorOpened(Editor editor) {
        if (editor instanceof CodeEditor) {
            BasicEditorPane basicEditorPane;
            CodeEditor ceditor = (CodeEditor)editor;
            if (this.isToolTipProvider && (basicEditorPane = ceditor.getFocusedEditorPane()) instanceof IdeEditorPane) {
                ((IdeEditorPane)basicEditorPane).getMultiHoverProvider().registerProvider((HoverProvider)this);
            }
        }
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
        if (editor instanceof CodeEditor) {
            BasicEditorPane basicEditorPane;
            CodeEditor ceditor = (CodeEditor)editor;
            if (this.isToolTipProvider && (basicEditorPane = ceditor.getFocusedEditorPane()) instanceof IdeEditorPane) {
                ((IdeEditorPane)basicEditorPane).getMultiHoverProvider().unregisterProvider((HoverProvider)this);
            }
        }
    }

    void lineClicked(Gutter gutter, int clickedLine, MouseEvent event) {
        CodeEditorGutter codeEditorGutter;
        Context context;
        if (gutter instanceof CodeEditorGutter && (context = (codeEditorGutter = (CodeEditorGutter)gutter).getContext()) != null) {
            this.toggleBreakpoint(context, codeEditorGutter.getCodeEditor(), clickedLine);
        }
    }

    @Deprecated
    public String getToolTipText(CodeEditor codeEditor, MouseEvent mouseEvent, int offset) {
        if (this.shouldProvideToolTip()) {
            if (this.toolTipEvaluator == null) {
                this.toolTipEvaluator = new ToolTipEvaluator(this);
            }
            String toolTip = this.toolTipEvaluator.getToolTip(codeEditor, offset);
            return toolTip;
        }
        return null;
    }

    public void activeViewChanged(ActiveViewEvent e) {
        if (this.activeCodeEditor != null) {
            this.activeCodeEditor.removeCursorListener((CursorListener)this);
        }
        if (this.activeInspector != null) {
            this.activeInspector.inspectorActiveView(false);
        }
        this.activeView = Ide.getMainWindow().getLastActiveView();
        Context context = this.activeView.getContext();
        this.activeCodeEditor = Source.getCodeEditorFromContext(context);
        InspectorWindow inspectorWindow = this.activeInspector = this.activeView instanceof InspectorWindow ? (InspectorWindow)this.activeView : null;
        if (this.activeCodeEditor != null) {
            this.activeCodeEditor.addCursorListener((CursorListener)this);
        }
        if (this.activeInspector != null) {
            this.activeInspector.inspectorActiveView(true);
        }
        this.checkCommandsBecauseActiveViewChanged();
    }

    public void update(final Object observed, final UpdateMessage change) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int messageID = change.getMessageID();
                if (observed == Ide.getSystem()) {
                    if (messageID == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                        JDebugger.this.activeProjectChanged();
                        JDebugger.this.updateActiveBreakpoints();
                    }
                } else if (observed instanceof Workspace) {
                    if (messageID == UpdateMessage.OBJECT_RENAMED) {
                        Breakpoint.breakpointOwnerRenamed((UpdateMessage)change);
                    }
                } else if (observed instanceof Project && messageID == UpdateMessage.OBJECT_RENAMED) {
                    Breakpoint.breakpointOwnerRenamed((UpdateMessage)change);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void cursorUpdate(CodeEditor codeEditor) {
        this.checkCommandsBecauseCursorMoved();
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        int i;
        EditorManager.getEditorManager().removeEditorListener((EditorListener)this);
        if (this.debuggingListeners != null) {
            for (i = this.debuggingListeners.size() - 1; i >= 0; --i) {
                DebuggingListener debuggingListener = this.debuggingListeners.get(i);
                debuggingListener.stopListening();
            }
        }
        if (this.debuggingProcesses != null) {
            for (i = this.debuggingProcesses.size() - 1; i >= 0; --i) {
                DebuggingProcess debuggingProcess = this.debuggingProcesses.get(i);
                debuggingProcess.terminate();
            }
        }
        if (this.objectPreferences != null) {
            this.objectPreferences.saveChangedSettings();
        }
        this.windowManager.shutdownWindows();
    }

    public JMenu getDebugMenu() {
        return runMenu;
    }

    public synchronized ContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new ContextMenu();
        }
        return contextMenu;
    }

    public JMenu getViewMenu() {
        Menubar menubar = Ide.getMenubar();
        if (viewDebuggerSubMenu == null) {
            JMenu viewDebuggerSubMenu = menubar.createSubMenu(DbgArb.getString(45), DbgArb.getInteger(46), JDeveloperMenuConstants.WEIGHT_VIEW_DEBUGGER);
            MenuManager.putJMenu((String)VIEW_DEBUGGER_MENU_ID, (JMenu)viewDebuggerSubMenu);
            JDebugger.viewDebuggerSubMenu = viewDebuggerSubMenu;
        }
        return viewDebuggerSubMenu;
    }

    public boolean isDebugging() {
        if (this.debuggingProcesses != null) {
            return !this.debuggingProcesses.isEmpty();
        }
        return false;
    }

    public void startDebugger(final Context context, final DebuggerStartCallback callBack) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggingProcess pr = new DebuggingProcess(context, callBack);
                JDebugger.this.startProcess(context, pr);
            }
        });
    }

    @Deprecated
    public void redefineClasses(Map compilerMap) {
        this.redefineClasses(null, compilerMap);
    }

    public void redefineClasses(Project project, Map compilerMap) {
        final HashMap nameToGuts = new HashMap();
        nameToGuts.putAll(compilerMap);
        ++this.duringClassRedefinition;
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(final DebuggingProcess debuggingProcess, boolean live) {
                if (live) {
                    debuggingProcess.redefineClasses(nameToGuts);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JDebugger.this.getStackWindow(true).everythingChanged();
                            Breakpoint.updateBreakpointIcons((List[])Breakpoint.getBreakpoints((Workspace)debuggingProcess.getWorkspace(), (Project)debuggingProcess.getProject()));
                            JDebugger.this.updateBreakpointsWindow();
                        }
                    });
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                JDebugger.this.duringClassRedefinition--;
            }
        };
        this.pauseAndInvoke(runWhilePaused, runOnceLater);
    }

    public boolean isStackTraceLine(String line) {
        try {
            int openParen = line.indexOf(40);
            if (openParen != -1) {
                int closeParen;
                int space = line.lastIndexOf(32, openParen);
                int dot = line.lastIndexOf(46, openParen);
                int colon = line.indexOf(58, openParen);
                if (space != -1 && dot != -1 && colon != -1 && dot > space + 1 && colon > openParen + 1 && (closeParen = line.indexOf(41, colon)) != -1 && closeParen > colon + 1) {
                    int lineNumber = Integer.parseInt(line.substring(colon + 1, closeParen));
                    String classname = line.substring(space + 1, dot);
                    String filename = line.substring(openParen + 1, colon);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean showSourceFileForStackTraceLine(Workspace workspace, Project project, String stackTraceLine) {
        try {
            int openParen = stackTraceLine.indexOf(40);
            if (openParen != -1) {
                int closeParen;
                int space = stackTraceLine.lastIndexOf(32, openParen);
                int dot = stackTraceLine.lastIndexOf(46, openParen);
                int colon = stackTraceLine.indexOf(58, openParen);
                if (space != -1 && dot != -1 && colon != -1 && dot > space + 1 && colon > openParen + 1 && (closeParen = stackTraceLine.indexOf(41, colon)) != -1 && closeParen > colon + 1) {
                    int lineNumber = Integer.parseInt(stackTraceLine.substring(colon + 1, closeParen));
                    String classname = stackTraceLine.substring(space + 1, dot);
                    String filename = stackTraceLine.substring(openParen + 1, colon);
                    int lastDot = classname.lastIndexOf(46);
                    String pkg = lastDot != -1 ? classname.substring(0, lastDot) : "";
                    return Source.showSourceFile(workspace, project, pkg, classname, filename, lineNumber, false, null);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public URL parseStackTraceLine(Workspace workspace, Project project, String stackTraceLine) {
        try {
            int openParen = stackTraceLine.indexOf(40);
            if (openParen != -1) {
                int closeParen;
                int space = stackTraceLine.lastIndexOf(32, openParen);
                int dot = stackTraceLine.lastIndexOf(46, openParen);
                int colon = stackTraceLine.indexOf(58, openParen);
                if (space != -1 && dot != -1 && colon != -1 && dot > space + 1 && colon > openParen + 1 && (closeParen = stackTraceLine.indexOf(41, colon)) != -1 && closeParen > colon + 1) {
                    int lineNumber = Integer.parseInt(stackTraceLine.substring(colon + 1, closeParen));
                    String classname = stackTraceLine.substring(space + 1, dot);
                    String filename = stackTraceLine.substring(openParen + 1, colon);
                    int lastDot = classname.lastIndexOf(46);
                    String pkg = lastDot != -1 ? classname.substring(0, lastDot) : "";
                    URL url = Source.findSourceFile(workspace, project, pkg, filename);
                    URL urlWithLine = URLFactory.replaceRefPart((URL)url, (String)Integer.toString(lineNumber));
                    return urlWithLine;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public boolean showSourceFileForStackTraceLine(Workspace workspace, Project project, URL urlWithLine) {
        int lineNumber = 0;
        try {
            String ref = urlWithLine.getRef();
            lineNumber = Integer.parseInt(ref);
        }
        catch (Exception e) {
            // empty catch block
        }
        URL url = URLFactory.replaceRefPart((URL)urlWithLine, null);
        return Source.showSourceFile(workspace, project, url, lineNumber, true);
    }

    public void addRunAndDebugToContextMenu(ContextMenu popup, Context context) {
        DebuggerContextMenuListener.insertRunnableItems((ContextMenu)popup, (Context)context);
        JRunnerContextMenuListener.insertRunnableItems((ContextMenu)popup, (Context)context);
    }

    public WindowProviderCallback addDebuggerWindowProvider(DebuggerWindowProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Need a valid DebuggerWindowProvider argument");
        }
        provider.setDebuggerDockableLayoutPrefix(DEBUGGER_ID);
        DebuggerHook.addDebuggerListener((DebuggerListener)provider);
        return this.windowManager.addDebuggerWindowProvider(provider, true);
    }

    public void addDebuggerWindowProvider(DebuggerWindowProviderDeclarator declarator) {
        if (declarator == null) {
            throw new IllegalArgumentException("Need a valid DebuggerWindowProviderDeclarator argument");
        }
        WindowProviderCallback callback = this.addDebuggerWindowProvider(declarator.getDebuggerWindowProvider());
        declarator.setDebuggerWindowProviderCallback((DebuggerWindowProviderCallback)callback);
    }

    public void removeDebuggerWindowProvider(DebuggerWindowProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Need a valid DebuggerWindowProvider argument");
        }
        DebuggerHook.removeDebuggerListener((DebuggerListener)provider);
        this.windowManager.removeDebuggerWindowProvider(provider);
    }

    public DebuggerExtenderCallback addDebuggerExtender(DebuggerExtender extender) {
        ExtenderCallback callback = this.extenderManager.addExtender(extender);
        extender.breakpointsLoaded();
        return callback;
    }

    public void addDebuggerExtender(DebuggerExtenderDeclarator extenderDeclarator) {
        if (extenderDeclarator == null) {
            throw new IllegalArgumentException("Need a valid DebuggerExtenderDeclarator argument");
        }
        ExtenderCallback callback = this.extenderManager.addExtender(extenderDeclarator);
        if (callback != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JDebugger.this.updateActiveBreakpoints();
                }
            });
        }
    }

    public void addDebuggerExtender(DebuggerExtenderDeclarator extenderDeclarator, List<String> sourceExtensions) {
        if (extenderDeclarator == null) {
            throw new IllegalArgumentException("Need a valid DebuggerExtenderDeclarator argument");
        }
        ExtenderCallback callback = this.extenderManager.addExtender(extenderDeclarator, sourceExtensions);
        if (callback != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JDebugger.this.updateActiveBreakpoints();
                }
            });
        }
    }

    public void removeDebuggerExtender(DebuggerExtender extender) {
        if (extender == null) {
            throw new IllegalArgumentException("Need a valid DebuggerExtender argument");
        }
        DebuggerHook.removeDebuggerListener((DebuggerListener)extender);
        this.extenderManager.removeExtender(extender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BreakpointDetails debuggeeStoppedAtBreakpoint(DebuggingProcess debuggingProcess, DebugBreakpoint dbp) {
        Map<StepIntoLocationKey, Set<MethodRange>> stateForProcess;
        BreakpointDetails details = new BreakpointDetails();
        details.setDebugBreakpoint(dbp);
        Breakpoint bp = this.findBreakpoint(dbp);
        details.setBreakpoint(bp);
        if (bp != null) {
            this.extenderManager.debuggeeStoppedAtBreakpoint(debuggingProcess.getContext(), details);
        }
        if ((stateForProcess = this.processToStepIntoStateMap.get(debuggingProcess)) != null) {
            int stackLevel = debuggingProcess.getVM().getCurrentThread().getStackFrameCount();
            Set<StepIntoLocationKey> locationsWhereStepIntoOuterWasInitiated = stateForProcess.keySet();
            Map<StepIntoLocationKey, Set<MethodRange>> map = stateForProcess;
            synchronized (map) {
                HashSet<StepIntoLocationKey> outOfScopeKeys = new HashSet<StepIntoLocationKey>();
                for (StepIntoLocationKey key : locationsWhereStepIntoOuterWasInitiated) {
                    if (key.depth > stackLevel) {
                        outOfScopeKeys.add(key);
                        continue;
                    }
                    if (key.depth != stackLevel) continue;
                    try {
                        int line = debuggingProcess.getVM().getCurrentStackFrame().getLocation().getLine();
                        if (key.line == line) continue;
                        outOfScopeKeys.add(key);
                    }
                    catch (Exception e) {}
                }
                for (StepIntoLocationKey outOfScopeKey : outOfScopeKeys) {
                    stateForProcess.remove(outOfScopeKey);
                }
            }
        }
        return details;
    }

    public void showConditionalBreakpointResultInHover(DebuggingProcess debuggingProcess, CodeEditor codeEditor, DebugBreakpoint dbp) {
        Context context;
        if (codeEditor == null && (codeEditor = Source.getCodeEditorFromContext(context = debuggingProcess.getContext())) == null) {
            return;
        }
        CodeEditorGutter gutter = codeEditor.getGutter();
        ArrayList marksOnBreakpointLine = new ArrayList();
        Breakpoint bp = this.findBreakpoint(dbp);
        gutter.getMarksOnLine(marksOnBreakpointLine, bp.getLine());
        Rectangle whereToPoint = null;
        for (LineGutterPlugin.Column.Mark mark : marksOnBreakpointLine) {
            SourceIcon gutterIcon;
            Breakpoint b;
            if (!(mark.getUserData() instanceof SourceIcon) || (b = (gutterIcon = (SourceIcon)mark.getUserData()).getBreakpoint()) == null || !b.equals(bp)) continue;
            whereToPoint = gutter.getRolloverRectFor((GutterMark)mark);
            break;
        }
        if (whereToPoint == null) {
            return;
        }
        try {
            BreakpointConditionEvaluationResult result = (BreakpointConditionEvaluationResult)dbp;
            long threadID = debuggingProcess.getVM().getCurrentThread().getThreadId();
            this.conditionalBreakpointPeek = BreakpointConditionHoverBuilder.build((Breakpoint)bp, (JComponent)gutter, (BreakpointConditionEvaluationResult)result, (long)threadID, whereToPoint);
            this.conditionalBreakpointPeek.setRectangle(whereToPoint);
            this.conditionalBreakpointPeek.showPeek();
            Rectangle bounds = this.conditionalBreakpointPeek.getGhostPointingPalette().getBounds();
            Point whereP = SwingUtilities.convertPoint(gutter.getParent(), whereToPoint.getLocation(), this.conditionalBreakpointPeek.getGhostPointingPalette().getParent());
            if (bounds.getWidth() + 25.0 < whereP.getX()) {
                bounds.x = whereP.x - bounds.width - 20;
                bounds.y = whereP.y + whereToPoint.height / 2 - bounds.height / 2;
            }
            this.conditionalBreakpointPeek.getGhostPointingPalette().setLocation(bounds.getLocation());
        }
        catch (Throwable t) {
            Log.error((String)"JDebugger.showBConditionalBreakpointResultInHover unable to get location to anchor hover to");
        }
    }

    boolean canDebuggerExtenderShowBreakpointLocation(Breakpoint bp) {
        DebuggingProcess process = this.activeDebuggingProcess;
        Context context = process != null ? process.getContext() : null;
        return this.extenderManager.canShowBreakpointLocation(context, bp);
    }

    boolean debuggerExtenderShowBreakpointLocation(Breakpoint bp) {
        DebuggingProcess process = this.activeDebuggingProcess;
        Context context = process != null ? process.getContext() : null;
        return this.extenderManager.showBreakpointLocation(context, bp);
    }

    void setDebuggerExtendersEvaluator(DebuggingProcess process, Evaluator evaluator) {
        Breakpoint bp;
        DebugVirtualMachine vm = process.vm;
        if (vm != null && (bp = this.findBreakpoint(vm.getCurrentBreakpoint())) != null && this.extenderManager.isExtenderBreakpoint(bp)) {
            this.extenderManager.setEvaluator(process, bp, evaluator);
            this.checkCommandsBecauseDebuggingProcessStateChanged(process);
        }
    }

    private DebugBreakpoint doSteppingAction(DebuggingProcess process, BreakpointDetails breakpointDetails, ExtenderManager.ExtenderAction action) {
        DebugVirtualMachine vm = process.vm;
        if (vm != null && this.extenderManager.stoppedAtExtenderBreakpoint(breakpointDetails)) {
            DebugBreakpoint dbp;
            Breakpoint tempBreakpoint = null;
            switch (action) {
                case STEP_OVER: {
                    tempBreakpoint = this.extenderManager.stepOver(process, breakpointDetails);
                    break;
                }
                case STEP_INTO: {
                    tempBreakpoint = this.extenderManager.stepInto(process, breakpointDetails);
                    break;
                }
                case STEP_OUT: {
                    tempBreakpoint = this.extenderManager.stepOut(process, breakpointDetails);
                    break;
                }
                case STEP_TO_END_OF_METHOD: {
                    tempBreakpoint = this.extenderManager.stepToEndOfMethod(process, breakpointDetails);
                    break;
                }
                case RUN_TO_CURSOR: {
                    tempBreakpoint = this.extenderManager.runToCursor(process, breakpointDetails);
                }
            }
            if (tempBreakpoint != null && (dbp = BreakpointRuntimeSupport.setBreakpointInVm(tempBreakpoint, process, true)) != null) {
                this.tempBreakpointHasBeenSetInVm(process, tempBreakpoint, dbp);
                return dbp;
            }
        }
        this.clearTempBreakpoint(process);
        return null;
    }

    DebugBreakpoint debuggerExtenderStepOver(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.doSteppingAction(process, breakpointDetails, ExtenderManager.ExtenderAction.STEP_OVER);
    }

    DebugBreakpoint debuggerExtenderStepInto(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.doSteppingAction(process, breakpointDetails, ExtenderManager.ExtenderAction.STEP_INTO);
    }

    DebugBreakpoint debuggerExtenderStepOut(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.doSteppingAction(process, breakpointDetails, ExtenderManager.ExtenderAction.STEP_OUT);
    }

    DebugBreakpoint debuggerExtenderStepToEndOfMethod(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.doSteppingAction(process, breakpointDetails, ExtenderManager.ExtenderAction.STEP_TO_END_OF_METHOD);
    }

    DebugBreakpoint debuggerExtenderRunToCursor(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.doSteppingAction(process, breakpointDetails, ExtenderManager.ExtenderAction.RUN_TO_CURSOR);
    }

    public Object evaluateNumericExpression(String expression) {
        JavaEvaluator evaluator = new JavaEvaluator(new DebugContext(), false);
        Object o = evaluator.evaluate(expression, false);
        if (o instanceof EvaluationInfo) {
            EvaluationInfo eval = (EvaluationInfo)o;
            return eval.getWrappedValue();
        }
        return null;
    }

    synchronized IdeLayout getDebugLayout() {
        if (this.debugLayout == null) {
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            URL url = er.getSystemDirectory("oracle.ide");
            String filename = url.getPath() + "Debugging" + ".layout";
            this.debugLayout = new IdeLayout(URLFactory.newFileURL((String)filename), DbgArb.getString(500), OracleIcons.getIcon((String)"debug.png"));
            this.debugLayout.setProperty(DEBUG_LAYOUT_KEY, Boolean.toString(true));
            Layouts.getLayouts().add((Element)this.debugLayout);
        }
        return this.debugLayout;
    }

    private void makeActions() {
        String category = DbgArb.getString(0);
        SharedActions shared = SharedActions.getInstance();
        this.getActionEmpty();
        this.getActionDebugProject();
        actionDebugToggleBreakpoint = IdeAction.get((int)DebuggerConstants.TOGGLEBREAKPOINT_CMD_ID);
        this.getActionDebugSuspendAllBreakpoints();
        actionDebugReset = shared.getTerminateAction();
        this.getActionDebugStepOver();
        this.getActionDebugStepOverBC();
        this.getActionDebugStepInto();
        this.getActionDebugStepIntoBC();
        this.getActionDebugStepOut();
        this.getActionDebugStepToEndOfMethod();
        actionDebugContinueStep = IdeAction.get((int)DEBUG_CONTINUESTEP_CMD_ID);
        actionDebugRunToCursor = IdeAction.get((int)DEBUG_RUNTOCURSOR_CMD_ID);
        actionDebugStepIntoMethod = IdeAction.get((int)DEBUG_STEPINTOMETHOD_CMD_ID);
        actionDebugSetNextStatement = IdeAction.get((int)DEBUG_POP_1_STACK_FRAME_CMD_ID);
        actionDebugRestartMethod = IdeAction.get((int)DEBUG_RESTARTMETHOD_CMD_ID);
        this.getActionDebugShowIP();
        actionDebugPause = shared.getSuspendAction();
        actionDebugResume = shared.getResumeAction();
        actionDebugDetach = shared.getDetachAction();
        actionDebugReset = shared.getTerminateAction();
        actionDebugGC = shared.getGcAction();
        shared.addController(this);
        actionCodeEditorToggleWatchpoint = IdeAction.find((String)"DebugCodeEditorToggleWatchpointCommand");
        actionCodeEditorWatch = IdeAction.find((int)CODE_EDITOR_WATCH_CMD_ID);
        actionCodeEditorInspect = IdeAction.find((int)CODE_EDITOR_INSPECT_CMD_ID);
        actionStructureCreateWatchpoint = IdeAction.findOrCreate((int)STRUCTURE_CREATEWATCHPOINT_CMD_ID, null, (String)DbgArb.getString(121), (String)category, (Integer)DbgArb.getInteger(122), (Icon)OracleIcons.getIcon((String)"debugger/enabledwatchpoint.gif"), null, (boolean)false);
        actionStructureCreateWatchpoint.addController((Controller)this);
    }

    private IdeAction getActionMruDebug() {
        if (actionMruDebug == null) {
            actionMruDebug = IdeAction.find((String)"DebugMruProjectCommand");
        }
        return actionMruDebug;
    }

    void makeDebuggingListenerActions() {
        if (actionNavigatorStopListening != null) {
            return;
        }
        actionNavigatorStopListening = IdeAction.findOrCreate((int)NAVIGATOR_STOPLISTENING_CMD_ID, null, (String)DbgArb.getString(105), null, (Integer)DbgArb.getInteger(106), null, null, (boolean)false);
        actionNavigatorStopListening.addController((Controller)this);
    }

    private void makeDebuggingProcessActions() {
        if (actionNavigatorDetachDebugger != null) {
            return;
        }
        actionNavigatorDetachDebugger = IdeAction.findOrCreate((int)NAVIGATOR_DETACHDEBUGGER_CMD_ID, null, (String)DbgArb.getString(108), null, (Integer)DbgArb.getInteger(109), null, null, (boolean)false);
        actionNavigatorDetachDebugger.addController((Controller)this);
        actionLogWindowCancelDebugConnection = IdeAction.findOrCreate((int)LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID, null, (String)DbgArb.getString(123), null, (Integer)DbgArb.getInteger(124), (Icon)OracleIcons.getIcon((String)"terminate.png"), null, (boolean)false);
        actionLogWindowCancelDebugConnection.addController((Controller)this);
        actionLogWindowShowIP = actionDebugShowIP.newLocalAction(null);
        actionLogWindowResume = actionDebugResume.newLocalAction(null);
        actionLogWindowStepOver = actionDebugStepOver.newLocalAction(null);
        actionLogWindowStepInto = actionDebugStepInto.newLocalAction(null);
        actionLogWindowStepOut = actionDebugStepOut.newLocalAction(null);
        actionLogWindowStepToEndOfMethod = actionDebugStepToEndOfMethod.newLocalAction(null);
        actionLogWindowStepOverBC = actionDebugStepOverBC.newLocalAction(null);
        actionLogWindowStepIntoBC = actionDebugStepIntoBC.newLocalAction(null);
        actionLogWindowPause = actionDebugPause.newLocalAction(null);
        actionLogWindowGC = actionDebugGC.newLocalAction(null);
        actionLogWindowReset = actionDebugReset.newLocalAction(null);
    }

    static String getExtensionID() {
        return "oracle.jdeveloper.runner";
    }

    private void initializeIDESettings() {
        Preferences preferences = Preferences.getPreferences();
        IdeSettings settings = Ide.getSettings();
        settings.putLegacyData("DebugWindowOptions", (Copyable)DebugWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("BreakpointsWindowOptions", (Copyable)BreakpointsWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("ClassesWindowOptions", (Copyable)ClassesWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("LocalsWindowOptions", (Copyable)LocalsWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("HeapWindowOptions", (Copyable)HeapWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("InspectorWindowOptions", (Copyable)InspectorWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("SmartWindowOptions", (Copyable)SmartWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("StackWindowOptions", (Copyable)StackWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("WatchWindowOptions", (Copyable)WatchWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("ThreadsWindowOptions", (Copyable)ThreadsWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("MonitorsWindowOptions", (Copyable)MonitorsWindowSettings.getInstance((PropertyStorage)preferences));
    }

    private void activeProjectChanged() {
        if (this.activeWorkspace != null) {
            this.activeWorkspace.detach((Observer)this);
        }
        if (this.activeProject != null) {
            this.activeProject.detach((Observer)this);
        }
        this.activeWorkspace = Ide.getActiveWorkspace();
        this.activeProject = Ide.getActiveProject();
        if (this.activeWorkspace != null) {
            this.activeWorkspace.attach((Observer)this);
        }
        if (this.activeProject != null) {
            this.activeProject.attach((Observer)this);
        }
    }

    void updateActiveBreakpoints() {
        Breakpoint.hideAllBreakpointIcons();
        List[] activeBreakpoints = Breakpoint.getBreakpoints((Workspace)this.getActiveWorkspace(), (Project)this.getActiveProject());
        Breakpoint.showBreakpointIcons((List[])activeBreakpoints);
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.setContext(this.getActiveWorkspace(), this.getActiveProject());
        }
    }

    private void debugWindowSettingsChanged() {
        DebuggingProcess debuggingProcess;
        int i;
        this.updateToolTipProvider();
        boolean isShowActionButtonsOnToolbar = this.dbgSettings.isShowActionButtonsOnToolbar();
        if (this.debuggingProcessesConnecting != null) {
            for (i = this.debuggingProcessesConnecting.size() - 1; i >= 0; --i) {
                debuggingProcess = this.debuggingProcessesConnecting.get(i);
                debuggingProcess.showProcessActionButtonsOnToolbar(isShowActionButtonsOnToolbar);
            }
        }
        if (this.debuggingProcesses != null) {
            for (i = this.debuggingProcesses.size() - 1; i >= 0; --i) {
                debuggingProcess = this.debuggingProcesses.get(i);
                debuggingProcess.showProcessActionButtonsOnToolbar(isShowActionButtonsOnToolbar);
            }
        }
        changedCellBackground = this.dbgSettings.getChangedCellBackgroundColor();
        changedCellForeground = this.dbgSettings.getChangedCellForegroundColor();
    }

    void tracingChanged() {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    debuggingProcess.setTracing();
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                JDebugger.this.checkCommandsBecauseTracingChanged();
            }
        };
        this.pauseAndInvoke(runWhilePaused, runOnceLater);
        ClassesWindow classesWindow = this.getClassesWindow(false);
        if (classesWindow != null) {
            classesWindow.tracingChanged();
        }
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        block8: {
            Object source;
            block7: {
                source = e.getSource();
                if (source != runMenu) break block7;
                runMenu.removeMenuListener(this);
                this.buildDebugMenu();
                if (!Product.isRaptor()) break block8;
                Menubar menubar = Ide.getMenubar();
                Component debugProjectMenu = null;
                for (Component menuComponent : runMenu.getMenuComponents()) {
                    if (!(menuComponent instanceof MenuItem) || !DEBUG_PROJECT_CMD_PREFIX.equals(menubar.getId(menuComponent))) continue;
                    debugProjectMenu = menuComponent;
                    break;
                }
                if (debugProjectMenu == null) break block8;
                runMenu.remove(debugProjectMenu);
                break block8;
            }
            if (source == viewMenu) {
                viewMenu.removeMenuListener(this);
                if (Product.isRaptor()) {
                    Menubar menubar = Ide.getMenubar();
                    JMenu debuggerSubMenu = null;
                    String viewDebugMenuText = ExtensionResources.get("DEBUG_VIEW_MENU");
                    viewDebugMenuText = viewDebugMenuText.replace("&", "");
                    for (Component menuComponent : viewMenu.getMenuComponents()) {
                        JMenu menu;
                        if (!(menuComponent instanceof JMenu) || !viewDebugMenuText.equals((menu = (JMenu)menuComponent).getText())) continue;
                        debuggerSubMenu = menu;
                        break;
                    }
                    if (debuggerSubMenu != null) {
                        ArrayList<Component> toBeRemoved = new ArrayList<Component>();
                        for (Component menuComponent : debuggerSubMenu.getMenuComponents()) {
                            String componentId;
                            if (!(menuComponent instanceof MenuItem) || !VIEW_THREADS_CMD_NAME.equals(componentId = menubar.getId(menuComponent)) && !VIEW_CLASSES_CMD_NAME.equals(componentId) && !VIEW_HEAP_CMD_NAME.equals(componentId) && !VIEW_MONITORS_CMD_NAME.equals(componentId)) continue;
                            toBeRemoved.add(menuComponent);
                        }
                        for (Component component : toBeRemoved) {
                            debuggerSubMenu.remove(component);
                        }
                    }
                }
            }
        }
    }

    private void buildDebugMenu() {
        if (!debugMenuBuilt) {
            Context[] context = new Context[]{Ide.getMainWindow().getLastActiveView().getContext()};
            this.updateIfNotVisible(actionDebugToggleBreakpoint, context);
            this.updateIfNotVisible(actionDebugSuspendAllBreakpoints, context);
            this.updateIfNotVisible(actionDebugPause, context);
            this.updateIfNotVisible(actionDebugResume, context);
            this.updateIfNotVisible(actionDebugDetach, context);
            this.updateIfNotVisible(actionDebugStepOver, context);
            this.updateIfNotVisible(actionDebugStepInto, context);
            this.updateIfNotVisible(actionDebugStepOut, context);
            this.updateIfNotVisible(actionDebugStepToEndOfMethod, context);
            this.updateIfNotVisible(actionDebugContinueStep, context);
            this.updateIfNotVisible(actionDebugRunToCursor, context);
            this.updateIfNotVisible(actionDebugStepIntoMethod, context);
            this.updateIfNotVisible(actionDebugSetNextStatement, context);
            this.updateIfNotVisible(actionDebugRestartMethod, context);
            this.updateIfNotVisible(actionDebugShowIP, context);
            this.updateIfNotVisible(actionDebugGC, context);
            debugMenuBuilt = true;
        }
    }

    private void updateDebugProjectAction(final IdeAction action, Context context) {
        String name;
        String currentWSName = null;
        if (context.getWorkspace() != null && (currentWSName = WorkingSets.getInstance((Workspace)context.getWorkspace()).getCurrentWorkingSetName()) == WorkingSets.ALL_FILES_WORKING_SET_LABEL) {
            currentWSName = null;
        }
        boolean isUseCurrentWorkingSet = Runner.getRunner().getRunnerOptions().isRunCurrentWorkingSet() && currentWSName != null;
        Runnable edtRunnable = new Runnable(){

            @Override
            public void run() {
                action.setEnabled(JDebugger.this.canStartProcess(null));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            edtRunnable.run();
        } else {
            SwingUtilities.invokeLater(edtRunnable);
        }
        Project mruProject = JRunner.getMRUProject(context);
        if (mruProject != null && !mruProject.isOpen()) {
            mruProject = null;
        }
        if (mruProject != null) {
            String projectShortLabel = mruProject.getShortLabel();
            name = DbgArb.format(isUseCurrentWorkingSet ? 5 : 4, projectShortLabel);
        } else {
            Project project = context.getProject();
            if (project == null) {
                name = DbgArb.getString(isUseCurrentWorkingSet ? 3 : 2);
                action.setEnabled(JRunner.validateProjectRunnable(context, Ide.getActiveProject()));
            } else {
                name = DbgArb.format(isUseCurrentWorkingSet ? 5 : 4, project.getShortLabel());
                action.setEnabled(JRunner.validateProjectRunnable(context, project));
            }
        }
        try {
            action.putValue("Name", (Object)name);
        }
        catch (ClassCastException cce) {
            try {
                action.putValue("Name", (Object)name);
            }
            catch (ClassCastException anothercce) {
                // empty catch block
            }
        }
    }

    private boolean isActionVisible(IdeAction action) {
        int cmdId = action.getCommandId();
        if (cmdId == DEBUG_STEPOVERBC_CMD_ID || cmdId == DEBUG_STEPINTOBC_CMD_ID) {
            return BytecodeFileSystemHelper.getInstance(false) != null;
        }
        return cmdId == DEBUG_PROJECT_CMD_ID || cmdId == DEBUG_RESUME_CMD_ID || cmdId == DEBUG_STEPOVER_CMD_ID || cmdId == DEBUG_STEPINTO_CMD_ID || cmdId == DEBUG_STEPOUT_CMD_ID || cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID || cmdId == DEBUG_PAUSE_CMD_ID || cmdId == DEBUG_RESET_CMD_ID || cmdId == DEBUG_SHOWIP_CMD_ID || cmdId == DEBUG_GC_CMD_ID || cmdId == DEBUG_SUSPEND_ALL_BREAKPOINTS_CMD_ID || cmdId == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID;
    }

    private void updateIfVisible(IdeAction action, Context[] context) {
        if (action != null && this.isActionVisible(action)) {
            if (context[0] == null) {
                context[0] = Ide.getMainWindow().getLastActiveView().getContext();
            }
            this.update(action, context[0]);
        }
    }

    private void updateIfNotVisible(IdeAction action, Context[] context) {
        if (action != null && !this.isActionVisible(action)) {
            if (context[0] == null) {
                context[0] = Ide.getMainWindow().getLastActiveView().getContext();
            }
            this.update(action, context[0]);
        }
    }

    private void checkCommandsBecauseActiveViewChanged() {
        Context[] context = new Context[1];
        this.updateIfVisible(actionDebugRunToCursor, context);
        this.updateIfVisible(actionDebugStepIntoMethod, context);
        this.updateIfVisible(actionDebugSetNextStatement, context);
        this.updateIfVisible(actionDebugRestartMethod, context);
        this.checkCommandsForTopLogPage();
    }

    private void checkCommandsBecauseCursorMoved() {
        if (this.activeDebuggingProcess != null) {
            Context[] context = new Context[1];
            this.updateIfVisible(actionDebugRunToCursor, context);
            this.updateIfVisible(actionDebugStepIntoMethod, context);
            this.updateIfVisible(actionDebugSetNextStatement, context);
            this.updateIfVisible(actionDebugRestartMethod, context);
        }
    }

    private boolean shouldProvideToolTip() {
        return this.duringClassRedefinition == 0 && this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped() && this.dbgSettings.isShowToolTipInCodeEditor();
    }

    private void updateToolTipProvider() {
        block5: {
            boolean should = this.shouldProvideToolTip();
            if (this.isToolTipProvider == should) break block5;
            this.isToolTipProvider = should;
            CodeEditor[] ceditors = SourceIcon.getOpenCodeEditors();
            if (this.isToolTipProvider) {
                for (int i = ceditors.length - 1; i >= 0; --i) {
                    BasicEditorPane basicEditorPane = ceditors[i].getFocusedEditorPane();
                    if (!(basicEditorPane instanceof IdeEditorPane)) continue;
                    ((IdeEditorPane)basicEditorPane).getMultiHoverProvider().registerProvider((HoverProvider)this);
                }
            } else {
                if (this.toolTipEvaluator != null) {
                    this.toolTipEvaluator.clearEvaluator();
                }
                for (int i = ceditors.length - 1; i >= 0; --i) {
                    BasicEditorPane basicEditorPane = ceditors[i].getFocusedEditorPane();
                    if (!(basicEditorPane instanceof IdeEditorPane)) continue;
                    ((IdeEditorPane)basicEditorPane).getMultiHoverProvider().unregisterProvider((HoverProvider)this);
                }
            }
        }
    }

    private void updateMainDebugCommands() {
        Context[] context = new Context[1];
        this.updateIfVisible(actionDebugPause, context);
        this.updateIfVisible(actionDebugResume, context);
        this.updateIfVisible(actionDebugDetach, context);
        this.updateIfVisible(actionDebugReset, context);
        this.updateIfVisible(actionDebugStepOver, context);
        this.updateIfVisible(actionDebugStepOverBC, context);
        this.updateIfVisible(actionDebugStepInto, context);
        this.updateIfVisible(actionDebugStepIntoBC, context);
        this.updateIfVisible(actionDebugStepOut, context);
        this.updateIfVisible(actionDebugStepToEndOfMethod, context);
        this.updateIfVisible(actionDebugContinueStep, context);
        this.updateIfVisible(actionDebugRunToCursor, context);
        this.updateIfVisible(actionDebugStepIntoMethod, context);
        this.updateIfVisible(actionDebugSetNextStatement, context);
        this.updateIfVisible(actionDebugRestartMethod, context);
        this.updateIfVisible(actionDebugShowIP, context);
        this.updateIfVisible(actionDebugGC, context);
        this.updateIfVisible(actionDebugSuspendAllBreakpoints, context);
    }

    private void checkCommandsBecauseActiveDebuggingProcessChanged() {
        this.updateToolTipProvider();
        this.updateMainDebugCommands();
        this.checkCommandsForTopLogPage();
    }

    void checkCommandsBecauseDebuggingProcessStateChanged(DebuggingProcess debuggingProcess) {
        if (debuggingProcess == this.activeDebuggingProcess) {
            this.updateToolTipProvider();
            this.updateMainDebugCommands();
        }
        this.checkCommandsForTopLogPage();
    }

    private void checkCommandsForTopLogPage() {
        LogPage logPage = LogManager.getIdeLogWindow().getPage();
        if (logPage instanceof RunLogPage) {
            DebuggingProcess debuggingProcess;
            Context[] context = new Context[]{logPage.getLogPageView().getContext()};
            DebuggingProcess connectingDebuggingProcess = this.findDebuggingProcess((RunLogPage)logPage, true);
            if (connectingDebuggingProcess != null) {
                this.updateIfVisible(actionLogWindowCancelDebugConnection, context);
            }
            if ((debuggingProcess = this.findDebuggingProcess((RunLogPage)logPage, false)) != null) {
                this.updateIfVisible(actionLogWindowShowIP, context);
                this.updateIfVisible(actionLogWindowResume, context);
                this.updateIfVisible(actionLogWindowStepOver, context);
                this.updateIfVisible(actionLogWindowStepInto, context);
                this.updateIfVisible(actionLogWindowStepOut, context);
                this.updateIfVisible(actionLogWindowStepToEndOfMethod, context);
                this.updateIfVisible(actionLogWindowStepOverBC, context);
                this.updateIfVisible(actionLogWindowStepIntoBC, context);
                this.updateIfVisible(actionLogWindowPause, context);
                this.updateIfVisible(actionLogWindowGC, context);
                this.updateIfVisible(actionLogWindowReset, context);
            }
        }
    }

    private void checkCommandsBecauseTracingChanged() {
        Context[] context = new Context[1];
        this.updateIfVisible(actionDebugStepOver, context);
        this.updateIfVisible(actionDebugStepOverBC, context);
        this.updateIfVisible(actionDebugStepInto, context);
        this.updateIfVisible(actionDebugStepIntoBC, context);
        this.updateIfVisible(actionDebugStepToEndOfMethod, context);
        this.checkCommandsForTopLogPage();
    }

    private boolean canStartProcess(Context context) {
        Node node;
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null && compiler.isBusy(null)) {
            return false;
        }
        if (context != null && !context.containsProperty(RunProcess.RUN_PROCESS_USE_NODE_FROM_CONTEXT) && (node = RunProcess.getContextNodeForRun((Context)context)) instanceof Project && node == context.getProject()) {
            context = null;
        }
        boolean contextOk = false;
        if (context != null) {
            contextOk = this.isContextNodeRunnable(context);
        } else if (Ide.getActiveProject() != null) {
            contextOk = true;
        } else {
            Context activeContext = new Context(Ide.getMainWindow().getLastActiveView().getContext());
            if (activeContext != null) {
                contextOk = this.isContextNodeRunnable(activeContext);
            }
        }
        return contextOk;
    }

    private boolean isContextNodeRunnable(Context context) {
        Node node = RunProcess.getContextNodeForRun((Context)context);
        return node != null && Runner.getRunner().couldNodeBeRunnable(node, DebuggingProcess.starterFactorySubClass);
    }

    private void startProcess(Context context, boolean updateMruProperties) {
        DebuggingProcess debuggingProcess = this.createDebuggingProcess(context, updateMruProperties);
        this.startProcess(context, debuggingProcess);
    }

    private void startProcess(Context context, DebuggingProcess process) {
        Project project = context == null ? this.getActiveProject() : context.getProject();
        List debuggerWindowProviderDeclarators = DebuggerHook.getDebuggerWindowProviderDeclarators((Project)project);
        for (DebuggerWindowProviderDeclarator declarator : debuggerWindowProviderDeclarators) {
            DebuggerWindowProvider provider = declarator.getDebuggerWindowProvider();
            if (provider == null) continue;
            provider.setDebuggerDockableLayoutPrefix(DEBUGGER_ID);
            if (this.windowManager.hasDebuggerWindowProvider(provider)) continue;
            WindowProviderCallback callback = this.addDebuggerWindowProvider(provider);
            declarator.setDebuggerWindowProviderCallback((DebuggerWindowProviderCallback)callback);
            this.windowManager.installCustomWindow(callback);
        }
        boolean updateBreakpoints = false;
        List debuggerExtenderIds = DebuggerHook.getDebuggerExtenderIds((Project)project);
        for (String id : debuggerExtenderIds) {
            if (this.extenderManager.hasExtender(id) || this.extenderManager.addExtender(id) == null) continue;
            updateBreakpoints = true;
        }
        if (updateBreakpoints) {
            this.updateActiveBreakpoints();
        }
        this.extenderManager.newDebugSession(context);
        process.start();
    }

    private DebuggingProcess createDebuggingProcess(Context context, boolean updateMruProperties) {
        Context context2 = JRunner.prepareProcessContext(context, updateMruProperties);
        DebuggingProcess debuggingProcess = new DebuggingProcess(context2);
        return debuggingProcess;
    }

    private boolean canStopListening(Context context) {
        Element[] selection = context.getSelection();
        if (selection != null && selection.length > 0) {
            for (int i = selection.length - 1; i >= 0; --i) {
                Element element = selection[i];
                if (element instanceof DebuggingListener) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void stopListening(Context context) {
        Element[] selection = context.getSelection();
        if (selection != null && selection.length > 0) {
            for (int i = selection.length - 1; i >= 0; --i) {
                Element element = selection[i];
                if (!(element instanceof DebuggingListener)) continue;
                DebuggingListener debuggingListener = (DebuggingListener)element;
                debuggingListener.stopListening();
            }
        }
    }

    private boolean canDetachDebugger(Context context) {
        Element[] selection = context.getSelection();
        if (selection != null && selection.length > 0) {
            for (int i = selection.length - 1; i >= 0; --i) {
                Element element = selection[i];
                if (element instanceof DebuggingProcess) {
                    DebuggingProcess debuggingProcess = (DebuggingProcess)element;
                    if (debuggingProcess.canDetach()) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void detachDebugger(Context context) {
        Element[] selection = context.getSelection();
        if (selection != null && selection.length > 0) {
            for (int i = selection.length - 1; i >= 0; --i) {
                DebuggingProcess debuggingProcess;
                Element element = selection[i];
                if (!(element instanceof DebuggingProcess) || !(debuggingProcess = (DebuggingProcess)element).canDetach()) continue;
                debuggingProcess.detach();
            }
        }
    }

    DockableWindow getDebuggerWindow(String windowID) {
        if (this.firstDebuggingProcessCreated) {
            return this.windowManager.getDebuggerWindow(windowID);
        }
        return null;
    }

    DockableWindow getOrCreateDebuggerWindow(String windowID) {
        DockableWindow dockableWindow = this.windowManager.getDebuggerWindow(windowID);
        if (dockableWindow != null) {
            return dockableWindow;
        }
        if (windowID.equals("Debugger.BreakpointsWindow")) {
            this.breakpointsWindow = new BreakpointsWindow(this.getActiveWorkspace(), this.getActiveProject());
            this.windowManager.addDebuggerWindowProvider(this.breakpointsWindow, false);
            this.windowManager.installWindow(windowID);
            return this.breakpointsWindow;
        }
        if (windowID.equals("Debugger.ThreadsWindow")) {
            this.threadsWindow = new ThreadsWindow();
            this.windowManager.addDebuggerWindowProvider(this.threadsWindow, false);
            this.windowManager.installWindow(windowID);
            return this.threadsWindow;
        }
        if (windowID.equals("Debugger.StackWindow")) {
            this.stackWindow = new StackWindow();
            this.windowManager.addDebuggerWindowProvider(this.stackWindow, false);
            this.windowManager.installWindow(windowID);
            return this.stackWindow;
        }
        if (windowID.equals("Debugger.LocalsWindow")) {
            this.localsWindow = new LocalsWindow();
            this.windowManager.addDebuggerWindowProvider(this.localsWindow, false);
            this.windowManager.installWindow(windowID);
            return this.localsWindow;
        }
        if (windowID.equals("Debugger.WatchWindow")) {
            this.watchWindow = new WatchWindow();
            this.windowManager.addDebuggerWindowProvider(this.watchWindow, false);
            this.windowManager.installWindow(windowID);
            return this.watchWindow;
        }
        if (windowID.equals("Debugger.SmartWindow")) {
            this.smartWindow = new SmartWindow();
            this.windowManager.addDebuggerWindowProvider(this.smartWindow, false);
            this.windowManager.installWindow(windowID);
            return this.smartWindow;
        }
        if (windowID.equals("Debugger.HeapWindow")) {
            this.heapWindow = new HeapWindow();
            this.windowManager.addDebuggerWindowProvider(this.heapWindow, false);
            this.windowManager.installWindow(windowID);
            return this.heapWindow;
        }
        if (windowID.equals("Debugger.ClassesWindow")) {
            this.classesWindow = new ClassesWindow();
            this.windowManager.addDebuggerWindowProvider(this.classesWindow, false);
            this.windowManager.installWindow(windowID);
            return this.classesWindow;
        }
        if (windowID.equals("Debugger.MonitorsWindow")) {
            this.monitorsWindow = new MonitorsWindow();
            this.windowManager.addDebuggerWindowProvider(this.monitorsWindow, false);
            this.windowManager.installWindow(windowID);
            return this.monitorsWindow;
        }
        if (InspectorWindow.isInspectorWindowId(windowID)) {
            return this.getOrCreateInspectorWindow(windowID);
        }
        return null;
    }

    BreakpointsWindow getBreakpointsWindow(boolean forceCreate) {
        if (this.breakpointsWindow == null && forceCreate) {
            this.breakpointsWindow = (BreakpointsWindow)this.getOrCreateDebuggerWindow("Debugger.BreakpointsWindow");
        }
        return this.breakpointsWindow;
    }

    ThreadsWindow getThreadsWindow(boolean forceCreate) {
        if (this.threadsWindow == null && forceCreate) {
            this.threadsWindow = (ThreadsWindow)this.getOrCreateDebuggerWindow("Debugger.ThreadsWindow");
            if (this.stackWindow != null) {
                this.threadsWindow.updateStackWindow();
            }
        }
        return this.threadsWindow;
    }

    StackWindow getStackWindow(boolean forceCreate) {
        if (this.stackWindow == null && forceCreate) {
            this.stackWindow = (StackWindow)this.getOrCreateDebuggerWindow("Debugger.StackWindow");
            if (this.threadsWindow != null) {
                this.threadsWindow.updateStackWindow();
            }
            this.stackWindow.updateLocalsWindow(false);
            this.stackWindow.updateWatchWindow(false);
        }
        return this.stackWindow;
    }

    SmartWindow getSmartWindow(boolean forceCreate) {
        if (this.smartWindow == null && forceCreate) {
            this.smartWindow = (SmartWindow)this.getOrCreateDebuggerWindow("Debugger.SmartWindow");
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.smartWindowCreated(this.smartWindow);
            }
        }
        return this.smartWindow;
    }

    LocalsWindow getLocalsWindow(boolean forceCreate) {
        if (this.localsWindow == null && forceCreate) {
            this.localsWindow = (LocalsWindow)this.getOrCreateDebuggerWindow("Debugger.LocalsWindow");
            if (this.stackWindow != null) {
                this.stackWindow.updateLocalsWindow(false);
            }
        }
        return this.localsWindow;
    }

    WatchWindow getWatchWindow(boolean forceCreate) {
        if (this.watchWindow == null && forceCreate) {
            this.watchWindow = (WatchWindow)this.getOrCreateDebuggerWindow("Debugger.WatchWindow");
            if (this.stackWindow != null) {
                this.stackWindow.updateWatchWindow(false);
            }
        }
        return this.watchWindow;
    }

    ClassesWindow getClassesWindow(boolean forceCreate) {
        if (this.classesWindow == null && forceCreate) {
            this.classesWindow = (ClassesWindow)this.getOrCreateDebuggerWindow("Debugger.ClassesWindow");
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.classesWindowCreated(this.classesWindow);
            }
        }
        return this.classesWindow;
    }

    HeapWindow getHeapWindow(boolean forceCreate) {
        if (this.heapWindow == null && forceCreate) {
            this.heapWindow = (HeapWindow)this.getOrCreateDebuggerWindow("Debugger.HeapWindow");
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.heapWindowCreated(this.heapWindow);
            }
        }
        return this.heapWindow;
    }

    MonitorsWindow getMonitorsWindow(boolean forceCreate) {
        if (this.monitorsWindow == null && forceCreate) {
            this.monitorsWindow = (MonitorsWindow)this.getOrCreateDebuggerWindow("Debugger.MonitorsWindow");
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.monitorsWindowCreated(this.monitorsWindow);
            }
        }
        return this.monitorsWindow;
    }

    public EvaluatorItem addWatch(Object expression) {
        this.viewWatches();
        this.getWatchWindow(true);
        return this.watchWindow.addWatch(expression);
    }

    public boolean removeWatch(EvaluatorItem ei) {
        this.getWatchWindow(true);
        return this.watchWindow.removeWatch(ei);
    }

    public InspectorWindow inspect(Object expression) {
        String windowId = InspectorWindow.getNewInspectorWindowId();
        InspectorWindow inspectorWindow = this.createInspectorWindow(windowId, expression);
        this.addInspectorWindow(inspectorWindow, true);
        return inspectorWindow;
    }

    private void addInspectorWindow(InspectorWindow inspectorWindow, boolean updateLayout) {
        if (this.inspectorWindows == null) {
            this.inspectorWindows = new ArrayList();
        }
        this.inspectorWindows.add(inspectorWindow);
        this.getStackWindow(true);
        this.stackWindow.newInspectorWindow(inspectorWindow);
        if (updateLayout) {
            this.windowManager.installWindow(inspectorWindow.getId());
        }
    }

    private InspectorWindow createInspectorWindow(String windowID, Object expression) {
        InspectorWindow inspectorWindow = new InspectorWindow(windowID, expression);
        this.windowManager.addDebuggerWindowProvider(inspectorWindow, false);
        return inspectorWindow;
    }

    InspectorWindow getOrCreateInspectorWindow(String windowId) {
        if (this.inspectorWindows != null) {
            for (InspectorWindow inspectorWindow : this.inspectorWindows) {
                if (!windowId.equals(inspectorWindow.getId())) continue;
                return inspectorWindow;
            }
        }
        InspectorWindow inspectorWindow = this.createInspectorWindow(windowId, null);
        this.addInspectorWindow(inspectorWindow, false);
        return inspectorWindow;
    }

    void removeInspectorWindow(InspectorWindow inspectorWindow) {
        if (this.inspectorWindows != null) {
            this.inspectorWindows.remove(inspectorWindow);
            inspectorWindow.removeInspector();
        }
    }

    Iterator getInspectorWindows() {
        if (this.inspectorWindows != null) {
            List clone = (List)((ArrayList)this.inspectorWindows).clone();
            return clone.iterator();
        }
        return new ArrayList().iterator();
    }

    DebuggingProcess[] getDebuggingProcessesForBreakpoint(Breakpoint bp) {
        ArrayList<DebuggingProcess> list = new ArrayList<DebuggingProcess>();
        if (this.debuggingProcesses != null) {
            block0: for (DebuggingProcess debuggingProcess : this.debuggingProcesses) {
                List[] breakpoints = Breakpoint.getBreakpoints((Workspace)debuggingProcess.getWorkspace(), (Project)debuggingProcess.getProject());
                int length = breakpoints.length;
                for (int i = 0; i < length; ++i) {
                    if (!breakpoints[i].contains(bp)) continue;
                    list.add(debuggingProcess);
                    continue block0;
                }
            }
        }
        return list.toArray(new DebuggingProcess[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheNewBreakpoints() {
        Boolean bl = this.cacheNewBreakpoints;
        synchronized (bl) {
            this.cacheNewBreakpoints = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushNewBreakpoints() {
        Boolean bl = this.cacheNewBreakpoints;
        synchronized (bl) {
            this.cacheNewBreakpoints = false;
            if (this.cachedNewBreakpoints != null) {
                for (Breakpoint bp : this.cachedNewBreakpoints) {
                    this.addBreakpoint(bp);
                }
                this.cachedNewBreakpoints = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBreakpoint(Breakpoint bp) {
        if (this.activeDebuggingProcess != null && this.activeDebuggingProcess.getSuspendBreakpoints()) {
            bp.setSuspended(true);
        }
        Boolean bl = this.cacheNewBreakpoints;
        synchronized (bl) {
            if (this.cacheNewBreakpoints.booleanValue()) {
                if (this.cachedNewBreakpoints == null) {
                    this.cachedNewBreakpoints = new ArrayList<Breakpoint>();
                }
                this.cachedNewBreakpoints.add(bp);
                return;
            }
        }
        if (bp != null) {
            if (this.breakpointsWindow != null) {
                this.breakpointsWindow.addNewBreakpoint(bp);
            } else {
                this.addBreakpoint(bp, null);
            }
        }
    }

    void addBreakpoint(Breakpoint bp, Runnable runOnceLater) {
        if (this.activeDebuggingProcess != null && this.activeDebuggingProcess.getSuspendBreakpoints()) {
            bp.setSuspended(true);
        }
        Breakpoint.addBreakpointToOwner((Breakpoint)bp);
        if (this.extenderManager.isExtenderBreakpoint(bp)) {
            this.extenderManager.breakpointAdded(bp);
        }
        boolean inScope = false;
        List[] breakpoints = Breakpoint.getBreakpoints((Workspace)this.getActiveWorkspace(), (Project)this.getActiveProject());
        int length = breakpoints.length;
        for (int i = 0; i < length; ++i) {
            if (!breakpoints[i].contains(bp)) continue;
            inScope = true;
            break;
        }
        if (inScope) {
            bp.showBreakpointIcon();
        } else {
            bp.hideBreakpointIcon();
        }
        BreakpointRuntimeSupport.setBreakpointInVm(bp, runOnceLater);
        if (!this.extenderManager.isExtenderBreakpoint(bp)) {
            String classOrPackage1 = null;
            String classOrPackage2 = null;
            int bpType = bp.getType();
            if (bpType == 0) {
                classOrPackage1 = bp.getPackage();
                String file = bp.getFile();
                int dot = file.indexOf(46);
                if (dot != -1) {
                    file = file.substring(0, dot);
                }
                classOrPackage2 = classOrPackage1 + "." + file;
            } else if (bpType == 1) {
                String method = bp.getMethod();
                int lastDot = method.lastIndexOf(46);
                if (lastDot != -1) {
                    classOrPackage1 = method.substring(0, lastDot);
                }
            } else if (bpType == 7) {
                int iDot;
                int iClass;
                String fqMethodName = bp.getMethod();
                int iSignature = fqMethodName.indexOf("(");
                if (iSignature != -1 && (iClass = fqMethodName.lastIndexOf(" ", iSignature) + 1) != -1 && (iDot = fqMethodName.lastIndexOf(".", iSignature)) != -1) {
                    classOrPackage1 = fqMethodName.substring(iClass, iDot);
                }
            } else if (bpType == 4) {
                classOrPackage1 = bp.getClassName();
            }
            if (!(classOrPackage1 == null && classOrPackage2 == null || this.activeDebuggingProcess != null && !this.activeDebuggingProcess.canSetTracing())) {
                DebugConfiguration debugConfiguration = null;
                if (this.activeDebuggingProcess != null) {
                    debugConfiguration = this.activeDebuggingProcess.getDebugConfiguration();
                } else if (this.getActiveProject() != null) {
                    debugConfiguration = DebugConfiguration.getInstance((PropertyStorage)this.getActiveProject());
                }
                if (debugConfiguration != null) {
                    List tracingIncludeList = debugConfiguration.getTracingIncludeList();
                    List tracingExcludeList = debugConfiguration.getTracingExcludeList();
                    if (classOrPackage1 != null && !DebugShared.isClassOrPackageDebuggable(classOrPackage1, tracingIncludeList, tracingExcludeList) || classOrPackage2 != null && !DebugShared.isClassOrPackageDebuggable(classOrPackage2, tracingIncludeList, tracingExcludeList)) {
                        RunConfiguration runConfiguration = debugConfiguration.getRunConfiguration();
                        String message = DbgArb.format(782, runConfiguration.getName(), DbgArb.getString(14));
                        message = message + DbgArb.getString(783);
                        if (!runConfiguration.isCustom()) {
                            message = message + DbgArb.format(784, runConfiguration.getName());
                        }
                        message = message + DbgArb.getString(785);
                        String title = DbgArb.getString(786);
                        boolean answer = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)title, null);
                        if (answer) {
                            TracingPanel.showTracingDialog(debugConfiguration);
                        }
                    }
                }
            }
        }
    }

    void deleteBreakpoint(Breakpoint bp) {
        if (bp != null) {
            BreakpointMarker marker = (BreakpointMarker)bp.getMarker();
            if (marker != null) {
                try {
                    if (marker.markable() != null) {
                        marker.delete();
                    }
                }
                catch (MarkerException e) {
                    FeedbackManager.reportException((Throwable)e);
                }
            }
            bp.deleteBreakpoint();
            this.updateBreakpointsWindow();
        }
    }

    void updateBreakpointsWindow() {
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.everythingChanged();
        }
    }

    void updateBreakpointsWindowDescription() {
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.breakpointDescriptionChanged();
        }
    }

    void updateBreakpointsWindowStatus(Breakpoint bp) {
        this.extenderManager.breakpointChanged(null, bp);
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.breakpointStatusChanged();
        }
    }

    void updateBreakpointsWindowInstanceFilters() {
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.breakpointInstanceFiltersChanged();
        }
    }

    private Breakpoint findBreakpointByIconLocation(CodeEditor codeEditor, int line, Boolean watchpoint) {
        Breakpoint possible = null;
        URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.getActiveWorkspace(), this.getActiveProject());
        List[] activeBreakpoints = Breakpoint.getBreakpoints((Workspace)this.getActiveWorkspace(), (Project)this.getActiveProject());
        int length = activeBreakpoints.length;
        for (int i = 0; i < length; ++i) {
            for (Breakpoint bp : activeBreakpoints[i]) {
                if (watchpoint != null && (watchpoint == false ? bp.getType() == 6 : bp.getType() != 6) || !bp.matchesIconLocation(codeEditor, line)) continue;
                if (ownerURL == null || URLFileSystem.equals((URL)ownerURL, (URL)bp.getOwnerURL())) {
                    return bp;
                }
                possible = bp;
            }
        }
        return possible;
    }

    public boolean toggleBreakpoint(Context context, Editor editor, int line) {
        return false;
    }

    private void toggleBreakpoint(Context context, CodeEditor codeEditor, int line) {
        String fqNodeClass = context.getNode().getClass().getName();
        boolean handledCompletelyByExtender = false;
        DebuggerBreakpointGutterToggleHandler handler = this.gutterToggleHandlers.get(fqNodeClass);
        if (handler != null) {
            handledCompletelyByExtender = handler.toggleBreakpoint(context, (Editor)codeEditor, line);
        }
        if (handledCompletelyByExtender) {
            this.updateBreakpointsWindow();
        } else {
            Breakpoint bp = this.findBreakpointByIconLocation(codeEditor, line, Boolean.FALSE);
            if (bp != null) {
                bp.deleteBreakpoint();
                this.updateBreakpointsWindow();
            } else {
                int offset = codeEditor.getLineStartOffset(line) + 1;
                this.createBreakpoint(context, line, offset);
            }
        }
    }

    private void createBreakpoint(Context context, int line, int offset) {
        URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.getActiveWorkspace(), this.getActiveProject());
        Node node = context.getNode();
        if (node != null) {
            Breakpoint bp = null;
            if (JDebugger.usePackageFileLine(context, line)) {
                String pkg = Source.getPackageFromNode(node, context.getProject());
                String file = Source.getFilenameFromNode(node);
                if (pkg != null && file != null && file.length() > 0) {
                    bp = new Breakpoint(ownerURL, this.getActiveProject(), 0, node.getURL(), pkg, file, line);
                    BreakpointMarker marker = JDebugger.createAndAttachMarker(node.getURL(), offset, line);
                    bp.setMarker((BreakpointMarkerAPI)marker);
                }
            } else {
                String methodName;
                URL url = node.getURL();
                boolean nodeIsBytecodeDisassembly = false;
                BytecodeFileSystemHelper bytecodeHelper = BytecodeFileSystemHelper.getInstance(false);
                if (bytecodeHelper != null && (methodName = BytecodeFileSystemHelper.getMethodName(url)) != null) {
                    nodeIsBytecodeDisassembly = true;
                    offset = bytecodeHelper.getBytecodeOffsetFromLine(url, line);
                    if (offset != -1) {
                        bp = new Breakpoint(ownerURL, this.getActiveProject(), 7, url, methodName, offset);
                    }
                }
                if (!nodeIsBytecodeDisassembly) {
                    bp = new Breakpoint(ownerURL, this.getActiveProject(), 5, url, line);
                }
            }
            this.addBreakpoint(bp);
        }
    }

    static BreakpointMarker createAndAttachMarker(URL url, int offset, int line) {
        try {
            BreakpointMarker marker = (BreakpointMarker)Marker.Factory.newMarker(BreakpointMarker.class, (Context)new Context());
            if (offset != -1) {
                marker.offset(offset);
            }
            if (line != -1) {
                marker.line(line);
            }
            marker.column(1);
            Markable markable = JDebugger.getMarkableForURL(url);
            if (markable != null) {
                markable.addMarkers(new Marker[]{marker});
            }
            return marker;
        }
        catch (MarkerException e) {
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.error((String)("Breakpoint  " + url + ":" + line + " line number out of range, won't be able to track position updates if file edited"));
            return null;
        }
    }

    private static Markable getMarkableForURL(URL url) {
        Node locatable = null;
        try {
            locatable = NodeFactory.findOrCreate((URL)url);
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        if (locatable == null) {
            return null;
        }
        return Markable.Adapter.adapt((Locatable)locatable);
    }

    Breakpoint findWatchpoint(String className, String fieldName) {
        Breakpoint possible = null;
        URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.getActiveWorkspace(), this.getActiveProject());
        List[] activeBreakpoints = Breakpoint.getBreakpoints((Workspace)this.getActiveWorkspace(), (Project)this.getActiveProject());
        int length = activeBreakpoints.length;
        for (int i = 0; i < length; ++i) {
            for (Breakpoint bp : activeBreakpoints[i]) {
                if (bp.getType() != 6 || !bp.getClassName().equals(className) || !bp.getFieldName().equals(fieldName)) continue;
                if (ownerURL == null || URLFileSystem.equals((URL)ownerURL, (URL)bp.getOwnerURL())) {
                    return bp;
                }
                possible = bp;
            }
        }
        return possible;
    }

    private void createWatchpoint(String className, String fieldName) {
        URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.getActiveWorkspace(), this.getActiveProject());
        this.addBreakpoint(new Breakpoint(ownerURL, this.getActiveProject(), 6, className, fieldName, false, true));
    }

    private void toggleWatchpoint(String className, String fieldName) {
        Breakpoint bp = this.findWatchpoint(className, fieldName);
        if (bp != null) {
            bp.deleteBreakpoint();
            this.updateBreakpointsWindow();
        } else {
            this.createWatchpoint(className, fieldName);
        }
    }

    static URL getNewBreakpointOwnerURL(Workspace workspace, Project project) {
        String bpScope = BreakpointsWindowSettings.getInstance().getBreakpointScope();
        if (bpScope.equals("workspace") && workspace != null && workspace != Ide.getDefaultWorkspace()) {
            return workspace.getURL();
        }
        if (bpScope.equals("project") && project != null && project != Ide.getDefaultProject()) {
            return project.getURL();
        }
        return null;
    }

    static boolean usePackageFileLine(Context context, int line) {
        Iterator<PackageFileLineCheck> packageFileLineChecks = PackageFileLineChecker.getPackageFileLineChecks();
        while (packageFileLineChecks.hasNext()) {
            if (packageFileLineChecks.next().usePackageFileLine(context, line)) continue;
            return false;
        }
        Node node = context.getNode();
        return node instanceof PackagedSource;
    }

    void breakpointHasBeenSetInVm(Breakpoint bp, DebugBreakpoint dbp) {
        if (this.breakpointForDebugBreakpoint == null) {
            this.breakpointForDebugBreakpoint = new HashMap<DebugBreakpoint, Breakpoint>();
            this.breakpointForDebugBreakpoint = Collections.synchronizedMap(this.breakpointForDebugBreakpoint);
        }
        this.breakpointForDebugBreakpoint.put(dbp, bp);
    }

    private void tempBreakpointHasBeenSetInVm(DebuggingProcess process, Breakpoint bp, DebugBreakpoint dbp) {
        this.breakpointHasBeenSetInVm(bp, dbp);
        this.clearTempBreakpoint(process);
        if (this.temporaryBreakpoints == null) {
            this.temporaryBreakpoints = new HashMap<DebuggingProcess, DebugBreakpoint>();
        }
        this.temporaryBreakpoints.put(process, dbp);
        this.extenderManager.temporaryBreakpointSet(process.getContext(), bp);
    }

    void clearTempBreakpoint(DebuggingProcess process) {
        DebugBreakpoint dbp;
        if (this.temporaryBreakpoints != null && (dbp = this.temporaryBreakpoints.remove(process)) != null) {
            Breakpoint bp = this.breakpointForDebugBreakpoint.get(dbp);
            if (bp != null) {
                this.breakpointHasBeenDeleted(bp);
            }
            this.breakpointHasBeenRemovedFromVm(dbp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBreakpointsInVm(DebuggingProcess process, boolean includePersistentBps) {
        this.cacheNewBreakpoints();
        try {
            BreakpointRuntimeSupport.setBreakpointsInVm(process, includePersistentBps);
            this.updateBreakpointsWindow();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.flushNewBreakpoints();
        }
    }

    void removeBreakpointsFromVm(DebuggingProcess process) {
        BreakpointRuntimeSupport.removeBreakpointsFromVm(process);
        this.updateBreakpointsWindow();
    }

    void breakpointHasBeenRemovedFromVm(DebugBreakpoint dbp) {
        Assert.check((this.breakpointForDebugBreakpoint != null ? 1 : 0) != 0);
        this.breakpointForDebugBreakpoint.remove(dbp);
    }

    void breakpointHasBeenDeleted(Breakpoint bp) {
        this.extenderManager.breakpointDeleted(bp);
    }

    void breakpointHasBeenMoved(Breakpoint bp) {
        this.extenderManager.breakpointMoved(bp);
        this.updateBreakpointsWindow();
    }

    void breakpointHasBeenRefactored(Breakpoint bp) {
        this.extenderManager.breakpointRefactored(bp);
        this.updateBreakpointsWindow();
    }

    Breakpoint findBreakpoint(DebugBreakpoint dbp) {
        if (dbp == null) {
            return null;
        }
        if (this.breakpointForDebugBreakpoint != null) {
            return this.breakpointForDebugBreakpoint.get(dbp);
        }
        return null;
    }

    void breakpointChanged(DebuggingProcess debuggingProcess, DebugBreakpoint dbp) {
        Breakpoint bp = this.findBreakpoint(dbp);
        if (bp != null) {
            BreakpointRuntimeSupport.changed(bp, debuggingProcess);
            this.updateBreakpointsWindow();
            this.extenderManager.breakpointChanged(debuggingProcess, bp);
        }
    }

    void viewBreakpoints() {
        DockUtil.showDockableWindow((DockableView)this.getBreakpointsWindow(true));
    }

    void viewWatches() {
        this.safelyShowDockable(this.getWatchWindow(true));
    }

    void viewHeap() {
        this.safelyShowDockable(this.getHeapWindow(true));
    }

    void viewMonitors() {
        this.safelyShowDockable(this.getMonitorsWindow(true));
    }

    private void viewLog() {
        LogPage logPage;
        DebuggingProcess process = this.activeDebuggingProcess;
        if (process != null && (logPage = process.getLogPage()) instanceof RunLogPage) {
            ((RunLogPage)logPage).show();
        }
    }

    void listenerStarted(DebuggingListener debuggingListener) {
        if (this.debuggingListeners == null) {
            this.debuggingListeners = new ArrayList<DebuggingListener>();
        }
        this.debuggingListeners.add(debuggingListener);
    }

    void listenerStopped(DebuggingListener debuggingListener) {
        Assert.check((this.debuggingListeners != null ? 1 : 0) != 0);
        this.debuggingListeners.remove(debuggingListener);
    }

    synchronized void debuggingProcessCreated() {
        if (!this.firstDebuggingProcessCreated) {
            this.firstDebuggingProcessCreated = true;
            this.makeDebuggingProcessActions();
        }
        this.windowManager.installCustomWindows();
    }

    void debuggingProcessBeforeConnecting(DebuggingProcess debuggingProcess) {
        if (this.debuggingProcessesConnecting == null) {
            this.debuggingProcessesConnecting = new ArrayList<DebuggingProcess>();
        }
        this.debuggingProcessesConnecting.add(debuggingProcess);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowCancelDebugConnection);
        this.checkCommandsForTopLogPage();
    }

    void debuggingProcessAfterConnecting(DebuggingProcess debuggingProcess) {
        if (this.debuggingProcessesConnecting != null) {
            this.debuggingProcessesConnecting.remove(debuggingProcess);
        }
    }

    void debuggingProcessStarted(DebuggingProcess debuggingProcess) {
        if (this.debuggingProcesses == null) {
            this.debuggingProcesses = new ArrayList<DebuggingProcess>();
        }
        if (this.debuggingProcesses.isEmpty()) {
            this.showActionButtonsOnMainToolbar(true);
        }
        this.debuggingProcesses.add(debuggingProcess);
        SharedActions.getInstance().processStarted(debuggingProcess);
        this.addNormalButtons(debuggingProcess);
        debuggingProcess.showProcessActionButtonsOnToolbar(this.dbgSettings.isShowActionButtonsOnToolbar());
        this.checkCommandsForTopLogPage();
        this.getThreadsWindow(true).getGUI();
        this.getStackWindow(true).getGUI();
    }

    private void addNormalButtons(DebuggingProcess debuggingProcess) {
        JComponent terminateButton = TerminateRunProcessButtons.getTerminateRunProcessButton((RunProcess)debuggingProcess, (IdeAction)actionLogWindowReset);
        debuggingProcess.addProcessActionButtonToToolbar(terminateButton);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowShowIP);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowStepOver);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowStepInto);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowStepOut);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowStepToEndOfMethod);
        debuggingProcess.addByteCodeActionButtonToToolbar(actionLogWindowStepOverBC);
        debuggingProcess.addByteCodeActionButtonToToolbar(actionLogWindowStepIntoBC);
        if (BytecodeFileSystemHelper.getInstance(false) != null) {
            debuggingProcess.enableByteCodeButtonsOnToolbar();
        }
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowResume);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowPause);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowGC);
        debuggingProcess.addProcessActionButtonToToolbar(actionDebugSuspendAllBreakpoints);
    }

    void addStepBytecodeActions() {
        if (this.debuggingProcesses != null) {
            for (DebuggingProcess debuggingProcess : this.debuggingProcesses) {
                debuggingProcess.enableByteCodeButtonsOnToolbar();
                debuggingProcess.showProcessActionButtonsOnToolbar(this.dbgSettings.isShowActionButtonsOnToolbar());
            }
            this.showByteCodeActionButtonsOnMainToolbar(true);
            Context[] context = new Context[1];
            this.updateIfVisible(actionDebugStepOverBC, context);
            this.updateIfVisible(actionDebugStepIntoBC, context);
            LogPage logPage = LogManager.getIdeLogWindow().getPage();
            if (logPage instanceof RunLogPage) {
                context[0] = logPage.getLogPageView().getContext();
                this.updateIfVisible(actionLogWindowStepOverBC, context);
                this.updateIfVisible(actionLogWindowStepIntoBC, context);
            }
        }
    }

    void pauseAndInvoke(RunWhilePaused runWhilePaused, Runnable runOnceLater) {
        DebuggingProcess[] processes = this.debuggingProcesses != null ? this.debuggingProcesses.toArray(new DebuggingProcess[this.debuggingProcesses.size()]) : new DebuggingProcess[]{};
        JDebugger.pauseAndInvoke(processes, runWhilePaused, runOnceLater);
    }

    static void pauseAndInvoke(DebuggingProcess[] processes, final RunWhilePaused runWhilePaused, final Runnable runOnceLater) {
        int length = processes.length;
        if (length > 0) {
            final int[] countDown = new int[]{length};
            RunWhilePaused wrapper = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    if (debuggingProcess != null && live) {
                        runWhilePaused.run(debuggingProcess, live);
                    }
                    countDown[0] = countDown[0] - 1;
                    if (countDown[0] == 0 && runOnceLater != null) {
                        SwingUtilities.invokeLater(runOnceLater);
                    }
                }
            };
            for (int i = 0; i < length; ++i) {
                processes[i].runWhilePaused(wrapper);
            }
        } else if (runOnceLater != null) {
            SwingUtilities.invokeLater(runOnceLater);
        }
    }

    DebuggingProcess findDebuggingProcess(DebugVirtualMachine vm) {
        if (this.debuggingProcesses != null) {
            for (DebuggingProcess debuggingProcess : this.debuggingProcesses) {
                if (debuggingProcess.getVM() != vm) continue;
                return debuggingProcess;
            }
        }
        return null;
    }

    DebuggingProcess findDebuggingProcess(RunLogPage runLogPage, boolean connecting) {
        List<DebuggingProcess> list;
        List<DebuggingProcess> list2 = list = connecting ? this.debuggingProcessesConnecting : this.debuggingProcesses;
        if (list != null) {
            for (DebuggingProcess debuggingProcess : list) {
                if (debuggingProcess.getLogPage() != runLogPage) continue;
                return debuggingProcess;
            }
        }
        return null;
    }

    synchronized void processSelected(DebuggingProcess debuggingProcess) {
        this.activeDebuggingProcess = debuggingProcess;
        if (this.activeDebuggingProcess == null) {
            actionDebugSuspendAllBreakpoints.setState(false);
            if (suspendAllBreakpointsToolbarButton != null) {
                suspendAllBreakpointsToolbarButton.setSelected(false);
            }
        }
        Workspace workspace = debuggingProcess.getWorkspace();
        Project project = debuggingProcess.getProject();
        List[] breakpoints = Breakpoint.getBreakpoints((Workspace)workspace, (Project)project);
        Breakpoint.updateBreakpointIcons((List[])breakpoints);
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.processSelectionChanged();
        }
        this.checkCommandsBecauseActiveDebuggingProcessChanged();
        this.windowManager.setDebuggerWindowProvidersContext(debuggingProcess.getContext());
        this.toolTipExpressionProviders = DebuggerHook.getToolTipExpressionProviders((Project)project);
        this.smartDataProviders = DebuggerHook.getSmartDataProviders((Project)project);
        this.inspectorExpressionProviders = DebuggerHook.getInspectorExpressionProviders((Project)project);
        this.gutterToggleHandlers = DebuggerHook.getBreakpointGutterToggleHandlers((Project)project);
        this.gutterToggleHandlers.put("oracle.jdeveloper.model.JavaSourceNode", this);
    }

    synchronized void processUnselected(DebuggingProcess debuggingProcess) {
        this.activeDebuggingProcess = null;
        SourceIcon.removeColumn((int)2);
        Container popupMenu = contextMenu.getGUI(false);
        if (popupMenu != null && popupMenu.isVisible()) {
            popupMenu.setVisible(false);
        }
        Workspace workspace = debuggingProcess.getWorkspace();
        Project project = debuggingProcess.getProject();
        List[] breakpoints = Breakpoint.getBreakpoints((Workspace)workspace, (Project)project);
        Breakpoint.updateBreakpointIcons((List[])breakpoints);
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.processSelectionChanged();
        }
        this.checkCommandsBecauseActiveDebuggingProcessChanged();
        this.toolTipExpressionProviders = Collections.emptyList();
        this.smartDataProviders = Collections.emptyList();
        this.inspectorExpressionProviders = Collections.emptyList();
        this.gutterToggleHandlers = Collections.emptyMap();
    }

    void debuggingProcessFinished(DebuggingProcess debuggingProcess) {
        if (this.activeDebuggingProcess == debuggingProcess) {
            this.activeDebuggingProcess = null;
            SourceIcon.removeColumn((int)2);
            if (suspendAllBreakpointsToolbarButton != null) {
                suspendAllBreakpointsToolbarButton.setSelected(false);
            }
            if (this.conditionalBreakpointPeek != null && this.conditionalBreakpointPeek.isShowing()) {
                this.conditionalBreakpointPeek.hidePeek();
                this.conditionalBreakpointPeek = null;
            }
        }
        if (this.debuggingProcesses != null) {
            this.debuggingProcesses.remove(debuggingProcess);
            if (this.debuggingProcesses.isEmpty()) {
                this.showActionButtonsOnMainToolbar(false);
            }
        }
        if (this.threadsWindow != null) {
            this.threadsWindow.processFinished(debuggingProcess);
        }
        if (this.smartWindow != null) {
            this.smartWindow.processFinished(debuggingProcess);
        }
        if (this.classesWindow != null) {
            this.classesWindow.processFinished(debuggingProcess);
        }
        if (this.heapWindow != null) {
            this.heapWindow.processFinished(debuggingProcess);
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.processFinished(debuggingProcess);
        }
        logger.trace("---- debuggingProcessFinished(), state cleared in JDebugger ----");
        this.processToStepIntoStateMap.remove(debuggingProcess);
        if (this.textTabberForStepIntoMethods != null) {
            this.textTabberForStepIntoMethods.setActive(false);
        }
        this.escapedFromTextTabber = false;
        this.clearExecutionPointOffsetMark(debuggingProcess.getContext());
    }

    boolean isActiveDebuggingProcess(DebuggingProcess debuggingProcess) {
        if (this.activeDebuggingProcess != null) {
            return this.activeDebuggingProcess.equals(debuggingProcess);
        }
        return false;
    }

    DebuggingProcess getActiveDebuggingProcess() {
        return this.activeDebuggingProcess;
    }

    boolean canShowDebuggingWindows() {
        return this.activeDebuggingProcess != null;
    }

    static boolean isDebuggingLayout(Layout layout) {
        String debugLayoutProperty = layout.getProperty(DEBUG_LAYOUT_KEY, Boolean.toString(false));
        return Boolean.toString(true).equals(debugLayoutProperty);
    }

    boolean canShowDebuggingWindows(Layout layout) {
        return this.canShowDebuggingWindows() && JDebugger.isDebuggingLayout(layout);
    }

    boolean canShowHeapWindow() {
        if (this.activeDebuggingProcess != null) {
            try {
                DebugVirtualMachine vm = this.activeDebuggingProcess.getVM();
                if (vm != null) {
                    return vm.getCapabilities().canGetHeap();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    boolean canShowMonitorsWindow() {
        if (this.activeDebuggingProcess != null) {
            Callable<Boolean> callableTask = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    DebugVirtualMachine vm = JDebugger.this.activeDebuggingProcess.getVM();
                    if (vm != null) {
                        return vm.getCapabilities().canGetMonitors();
                    }
                    return Boolean.FALSE;
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                ExecutorService service = Executors.newSingleThreadExecutor();
                Future<Boolean> task = service.submit(callableTask);
                try {
                    return task.get();
                }
                catch (InterruptedException e) {
                    return false;
                }
                catch (ExecutionException e) {
                    return false;
                }
            }
            try {
                return (Boolean)callableTask.call();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private Breakpoint getBreakpointFromGutterMarkRightClick(Context context) {
        Object o;
        GutterMark gutterMark;
        if (context.getView() instanceof CodeEditorGutterView && (gutterMark = CodeEditorGutter.getMarkForContext((Context)context)) != null && (o = gutterMark.getUserData()) instanceof SourceIcon) {
            SourceIcon sourceIcon = (SourceIcon)o;
            Breakpoint bp = sourceIcon.getBreakpoint();
            return bp;
        }
        return null;
    }

    private boolean toggleBreakpointFromCodeEditor(Context context, IdeAction action) {
        int editorLine;
        Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
        if (bp != null && bp.getType() != 6) {
            if (action != null) {
                action.setEnabled(true);
            } else {
                bp.deleteBreakpoint();
                this.updateBreakpointsWindow();
            }
            return true;
        }
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorLine = Source.getLineFromCodeEditor(context)) != 0) {
            if (action != null) {
                action.setEnabled(true);
            } else {
                this.toggleBreakpoint(context, codeEditor, editorLine);
            }
            return true;
        }
        if (action != null) {
            action.setEnabled(false);
        }
        return false;
    }

    private boolean toggleWatchpointFromCodeEditor(Context context, IdeAction action) {
        Node editorNode;
        Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
        if (bp != null && bp.getType() == 6) {
            if (action == null) {
                bp.deleteBreakpoint();
                this.updateBreakpointsWindow();
            }
            return true;
        }
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorNode = Source.getNodeFromCodeEditor(context)) instanceof JavaSourceNode) {
            JavaManager javaManager;
            SourceFile sourceFile;
            int editorOffset = 0;
            if (context.getView() instanceof CodeEditorGutterView) {
                int line = Source.getLineFromCodeEditor(context);
                if (line == 0) {
                    return false;
                }
                editorOffset = JDebugger.getLineStartOffsetSkipWhite(codeEditor, line);
            } else {
                editorOffset = codeEditor.getCaretPosition();
                if (codeEditor.getSelectedText() != null) {
                    --editorOffset;
                }
            }
            Project project = context.getProject();
            if (project != null && (sourceFile = (javaManager = JavaManager.getJavaManager((Project)project)).getSourceFile(editorNode.getURL())) != null) {
                SourceElement sourceElement = sourceFile.getElementAt(editorOffset);
                SourceFieldVariable sourceFieldVariable = null;
                if (sourceElement instanceof SourceName) {
                    Iterator itVariables;
                    if ((sourceElement = sourceElement.getParent()) instanceof SourceFieldVariable) {
                        sourceFieldVariable = (SourceFieldVariable)sourceElement;
                    } else if (sourceElement instanceof SourceTypeReference && (sourceElement = sourceElement.getParent()) instanceof SourceFieldDeclaration && (itVariables = ((SourceFieldDeclaration)sourceElement).getVariables().iterator()).hasNext()) {
                        sourceFieldVariable = (SourceFieldVariable)itVariables.next();
                    }
                }
                if (sourceFieldVariable != null) {
                    SourcePackage sourcePackage;
                    SourceClass sourceClass = sourceFieldVariable.getEnclosingClass();
                    String innerClassNames = "";
                    SourceClass parentClass = sourceClass.getEnclosingClass();
                    while (parentClass != null) {
                        innerClassNames = "$" + sourceClass.getName() + innerClassNames;
                        sourceClass = parentClass;
                        parentClass = sourceClass.getEnclosingClass();
                    }
                    String className = sourceClass.getName() + innerClassNames;
                    String fieldName = sourceFieldVariable.getName();
                    if (className.indexOf(".") == -1 && (sourcePackage = sourceFile.getSourcePackage()) != null) {
                        className = sourcePackage.getName() + "." + className;
                    }
                    if (action == null) {
                        this.toggleWatchpoint(className, fieldName);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean enableBreakpointFromCodeEditor(Context context, IdeAction action) {
        int editorLine;
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorLine = Source.getLineFromCodeEditor(context)) != 0) {
            Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
            if (bp == null) {
                bp = this.findBreakpointByIconLocation(codeEditor, editorLine, null);
            }
            if (bp != null && !bp.isRuntimeEnabled()) {
                if (action != null) {
                    if (bp.getType() == 6) {
                        action.putValue("Name", (Object)DbgArb.getString(112));
                    } else {
                        action.putValue("Name", (Object)DbgArb.getString(111));
                    }
                    action.setEnabled(true);
                } else {
                    bp.setEnabled(true);
                }
                return true;
            }
        }
        if (action != null) {
            action.setEnabled(false);
        }
        return false;
    }

    private boolean disableBreakpointFromCodeEditor(Context context, IdeAction action) {
        int editorLine;
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorLine = Source.getLineFromCodeEditor(context)) != 0) {
            Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
            if (bp == null) {
                bp = this.findBreakpointByIconLocation(codeEditor, editorLine, null);
            }
            if (bp != null && bp.isRuntimeEnabled()) {
                if (action != null) {
                    if (bp.getType() == 6) {
                        action.putValue("Name", (Object)DbgArb.getString(114));
                    } else {
                        action.putValue("Name", (Object)DbgArb.getString(113));
                    }
                    action.setEnabled(true);
                } else {
                    bp.setEnabled(false);
                }
                return true;
            }
        }
        if (action != null) {
            action.setEnabled(false);
        }
        return false;
    }

    private boolean editBreakpointFromCodeEditor(Context context, IdeAction action) {
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null) {
            int editorLine;
            Breakpoint bp = (Breakpoint)context.getProperty("Breakpoint");
            if (bp == null && (editorLine = Source.getLineFromCodeEditor(context)) != 0 && (bp = this.getBreakpointFromGutterMarkRightClick(context)) == null) {
                bp = this.findBreakpointByIconLocation(codeEditor, editorLine, null);
            }
            if (bp != null) {
                if (action != null) {
                    if (bp.getType() == 6) {
                        action.putValue("Name", (Object)DbgArb.getString(116));
                    } else {
                        action.putValue("Name", (Object)DbgArb.getString(115));
                    }
                    action.setEnabled(true);
                } else {
                    this.getBreakpointsWindow(true).editBreakpoint(bp);
                }
                return true;
            }
        }
        if (action != null) {
            action.setEnabled(false);
        }
        return false;
    }

    String getMethodFromCodeEditor() {
        CodeEditor editor = null;
        if (this.activeCodeEditor != null) {
            editor = this.activeCodeEditor;
        } else {
            for (View v : Ide.getMainWindow().getVisibleViews()) {
                if (!(v instanceof CodeEditor)) continue;
                editor = (CodeEditor)v;
            }
        }
        if (editor == null) {
            return null;
        }
        Context editorContext = editor.getContext();
        JavaManager javaManager = JavaManager.getAnyInstance((Project)this.getActiveProject());
        Node editorNode = Source.getNodeFromCodeEditor(editorContext);
        if (editorNode == null) {
            return null;
        }
        SourceFile sourceFile = javaManager.getSourceFile(editorNode.getURL());
        SourceElement element = null;
        if (sourceFile != null) {
            element = sourceFile.getElementAt(editor.getCaretPosition());
        }
        while (element != null) {
            if (element instanceof SourceMethodCallExpression) {
                SourceMethodCallExpression exp = (SourceMethodCallExpression)element;
                StringBuffer methodName = this.getPackageAndClassFromElement(element);
                if (methodName == null) {
                    return null;
                }
                methodName.append(exp.getName());
                return methodName.toString();
            }
            if (element instanceof SourceNewClassExpression) {
                SourceNewClassExpression exp = (SourceNewClassExpression)element;
                StringBuffer methodName = this.getPackageAndClassFromElement(element);
                if (methodName == null) {
                    return null;
                }
                methodName.append(exp.getResolvedMethod().getName());
                return methodName.toString();
            }
            if (element instanceof MethodSym) {
                MethodSym exp = (MethodSym)element;
                StringBuffer methodName = this.getPackageAndClassFromElement(element);
                if (methodName == null) {
                    return null;
                }
                methodName.append(exp.getName());
                return methodName.toString();
            }
            element = element.getParent();
        }
        return null;
    }

    private StringBuffer getPackageAndClassFromElement(SourceElement element) {
        JavaElement resolvedElement = element.getCompiledObject();
        if (resolvedElement == null) {
            return null;
        }
        JavaFile file = resolvedElement.getFile();
        String packageName = file.getPackageName();
        StringBuffer methodName = new StringBuffer();
        if (packageName != null && packageName.length() > 0) {
            methodName.append(packageName);
            methodName.append(".");
        }
        JavaElement classElement = resolvedElement;
        while (!(classElement instanceof JavaClass)) {
            classElement = classElement.getOwner();
        }
        methodName.append(((JavaClass)classElement).getName());
        methodName.append(".");
        return methodName;
    }

    boolean editBreakpoint(Breakpoint bp) {
        return this.getBreakpointsWindow(true).editBreakpoint(bp);
    }

    public static boolean eeditBreakpoint(Breakpoint bp) {
        return JDebugger.getInstance().editBreakpoint(bp);
    }

    private boolean createWatchpointFromStructure(Context context, IdeAction action) {
        Element element = context.getElement();
        if (element == null) {
            return false;
        }
        Class<?> elementClass = element.getClass();
        if (elementClass != null && elementClass.getName().endsWith("FieldElement")) {
            try {
                String fieldName;
                Breakpoint bp;
                Method getEnclosingClass = elementClass.getMethod("getEnclosingClass", new Class[0]);
                if (getEnclosingClass == null) {
                    return false;
                }
                Object classElement = getEnclosingClass.invoke((Object)element, new Object[0]);
                if (classElement == null) {
                    return false;
                }
                Class<?> classElementClass = classElement.getClass();
                Method getSymbolName = classElementClass.getMethod("getSymbolName", new Class[0]);
                if (getSymbolName == null) {
                    return false;
                }
                String className = (String)getSymbolName.invoke(classElement, new Object[0]);
                if (className == null) {
                    return false;
                }
                if (className.indexOf(".") == -1) {
                    Method getPackageName = classElementClass.getMethod("getPackageName", new Class[0]);
                    if (getPackageName == null) {
                        return false;
                    }
                    String pkg = (String)getPackageName.invoke(classElement, new Object[0]);
                    if (pkg != null && pkg.length() > 0) {
                        className = pkg + "." + className;
                    }
                }
                if ((bp = this.findWatchpoint(className, fieldName = (String)getSymbolName.invoke((Object)element, new Object[0]))) == null) {
                    if (action == null) {
                        this.createWatchpoint(className, fieldName);
                    }
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    static String trimExpression(String expression) {
        StringBuffer buffer = new StringBuffer();
        String[] parts = expression.split("[\r\n]");
        for (int i = 0; i < parts.length; ++i) {
            buffer.append(parts[i].trim());
        }
        return buffer.toString();
    }

    private void watchFromCodeEditor(Context context) {
        if (this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped()) {
            CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
            if (codeEditor == null) {
                return;
            }
            String expression = codeEditor.getSelectedText();
            if (expression != null && (expression = JDebugger.trimExpression(expression)).length() > 0) {
                this.addWatch(expression);
                this.viewWatches();
                return;
            }
            Set<ExpressionProvider.ExpressionWithMetaData> expressions = ExpressionProvider.getInspectorExpressions(codeEditor, codeEditor.getCaretPosition());
            if (expressions.size() > 0) {
                expression = expressions.iterator().next().getExpression();
            }
            if (expression == null) {
                expression = "";
            }
            this.getWatchWindow(true);
            if (this.watchWindow.addWatchDialog(expression)) {
                this.viewWatches();
            }
        }
    }

    private void inspectFromCodeEditor(Context context) {
        if (this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped()) {
            CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
            if (codeEditor == null) {
                return;
            }
            String expression = codeEditor.getSelectedText();
            if (expression != null && (expression = JDebugger.trimExpression(expression)).length() > 0) {
                this.inspect(expression);
                return;
            }
            Set<ExpressionProvider.ExpressionWithMetaData> expressions = ExpressionProvider.getInspectorExpressions(codeEditor, codeEditor.getCaretPosition());
            if (expressions.size() > 0) {
                expression = expressions.iterator().next().getExpression();
            }
            if (expression == null) {
                expression = "";
            }
            this.inspect(expression);
        }
    }

    private static RunLogPage getRunLogPage(Context context) {
        LogPage logPage;
        View view = context.getView();
        if (view instanceof RunLogPage) {
            return (RunLogPage)view;
        }
        LogWindow logWindow = LogManager.getLogManager().getLogWindow();
        if (logWindow != null && (logPage = logWindow.getPage()) instanceof RunLogPage) {
            return (RunLogPage)logPage;
        }
        return null;
    }

    private boolean canDoLogWindowAction(Context context, int cmdId) {
        RunLogPage runLogPage;
        if (context != null && (runLogPage = JDebugger.getRunLogPage(context)) != null) {
            if (cmdId == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID) {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, true);
                if (debuggingProcess != null) {
                    return debuggingProcess.canCancelConnection();
                }
            } else {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, false);
                if (debuggingProcess != null && debuggingProcess == this.activeDebuggingProcess) {
                    if (cmdId == DEBUG_SHOWIP_CMD_ID) {
                        return debuggingProcess.canShowIP();
                    }
                    if (cmdId == DEBUG_RESUME_CMD_ID) {
                        return debuggingProcess.canResume();
                    }
                    if (cmdId == DEBUG_STEPOVER_CMD_ID) {
                        return debuggingProcess.canStepOver();
                    }
                    if (cmdId == DEBUG_STEPINTO_CMD_ID) {
                        return debuggingProcess.canStepInto();
                    }
                    if (cmdId == DEBUG_STEPOUT_CMD_ID) {
                        return debuggingProcess.canStepOut();
                    }
                    if (cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID) {
                        return debuggingProcess.canStepToEndOfMethod();
                    }
                    if (cmdId == DEBUG_STEPOVERBC_CMD_ID) {
                        return debuggingProcess.canStepOver();
                    }
                    if (cmdId == DEBUG_STEPINTOBC_CMD_ID) {
                        return debuggingProcess.canStepInto();
                    }
                    if (cmdId == DEBUG_PAUSE_CMD_ID) {
                        return debuggingProcess.canPause();
                    }
                    if (cmdId == DEBUG_GC_CMD_ID) {
                        return debuggingProcess.canGC();
                    }
                    if (cmdId == DEBUG_SUSPEND_ALL_BREAKPOINTS_CMD_ID) {
                        return debuggingProcess.canSuspendBreakpoints();
                    }
                    if (cmdId == DEBUG_RESET_CMD_ID) {
                        return debuggingProcess.canTerminate();
                    }
                }
            }
        }
        return false;
    }

    private void doLogWindowAction(Context context, int cmdId) {
        RunLogPage runLogPage;
        if (context != null && (runLogPage = JDebugger.getRunLogPage(context)) != null) {
            if (cmdId == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID) {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, true);
                if (debuggingProcess != null) {
                    debuggingProcess.cancelConnection();
                }
            } else {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, false);
                if (debuggingProcess != null) {
                    if (cmdId == DEBUG_SHOWIP_CMD_ID) {
                        debuggingProcess.showIP();
                    } else if (cmdId == DEBUG_RESUME_CMD_ID) {
                        debuggingProcess.resume();
                    } else if (cmdId == DEBUG_STEPOVER_CMD_ID) {
                        debuggingProcess.stepOver(JDebugger.getEventTime(context));
                    } else if (cmdId == DEBUG_STEPINTO_CMD_ID) {
                        debuggingProcess.stepInto(JDebugger.getEventTime(context));
                    } else if (cmdId == DEBUG_STEPOUT_CMD_ID) {
                        debuggingProcess.stepOut(JDebugger.getEventTime(context));
                    } else if (cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID) {
                        debuggingProcess.stepToEndOfMethod(JDebugger.getEventTime(context));
                    } else if (cmdId == DEBUG_STEPOVERBC_CMD_ID) {
                        debuggingProcess.stepOverBC(JDebugger.getEventTime(context));
                    } else if (cmdId == DEBUG_STEPINTOBC_CMD_ID) {
                        debuggingProcess.stepIntoBC(JDebugger.getEventTime(context));
                    } else if (cmdId == DEBUG_PAUSE_CMD_ID) {
                        debuggingProcess.pause();
                    } else if (cmdId == DEBUG_GC_CMD_ID) {
                        debuggingProcess.gc();
                    } else if (cmdId == DEBUG_RESET_CMD_ID) {
                        debuggingProcess.terminate();
                    }
                }
            }
        }
    }

    void showContextMenu(MouseEvent e, DockableWindow dw, JFastTreeTable treeTable) {
        if (treeTable != null && treeTable.isEnabled() && e.getSource() == treeTable) {
            JTree tree = treeTable.getTree();
            int y = e.getY();
            int w = treeTable.getWidth();
            for (int x = 20; x < w; x += 20) {
                TreePath treePath = tree.getPathForLocation(x, y);
                if (treePath == null) continue;
                boolean alreadySelected = false;
                TreePath[] treePaths = tree.getSelectionPaths();
                if (treePaths != null) {
                    for (int i = treePaths.length - 1; i >= 0; --i) {
                        if (!treePath.equals(treePaths[i])) continue;
                        alreadySelected = true;
                        break;
                    }
                }
                if (alreadySelected) continue;
                this.selectTreeTablePath(treeTable, treePath, false);
            }
        }
        this.showContextMenu(e, dw);
    }

    void showContextMenu(MouseEvent e, DockableWindow dw, JTable table) {
        int row;
        if (table != null && table.isEnabled() && e.getSource() == table && table.isEnabled() && (row = table.rowAtPoint(e.getPoint())) != -1) {
            ListSelectionModel listSelectionModel = table.getSelectionModel();
            listSelectionModel.clearSelection();
            listSelectionModel.addSelectionInterval(row, row);
        }
        this.showContextMenu(e, dw);
    }

    void showContextMenu(MouseEvent e, DockableWindow dw) {
        ContextMenu debuggerContextMenu = this.getContextMenu();
        try {
            debuggerContextMenu.show(dw.getContext((EventObject)e));
        }
        catch (IllegalComponentStateException hidden) {
            // empty catch block
        }
    }

    void selectTreeTablePath(JFastTreeTable treeTable, TreePath treePath, boolean scrollToVisible) {
        this.selectTreeTablePath(treeTable, new TreePath[]{treePath}, scrollToVisible);
    }

    void selectTreeTablePath(final JFastTreeTable treeTable, final TreePath[] treePaths, boolean scrollToVisible) {
        final JTree tree = treeTable.getTree();
        if (scrollToVisible) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int row = tree.getRowForPath(treePaths[0]);
                    Rectangle r = treeTable.getCellRect(row, 0, true);
                    if (r != null) {
                        treeTable.scrollRectToVisible(r);
                    }
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePath[] currentSelection = tree.getSelectionPaths();
                boolean areEqual = true;
                if (currentSelection == null || currentSelection.length != treePaths.length) {
                    areEqual = false;
                } else {
                    for (int i = 0; i < currentSelection.length; ++i) {
                        if (currentSelection[i].equals(treePaths[i])) continue;
                        areEqual = false;
                        break;
                    }
                }
                if (!areEqual) {
                    try {
                        tree.setSelectionPaths(treePaths);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    static boolean isDoubleClickInTreeTable(JFastTreeTable treeTable, MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0 && e.getClickCount() == 2) {
            int columnAtX = treeTable.getColumnModel().getColumnIndexAtX(e.getX());
            int column = treeTable.convertColumnIndexToModel(columnAtX);
            if (column == 0) {
                Rectangle r;
                JTree tree = treeTable.getTree();
                TreePath treePath = tree.getSelectionPath();
                if (treePath != null && (r = tree.getPathBounds(treePath)) != null) {
                    r.width = 1000;
                    Point p = e.getPoint();
                    if (r.contains(p)) {
                        return true;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    static void adjustColumnsAfterResize(JScrollPane scrollPane, JTable table) {
        int tableWidth;
        if (table.getAutoResizeMode() == 0) {
            tableWidth = table.getWidth();
        } else {
            tableWidth = 0;
            TableColumnModel tableColumnModel = table.getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                TableColumn column = e.nextElement();
                tableWidth += column.getPreferredWidth();
            }
        }
        int extra = scrollPane.getViewport().getWidth() - tableWidth;
        if (extra > 0) {
            boolean firstColumn = true;
            TableColumnModel tableColumnModel = table.getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                TableColumn column = e.nextElement();
                int width = column.getPreferredWidth();
                if (firstColumn) {
                    int remainingColumnCount = tableColumnModel.getColumnCount() - 1;
                    int extraForFirstColumn = remainingColumnCount > 0 ? extra / 2 : extra;
                    width += extraForFirstColumn;
                    if ((extra -= extraForFirstColumn) > 0 && remainingColumnCount > 0) {
                        extra /= remainingColumnCount;
                    }
                } else {
                    width += extra;
                }
                column.setPreferredWidth(width);
                firstColumn = false;
                if (extra > 0) continue;
                break;
            }
        }
    }

    static void addColumnsMenu(final JTable table, final ColumnMenuListener columnMenuListener, boolean[] showColumnInMenu) {
        int showColumnInMenuLength = showColumnInMenu.length;
        final ArrayList<TableColumn> allColumns = new ArrayList<TableColumn>();
        TableColumnModel tableColumnModel = table.getColumnModel();
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            int modelIndex = column.getModelIndex();
            if (modelIndex >= showColumnInMenuLength || !showColumnInMenu[modelIndex]) continue;
            allColumns.add(column);
        }
        JTableHeader tableHeader = table.getTableHeader();
        tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            private void showPopup(MouseEvent e) {
                Context context = Ide.getMainWindow().getLastActiveView().getContext((EventObject)e);
                ContextMenu contextMenu = new ContextMenu();
                contextMenu.addContextMenuListener(new ContextMenuListener(){

                    public void menuWillShow(ContextMenu popup) {
                        HashMap<Integer, JCheckBoxMenuItem> menuItems = new HashMap<Integer, JCheckBoxMenuItem>();
                        for (TableColumn column : allColumns) {
                            final int modelIndex = column.getModelIndex();
                            if (column.getHeaderValue() == null) continue;
                            final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(column.getHeaderValue().toString());
                            menuItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (menuItem.getState()) {
                                        columnMenuListener.showColumn(modelIndex);
                                    } else {
                                        columnMenuListener.hideColumn(modelIndex);
                                    }
                                }
                            });
                            menuItems.put(modelIndex, menuItem);
                            popup.add((Component)menuItem);
                        }
                        TableColumnModel tableColumnModel = table.getColumnModel();
                        Enumeration<TableColumn> e = tableColumnModel.getColumns();
                        while (e.hasMoreElements()) {
                            TableColumn column = e.nextElement();
                            int modelIndex = column.getModelIndex();
                            JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)menuItems.get(modelIndex);
                            if (menuItem == null) continue;
                            menuItem.setState(true);
                        }
                    }

                    public void menuWillHide(ContextMenu popup) {
                    }

                    public boolean handleDefaultAction(Context context) {
                        return false;
                    }
                });
                contextMenu.show(context);
            }
        });
    }

    ObjectPreferences getObjectPreferences() {
        if (this.objectPreferences == null) {
            this.objectPreferences = new ObjectPreferences();
        }
        return this.objectPreferences;
    }

    void setUseFilters(boolean useFilters) {
        this.dbgSettings.setUseFilters(useFilters);
        if (this.smartWindow != null) {
            this.smartWindow.setUseFilters(useFilters);
        }
        if (this.localsWindow != null) {
            this.localsWindow.setUseFilters(useFilters);
        }
        if (this.watchWindow != null) {
            this.watchWindow.setUseFilters(useFilters);
        }
        if (this.inspectorWindows != null) {
            for (InspectorWindow inspectorWindow : this.inspectorWindows) {
                inspectorWindow.setUseFilters(useFilters);
            }
        }
        if (this.heapWindow != null) {
            this.heapWindow.setUseFilters(useFilters);
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.setUseFilters(useFilters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dataHasBeenModified() {
        WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
        wc.show();
        try {
            this.updateDataWindows();
            if (this.threadsWindow != null) {
                this.threadsWindow.everythingChanged();
            }
            if (this.classesWindow != null) {
                this.classesWindow.everythingChanged();
            }
        }
        finally {
            wc.hide();
        }
    }

    void updateDataWindows() {
        if (this.smartWindow != null) {
            this.smartWindow.everythingChanged();
        }
        if (this.localsWindow != null) {
            this.localsWindow.everythingChanged();
        }
        if (this.watchWindow != null) {
            this.watchWindow.everythingChanged();
        }
        if (this.inspectorWindows != null) {
            for (InspectorWindow inspectorWindow : this.inspectorWindows) {
                inspectorWindow.everythingChanged();
            }
        }
        if (this.heapWindow != null) {
            this.heapWindow.everythingChanged();
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.everythingChanged();
        }
        this.windowManager.refreshCustomWindows();
    }

    void refreshSmartWindow() {
        if (this.smartWindow != null) {
            this.smartWindow.refreshWindow();
        }
    }

    void refreshCustomWindows(Evaluator evaluator, DebuggingProcess process) {
        this.windowManager.refreshCustomWindows(evaluator, process);
    }

    synchronized List<SmartDataProvider> getSmartDataProviders() {
        return this.smartDataProviders;
    }

    synchronized List<ToolTipExpressionProvider> getToolTipExpressionProviders() {
        return this.toolTipExpressionProviders;
    }

    synchronized List<DebuggerInspectorExpressionProvider> getInspectorExpressionProviders() {
        return this.inspectorExpressionProviders;
    }

    void stackFramesPopped() {
        if (this.stackWindow != null) {
            this.stackWindow.everythingChanged();
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.everythingChanged();
        }
    }

    static PrintWriter printHtmlHeader(URL url, String title) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)), IdeUtil.getIdeIanaEncoding()));
        pw.println("<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">");
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + IdeUtil.getIdeIanaEncoding() + "\">");
        pw.println("<meta name=\"Author\" content=\"JDeveloper Debugger\">");
        pw.println("<title>" + title + "</title>");
        pw.println("</head>");
        pw.println("<body>");
        return pw;
    }

    static void printHtmlFooter(PrintWriter pw) {
        pw.println("</body>");
        pw.println("</html>");
    }

    static void setControllerForActions(IdeAction[] actions, Controller controller) {
        for (int i = 0; i < actions.length; ++i) {
            IdeAction action = actions[i];
            if (action == null) continue;
            action.addController(controller);
            action.putValue(ACTION_OWNER, (Object)controller);
        }
    }

    static void clearControllerForActions(IdeAction[] actions, Controller controller) {
        for (int i = 0; i < actions.length; ++i) {
            IdeAction action = actions[i];
            if (action == null) continue;
            action.removeController(controller);
            action.putValue(ACTION_OWNER, null);
            action.setEnabled(false);
        }
    }

    static String fixTreeCellAccessibleName(String accessibleName, boolean expanded) {
        if (accessibleName != null) {
            accessibleName = expanded ? DbgArb.format(788, accessibleName) : DbgArb.format(789, accessibleName);
        }
        return accessibleName;
    }

    static long getObjectNumber(DebugDataCompositeInfo dci) {
        long address;
        DebugVirtualMachine vm = dci.getVM();
        DebugCapabilities capabilities = vm.getCapabilities();
        if (capabilities.canGetUniqueIDs()) {
            long uniqueID = dci.getUniqueID();
            if (uniqueID != 0L) {
                return uniqueID;
            }
        } else if (capabilities.canGetAddresses() && (address = dci.getAddressOfObject()) != 0L) {
            return address;
        }
        return 0L;
    }

    private static long getEventTime(Context context) {
        EventObject event = context.getEvent();
        if (event instanceof ActionEvent) {
            return ((ActionEvent)event).getWhen();
        }
        return 0L;
    }

    static int getLineStartOffsetSkipWhite(CodeEditor codeEditor, int line) {
        int offset = codeEditor.getLineStartOffset(line);
        try {
            String lineOfText = codeEditor.getText(offset, codeEditor.getLineEndOffset(line) - offset);
            int i = 0;
            while (Character.isWhitespace(lineOfText.charAt(i))) {
                ++offset;
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return offset;
    }

    private IdeAction getActionEmpty() {
        if (actionEmpty == null) {
            String category = DbgArb.getString(0);
            int EMPTY_DEBUG_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugProjectCommandEmpty");
            actionEmpty = IdeAction.findOrCreate((int)EMPTY_DEBUG_PROJECT_CMD_ID, null, (String)RunMgrArb.getString(0), (String)category, null, null, null, (boolean)false);
        }
        return actionEmpty;
    }

    public IdeAction getActionDebugProject() {
        if (actionDebugProject == null) {
            actionDebugProject = IdeAction.get((int)DEBUG_PROJECT_CMD_ID);
        }
        return actionDebugProject;
    }

    public IdeAction getActionDebugShowIP() {
        if (actionDebugShowIP == null) {
            actionDebugShowIP = IdeAction.get((int)DEBUG_SHOWIP_CMD_ID);
        }
        return actionDebugShowIP;
    }

    public IdeAction getActionDebugStepOver() {
        if (actionDebugStepOver == null) {
            actionDebugStepOver = IdeAction.get((int)DEBUG_STEPOVER_CMD_ID);
        }
        return actionDebugStepOver;
    }

    public IdeAction getActionDebugStepInto() {
        if (actionDebugStepInto == null) {
            actionDebugStepInto = IdeAction.get((int)DEBUG_STEPINTO_CMD_ID);
        }
        return actionDebugStepInto;
    }

    public IdeAction getActionDebugStepOut() {
        if (actionDebugStepOut == null) {
            actionDebugStepOut = IdeAction.get((int)DEBUG_STEPOUT_CMD_ID);
        }
        return actionDebugStepOut;
    }

    public IdeAction getActionDebugStepToEndOfMethod() {
        if (actionDebugStepToEndOfMethod == null) {
            actionDebugStepToEndOfMethod = IdeAction.get((int)DEBUG_STEPTOENDOFMETHOD_CMD_ID);
        }
        return actionDebugStepToEndOfMethod;
    }

    public IdeAction getActionDebugStepOverBC() {
        if (actionDebugStepOverBC == null) {
            actionDebugStepOverBC = IdeAction.get((int)DEBUG_STEPOVERBC_CMD_ID);
        }
        return actionDebugStepOverBC;
    }

    public IdeAction getActionDebugStepIntoBC() {
        if (actionDebugStepIntoBC == null) {
            actionDebugStepIntoBC = IdeAction.get((int)DEBUG_STEPINTOBC_CMD_ID);
        }
        return actionDebugStepIntoBC;
    }

    public IdeAction getActionDebugSuspendAllBreakpoints() {
        if (actionDebugSuspendAllBreakpoints == null) {
            actionDebugSuspendAllBreakpoints = IdeAction.get((int)DEBUG_SUSPEND_ALL_BREAKPOINTS_CMD_ID);
            actionDebugSuspendAllBreakpoints.addController((Controller)this);
        }
        return actionDebugSuspendAllBreakpoints;
    }

    static boolean isSecretFeatureEnabled(String feature) {
        return Ide.getProperty((String)feature) != null;
    }

    void showActionButtonsOnMainToolbar(boolean visible) {
        Toolbar tb = Ide.getToolbar();
        for (int i = 0; i < tb.getComponentCount(); ++i) {
            Action action;
            Component c = tb.getComponent(i);
            if (!(c instanceof AbstractButton) || !((action = ((AbstractButton)c).getAction()) instanceof IdeAction)) continue;
            IdeAction ideAction = (IdeAction)action;
            int cmdId = ideAction.getCommandId();
            if (cmdId == DEBUG_SHOWIP_CMD_ID || cmdId == DEBUG_STEPOVER_CMD_ID || cmdId == DEBUG_STEPINTO_CMD_ID || cmdId == DEBUG_STEPOUT_CMD_ID || cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID || cmdId == DEBUG_SUSPEND_ALL_BREAKPOINTS_CMD_ID) {
                c.setVisible(visible);
            }
            if (!visible) {
                this.showByteCodeActionButtonsOnMainToolbar(false);
                continue;
            }
            if (BytecodeFileSystemHelper.getInstance(false) == null) continue;
            this.showByteCodeActionButtonsOnMainToolbar(true);
        }
    }

    void showByteCodeActionButtonsOnMainToolbar(boolean visible) {
        Toolbar tb = Ide.getToolbar();
        for (int i = 0; i < tb.getComponentCount(); ++i) {
            IdeAction ideAction;
            int cmdId;
            Action action;
            Component c = tb.getComponent(i);
            if (!(c instanceof AbstractButton) || !((action = ((AbstractButton)c).getAction()) instanceof IdeAction) || (cmdId = (ideAction = (IdeAction)action).getCommandId()) != DEBUG_STEPOVERBC_CMD_ID && cmdId != DEBUG_STEPINTOBC_CMD_ID) continue;
            c.setVisible(visible);
        }
    }

    List<String> getCurrentThreadNames() {
        DebugVirtualMachine vm;
        ArrayList<String> names = new ArrayList<String>();
        DebuggingProcess process = this.getActiveDebuggingProcess();
        if (process != null && (vm = process.vm) != null) {
            try {
                DebugThreadInfo[] threads;
                for (DebugThreadInfo thread : threads = vm.listThreads()) {
                    String name = thread.getName();
                    if (name.length() <= 0) continue;
                    names.add(name);
                }
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
        }
        return names;
    }

    public static String[] filterBlanksFromHistoryList(String[] historyList) {
        ArrayList<String> newHistoryList = new ArrayList<String>();
        for (String history : historyList) {
            if (history.trim().length() <= 0) continue;
            newHistoryList.add(history);
        }
        return newHistoryList.toArray(new String[newHistoryList.size()]);
    }

    public static void selectHistoryString(JComboBox comboBox, String selection) {
        if (selection != null && selection.trim().length() > 0) {
            IdeUtil.comboBoxSelectItem((JComboBox)comboBox, (Object)selection);
        } else {
            comboBox.setSelectedIndex(-1);
            JTextField editor = (JTextField)comboBox.getEditor().getEditorComponent();
            editor.setText("");
        }
    }

    public Hover hover(JComponent component, Point p, List<HoverFlavor> flavors) {
        if (this.shouldProvideToolTip()) {
            if (this.toolTipEvaluator == null) {
                this.toolTipEvaluator = new ToolTipEvaluator(this);
            }
            SwingUtilities.convertPointFromScreen(p, component);
            BasicEditorPane editor = (BasicEditorPane)component;
            CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)editor);
            int offset = editor.viewToModel(p);
            Hover hover = this.toolTipEvaluator.showDataHover(codeEditor, offset);
            return hover;
        }
        return null;
    }

    public static void terminateDebuggingProcess(DebugVirtualMachine vm) {
        JDebugger debugger = JDebugger.getInstance();
        if (debugger.debuggingProcesses != null) {
            for (DebuggingProcess debuggingProcess : debugger.debuggingProcesses) {
                if (debuggingProcess.getVM() != vm) continue;
                debuggingProcess.terminate();
                break;
            }
        }
    }

    private static IdeAction getActionDebugSelection() {
        if (actionDebugSelection == null) {
            actionDebugSelection = IdeAction.find((String)"DebugSelectionCommand");
        }
        return actionDebugSelection;
    }

    private static IdeAction getActionContextMenuDebug() {
        if (actionContextMenuDebug == null) {
            actionContextMenuDebug = IdeAction.find((String)"ContextMenuDebugCommand");
        }
        return actionContextMenuDebug;
    }

    public static boolean isFastSwapEnabledDebuggingProcess(DebugVirtualMachine vm) {
        JDebugger debugger = JDebugger.getInstance();
        if (debugger != null && debugger.debuggingProcesses != null) {
            for (DebuggingProcess debuggingProcess : debugger.debuggingProcesses) {
                if (debuggingProcess.getVM() != vm) continue;
                return debuggingProcess.isFastSwapEnabled();
            }
        }
        return false;
    }

    public List<DebuggerEventSource> getDebuggerState() {
        ArrayList<DebuggerEventSource> state = new ArrayList<DebuggerEventSource>();
        for (DebuggingProcess process : this.debuggingProcesses) {
            DebuggerEventSource source = process.getLastEventSource();
            if (source == null) continue;
            state.add(source);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleStepInto(final Context context) {
        CodeEditor codeEditor;
        logger.trace("---Entering handleStepInfo() - method hilighting is " + (this.stepIntoMethodsAreHighlighted ? "ON" : "OFF"));
        if (this.escapedFromTextTabber) {
            if (this.activeDebuggingProcess == null) return;
            logger.trace("Escape mode -- doing legacy stepInto");
            this.activeDebuggingProcess.stepInto(JDebugger.getEventTime(context));
            this.escapedFromTextTabber = false;
            return;
        }
        Map<StepIntoLocationKey, Set<MethodRange>> locationToMethodRangesMap = this.processToStepIntoStateMap.get(this.activeDebuggingProcess);
        if (locationToMethodRangesMap == null) {
            locationToMethodRangesMap = new HashMap<StepIntoLocationKey, Set<MethodRange>>();
            this.processToStepIntoStateMap.put(this.activeDebuggingProcess, locationToMethodRangesMap);
        }
        if ((codeEditor = Source.getCodeEditorFromContext(context)) == null) {
            try {
                codeEditor = (CodeEditor)EditorManager.getEditorManager().getCurrentEditor();
            }
            catch (ClassCastException cce) {
                logger.trace("CurrentEditor is not a CodeEditor, doing legacy step-into-first ");
                if (this.activeDebuggingProcess == null) return;
                this.activeDebuggingProcess.stepInto(JDebugger.getEventTime(context));
                return;
            }
            context.setView((View)codeEditor);
            logger.trace("handleStepInto neeeded to push codeEditor and editorNode into context");
            Node editorNode = Source.getNodeFromCodeEditor(context);
            if (editorNode == null && codeEditor != null) {
                Context cecontext = CodeEditor.getContext((BasicEditorPane)codeEditor.getFocusedEditorPane());
                editorNode = Source.getNodeFromCodeEditor(cecontext);
                context.setNode(editorNode);
            }
            if (codeEditor == null) {
                logger.trace("No CodeEditor for context, doing legacy step-into-first ");
                if (this.activeDebuggingProcess == null) return;
                this.activeDebuggingProcess.stepInto(JDebugger.getEventTime(context));
                return;
            }
        }
        StepIntoLocationKey location = new StepIntoLocationKey();
        if (location.line == -1) {
            logger.trace("Could not get location information to do step-into-outer action, doing normal step-into ");
            if (this.activeDebuggingProcess == null) return;
            this.activeDebuggingProcess.stepInto(JDebugger.getEventTime(context));
            return;
        }
        Set<MethodRange> methodRangesForLocation = locationToMethodRangesMap.get(location);
        if (this.stepIntoMethodsAreHighlighted) {
            this.stepIntoMethodsAreHighlighted = false;
            int selectionOffset = codeEditor.getSelectionStart();
            codeEditor.gotoOffset(selectionOffset, 0);
            try {
                logger.trace("Will step into selection " + this.selectedRange + "; offset from editor " + selectionOffset);
            }
            catch (ExpiredTextBufferException e) {
                // empty catch block
            }
            this.textTabberForStepIntoMethods.setActive(false);
            this.escapedFromTextTabber = false;
            HashMap<TargetMethod, TargetMethod.VisitationTrackingInfo> methodsToTrack = new HashMap<TargetMethod, TargetMethod.VisitationTrackingInfo>();
            if (methodRangesForLocation != null) {
                Map<StepIntoLocationKey, Set<MethodRange>> map = locationToMethodRangesMap;
                synchronized (map) {
                    for (MethodRange mr : methodRangesForLocation) {
                        if (mr.isVisited()) {
                            logger.trace(" Not adding " + mr + " to methodsToTrack, it's already been visited");
                            continue;
                        }
                        boolean stopAtTarget = false;
                        if (mr.nameCoversOffset(selectionOffset)) {
                            stopAtTarget = true;
                        }
                        logger.trace(" Adding " + mr + " to methodsToTrack with stop=" + stopAtTarget);
                        this.createMethodVisitationTarget(methodsToTrack, mr, stopAtTarget);
                    }
                }
                this.activeDebuggingProcess.stepIntoMethod(context, methodsToTrack);
                return;
            }
            logger.trace("No methodRanges known for location even though highlighting indicator on, doing legacy step-into ");
            if (this.activeDebuggingProcess == null) return;
            this.activeDebuggingProcess.stepInto(JDebugger.getEventTime(context));
            return;
        }
        Map<StepIntoLocationKey, Set<MethodRange>> selectionOffset = locationToMethodRangesMap;
        synchronized (selectionOffset) {
            methodRangesForLocation = methodRangesForLocation == null ? this.getMethodCallsOnCurrentLine(codeEditor, context, location) : this.updateMethodVisitationTrackingState(locationToMethodRangesMap, methodRangesForLocation, location);
        }
        if (this.getUnvisitedMethodRangeCount(methodRangesForLocation) <= 1) {
            if (this.activeDebuggingProcess == null) return;
            this.activeDebuggingProcess.stepInto(JDebugger.getEventTime(context));
            return;
        }
        selectionOffset = locationToMethodRangesMap;
        synchronized (selectionOffset) {
            methodRangesForLocation = this.getTextRangesForMethodInvocations(codeEditor, methodRangesForLocation);
            if (methodRangesForLocation.size() > 1) {
                locationToMethodRangesMap.put(location, methodRangesForLocation);
            }
        }
        this.textTabberForStepIntoMethods.setEnterIsSelect(true);
        this.textTabberForStepIntoMethods.setActive(true);
        this.stepIntoMethodsAreHighlighted = true;
        this.textTabberForStepIntoMethods.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("PROPERTY_RANGE_CHANGE")) {
                    logger.trace("Selection changed to " + evt.getNewValue());
                    JDebugger.this.selectedRange = (TextRange)evt.getNewValue();
                } else if (evt.getPropertyName().equals("PROPERTY_ACTIVE")) {
                    JDebugger.this.stepIntoMethodsAreHighlighted = (Boolean)evt.getNewValue();
                    logger.trace("stepInfoMethodsAreHighlighted changed in listener to " + JDebugger.this.stepIntoMethodsAreHighlighted);
                } else if (evt.getPropertyName().equals("PROPERTY_SELECT")) {
                    JDebugger.this.handleStepInto(context);
                } else {
                    logger.trace("Unexpected TextTabber property change on " + evt.getPropertyName());
                }
            }
        });
        logger.trace("Highlighted targets, awaiting selection, default selection is " + this.selectedRange);
        String title = DbgArb.getString(857);
        String message = DbgArb.getString(858);
        MessageDialog.optionalInformation((String)title, (Component)Ide.getMainWindow(), (Object)message, (String)title, (String)DEBUGGER_STEP_INTO_OUTER_HELP_ID);
    }

    private Set<MethodRange> updateMethodVisitationTrackingState(Map<StepIntoLocationKey, Set<MethodRange>> locationToMethodRangesMap, Set<MethodRange> methodRangesForLocation, StepIntoLocationKey location) {
        Set<MethodRange> savedRanges = locationToMethodRangesMap.get(location);
        if (savedRanges != null) {
            logger.trace("Restored method ranges for location with " + savedRanges.size() + " entries");
            methodRangesForLocation = savedRanges;
            DebugThreadInfo currentThread = this.activeDebuggingProcess.vm.getCurrentThread();
            DebugLocation currentLocation = currentThread.getStackFrame(0).getLocation();
            int stackDepth = currentThread.getStackFrameCount();
            MethodVisitationInfoRetrievalKey key = new MethodVisitationInfoRetrievalKey(currentLocation, currentThread.getThreadId(), stackDepth);
            Map<TargetMethod, TargetMethod.VisitationTrackingInfo> visitationInfo = this.activeDebuggingProcess.vm.getCurrentThread().getMethodVisitationInfo(key);
            if (visitationInfo != null) {
                logger.trace("Before processing visitation info, have " + methodRangesForLocation.size() + " ranges, of which " + this.getUnvisitedMethodRangeCount(methodRangesForLocation) + " are unvisited");
                block0: for (TargetMethod mvi : visitationInfo.keySet()) {
                    TargetMethod.VisitationTrackingInfo trackingInfo = visitationInfo.get(mvi);
                    for (int numMarkedVisited = 0; numMarkedVisited < trackingInfo.getVisitationCount(); ++numMarkedVisited) {
                        logger.trace("Looking for MethodRange matching method visit #" + numMarkedVisited + " out of possible " + trackingInfo.getNumberOfOccurrences());
                        Iterator<MethodRange> mrIterator = methodRangesForLocation.iterator();
                        boolean foundMatch = false;
                        while (mrIterator.hasNext()) {
                            MethodRange mr = mrIterator.next();
                            if (!mr.getMethodName().equals(mvi.getMethodName()) || mr.isVisited()) continue;
                            mr.markVisited();
                            foundMatch = true;
                            break;
                        }
                        if (foundMatch) {
                            continue;
                        }
                        logger.trace("ERROR: unable to find as many method ranges as visitation count indicates");
                        continue block0;
                    }
                }
                locationToMethodRangesMap.put(location, methodRangesForLocation);
                logger.trace("After processing visitation info, have " + methodRangesForLocation.size() + " ranges, of which " + this.getUnvisitedMethodRangeCount(methodRangesForLocation) + " are unvisited");
            }
        }
        return methodRangesForLocation;
    }

    private int getUnvisitedMethodRangeCount(Set<MethodRange> ranges) {
        int count = 0;
        for (MethodRange range : ranges) {
            if (range.isVisited()) continue;
            ++count;
        }
        return count;
    }

    private Set<MethodRange> getTextRangesForMethodInvocations(CodeEditor codeEditor, Set<MethodRange> methodRanges) {
        BasicEditorPane pane = codeEditor.getFocusedEditorPane();
        this.selectedRange = null;
        this.textTabberForStepIntoMethods = new TextTabber(pane);
        for (MethodRange mrange : methodRanges) {
            if (mrange.isVisited()) continue;
            String name = mrange.getMethodName();
            int rangeStart = mrange.getMethodNameStartOffset();
            int rangeEnd = mrange.getMethodNameEndOffset();
            TextTabber.TabTextRange range = this.textTabberForStepIntoMethods.addRange((Object)name, rangeStart, rangeEnd);
            mrange.addTextRange((TextRange)range);
            if (this.selectedRange == null) {
                this.selectedRange = range;
                continue;
            }
            if (range.getStartOffset() >= this.selectedRange.getStartOffset()) continue;
            this.selectedRange = range;
        }
        if (this.selectedRange == null) {
            return Collections.emptySet();
        }
        TreeSet<MethodRange> sortedSet = new TreeSet<MethodRange>();
        sortedSet.addAll(methodRanges);
        logger.trace("getTextRangesForMethodInvocations returning " + methodRanges.size() + " method ranges sorted in invocation order");
        return sortedSet;
    }

    private CurrentLineInfo getCurrentLine(CodeEditor codeEditor, StepIntoLocationKey silKey) {
        CurrentLineInfo cli = this.getCurrentLineFromDebuggingProcess(codeEditor, silKey);
        if (cli == null) {
            cli = this.getCurrentLineFromExecutionMarkOffset(codeEditor);
        }
        if (cli == null) {
            cli = this.getCurrentLineFromCaretPosition(codeEditor);
        }
        return cli;
    }

    private CurrentLineInfo getCurrentLineFromDebuggingProcess(CodeEditor codeEditor, StepIntoLocationKey silKey) {
        CurrentLineInfo cli = new CurrentLineInfo();
        logger.trace("getting line from StepIntoLocationKey which is initialized to DebuggingProcess.currentLocation");
        try {
            cli.line = silKey.line;
            cli.startOfLineOffset = JDebugger.getLineStartOffsetSkipWhite(codeEditor, cli.line);
            cli.endOfLineOffset = codeEditor.getLineEndOffset(cli.line);
        }
        catch (Exception e) {
            logger.trace("getCurrentLineFromDebuggingProcess got exception " + e.getMessage());
            return null;
        }
        return cli;
    }

    private CurrentLineInfo getCurrentLineFromExecutionMarkOffset(CodeEditor codeEditor) {
        CurrentLineInfo cli = new CurrentLineInfo();
        if (this.executionPointOffsetMark != null) {
            logger.trace("getCurrentLineFromExecutionMarkOffset because DP.currentLocation unsuccessful");
            try {
                cli.line = codeEditor.getLineFromOffset(this.executionPointOffsetMark.getOffset());
                cli.startOfLineOffset = JDebugger.getLineStartOffsetSkipWhite(codeEditor, cli.line);
                cli.endOfLineOffset = codeEditor.getLineEndOffset(cli.line);
            }
            catch (Exception e) {
                logger.trace("getCurrentLineFromExecutionPointOffsetMark got exception " + e.getMessage());
                return null;
            }
            return cli;
        }
        return null;
    }

    private CurrentLineInfo getCurrentLineFromCaretPosition(CodeEditor codeEditor) {
        CurrentLineInfo cli = new CurrentLineInfo();
        logger.trace("getCurrentLineFromCaretPosition gets line from editor caret line (questionable)");
        try {
            cli.line = codeEditor.getCaretLine();
            cli.startOfLineOffset = JDebugger.getLineStartOffsetSkipWhite(codeEditor, cli.line);
            cli.endOfLineOffset = codeEditor.getLineEndOffset(cli.line);
        }
        catch (Exception e) {
            logger.trace("getCurrentLocationFromCaretPosition got exception " + e.getMessage());
            return null;
        }
        return cli;
    }

    private Set<MethodRange> getMethodCallsOnCurrentLine(CodeEditor codeEditor, Context context, StepIntoLocationKey silKey) {
        final HashSet<MethodRange> methodRanges = new HashSet<MethodRange>();
        if (codeEditor == null) {
            logger.trace("getMethodCallsOnCurrentLine called with null codeeditor");
            return methodRanges;
        }
        CurrentLineInfo cli = this.getCurrentLine(codeEditor, silKey);
        if (cli == null) {
            return methodRanges;
        }
        final int lineEndOffset = cli.endOfLineOffset;
        int lineLength = lineEndOffset - cli.startOfLineOffset;
        String lineContent = null;
        try {
            lineContent = codeEditor.getText(cli.startOfLineOffset, lineLength);
        }
        catch (BadLocationException e) {
            FeedbackManager.reportException((String)("Bad Location exception at line " + cli.line + " of " + codeEditor.getDisplayName()), (Throwable)e);
            return methodRanges;
        }
        JavaManager javaManager = JavaManager.getJavaManager((Project)this.getActiveProject());
        Node editorNode = Source.getNodeFromCodeEditor(context);
        if (editorNode == null) {
            Context cecontext = CodeEditor.getContext((BasicEditorPane)codeEditor.getFocusedEditorPane());
            editorNode = Source.getNodeFromCodeEditor(cecontext);
        }
        if (editorNode == null) {
            logger.trace("EditorNode not found -- doing legacy stepInto");
            return methodRanges;
        }
        SourceFile sourceFile = javaManager.getSourceFile(editorNode.getURL());
        if (sourceFile == null) {
            logger.trace("SourceFile for editor node not found -- doing legacy stepInto");
            return methodRanges;
        }
        int startingOffset = cli.startOfLineOffset;
        SourceElement element = null;
        do {
            if ((element = sourceFile.getElementAt(startingOffset + 1)) == null) {
                return methodRanges;
            }
            if (element instanceof BlockSym) {
                while (++startingOffset < lineEndOffset && sourceFile.getElementAt(startingOffset) instanceof BlockSym) {
                }
                if (startingOffset >= lineEndOffset) {
                    return methodRanges;
                }
                element = sourceFile.getElementAt(startingOffset);
                if (element instanceof MethodSym) {
                    return methodRanges;
                }
            }
            while (!(element instanceof SourceStatement) && !(element instanceof SourceVariableDeclaration)) {
                if ((element = element.getParent()) != null) continue;
                return methodRanges;
            }
            SourceVisitor visitor = new SourceVisitor(){
                int nestingLevel = 0;
                boolean done = false;
                boolean executingLambda = false;
                boolean definingLambda = false;

                public void whenEnterLambdaExpression(SourceLambdaExpression le) {
                    DebugThreadInfo currentThread = ((JDebugger)JDebugger.this).activeDebuggingProcess.vm.getCurrentThread();
                    DebugLocation currentLocation = currentThread.getStackFrame(0).getLocation();
                    DebugMethodInfo currentMethod = currentLocation.getMethod();
                    if (currentMethod.getNameWithoutClassOrSignature().startsWith("lambda$") || currentMethod.getName().contains("$$Lambda$")) {
                        this.executingLambda = true;
                        methodRanges.clear();
                    } else {
                        this.definingLambda = true;
                    }
                }

                public void whenExitLambdaExpression(SourceLambdaExpression le) {
                    if (this.executingLambda) {
                        this.done = true;
                    }
                    this.definingLambda = false;
                    this.executingLambda = false;
                }

                public void whenEnterMethodCallExpression(SourceMethodCallExpression mi) {
                    if (this.definingLambda || this.executingLambda) {
                        logger.trace("MethodCall " + mi.getText() + " is child of lambda");
                    }
                    if (this.nestingLevel == 0 && mi.getStartOffset() > lineEndOffset) {
                        this.done = true;
                    } else {
                        ++this.nestingLevel;
                    }
                }

                public void whenEnterNewClassExpression(SourceNewClassExpression mi) {
                    if (this.nestingLevel == 0 && mi.getStartOffset() > lineEndOffset) {
                        this.done = true;
                    } else {
                        ++this.nestingLevel;
                    }
                }

                public void whenExitMethodCallExpression(SourceMethodCallExpression mi) {
                    --this.nestingLevel;
                    if (!this.done) {
                        if (this.definingLambda) {
                            logger.trace("not adding " + mi.getText() + " as a target because it is being defined, not used");
                        } else {
                            methodRanges.add(new MethodRange((SourceInvokeExpression)mi));
                        }
                    }
                }

                public void whenExitNewClassExpression(SourceNewClassExpression mi) {
                    --this.nestingLevel;
                    if (!(this.done || mi.getEndOffset() > lineEndOffset && this.nestingLevel <= 0)) {
                        if (this.definingLambda) {
                            logger.trace("not adding " + mi.getText() + " as a target because it is being defined, not used");
                        } else {
                            methodRanges.add(new MethodRange((SourceInvokeExpression)mi));
                        }
                    }
                }

                public void whenEnterQuestionExpression(SourceQuestionExpression sqe) {
                    methodRanges.clear();
                    this.done = true;
                }

                public void whenEnterClassBody(SourceClassBody body) {
                    this.done = true;
                }
            };
            visitor.visit(element);
            startingOffset = element.getEndOffset() + 1;
            while (element.getEndOffset() < lineEndOffset && sourceFile.getElementAt(startingOffset) == element) {
                ++startingOffset;
            }
        } while (element.getEndOffset() + 1 < lineEndOffset);
        return methodRanges;
    }

    private void createMethodVisitationTarget(Map<TargetMethod, TargetMethod.VisitationTrackingInfo> currentTargets, MethodRange newTarget, boolean stopAtTarget) {
        TargetMethod existingTarget = null;
        for (TargetMethod tm : currentTargets.keySet()) {
            if (!tm.getMethodName().equals(newTarget.getMethodName())) continue;
            existingTarget = tm;
            break;
        }
        if (existingTarget == null) {
            DebugThreadInfo currentThread = this.activeDebuggingProcess.vm.getCurrentThread();
            DebugLocation currentLocation = currentThread.getStackFrame(0).getLocation();
            TargetMethod newTM = new TargetMethod(newTarget.getMethodName(), currentLocation.getClassInfo().getPackage(), currentLocation.getClassInfo().getNameWithoutPackage(), currentLocation.getLine());
            currentTargets.put(newTM, new TargetMethod.VisitationTrackingInfo(stopAtTarget));
        } else {
            currentTargets.get(existingTarget).incrementOccurrences();
            if (stopAtTarget) {
                currentTargets.get(existingTarget).setStopAtOccurence(currentTargets.get(existingTarget).getNumberOfOccurrences() - 1);
            }
        }
    }

    private void clearExecutionPointOffsetMark(Context context) {
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        try {
            codeEditor.getFocusedEditorPane().getTextBuffer().removeOffsetMark(this.executionPointOffsetMark);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executionPointOffsetMark = null;
    }

    void setExecutionPointOffsetMark(Context runProcessContext) {
        try {
            Context context = JDebugger.findCodeEditorContextForNode(runProcessContext.getWorkspace(), runProcessContext.getNode());
            CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
            if (codeEditor == null) {
                this.executionPointOffsetMark = null;
                return;
            }
            int line = Source.getLineFromCodeEditor(context);
            int offset = codeEditor.getLineStartOffset(line);
            this.executionPointOffsetMark = codeEditor.getFocusedEditorPane().getTextBuffer().addOffsetMark(offset);
        }
        catch (Exception e) {
            FeedbackManager.reportException((String)"This may be related to empty debugger data windows problem", (Throwable)e);
        }
    }

    private static Context findCodeEditorContextForNode(Workspace workspace, Node node) {
        for (Object e : EditorManager.getEditorManager().getAllEditors()) {
            URL codeEditorWorkspaceURL;
            CodeEditor editor;
            Context context;
            if (!(e instanceof CodeEditor) || (context = (editor = (CodeEditor)e).getContext()) == null || context.getNode() != node) continue;
            URL workspaceURL = workspace != null ? workspace.getURL() : null;
            Workspace codeEditorWorkspace = context.getWorkspace();
            URL uRL = codeEditorWorkspaceURL = codeEditorWorkspace != null ? codeEditorWorkspace.getURL() : null;
            if (workspaceURL != null && codeEditorWorkspaceURL != null && !URLFileSystem.equals((URL)workspaceURL, (URL)codeEditorWorkspaceURL)) continue;
            return context;
        }
        return null;
    }

    static {
        lastSavedFile = null;
        changedCellSelectedBackground = ColorUtils2.lighterShadeColor((Color)UIManager.getColor("Table.selectionBackground"));
        debugMenuBuilt = false;
        VIEW_BREAKPOINTS_CMD_ID = Ide.findOrCreateCmdID((String)VIEW_BREAKPOINTS_CMD_NAME);
        VIEW_THREADS_CMD_ID = Ide.findOrCreateCmdID((String)VIEW_THREADS_CMD_NAME);
        VIEW_STACK_CMD_ID = Ide.findOrCreateCmdID((String)VIEW_STACK_CMD_NAME);
        VIEW_SMART_CMD_ID = Ide.findOrCreateCmdID((String)VIEW_SMART_CMD_NAME);
        VIEW_LOCALS_CMD_ID = Ide.findOrCreateCmdID((String)VIEW_LOCALS_CMD_NAME);
        VIEW_WATCHES_CMD_ID = Ide.findOrCreateCmdID((String)VIEW_WATCHES_CMD_NAME);
        VIEW_CLASSES_CMD_ID = Ide.findOrCreateCmdID((String)VIEW_CLASSES_CMD_NAME);
        VIEW_HEAP_CMD_ID = Ide.findOrCreateCmdID((String)VIEW_HEAP_CMD_NAME);
        VIEW_MONITORS_CMD_ID = Ide.findOrCreateCmdID((String)VIEW_MONITORS_CMD_NAME);
        VIEW_LOG_CMD_ID = Ide.findOrCreateCmdID((String)VIEW_LOG_CMD_NAME);
        DEBUG_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)DEBUG_PROJECT_CMD_PREFIX);
        DEBUG_PAUSE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugPauseCommand");
        DEBUG_RESUME_CMD_ID = Ide.findOrCreateCmdID((String)"DebugResumeCommand");
        DEBUG_DETACH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugDetachCommand");
        DEBUG_RESET_CMD_ID = Ide.findOrCreateCmdID((String)"DebugResetCommand");
        DEBUG_STEPOVER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepOverCommand");
        DEBUG_STEPOVERBC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepOverBCCommand");
        DEBUG_STEPINTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepIntoCommand");
        DEBUG_STEPINTOBC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepIntoBCCommand");
        DEBUG_STEPOUT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepOutCommand");
        DEBUG_STEPTOENDOFMETHOD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepToEndOfMethodCommand");
        DEBUG_CONTINUESTEP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugContinueStepCommand");
        DEBUG_RUNTOCURSOR_CMD_ID = Ide.findOrCreateCmdID((String)"DebugRunToCursorCommand");
        DEBUG_STEPINTOMETHOD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepIntoMethodCommand");
        DEBUG_SETNEXTSTATEMENT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSetNextStatementCommand");
        DEBUG_SHOWIP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugShowIPCommand");
        DEBUG_GC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugGCCommand");
        DEBUG_POP_1_STACK_FRAME_CMD_ID = Ide.findOrCreateCmdID((String)"DebugPop1StackFrameCommand");
        DEBUG_SUSPEND_ALL_BREAKPOINTS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSuspendAllBreakpointsCommand");
        DEBUG_RESTARTMETHOD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugRestartMethodCommand");
        NAVIGATOR_STOPLISTENING_CMD_ID = Ide.findOrCreateCmdID((String)"NavigatorStopListening");
        NAVIGATOR_DETACHDEBUGGER_CMD_ID = Ide.findOrCreateCmdID((String)"NavigatorDetachDebugger");
        CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorToggleWatchpointCommand");
        CODE_EDITOR_WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorWatchCommand");
        CODE_EDITOR_INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorInspectCommand");
        STRUCTURE_CREATEWATCHPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStructureCreateWatchpointCommand");
        LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowCancelDebugConnectionCommand");
    }

    class StepIntoLocationKey {
        String pkg;
        String file;
        int line = -1;
        int depth;
        int byteCodeOffset = -1;

        public StepIntoLocationKey() {
            DebugLocation stoppedAtLocation = null;
            try {
                DebugLocation prevWayOfGettingLocation = JDebugger.this.activeDebuggingProcess.getVM().getCurrentStackFrame().getLocation();
                stoppedAtLocation = JDebugger.this.activeDebuggingProcess.getCurrentLocation();
                if (!stoppedAtLocation.equals(prevWayOfGettingLocation)) {
                    logger.trace("SILKey init previously would use " + prevWayOfGettingLocation + " now using " + stoppedAtLocation);
                }
                this.depth = JDebugger.this.activeDebuggingProcess.getVM().getCurrentThread().getStackFrameCount();
            }
            catch (Exception e) {
                logger.trace("Unable to get stack depth for step-into, using legacy logic");
                return;
            }
            if (stoppedAtLocation != null) {
                this.line = stoppedAtLocation.getLine();
                this.byteCodeOffset = stoppedAtLocation.getBytecodeOffset();
                this.file = stoppedAtLocation.getFilename();
                this.pkg = stoppedAtLocation.getClassInfo().getPackage();
            }
        }

        public int hashCode() {
            return this.file.hashCode() << 6 + this.depth * 37 + this.line;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof StepIntoLocationKey)) {
                return false;
            }
            StepIntoLocationKey other = (StepIntoLocationKey)o;
            if (other.line != this.line || other.depth != this.depth) {
                return false;
            }
            if (!other.pkg.equals(this.pkg)) {
                return false;
            }
            return other.file.equals(this.file);
        }

        public String toString() {
            return String.format("%s.%s(depth %d line %d)", this.pkg, this.file, this.depth, this.line);
        }
    }

    class CurrentLineInfo {
        int line = -1;
        int startOfLineOffset = -1;
        int endOfLineOffset = -1;

        CurrentLineInfo() {
        }
    }

    class MethodRange
    implements Comparable {
        private String mi_text;
        private int mi_startOffset;
        private int mi_endOffset;
        private int mi_hash;
        private int mi_nameStartOffset;
        private int mi_nameEndOffset;
        private String mi_methodName;
        private TextRange textRange;
        private List<SourceElement> ancestorNodes;
        private boolean visited = false;

        MethodRange(SourceInvokeExpression sourceExpression) {
            this.mi_text = sourceExpression.getText();
            this.mi_hash = sourceExpression.hashCode();
            this.mi_startOffset = sourceExpression.getStartOffset();
            this.mi_endOffset = sourceExpression.getEndOffset();
            if (sourceExpression instanceof SourceMethodCallExpression) {
                this.mi_methodName = ((SourceMethodCallExpression)sourceExpression).getName();
                this.mi_nameStartOffset = ((SourceMethodCallExpression)sourceExpression).getNameElement().getStartOffset();
                this.mi_nameEndOffset = ((SourceMethodCallExpression)sourceExpression).getNameElement().getEndOffset();
            } else if (sourceExpression instanceof SourceNewClassExpression) {
                this.mi_methodName = "<init>";
                this.mi_nameStartOffset = this.mi_startOffset + 4;
                SourceNewClassExpression exp = (SourceNewClassExpression)sourceExpression;
                String className = exp.getSourceType().getName();
                this.mi_nameEndOffset = this.mi_nameStartOffset + className.length();
            } else {
                this.mi_methodName = null;
                this.mi_nameStartOffset = -1;
                this.mi_nameEndOffset = -1;
            }
        }

        void addTextRange(TextRange range) {
            this.textRange = range;
        }

        int getMethodInvocationStart() {
            return this.mi_startOffset;
        }

        int getMethodInvocationEnd() {
            return this.mi_endOffset;
        }

        boolean matchesTextRange(TextRange r) {
            return this.textRange == r;
        }

        String getMethodName() {
            return this.mi_methodName;
        }

        int getMethodNameStartOffset() {
            return this.mi_nameStartOffset;
        }

        int getMethodNameEndOffset() {
            return this.mi_nameEndOffset;
        }

        private void markVisited() {
            this.visited = true;
        }

        private boolean isVisited() {
            return this.visited;
        }

        public String toString() {
            return this.mi_text + " full range:" + this.mi_startOffset + "-" + this.mi_endOffset + " name range: " + this.getMethodNameStartOffset() + "-" + this.getMethodNameEndOffset() + (this.isVisited() ? " (visited)" : "");
        }

        public int hashCode() {
            return this.mi_hash;
        }

        public boolean equals(Object other) {
            if (!(other instanceof MethodRange)) {
                return false;
            }
            MethodRange otherRange = (MethodRange)other;
            return otherRange.mi_text.equals(this.mi_text) && otherRange.getMethodInvocationStart() == this.getMethodInvocationStart();
        }

        TextRange getTextRange() {
            return this.textRange;
        }

        public int compareTo(Object o) {
            if (o instanceof MethodRange) {
                int thisEnd;
                MethodRange other = (MethodRange)o;
                if (other.getTextRange() == null || this.getTextRange() == null) {
                    throw new IllegalArgumentException("Trying to sort MethodRange without TextRange is not allowed");
                }
                int otherStart = other.getTextRange().getStartOffset();
                if (otherStart < (thisEnd = this.getMethodInvocationEnd())) {
                    return 1;
                }
                if (otherStart > thisEnd) {
                    return -1;
                }
                return 0;
            }
            throw new IllegalArgumentException("Expected MethodRange");
        }

        private boolean nameCoversOffset(int offsetFromEditor) {
            return this.getMethodNameStartOffset() <= offsetFromEditor && this.getMethodNameEndOffset() >= offsetFromEditor;
        }
    }
}

