/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import oracle.ide.migration.Migrator;
import oracle.jdevimpl.runner.debug.ObjectPreferences;

public class ObjectPreferencesMigrator
implements Migrator {
    private boolean o2dUrlExists;
    private boolean hsUrlExists;

    public ObjectPreferencesMigrator() {
        Class<ObjectPreferences> cls = ObjectPreferences.class;
    }

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public String getDescription(int category) {
        return null;
    }

    public boolean canMigrate(int category, File sourceDir) {
        this.o2dUrlExists = new File(sourceDir, "debuggerObjectPreferences.xml").exists();
        this.hsUrlExists = new File(sourceDir, "debuggerObjectPreferencesHs.xml").exists();
        return this.o2dUrlExists || this.hsUrlExists;
    }

    public void setSelected(int category, boolean selected) {
    }

    public boolean isSelected(int category) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] migrate(File sourceDir, File destDir) {
        File writeFile = null;
        File readFile = null;
        if (this.hsUrlExists) {
            readFile = new File(sourceDir, "debuggerObjectPreferencesHs.xml");
            writeFile = new File(destDir, "debuggerObjectPreferencesHs.xml");
        } else if (this.o2dUrlExists) {
            readFile = new File(sourceDir, "debuggerObjectPreferences.xml");
            writeFile = new File(destDir, "debuggerObjectPreferences.xml");
        }
        if (this.o2dUrlExists || this.hsUrlExists) {
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(readFile));
                writer = new BufferedWriter(new FileWriter(writeFile));
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        return new String[0];
    }
}

