/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;

public final class RemoteDebugSettingsPanel
extends DefaultTraversablePanel
implements ItemListener {
    private final Protocol[] protocols;
    private final JComboBox protocolComboBox;
    private final CardLayout cardLayout;
    private final JPanel cardPanel;
    private final JCheckBox promptCheckBox;

    public RemoteDebugSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_remotesetpanel_html");
        List<String> remoteProtocols = DebugFactory.getRemoteProtocols();
        this.protocols = new Protocol[remoteProtocols.size()];
        int count = 0;
        for (String remoteProtocol : remoteProtocols) {
            int factoryCookie = DebugFactory.getDebugConnectorCookie(remoteProtocol);
            this.protocols[count++] = new Protocol(factoryCookie, remoteProtocol, DebugFactory.getDebugConnectorDisplayName(factoryCookie));
        }
        JLabel protocolLabel = new JLabel();
        this.protocolComboBox = new JComboBox();
        this.protocolComboBox.setModel(new NonNullableComboBoxModel((Object[])this.protocols));
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.fillCardPanel();
        this.promptCheckBox = new JCheckBox();
        ResourceUtils.resLabel((JLabel)protocolLabel, (Component)this.protocolComboBox, (String)DbgArb.getString(321));
        ResourceUtils.resButton((AbstractButton)this.promptCheckBox, (String)DbgArb.getString(332));
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add(protocolLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.protocolComboBox, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.cardPanel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 20, 0, 0), 0, 0));
        this.add(this.promptCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.protocolComboBox.addItemListener(this);
    }

    public void onEntry(TraversableContext tc) {
        DebugConfiguration debugConfiguration = RemoteDebugSettingsPanel.getDebugConfiguration(tc);
        this.loadFrom(debugConfiguration);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        DebugConfiguration debugConfiguration = RemoteDebugSettingsPanel.getDebugConfiguration(tc);
        this.commitTo(debugConfiguration);
    }

    private static DebugConfiguration getDebugConfiguration(TraversableContext tc) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)tc);
        return DebugConfiguration.getInstance(runConfiguration);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String card = this.protocolComboBox.getSelectedItem().toString();
        this.cardLayout.show(this.cardPanel, card);
    }

    private void loadFrom(DebugConfiguration debugConfiguration) {
        int index = 0;
        String remoteProtocol = debugConfiguration.getRemoteProtocol();
        for (int i = 0; i < this.protocols.length; ++i) {
            if (this.protocols[i].getProtocol().equals(remoteProtocol)) {
                index = i;
                break;
            }
            if (!this.protocols[i].getProtocol().equals(DebugFactory.getDefaultProtocol())) continue;
            index = i;
        }
        this.protocolComboBox.setSelectedIndex(index);
        int protocolsLength = this.protocols.length;
        for (int i = 0; i < protocolsLength; ++i) {
            this.protocols[i].loadFrom(debugConfiguration);
        }
        this.promptCheckBox.setSelected(debugConfiguration.isPromptForRemoteDebugging());
    }

    private void commitTo(DebugConfiguration debugConfiguration) {
        int index = this.protocolComboBox.getSelectedIndex();
        debugConfiguration.setRemoteProtocol(this.protocols[index].getProtocol());
        int protocolsLength = this.protocols.length;
        for (int i = 0; i < protocolsLength; ++i) {
            this.protocols[i].commitTo(debugConfiguration);
        }
        debugConfiguration.setPromptForRemoteDebugging(this.promptCheckBox.isSelected());
    }

    private void fillCardPanel() {
        int protocolsLength = this.protocols.length;
        if (protocolsLength > 0) {
            for (int i = 0; i < protocolsLength; ++i) {
                Protocol protocol = this.protocols[i];
                this.cardPanel.add((Component)protocol.getPanel(), protocol.toString());
            }
            this.cardLayout.first(this.cardPanel);
        }
    }

    static class Protocol {
        private final String protocol;
        private final String label;
        private final DebugConnectArg[] connectArgs;
        private final JLabel[] connectParamLabels;
        private final JTextField[] connectParams;
        private final JLabel info1;
        private final JTextArea info2;
        private final JLabel info3;
        private final JTextArea info4;
        private final JPanel panel;

        Protocol(int factory, String protocol, String label) {
            this.protocol = protocol;
            this.label = label;
            this.connectArgs = DebugFactory.newInstance(factory).getConnectArgs();
            int length = this.connectArgs.length;
            this.connectParamLabels = new JLabel[length];
            this.connectParams = new JTextField[length];
            String[] labelNames = new String[length];
            for (int i = 0; i < length; ++i) {
                DebugConnectArg connectArg = this.connectArgs[i];
                this.connectParamLabels[i] = new JLabel(connectArg.getLabel());
                this.connectParams[i] = new JTextField(connectArg.getValue());
                this.connectParamLabels[i].setLabelFor(this.connectParams[i]);
                labelNames[i] = this.connectParamLabels[i].getText();
            }
            this.info1 = new JLabel();
            this.info1.setText("");
            this.info1.setHorizontalAlignment(2);
            this.info2 = new JTextArea();
            this.info2.setText("");
            this.info2.setBackground(this.info1.getBackground());
            this.info2.setEditable(false);
            this.info2.setLineWrap(true);
            this.info2.setWrapStyleWord(true);
            this.info1.setLabelFor(this.info2);
            this.info3 = new JLabel();
            this.info3.setText("");
            this.info3.setHorizontalAlignment(2);
            this.info4 = new JTextArea();
            this.info4.setText("");
            this.info4.setBackground(this.info3.getBackground());
            this.info4.setEditable(false);
            this.info4.setLineWrap(true);
            this.info4.setWrapStyleWord(true);
            this.info3.setLabelFor(this.info4);
            String[] helpStrings = DebugFactory.getDebugConnectorRemoteConnectHelpStrings(factory);
            if (helpStrings.length > 1) {
                this.info1.setText(helpStrings[0]);
                this.info2.setText(helpStrings[1]);
            }
            if (helpStrings.length > 3) {
                this.info3.setText(helpStrings[2]);
                this.info4.setText(helpStrings[3]);
            }
            this.panel = new JPanel(new GridBagLayout());
            int y = 0;
            for (int i = 0; i < this.connectArgs.length; ++i) {
                this.panel.add((Component)this.connectParamLabels[i], new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
                this.panel.add((Component)this.connectParams[i], new GridBagConstraints(1, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
            }
            if (this.info1.getText().length() > 0 || this.info2.getText().length() > 0) {
                this.panel.add((Component)this.info1, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
                this.panel.add((Component)this.info2, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                if (this.info3.getText().length() > 0 || this.info4.getText().length() > 0) {
                    this.panel.add((Component)this.info3, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
                    this.panel.add((Component)this.info4, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                }
            }
            this.panel.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        String getProtocol() {
            return this.protocol;
        }

        public String toString() {
            return this.label;
        }

        JPanel getPanel() {
            return this.panel;
        }

        void loadFrom(DebugConfiguration debugConfiguration) {
            for (int i = 0; i < this.connectArgs.length; ++i) {
                DebugConnectArg connectArg = this.connectArgs[i];
                String value = debugConfiguration.getRemoteParameterValue(this.protocol, connectArg.getName(), connectArg.getValue());
                this.connectParams[i].setText(value);
            }
        }

        void commitTo(DebugConfiguration debugConfiguration) {
            for (int i = 0; i < this.connectArgs.length; ++i) {
                DebugConnectArg connectArg = this.connectArgs[i];
                String value = this.connectParams[i].getText().trim();
                debugConfiguration.putRemoteParameterValue(this.protocol, connectArg.getName(), value);
            }
        }
    }
}

