/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.model.Node;
import oracle.ide.runner.SmartDataProvider;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceHasType;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.model.JavaSourceNode;

public class SmartJava
implements SmartDataProvider {
    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String exp = args[i];
            System.out.println("................................................................................");
            System.out.println("exp is \"" + exp + "\"");
            String[] expressions = SmartJava.test(exp);
            for (int j = 0; j < expressions.length; ++j) {
                System.out.println("expressions " + j + " is \"" + expressions[j] + "\"");
            }
            System.out.println();
        }
    }

    public static String[] test(String exp) {
        SmartJava smartJava = new SmartJava();
        ArrayList expressions = new ArrayList();
        ReadTextBuffer tb = TextBufferFactory.createReadTextBuffer((String)exp);
        smartJava.getExpressions(tb, 0, exp.length(), expressions);
        return expressions.toArray(new String[expressions.size()]);
    }

    public boolean canUnderstand(Node node) {
        return node instanceof JavaSourceNode;
    }

    public void getExpressions(ReadTextBuffer tb, int startOffset, int endOffset, List expressions) {
        LinkedHashSet setOfExpressions = new LinkedHashSet();
        ExpressionGatherer expressionGatherer = new ExpressionGatherer(setOfExpressions);
        try {
            int tokenStart;
            int token;
            JavaLexer javaLexer = new JavaLexer();
            LexerToken lexerToken = javaLexer.createLexerToken();
            javaLexer.setTextBuffer(tb);
            javaLexer.setPosition(startOffset);
            javaLexer.setSkipComments(true);
            while ((token = javaLexer.lex(lexerToken)) != 0 && (tokenStart = lexerToken.getStartOffset()) <= endOffset) {
                switch (token) {
                    case 4: 
                    case 136: {
                        int endOfParser = SmartJava.useJavaParser(tb, tokenStart, endOffset, expressionGatherer);
                        javaLexer.setPosition(endOfParser);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        expressions.addAll(setOfExpressions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int useJavaParser(ReadTextBuffer tb, int tokenStart, int endOffset, ExpressionGatherer expressionGatherer) {
        tb.readLock();
        try {
            int i;
            String exp = tb.getString(tokenStart, endOffset - tokenStart);
            SourceFile file = SourceFactory.createFile((int)3);
            SourceFactory factory = file.getFactory();
            SourceExpression se = factory.createExpressionFromText(exp);
            expressionGatherer.gatherExpressions(se);
            int endOfParser = endOffset;
            String text = se.getText();
            if (text != null && text.length() > 0 && (i = exp.indexOf(text)) != -1) {
                endOfParser = tokenStart + i + text.length();
            }
            int n = endOfParser;
            return n;
        }
        finally {
            tb.readUnlock();
        }
    }

    static abstract class SmartJavaOperator {
        SmartJavaOperator() {
        }

        static StringBuffer[] performSingleOperation(StringBuffer[] s1, SmartJavaOperator o) {
            StringBuffer[] result = null;
            if (s1 != null) {
                int length = s1.length;
                result = new StringBuffer[length];
                for (int i = 0; i < length; ++i) {
                    result[i] = new StringBuffer(s1[i].toString());
                    o.operateSingle(result[i]);
                }
            }
            return result;
        }

        public void operateSingle(StringBuffer sb1) {
        }

        static StringBuffer[] performDoubleOperation(StringBuffer[] s1, StringBuffer[] s2, SmartJavaOperator o) {
            StringBuffer[] result = null;
            if (s1 != null && s2 != null) {
                int length1 = s1.length;
                int length2 = s2.length;
                result = new StringBuffer[length1 * length2];
                for (int i1 = 0; i1 < length1; ++i1) {
                    for (int i2 = 0; i2 < length2; ++i2) {
                        int i = i1 * length2 + i2;
                        result[i] = new StringBuffer(s1[i1].toString());
                        o.operateDouble(result[i], s2[i2]);
                    }
                }
            }
            return result;
        }

        public void operateDouble(StringBuffer sb1, StringBuffer sb2) {
        }
    }

    static class ExpressionGatherer {
        private final Set setOfExpressions;
        private final Map mapResults;

        private ExpressionGatherer(Set setOfExpressions) {
            this.setOfExpressions = setOfExpressions;
            this.mapResults = new HashMap();
        }

        private void gatherExpressions(SourceExpression sourceExpression) {
            this.processSourceExpression(sourceExpression);
            this.mapResults.clear();
        }

        private void processSourceExpression(SourceExpression se) {
            if (se != null) {
                int operandCount = se.getOperandCount();
                for (int i = 0; i < operandCount; ++i) {
                    this.processSourceExpression(se.getOperandAt(i));
                }
                StringBuffer[] result = null;
                switch (se.getOperatorCode()) {
                    case 45: 
                    case 46: {
                        result = (StringBuffer[])this.mapResults.get(se.getFirstOperand());
                        break;
                    }
                    case 41: {
                        result = this.prependOperatorToEachResult(se.getFirstOperand(), "!");
                        break;
                    }
                    case 9: {
                        result = this.prependOperatorToEachResult(se.getFirstOperand(), "~");
                        break;
                    }
                    case 44: {
                        result = this.prependOperatorToEachResult(se.getFirstOperand(), "+");
                        break;
                    }
                    case 37: {
                        result = this.prependOperatorToEachResult(se.getFirstOperand(), "-");
                        break;
                    }
                    case 47: {
                        result = this.appendToEachResult(se.getFirstOperand(), "-1");
                        break;
                    }
                    case 48: {
                        result = this.appendToEachResult(se.getFirstOperand(), "+1");
                        break;
                    }
                    case 19: {
                        result = this.appendToEachResult(se.getFirstOperand(), "." + ((SourceHasName)se).getName());
                        break;
                    }
                    case 27: {
                        result = this.processLiteral(se);
                        break;
                    }
                    case 53: {
                        result = this.processSimpleName(se);
                        break;
                    }
                    case 24: {
                        result = this.processMethodCall(se);
                        break;
                    }
                    case 16: {
                        result = this.processArrayAccess(se);
                        break;
                    }
                    case 40: {
                        this.processNewObject(se);
                        break;
                    }
                    case 38: {
                        result = (StringBuffer[])this.mapResults.get(se.getFirstOperand());
                    }
                }
                this.mapResults.put(se, result);
            }
        }

        private StringBuffer[] appendToEachResult(SourceExpression se, final String text) {
            StringBuffer[] sba = (StringBuffer[])this.mapResults.get(se);
            if (sba != null) {
                return SmartJavaOperator.performSingleOperation(sba, new SmartJavaOperator(){

                    @Override
                    public void operateSingle(StringBuffer sb1) {
                        sb1.append(text);
                        ExpressionGatherer.this.addExpression(sb1);
                    }
                });
            }
            return null;
        }

        private StringBuffer[] prependOperatorToEachResult(SourceExpression se, final String operator) {
            StringBuffer[] sba = (StringBuffer[])this.mapResults.get(se);
            if (sba != null) {
                return SmartJavaOperator.performSingleOperation(sba, new SmartJavaOperator(){

                    @Override
                    public void operateSingle(StringBuffer sb1) {
                        boolean add = Character.isJavaIdentifierStart(sb1.charAt(0));
                        sb1.insert(0, operator);
                        if (add) {
                            ExpressionGatherer.this.addExpression(sb1);
                        }
                    }
                });
            }
            return null;
        }

        private StringBuffer[] processLiteral(SourceExpression se) {
            String name = se.getText();
            return new StringBuffer[]{new StringBuffer(name)};
        }

        private StringBuffer[] processSimpleName(SourceExpression se) {
            String name = ((SourceHasName)se).getName();
            this.addExpression(name);
            return new StringBuffer[]{new StringBuffer(name)};
        }

        private StringBuffer[] processMethodCall(SourceExpression se) {
            StringBuffer[] lhs;
            String methodName = ((SourceHasName)se).getName();
            StringBuffer[] fieldNames = this.getFieldNamesFromMethodName(methodName);
            StringBuffer[] stringBufferArray = lhs = se.getOperandCount() > 1 ? (StringBuffer[])this.mapResults.get(se.getFirstOperand()) : null;
            if (lhs != null) {
                return SmartJavaOperator.performDoubleOperation(lhs, fieldNames, new SmartJavaOperator(){

                    @Override
                    public void operateDouble(StringBuffer sb1, StringBuffer sb2) {
                        sb1.append(".").append(sb2);
                        ExpressionGatherer.this.addExpression(sb1);
                    }
                });
            }
            this.addExpressions(fieldNames);
            return fieldNames;
        }

        private StringBuffer[] getFieldNamesFromMethodName(String methodName) {
            String methodNameWithoutPrefix;
            boolean is = false;
            int i = methodName.lastIndexOf(46) + 1;
            if (methodName.regionMatches(i, "get", 0, 3)) {
                methodNameWithoutPrefix = methodName.substring(i + 3);
            } else if (methodName.regionMatches(i, "set", 0, 3)) {
                methodNameWithoutPrefix = methodName.substring(i + 3);
            } else if (methodName.regionMatches(i, "is", 0, 2)) {
                methodNameWithoutPrefix = methodName.substring(i + 2);
                is = true;
            } else {
                return null;
            }
            if (methodNameWithoutPrefix.length() == 0) {
                return null;
            }
            StringBuffer sb = new StringBuffer(methodNameWithoutPrefix);
            char c = sb.charAt(0);
            if (!Character.isLowerCase(c)) {
                sb.setCharAt(0, Character.toLowerCase(c));
            }
            String fieldName = sb.toString();
            if (is) {
                return new StringBuffer[]{new StringBuffer(methodName), new StringBuffer(fieldName), new StringBuffer('_' + fieldName)};
            }
            return new StringBuffer[]{new StringBuffer(fieldName), new StringBuffer('_' + fieldName)};
        }

        private StringBuffer[] processArrayAccess(SourceExpression se) {
            StringBuffer[] lhs = (StringBuffer[])this.mapResults.get(se.getFirstOperand());
            SourceExpression seList = se.getSecondOperand();
            int count = seList.getOperandCount();
            for (int i = 0; i < count; ++i) {
                SourceExpression seIndex = seList.getOperandAt(i);
                StringBuffer[] index = (StringBuffer[])this.mapResults.get(seIndex);
                lhs = SmartJavaOperator.performDoubleOperation(lhs, index, new SmartJavaOperator(){

                    @Override
                    public void operateDouble(StringBuffer sb1, StringBuffer sb2) {
                        sb1.append("[").append(sb2).append("]");
                        ExpressionGatherer.this.addExpression(sb1);
                    }
                });
            }
            return lhs;
        }

        private void processNewObject(SourceExpression se) {
            if (se instanceof SourceHasType) {
                String type = ((SourceHasType)se).getSourceType().getName();
                this.addExpression(type);
            }
        }

        private void addExpressions(StringBuffer[] sb) {
            for (int i = sb.length - 1; i >= 0; --i) {
                this.addExpression(sb[i].toString());
            }
        }

        private void addExpression(StringBuffer sb) {
            this.addExpression(sb.toString());
        }

        private void addExpression(String s) {
            this.setOfExpressions.add(s);
        }
    }
}

