/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.SourceIconRuntimeCallback;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.runner.debug.BytecodeFileSystemHelper;

class SourceIconRuntime
implements SourceIconRuntimeCallback {
    SourceIconRuntime() {
    }

    public JavaField getJavaField(Project jproject, URL nodeURL, String className, String fieldName) {
        String topLevelClassName = className.contains("$") ? className.substring(0, className.indexOf(36)) : className;
        JavaManager javaManager = JavaManager.getJavaManager((Project)jproject);
        SourceFile sourceFile = javaManager.getSourceFile(nodeURL);
        String[] innerClassList = className.split("\\$");
        if (sourceFile != null) {
            String sourceFilePackage = sourceFile.getPackageName();
            if (sourceFilePackage == null) {
                sourceFilePackage = "";
            }
            if (sourceFilePackage.equals(DebugShared.getPackage(topLevelClassName))) {
                List classes = sourceFile.getSourceClasses();
                for (SourceClass sourceClass : classes) {
                    if (!topLevelClassName.equals(sourceClass.getQualifiedName())) continue;
                    if (innerClassList.length > 1) {
                        sourceClass = this.navigateThruInnerClassList(sourceClass, innerClassList);
                    }
                    JavaField javaField = sourceClass.getDeclaredField(fieldName);
                    return javaField;
                }
            }
        }
        return null;
    }

    private SourceClass navigateThruInnerClassList(SourceClass startingFrom, String[] innerClassList) {
        block0: for (String innerClass : innerClassList) {
            Collection classes = startingFrom.getClasses();
            for (SourceClass innerSource : classes) {
                if (!innerSource.getName().equals(innerClass)) continue;
                startingFrom = innerSource;
                continue block0;
            }
        }
        return startingFrom;
    }

    public int getLineFromBytecodeOffset(Node node, int offset) {
        BytecodeFileSystemHelper bytecodeHelper = BytecodeFileSystemHelper.getInstance(false);
        if (bytecodeHelper != null) {
            return bytecodeHelper.getLineFromBytecodeOffset(node.getURL(), offset);
        }
        return 0;
    }

    public String getMethodNameFromBytecode(Node node) {
        BytecodeFileSystemHelper bytecodeHelper = BytecodeFileSystemHelper.getInstance(false);
        if (bytecodeHelper != null) {
            URL nodeURL = node.getURL();
            return BytecodeFileSystemHelper.getMethodName(nodeURL);
        }
        return null;
    }

    public boolean fileNameMatchesNode(String fileName, String pkg, Node node, Project project) {
        return fileName.equals(Source.getFilenameFromNode(node)) && Source.packageMatches(pkg, node, project);
    }
}

