/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.tree.TreePath;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorDataItem;
import oracle.jdevimpl.runner.debug.Expression;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.MonitorDataItem;

public class VersionedDataItem
extends DataItem {
    private Change change = Change.UNCHANGED;
    private long itemUpdatedStoppedCount;
    private long childrenUpdatedStoppedCount;
    private String previousValue;
    private String currentValue;
    private TreeMap<String, VersionedDataItem> vChildren;
    private DataItem item;
    private EvaluatorDataItem evaluatorDataItem;
    private MonitorDataItem monitorDataItem;
    private Object info;
    private DebugVirtualMachine vm;
    private VersionedDataItem parent = null;

    public VersionedDataItem(DataItem item, DebugVirtualMachine vm, long stopCount) {
        super(item.dataPanel, item.info);
        this.vm = vm;
        this.previousValue = "";
        this.item = item;
        this.info = item.getInfo();
        this.data = item.data;
        this.currentValue = item.getValue();
        this.change = Change.ADDED;
        this.itemUpdatedStoppedCount = stopCount;
        this.childrenUpdatedStoppedCount = -1L;
    }

    public void updateVDI(DataItem item, long stopCount) {
        if (!item.getDisplayName().equals(this.getDisplayName())) {
            super.setDisplayName(item.getDisplayName());
        }
        this.previousValue = this.currentValue;
        this.currentValue = item.getValue();
        if (!this.currentValue.equals(this.previousValue)) {
            if (stopCount != this.itemUpdatedStoppedCount) {
                this.change = Change.CHANGED;
                this.itemUpdatedStoppedCount = stopCount;
            }
        } else if (stopCount != this.itemUpdatedStoppedCount) {
            this.change = Change.UNCHANGED;
            this.itemUpdatedStoppedCount = stopCount;
        }
        this.info = item.getInfo();
        this.item = item;
        if (item instanceof EvaluatorDataItem) {
            this.setEvaluatorDataItem((EvaluatorDataItem)item);
        }
        if (item instanceof MonitorDataItem) {
            this.setMonitorDataItem((MonitorDataItem)item);
        }
    }

    public void setEvaluatorDataItem(EvaluatorDataItem edi) {
        this.evaluatorDataItem = edi;
        if (edi == null) {
            return;
        }
        DebugDataInfo info = edi.getDataInfo();
        if (info == null) {
            return;
        }
        this.currentValue = info instanceof DebugDataCompositeInfo ? ((DebugDataCompositeInfo)info).getCourtesyValue() : info.getValue();
    }

    public EvaluatorDataItem getEvaluatorDataItem() {
        return this.evaluatorDataItem;
    }

    public void setMonitorDataItem(MonitorDataItem mdi) {
        this.monitorDataItem = mdi;
    }

    public MonitorDataItem getMonitorDataItem() {
        return this.monitorDataItem;
    }

    public Change getChange() {
        return this.change;
    }

    void setNew() {
        this.change = Change.NEW;
    }

    public long getStateChangeStopCount() {
        return this.itemUpdatedStoppedCount;
    }

    public void setParent(VersionedDataItem parent) {
        this.parent = parent;
    }

    public void expire() {
        this.itemUpdatedStoppedCount = -1L;
        this.childrenUpdatedStoppedCount = -1L;
        VersionedDataItem vParent = this.parent;
        while (vParent != null) {
            vParent.expire();
            vParent = vParent.parent;
        }
    }

    @Override
    public Object getInfo() {
        return this.info;
    }

    public void setInfo(Object info) {
        this.info = info;
    }

    public String getPreviousValue() {
        return this.previousValue;
    }

    @Override
    public String getValue() {
        return this.currentValue;
    }

    @Override
    protected Object getValueOfColumn(int column) {
        if (column == 1) {
            return this.getValue();
        }
        return this.item.getValueOfColumn(column);
    }

    @Override
    int numberOfCachedChildren() {
        return this.vChildren == null ? 0 : this.vChildren.size();
    }

    @Override
    DataItem[] getChildNodes(boolean skipExpandedCheck) {
        boolean stopCountChangedSinceLastUpdate = false;
        DebugThreadInfo currentThread = this.vm.getCurrentThread();
        long debuggeeStoppedCount = JDebugger.getInstance().getActiveDebuggingProcess().getStoppedCount();
        if (currentThread != null && debuggeeStoppedCount != this.childrenUpdatedStoppedCount && debuggeeStoppedCount == this.itemUpdatedStoppedCount) {
            stopCountChangedSinceLastUpdate = true;
        }
        if (this.vChildren == null) {
            DataItem[] items = this.item.getChildNodes(false);
            this.vChildren = new TreeMap(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.matches("\\[\\d+\\]") && o2.matches("\\[\\d+\\]")) {
                        int start = o1.indexOf(91);
                        int end = o1.indexOf(93);
                        String s1 = o1.substring(start + 1, end);
                        int value1 = Integer.parseInt(o1.substring(start + 1, end));
                        start = o2.indexOf(91);
                        end = o2.indexOf(93);
                        int value2 = Integer.parseInt(o2.substring(start + 1, end));
                        return value1 - value2;
                    }
                    return o1.compareTo(o2);
                }
            });
            for (int i = 0; i < items.length; ++i) {
                VersionedDataItem vdi = new VersionedDataItem(items[i], this.vm, debuggeeStoppedCount);
                vdi.setNew();
                vdi.setParent(this);
                if (items[i] instanceof EvaluatorDataItem) {
                    vdi.setEvaluatorDataItem((EvaluatorDataItem)items[i]);
                }
                this.vChildren.put(items[i].getDisplayName(), vdi);
            }
            this.childrenUpdatedStoppedCount = debuggeeStoppedCount;
        } else {
            long start = System.currentTimeMillis();
            if (stopCountChangedSinceLastUpdate) {
                DataItem[] items;
                for (DataItem item : items = this.item.getChildNodes(skipExpandedCheck)) {
                    VersionedDataItem vItem = this.vChildren.get(item.getDisplayName());
                    if (vItem != null) {
                        vItem.updateVDI(item, debuggeeStoppedCount);
                    } else {
                        vItem = new VersionedDataItem(item, this.vm, debuggeeStoppedCount);
                        if (item instanceof EvaluatorDataItem) {
                            vItem.setEvaluatorDataItem((EvaluatorDataItem)item);
                        }
                    }
                    this.vChildren.put(item.getDisplayName(), vItem);
                }
                this.childrenUpdatedStoppedCount = debuggeeStoppedCount;
            }
            JDebugger.logger.trace(System.currentTimeMillis() - start + " ms to update versioned children");
        }
        return this.vChildren.values().toArray(new DataItem[this.vChildren.size()]);
    }

    @Override
    public Iterator<DataItem> getLazyChildren() {
        TreeMap<String, VersionedDataItem> currentChildren = this.vChildren;
        if (currentChildren != null) {
            ArrayList<DataItem> childList = new ArrayList<DataItem>(currentChildren.size());
            for (DataItem dataItem : currentChildren.values()) {
                childList.add(dataItem);
            }
            return childList.iterator();
        }
        return Arrays.asList(new DataItem[0]).iterator();
    }

    @Override
    String getToolTip(int column, TreePath treePath) {
        String tooltip = super.getToolTip(column, treePath);
        if (column == 1 && this.getValue() != null && !this.getValue().equals(this.previousValue)) {
            tooltip = "<html>" + tooltip + "<br/>" + "Previous value: " + this.previousValue + "</html>";
        }
        return tooltip;
    }

    public boolean equals(Object other) {
        if (other instanceof DataItem) {
            return ((DataItem)other).getID().equals(this.getID());
        }
        return false;
    }

    @Override
    boolean canAdjustRange() {
        return this.item.canAdjustRange();
    }

    @Override
    boolean canAdjustObjectPreferences() {
        return this.item.canAdjustObjectPreferences();
    }

    @Override
    boolean isEmpty() {
        return this.item.isEmpty();
    }

    @Override
    void adjustRange(TreePath treePath) {
        if (this.item.canAdjustRange() && treePath != null) {
            this.vChildren = null;
        }
        this.item.adjustRange(treePath);
    }

    @Override
    boolean adjustRange(TreePath treePath, int start, int count) {
        if (this.item.canAdjustRange() && treePath != null) {
            this.vChildren = null;
        }
        return this.item.adjustRange(treePath, start, count);
    }

    @Override
    int getRangeStart() {
        return this.item.getRangeStart();
    }

    @Override
    int getRangeCount() {
        return this.item.getRangeCount();
    }

    @Override
    boolean shouldShowArrayNavigationButtons() {
        return this.item.shouldShowArrayNavigationButtons();
    }

    @Override
    boolean canAdjustRangePrevious() {
        return this.item.canAdjustRangePrevious();
    }

    @Override
    boolean canAdjustRangeNext(boolean optimizeBySkippingScan) {
        return this.item.canAdjustRangeNext(optimizeBySkippingScan);
    }

    @Override
    boolean canAdjustRangeFirst() {
        return this.item.canAdjustRangePrevious();
    }

    @Override
    boolean canAdjustRangeLast(boolean optimize) {
        return this.item.canAdjustRangeNext(optimize);
    }

    @Override
    void adjustRangeFirst(TreePath treePath) {
        if (this.item.canAdjustRange() && treePath != null) {
            this.vChildren = null;
        }
        this.item.adjustRangeFirst(treePath);
    }

    @Override
    void adjustRangeLast(TreePath treePath) {
        if (this.item.canAdjustRange() && treePath != null) {
            this.vChildren = null;
        }
        this.item.adjustRangeLast(treePath);
    }

    @Override
    void adjustRangePrevious(TreePath treePath) {
        if (this.item.canAdjustRange() && treePath != null) {
            this.vChildren = null;
        }
        this.item.adjustRangePrevious(treePath);
    }

    @Override
    void adjustRangeNext(TreePath treePath) {
        if (this.item.canAdjustRange() && treePath != null) {
            this.vChildren = null;
        }
        this.item.adjustRangeNext(treePath);
    }

    @Override
    void modifyInfo(Object info, String displayNameOverride, String expressionPartOverride, TreePath treePath) {
        this.vChildren = null;
        this.info = info;
        this.item.modifyInfo(info, displayNameOverride, expressionPartOverride, treePath);
    }

    @Override
    void clearDataForItem() {
        this.item.clearDataForItem();
    }

    @Override
    void clearCacheForColumn(int column) {
        if (this.item != null) {
            this.item.clearCacheForColumn(column);
        }
    }

    @Override
    public DebugDataInfo getDataInfo() {
        return this.item.data;
    }

    @Override
    protected boolean isUnrelated() {
        return this.item.isUnrelated();
    }

    @Override
    public String getShortLabel() {
        return this.item.getDisplayName();
    }

    @Override
    public Object getData() {
        return this.item;
    }

    @Override
    public boolean mayHaveChildren() {
        return this.item.mayHaveChildren();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.item.getTransferDataFlavors();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.item.isDataFlavorSupported(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        return this.item.getTransferData(flavor);
    }

    @Override
    String getExpressionPart() {
        return this.item.getExpressionPart();
    }

    @Override
    String getDisplayName() {
        return this.item.getDisplayName();
    }

    @Override
    void setDisplayName(String displayName) {
        this.item.setDisplayName(displayName);
    }

    @Override
    String getActualType() {
        return this.item.getActualType(false, false);
    }

    @Override
    String getActualType(boolean ignoreCached, boolean showPackage) {
        return this.item.getActualType(ignoreCached, showPackage);
    }

    @Override
    String getFullyQualifiedActualType() {
        return this.item.getFullyQualifiedActualType();
    }

    @Override
    String getDeclaredType() {
        return this.item.getDeclaredType();
    }

    @Override
    String getFullyQualifiedDeclaredType() {
        return this.item.getFullyQualifiedDeclaredType();
    }

    @Override
    String getValue(boolean useCached, boolean getExtendedValue) {
        return this.item.getValue(useCached, getExtendedValue, true);
    }

    @Override
    String getValue(boolean useCached, boolean getExtendedValue, boolean addQuotes) {
        return this.item.getValue(useCached, getExtendedValue, addQuotes);
    }

    @Override
    String getValueExpressionUsed() {
        return this.item.getValueExpressionUsed();
    }

    @Override
    String getHexValue() {
        return this.item.getHexValue();
    }

    @Override
    String getAddress() {
        return this.item.getAddress();
    }

    @Override
    String getID() {
        return this.item.getID();
    }

    @Override
    public String getInstanceCount() {
        return this.item.getInstanceCount();
    }

    @Override
    public void setInstanceCount(long count) {
        this.item.setInstanceCount(count);
    }

    @Override
    int countChildNodes() {
        return this.getChildNodes(false).length;
    }

    @Override
    DataItem getField(String name) {
        return this.item.getField(name);
    }

    @Override
    List<DataItem> getFields() {
        return this.item.getFields();
    }

    @Override
    List<DataItem> getDeclaredFields() {
        return this.item.getDeclaredFields();
    }

    @Override
    void clearChildren(TreePath treePath) {
        this.vChildren = null;
        this.item.clearChildren(treePath);
    }

    @Override
    boolean canViewWhole() {
        return this.item.canViewWhole();
    }

    @Override
    void viewWhole() {
        this.item.viewWhole();
    }

    @Override
    int canUseToStringForValue() {
        return this.item.canUseToStringForValue();
    }

    @Override
    void toggleUseToString() {
        this.item.toggleUseToString();
    }

    @Override
    String canViewAnnotations() {
        return this.item.canViewAnnotations();
    }

    @Override
    void viewAnnotations(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        this.item.viewAnnotations(debuggingProcess, vm, thread, frame);
    }

    @Override
    boolean canViewAnnotationsForClass() {
        return this.item.canViewAnnotationsForClass();
    }

    @Override
    void viewAnnotationsForClass(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        this.item.viewAnnotationsForClass(debuggingProcess, vm, thread, frame);
    }

    @Override
    boolean canToggleValue() {
        return this.item.canToggleValue();
    }

    @Override
    void toggleValue() {
        this.expire();
        this.item.toggleValue();
    }

    @Override
    boolean canModifyValue() {
        return this.item.canModifyValue();
    }

    @Override
    void modifyValue(DebugVirtualMachine vm) {
        this.expire();
        this.item.modifyValue(vm);
    }

    @Override
    DataFlavor[] canDrag(TreePath treePath) {
        return this.item.canDrag(treePath);
    }

    @Override
    boolean canDiagram(TreePath treePath) {
        return this.item.canDiagram(treePath);
    }

    @Override
    boolean canWatchAndInspect(TreePath treePath) {
        return this.item.canWatchAndInspect(treePath);
    }

    @Override
    protected boolean prepareExpression(Object[] path, int i, Expression expression) {
        return this.item.prepareExpression(path, i, expression);
    }

    @Override
    void watch(TreePath treePath) {
        this.item.watch(treePath);
    }

    @Override
    void watch(TreePath treePath, String displayName) {
        this.item.watch(treePath, displayName);
    }

    @Override
    void inspect(TreePath treePath) {
        this.item.inspect(treePath, null);
    }

    @Override
    void inspect(TreePath treePath, String displayName) {
        this.item.inspect(treePath, displayName);
    }

    @Override
    boolean canWatchInspectClassLoader() {
        return this.item.canWatchInspectClassLoader();
    }

    @Override
    void watchClassLoader(DebuggingProcess debuggingProcess) {
        this.item.watchClassLoader(debuggingProcess);
    }

    @Override
    void inspectClassLoader(DebuggingProcess debuggingProcess) {
        this.item.inspectClassLoader(debuggingProcess);
    }

    @Override
    String canShowSource(int cmdId) {
        return this.item.canShowSource(cmdId);
    }

    @Override
    void showSource(int cmdId, DebuggingProcess debuggingProcess) {
        this.item.showSource(cmdId, debuggingProcess);
    }

    @Override
    long getAddressOfObject() {
        return this.item.getAddressOfObject();
    }

    @Override
    protected boolean shouldSkipField(DebugFieldInfo field) {
        return this.item.shouldSkipField(field);
    }

    @Override
    void setIsExpanded(boolean value) {
        this.item.setIsExpanded(value);
    }

    @Override
    boolean isExpanded() {
        return this.item.isExpanded();
    }

    static enum Change {
        NEW,
        ADDED,
        REMOVED,
        CHANGED,
        UNCHANGED;

    }
}

