/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.run;

import java.io.IOException;
import java.net.URL;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.compiler.Compiler;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Runner;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdeveloper.runner.RunningProcess;
import oracle.jdevimpl.runner.run.RunArb;

public final class JRunner
implements Controller,
Observer,
Addin {
    private static JRunner instance;
    private Project activeProject;
    private Workspace activeWorkspace;
    private static IdeAction actionRunProject;
    private static IdeAction actionRunSelection;
    private static IdeAction actionContextMenuRun;
    private static IdeAction actionMruRun;
    public static final String MRU_CONFIG_PROJECT_SHORT_NAME = "RunMRUConfigProjectShortName";
    public static final String MRU_CONFIG_PROJECT_RELATIVE_URL = "RunMRUConfigProjectRelativeUrl";
    public static final String MRU_CONFIG_NAME = "RunMRUConfigName";
    public static final String MRU_RUN_TARGET_URL = "RunMRUTargetURL";

    public JRunner() throws SingletonClassException {
        if (instance != null) {
            throw new SingletonClassException("oracle.jdevimpl.runner.run.JRunner");
        }
        instance = this;
    }

    public static JRunner getInstance() {
        return instance;
    }

    private Project getActiveProject() {
        if (this.activeProject == null) {
            this.activeProject = Ide.getActiveProject();
        }
        return this.activeProject;
    }

    private Workspace getActiveWorkspace() {
        if (this.activeWorkspace == null) {
            this.activeWorkspace = Ide.getActiveWorkspace();
        }
        return this.activeWorkspace;
    }

    public static int getContextMenuRunCommandID() {
        return Ide.findOrCreateCmdID((String)"ContextMenuRunCommand");
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (action == this.getActionRunProject()) {
            if (this.canStartProcess(null)) {
                this.startMruProcess(context);
            }
            return true;
        }
        if (action == this.getActionMruRun()) {
            if (this.canStartProcess(null)) {
                this.startMruProcess(context);
            }
            return true;
        }
        if (action.getValue("UserData") != null && action.getValue("UserData").toString().startsWith("RunConfigurationName:")) {
            RunConfiguration runConfiguration;
            String runConfigurationName = action.getValue("UserData").toString().substring(21);
            if (runConfigurationName != null && (runConfiguration = RunConfigurations.getRunConfigurationByName(this.getActiveProject(), runConfigurationName)) != null) {
                RunConfigurations.setActiveRunConfiguration(this.getActiveProject(), this.getActiveWorkspace(), runConfiguration);
                if (this.canStartProcess(null)) {
                    this.startProcess(null, true);
                }
            }
            return true;
        }
        if (action == this.getActionRunSelection()) {
            if (this.canStartProcess(context)) {
                Node contextNode = RunProcess.getContextNodeForRun((Context)context);
                if (contextNode != null && !(contextNode instanceof Workspace) && !(contextNode instanceof Project)) {
                    context.setProperty(RunProcess.RUN_PROCESS_DO_NOT_CONSIDER_DEFAULT, (Object)Boolean.TRUE);
                }
                this.startProcess(context, false);
            }
            return true;
        }
        if (action == this.getActionContextMenuRun()) {
            if (this.canStartProcess(context)) {
                context = (Context)action.getValue("UserData");
                Node contextNode = RunProcess.getContextNodeForRun((Context)context);
                if (contextNode != null && !(contextNode instanceof Workspace) && !(contextNode instanceof Project)) {
                    context.setProperty(RunProcess.RUN_PROCESS_DO_NOT_CONSIDER_DEFAULT, (Object)Boolean.TRUE);
                }
                this.startProcess(context, false);
            }
            action.putValue("UserData", null);
            return true;
        }
        return false;
    }

    public static Context prepareMruProcess(Context contextIn) {
        HashStructure userProps;
        Context contextOut = new Context(contextIn);
        Workspace currentWorkspace = Ide.getActiveWorkspace();
        if (currentWorkspace != null && Ide.getActiveProject() != null && RunConfigurations.getActiveRunConfiguration(Ide.getActiveProject(), Ide.getActiveWorkspace()) != null && (userProps = currentWorkspace.getUserPropertiesOnly()) != null) {
            String configName = userProps.getString(MRU_CONFIG_NAME);
            String mruTarget = userProps.getString(MRU_RUN_TARGET_URL);
            Project runPrj = JRunner.getMRUProject(contextOut);
            if (runPrj != null) {
                contextOut.setWorkspace(currentWorkspace);
                if (configName.equals(RunConfigurations.getActiveName(runPrj, currentWorkspace))) {
                    contextOut.setProject(runPrj);
                    Ide.setActiveProject((Project)runPrj);
                    if (mruTarget != null && mruTarget.length() != 0) {
                        Node targetNode = null;
                        URL targetUrl = null;
                        targetUrl = URLFactory.newURL((String)mruTarget);
                        if (targetUrl != null && (targetNode = NodeFactory.find((URL)targetUrl)) != null) {
                            contextOut.setNode(targetNode);
                            contextOut.setProperty(RunProcess.RUN_PROCESS_USE_NODE_FROM_CONTEXT, (Object)RunProcess.RUN_PROCESS_USE_NODE_FROM_CONTEXT);
                        }
                    }
                } else {
                    contextOut = null;
                }
            }
        }
        return contextOut;
    }

    private void startMruProcess(Context context) {
        context = JRunner.prepareMruProcess(context);
        this.startProcess(context, true);
    }

    public boolean update(IdeAction action, Context context) {
        if (action == this.getActionRunProject()) {
            this.updateRunProjectAction(action, context);
            return true;
        }
        return false;
    }

    public void update(final Object observed, final UpdateMessage change) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int messageID = change.getMessageID();
                if (observed == Ide.getSystem() && messageID == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                    JRunner.this.activeProject = Ide.getActiveProject();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void initialize() {
        Ide.getSystem().attach((Observer)this);
    }

    private IdeAction getActionMruRun() {
        if (actionMruRun == null) {
            actionMruRun = IdeAction.find((String)"RunMruProjectCommand");
        }
        return actionMruRun;
    }

    public static Project getMRUProject(Context context) {
        if (context == null) {
            return null;
        }
        Workspace currentWorkspace = context.getWorkspace();
        Project mruProject = null;
        if (currentWorkspace == null) {
            return null;
        }
        HashStructure userProps = currentWorkspace.getUserPropertiesOnly();
        if (userProps != null) {
            WorkingSet ws;
            Node node;
            String projectShortName = userProps.getString(MRU_CONFIG_PROJECT_SHORT_NAME);
            String configName = userProps.getString(MRU_CONFIG_NAME);
            String projectRelativeUrl = userProps.getString(MRU_CONFIG_PROJECT_RELATIVE_URL);
            if (projectShortName != null && configName != null && projectRelativeUrl != null && (node = NodeFactory.find((URL)URLFactory.newURL((URL)URLFileSystem.getParent((URL)currentWorkspace.getURL()), (String)projectRelativeUrl))) instanceof Project) {
                mruProject = (Project)node;
            }
            if (mruProject != null && Runner.getRunner().getRunnerOptions().isRunCurrentWorkingSet() && (ws = WorkingSets.getInstance((Workspace)context.getWorkspace()).getCurrentWorkingSet()).isExcluded(mruProject)) {
                mruProject = null;
            }
        }
        return mruProject;
    }

    public static boolean validateProjectRunnable(Context context, Project project) {
        if (Runner.getRunner().getRunnerOptions().isRunCurrentWorkingSet()) {
            if (project != null) {
                WorkingSet ws = WorkingSets.getInstance((Workspace)context.getWorkspace()).getCurrentWorkingSet();
                if (ws != null && ws.isExcluded(project)) {
                    return false;
                }
            } else {
                return Ide.getWorkspaces().workspaces().size() > 0;
            }
        }
        return project != null;
    }

    private void updateRunProjectAction(final IdeAction action, Context context) {
        String name;
        String currentWSName = null;
        if (context.getWorkspace() != null && (currentWSName = WorkingSets.getInstance((Workspace)context.getWorkspace()).getCurrentWorkingSetName()) == WorkingSets.ALL_FILES_WORKING_SET_LABEL) {
            currentWSName = null;
        }
        boolean isUseCurrentWorkingSet = Runner.getRunner().getRunnerOptions().isRunCurrentWorkingSet() && currentWSName != null;
        Runnable edtRunnable = new Runnable(){

            @Override
            public void run() {
                action.setEnabled(JRunner.this.canStartProcess(null));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            edtRunnable.run();
        } else {
            SwingUtilities.invokeLater(edtRunnable);
        }
        Project mruProject = JRunner.getMRUProject(context);
        if (mruProject != null && !mruProject.isOpen()) {
            mruProject = null;
        }
        if (mruProject != null) {
            String projectShortLabel = mruProject.getShortLabel();
            name = RunArb.format(isUseCurrentWorkingSet ? 3 : 2, projectShortLabel);
        } else {
            Project project = context.getProject();
            if (project == null) {
                name = RunArb.getString(isUseCurrentWorkingSet ? 1 : 0);
                action.setEnabled(JRunner.validateProjectRunnable(context, Ide.getActiveProject()));
            } else {
                name = RunArb.format(isUseCurrentWorkingSet ? 3 : 2, project.getShortLabel());
                action.setEnabled(JRunner.validateProjectRunnable(context, project));
            }
        }
        action.putValue("Name", (Object)name);
    }

    private boolean canStartProcess(Context context) {
        Node node;
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null && compiler.isBusy(null)) {
            return false;
        }
        if (context != null && !context.containsProperty(RunProcess.RUN_PROCESS_USE_NODE_FROM_CONTEXT) && (node = RunProcess.getContextNodeForRun((Context)context)) instanceof Project && node == context.getProject()) {
            context = null;
        }
        boolean contextOk = false;
        if (context != null) {
            contextOk = this.isContextNodeRunnable(context);
        } else if (Ide.getActiveProject() != null) {
            contextOk = true;
        } else {
            Context activeContext = new Context(Ide.getMainWindow().getLastActiveView().getContext());
            if (activeContext != null) {
                contextOk = this.isContextNodeRunnable(activeContext);
            }
        }
        return contextOk;
    }

    private boolean isContextNodeRunnable(Context context) {
        Node node = RunProcess.getContextNodeForRun((Context)context);
        return node != null && Runner.getRunner().couldNodeBeRunnable(node);
    }

    public void startProcess() {
        System.out.println("Please use oracle.jdeveloper.runner.EmbeddedServer instead of JRunner.startProcess");
        this.startProcess(null, false);
    }

    public void startProcess(Context context, boolean updateMruProperties) {
        RunningProcess runningProcess = this.createRunningProcess(context, updateMruProperties);
        runningProcess.start();
    }

    public static Context prepareProcessContext(Context context, boolean updateMruProperties) {
        Project activeProject;
        HashStructure userProps;
        if (context == null) {
            context = new Context(Ide.getMainWindow().getLastActiveView().getContext());
        }
        if (updateMruProperties && context != null && context.getWorkspace() != null && context.getProject() != null && (userProps = context.getWorkspace().getUserPropertiesOnly()) != null) {
            String projectShortName = userProps.getString(MRU_CONFIG_PROJECT_SHORT_NAME);
            String configName = userProps.getString(MRU_CONFIG_NAME);
            String mruTarget = userProps.getString(MRU_RUN_TARGET_URL);
            Project activeProject2 = Ide.getActiveProject();
            Workspace activeWorkspace = Ide.getActiveWorkspace();
            String activeRunConfiguration = null;
            String activeProjectShortLabel = null;
            if (activeProject2 != null) {
                activeRunConfiguration = RunConfigurations.getActiveRunConfiguration(activeProject2, activeWorkspace).getName();
                activeProjectShortLabel = activeProject2.getShortLabel();
            }
            if (projectShortName == null || configName == null || !configName.equals(activeRunConfiguration) || !projectShortName.equals(activeProjectShortLabel)) {
                URL targetURL;
                userProps.putString(MRU_CONFIG_PROJECT_SHORT_NAME, context.getProject().getShortLabel());
                userProps.putString(MRU_CONFIG_NAME, RunConfigurations.getActiveName(context.getProject(), context.getWorkspace()));
                userProps.putString(MRU_CONFIG_PROJECT_RELATIVE_URL, URLFileSystem.toRelativeSpec((URL)context.getProject().getURL(), (URL)context.getWorkspace().getURL()));
                Node targetNode = context.getNode();
                mruTarget = null;
                if (targetNode != null && (targetURL = targetNode.getURL()) != null) {
                    mruTarget = targetURL.toString();
                }
                userProps.putString(MRU_RUN_TARGET_URL, mruTarget);
                try {
                    context.getWorkspace().saveUserProperties();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if ((activeProject = Ide.getActiveProject()) != null && !context.containsProperty(RunProcess.RUN_PROCESS_USE_NODE_FROM_CONTEXT) && context != null && RunProcess.getContextNodeForRun((Context)context) == activeProject) {
            context = null;
        }
        if (context != null) {
            Workspace workspace = context.getWorkspace();
            Project project = context.getProject();
            if (workspace == null || project == null) {
                workspace = Ide.getActiveWorkspace();
                project = activeProject;
            }
            context.setWorkspace(workspace);
            context.setProject(project);
        }
        return context;
    }

    private RunningProcess createRunningProcess(Context context, boolean updateMruProperties) {
        Context context2 = JRunner.prepareProcessContext(context, updateMruProperties);
        RunningProcess runningProcess = new RunningProcess(context2);
        return runningProcess;
    }

    public IdeAction getActionRunProject() {
        if (actionRunProject == null) {
            actionRunProject = IdeAction.find((String)"RunProjectCommand");
        }
        return actionRunProject;
    }

    private IdeAction getActionRunSelection() {
        if (actionRunSelection == null) {
            actionRunSelection = IdeAction.find((String)"RunSelectionCommand");
        }
        return actionRunSelection;
    }

    private IdeAction getActionContextMenuRun() {
        if (actionContextMenuRun == null) {
            actionContextMenuRun = IdeAction.find((String)"ContextMenuRunCommand");
        }
        return actionContextMenuRun;
    }
}

