/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.core;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.ide.print.core.Command;

public final class Graphix
extends Graphics2D {
    private int myIndex;
    private int myNextIndex;
    private Graphix myRoot;
    private Graphics2D myGraphics;
    private List<Command.Operation> myCommands;

    public Graphix(Graphics2D graphics) {
        this(graphics, 0, null);
        this.myRoot = this;
        this.myNextIndex = this.myIndex + 1;
        this.myCommands = new Vector<Command.Operation>();
    }

    private Graphix(Graphics2D graphics, int index, Graphix root) {
        this.myGraphics = graphics;
        this.myIndex = index;
        this.myRoot = root;
    }

    @Override
    public void draw(Shape shape) {
        this.add(Command.DRAW_SHAPE, shape);
        this.myGraphics.draw(shape);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform transform, ImageObserver observer) {
        this.add(Command.DRAW_IMAGE_01, image, transform, observer);
        return this.myGraphics.drawImage(image, transform, observer);
    }

    @Override
    public void drawImage(BufferedImage image, BufferedImageOp op, int x, int y) {
        this.add(Command.DRAW_IMAGE_02, image, op, x, y);
        this.myGraphics.drawImage(image, op, x, y);
    }

    @Override
    public void drawRenderedImage(RenderedImage image, AffineTransform transform) {
        this.add(Command.DRAW_IMAGE_03, image, transform);
        this.myGraphics.drawRenderedImage(image, transform);
    }

    @Override
    public void drawRenderableImage(RenderableImage image, AffineTransform transform) {
        this.add(Command.DRAW_IMAGE_04, image, transform);
        this.myGraphics.drawRenderableImage(image, transform);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, Color color, ImageObserver observer) {
        this.add(Command.DRAW_IMAGE_05, x, y, color, observer);
        return this.myGraphics.drawImage(image, x, y, color, observer);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        this.add(Command.DRAW_IMAGE_06, image, x, y, observer);
        return this.myGraphics.drawImage(image, x, y, observer);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, int width, int height, Color color, ImageObserver observer) {
        this.add(Command.DRAW_IMAGE_07, image, x, y, width, height, color, observer);
        return this.myGraphics.drawImage(image, x, y, width, height, color, observer);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver observer) {
        this.add(Command.DRAW_IMAGE_08, image, x, y, width, height, observer);
        return this.myGraphics.drawImage(image, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        this.add(Command.DRAW_IMAGE_09, image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
        return this.myGraphics.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        this.add(Command.DRAW_IMAGE_10, image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        return this.myGraphics.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public void drawString(String str, float x, float y) {
        this.add(Command.DRAW_STRING_FLOAT, str, Float.valueOf(x), Float.valueOf(y));
        this.myGraphics.drawString(str, x, y);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.add(Command.DRAW_STRING_INT, str, x, y);
        this.myGraphics.drawString(str, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.add(Command.DRAW_ATTR_INT, iterator, x, y);
        this.myGraphics.drawString(iterator, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.add(Command.DRAW_ATTR_FLOAT, iterator, Float.valueOf(x), Float.valueOf(y));
        this.myGraphics.drawString(iterator, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector vector, float x, float y) {
        this.add(Command.DRAW_GLYPH_VECTOR, vector, Float.valueOf(x), Float.valueOf(y));
        this.myGraphics.drawGlyphVector(vector, x, y);
    }

    @Override
    public void fill(Shape shape) {
        this.add(Command.FILL_SHAPE, shape);
        this.myGraphics.fill(shape);
    }

    @Override
    public boolean hit(Rectangle rect, Shape shape, boolean onStroke) {
        this.add(Command.HIT, rect, shape, onStroke);
        return this.myGraphics.hit(rect, shape, onStroke);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.myGraphics.getDeviceConfiguration();
    }

    @Override
    public void setComposite(Composite composite) {
        this.add(Command.SET_COMPOSITE, composite);
        this.myGraphics.setComposite(composite);
    }

    @Override
    public void setPaint(Paint paint) {
        this.add(Command.SET_PAINT, paint);
        this.myGraphics.setPaint(paint);
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.add(Command.SET_STROKE, stroke);
        this.myGraphics.setStroke(stroke);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hints, Object value) {
        this.add(Command.SET_RENDERING_HINT, hints, value);
        this.myGraphics.setRenderingHint(hints, value);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hints) {
        return this.myGraphics.getRenderingHint(hints);
    }

    public void setRenderingHints(Map hints) {
        this.add(Command.SET_RENDERING_HINTS, hints);
        this.myGraphics.setRenderingHints(hints);
    }

    public void addRenderingHints(Map hints) {
        this.add(Command.ADD_RENDERING_HINTS, hints);
        this.myGraphics.addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.myGraphics.getRenderingHints();
    }

    @Override
    public void translate(double x, double y) {
        this.add(Command.TRANSLATE_DOUBLE, x, y);
        this.myGraphics.translate(x, y);
    }

    @Override
    public void rotate(double theta) {
        this.add(Command.ROTATE_01, theta);
        this.myGraphics.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.add(Command.ROTATE_02, theta, x, y);
        this.myGraphics.rotate(theta, x, y);
    }

    @Override
    public void scale(double x, double y) {
        this.add(Command.SCALE, x, y);
        this.myGraphics.scale(x, y);
    }

    @Override
    public void shear(double x, double y) {
        this.add(Command.SHEAR, x, y);
        this.myGraphics.shear(x, y);
    }

    @Override
    public void transform(AffineTransform transform) {
        this.add(Command.TRANSFORM, transform);
        this.myGraphics.transform(transform);
    }

    @Override
    public void setTransform(AffineTransform transform) {
        this.add(Command.SET_TRANSFORM, transform);
        this.myGraphics.setTransform(transform);
    }

    @Override
    public AffineTransform getTransform() {
        return this.myGraphics.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.myGraphics.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.myGraphics.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        this.add(Command.SET_BACKGROUND, color);
        this.myGraphics.setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.myGraphics.getBackground();
    }

    @Override
    public Stroke getStroke() {
        return this.myGraphics.getStroke();
    }

    @Override
    public void clip(Shape shape) {
        this.add(Command.CLIP_SHAPE, shape);
        this.myGraphics.clip(shape);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.myGraphics.getFontRenderContext();
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.add(Command.CLEAR_RECT, x, y, width, height);
        this.myGraphics.clearRect(x, y, width, height);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.add(Command.COPY_AREA, x, y, width, height, dx, dy);
        this.myGraphics.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public Graphics create() {
        Graphix created = new Graphix((Graphics2D)this.myGraphics.create(), this.myRoot.myNextIndex++, this.myRoot);
        this.add(Command.CREATE, this);
        return created;
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        Graphix created = new Graphix((Graphics2D)this.myGraphics.create(x, y, width, height), this.myRoot.myNextIndex++, this.myRoot);
        this.add(Command.CREATE_INT, x, y, width, height, this);
        return created;
    }

    @Override
    public void dispose() {
        this.add(Command.DISPOSE, new Object[0]);
        this.myGraphics.dispose();
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.add(Command.DRAW_ARC, x, y, width, height, startAngle, arcAngle);
        this.myGraphics.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.add(Command.DRAW_LINE, x1, y1, x2, y2);
        this.myGraphics.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.add(Command.DRAW_OVAL, x, y, width, height);
        this.myGraphics.drawOval(x, y, width, height);
    }

    @Override
    public void drawPolygon(int[] x, int[] y, int n) {
        this.add(Command.DRAW_POLYGON, x, y, n);
        this.myGraphics.drawPolygon(x, y, n);
    }

    @Override
    public void drawPolyline(int[] x, int[] y, int n) {
        this.add(Command.DRAW_POLYLINE, x, y, n);
        this.myGraphics.drawPolyline(x, y, n);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.add(Command.DRAW_ROUND_RECT, x, y, width, height, arcWidth, arcHeight);
        this.myGraphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.add(Command.FILL_ARC, x, y, width, height, startAngle, arcAngle);
        this.myGraphics.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.add(Command.FILL_OVAL, x, y, width, height);
        this.myGraphics.fillOval(x, y, width, height);
    }

    @Override
    public void fillPolygon(int[] x, int[] y, int n) {
        this.add(Command.FILL_POLYGON, x, y, n);
        this.myGraphics.fillPolygon(x, y, n);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.add(Command.FILL_RECT, x, y, width, height);
        this.myGraphics.fillRect(x, y, width, height);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.add(Command.FILL_ROUND_RECT, x, y, width, height, arcWidth, arcHeight);
        this.myGraphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public Shape getClip() {
        return this.myGraphics.getClip();
    }

    @Override
    public Rectangle getClipBounds() {
        return this.myGraphics.getClipBounds();
    }

    @Override
    public Rectangle getClipBounds(Rectangle rect) {
        return super.getClipBounds(rect);
    }

    @Override
    public Color getColor() {
        return this.myGraphics.getColor();
    }

    @Override
    public Font getFont() {
        return this.myGraphics.getFont();
    }

    @Override
    public FontMetrics getFontMetrics() {
        return super.getFontMetrics();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.myGraphics.getFontMetrics(font);
    }

    @Override
    public void setColor(Color color) {
        this.add(Command.SET_COLOR, color);
        this.myGraphics.setColor(color);
    }

    @Override
    public void setFont(Font font) {
        this.add(Command.SET_FONT, font);
        this.myGraphics.setFont(font);
    }

    @Override
    public void setPaintMode() {
        this.add(Command.SET_PAINT_MODE, new Object[0]);
        this.myGraphics.setPaintMode();
    }

    @Override
    public void setXORMode(Color color) {
        this.add(Command.SET_XOR_MODE, color);
        this.myGraphics.setXORMode(color);
    }

    @Override
    public void translate(int x, int y) {
        this.add(Command.TRANSLATE_INT, x, y);
        this.myGraphics.translate(x, y);
    }

    @Override
    public void setClip(Shape shape) {
        this.add(Command.SET_CLIP_SHAPE, shape);
        this.myGraphics.setClip(shape);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        super.drawRect(x, y, width, height);
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        super.draw3DRect(x, y, width, height, raised);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        super.fill3DRect(x, y, width, height, raised);
    }

    @Override
    public void drawPolygon(Polygon p) {
        super.drawPolygon(p);
    }

    @Override
    public void fillPolygon(Polygon p) {
        super.fillPolygon(p);
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        super.drawChars(data, offset, length, x, y);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        super.drawBytes(data, offset, length, x, y);
    }

    @Override
    public Rectangle getClipRect() {
        return super.getClipRect();
    }

    @Override
    public void finalize() {
        super.finalize();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public boolean hitClip(int x, int y, int width, int height) {
        return super.hitClip(x, y, width, height);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.add(Command.CLIP_RECT, x, y, width, height);
        this.myGraphics.clipRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
    }

    public static Graphics2D adjustGraphics(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        return graphics;
    }

    public void play(Graphics2D graphics) {
        Vector<Graphics2D> graphicsList = new Vector<Graphics2D>();
        graphicsList.add(0, graphics);
        Iterator<Command.Operation> i$ = this.myRoot.myCommands.iterator();
        while (i$.hasNext()) {
            Command.Operation command;
            int index = (command = i$.next()).getCommand() == Command.CREATE ? ((Graphix)command.getData()[0]).myIndex : (command.getCommand() == Command.CREATE_INT ? ((Graphix)command.getData()[4]).myIndex : command.getIndex());
            Object object = command.perform((Graphics2D)graphicsList.get(index));
            if (!(object instanceof Graphics2D)) continue;
            graphicsList.add((Graphics2D)object);
        }
    }

    private void add(Command command, Object ... data) {
        this.myRoot.myCommands.add(new Command.Operation(this.myIndex, command, data));
    }
}

