/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import oracle.ide.print.misc.Ide;
import oracle.ide.print.misc.Mnemonics;
import oracle.ide.print.misc.Util;

abstract class Dialog
extends JDialog {
    private ResourceBundle myResourceBundle;
    protected static final int TINY_SIZE = 2;
    protected static final int SMALL_SIZE = 3;
    protected static final int MEDIUM_SIZE = 5;
    protected static final int LARGE_SIZE = 8;
    protected static final int HUGE_SIZE = 13;
    private static final String HELP_ACTION = "help.action";
    private static final String CANCEL_ACTION = "cancel.action";
    private static final String DEFAULT_BUTTON = "default.button";

    protected Dialog() {
    }

    protected Dialog(String title) {
        super(Ide.getIde().getMainWindow(), null, true);
        this.getContentPane().add((Component)this.createButtonPanel(), "South");
        this.setTitle(this.i18n(title));
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(1).put(stroke, CANCEL_ACTION);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Dialog.this.close();
            }
        };
        this.getRootPane().getActionMap().put(CANCEL_ACTION, action);
        stroke = KeyStroke.getKeyStroke(112, 0);
        this.getRootPane().getInputMap(1).put(stroke, HELP_ACTION);
        action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Dialog.this.showHelp();
            }
        };
        this.getRootPane().getActionMap().put(HELP_ACTION, action);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent event) {
                Dialog.this.opened();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                Dialog.this.resized();
            }
        });
    }

    Dialog(String title, boolean isResizable) {
        this(title);
        this.init(isResizable);
    }

    protected final void init(boolean isResizable) {
        this.setResizable(isResizable);
        this.getContentPane().add((Component)this.getResizable(this.getInnerComponent(), isResizable), "Center");
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = Util.round((screen.getWidth() - (double)this.getWidth()) / 2.0);
        int y = Util.round((screen.getHeight() - (double)this.getHeight()) / 2.0);
        this.setLocation(x, y);
    }

    protected void opened() {
    }

    protected void resized() {
    }

    protected JButton[] getButtons() {
        return new JButton[0];
    }

    protected Component getInnerComponent() {
        return new JPanel();
    }

    protected String getHelpTopic() {
        return null;
    }

    protected final void close() {
        this.setVisible(false);
    }

    protected final void setToolTip(Object item, String toolTip) {
        Mnemonics.setTextAndToolTip(item, null, toolTip);
    }

    private JPanel getResizable(Component component, boolean isResizable) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = isResizable ? 1 : 0;
        c.insets = new Insets(isResizable ? 0 : 5, 13, 8, 13);
        c.anchor = 18;
        panel.add(component, c);
        return panel;
    }

    protected final void setBorder(JComponent component, Color color) {
        component.setBorder(new LineBorder(color));
    }

    private JPanel createButtonPanel() {
        JButton[] buttons = this.getButtons();
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int length = buttons.length;
        if (length < 4 && this.getHelpTopic() == null) {
            c.weightx = 1.0;
            c.insets = new Insets(0, 3, 8, 8);
            c.anchor = 12;
            JPanel p = this.createButtonPanel(buttons, 0, length);
            panel.add((Component)p, c);
        } else {
            int middle = length / 2;
            if (this.getHelpTopic() != null) {
                JButton[] tmp = new JButton[length + 1];
                tmp[0] = this.createHelpButton();
                for (int i = 0; i < length; ++i) {
                    tmp[i + 1] = buttons[i];
                }
                buttons = tmp;
                middle = 1;
                ++length;
            }
            c.weightx = 1.0;
            c.insets = new Insets(0, 8, 8, 0);
            c.anchor = 18;
            JPanel p1 = this.createButtonPanel(buttons, 0, middle);
            panel.add((Component)p1, c);
            c.weightx = 0.0;
            c.insets = new Insets(0, 0, 8, 8);
            c.anchor = 12;
            JPanel p2 = this.createButtonPanel(buttons, middle, length);
            panel.add((Component)p2, c);
        }
        this.correctWidth(buttons);
        return panel;
    }

    private JPanel createButtonPanel(JButton[] buttons, int lo, int hi) {
        JPanel panel = new JPanel(new FlowLayout(2));
        for (int i = lo; i < hi; ++i) {
            panel.add(buttons[i]);
        }
        panel.doLayout();
        return panel;
    }

    private void correctWidth(JButton[] buttons) {
        int maxWidth = 0;
        for (JButton button : buttons) {
            if (button.getWidth() > maxWidth) {
                maxWidth = button.getWidth();
            }
            if (!this.isDefaultButton(button)) continue;
            this.getRootPane().setDefaultButton(button);
        }
        for (JButton button : buttons) {
            this.setWidth(button, maxWidth);
        }
    }

    private JButton createHelpButton() {
        return this.createButton(new ButtonAction(this.i18n("LBL_Help"), this.i18n("TLT_Help")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Dialog.this.showHelp();
            }
        });
    }

    protected final void showHelp() {
        Ide.getIde().showHelp(this.getHelpTopic());
    }

    protected final void markAsDefault(JButton button) {
        button.putClientProperty(DEFAULT_BUTTON, Boolean.TRUE);
    }

    private boolean isDefaultButton(JButton button) {
        return button.getClientProperty(DEFAULT_BUTTON) == Boolean.TRUE;
    }

    protected final JLabel createLabel(String message) {
        JLabel label = new JLabel();
        Mnemonics.setTextAndToolTip(label, message, null);
        return label;
    }

    protected final JPanel createTitledSeparator(String title) {
        return Ide.getIde().createSeparator(title);
    }

    protected final JRadioButton createRadioButton(String text, String toolTip) {
        JRadioButton button = new JRadioButton();
        Mnemonics.setTextAndToolTip(button, text, toolTip);
        return button;
    }

    protected final JPanel createPanel(JComponent ... components) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        for (JComponent component : components) {
            panel.add((Component)component, c);
            c.insets = new Insets(0, 8, 0, 0);
        }
        return panel;
    }

    protected final void printError(String message) {
        JOptionPane.showMessageDialog(Ide.getIde().getMainWindow(), message, this.i18n("LBL_Error"), 0);
    }

    protected final JButton createButton(Action action) {
        return (JButton)this.createAbstractButton(new JButton(), action);
    }

    protected final JCheckBox createCheckBox(Action action) {
        return (JCheckBox)this.createAbstractButton(new JCheckBox(), action);
    }

    protected final JToggleButton createToggleButton(Action action) {
        return (JToggleButton)this.createAbstractButton(new JToggleButton(), action);
    }

    private AbstractButton createAbstractButton(AbstractButton button, Action action) {
        button.setAction(action);
        Mnemonics.setTextAndToolTip(button, button.getText(), (String)action.getValue("ShortDescription"));
        return button;
    }

    protected final void setWidth(JComponent component, int width) {
        this.setSize(component, new Dimension(width, component.getPreferredSize().height));
    }

    protected final void setHeight(JComponent component, int height) {
        this.setSize(component, new Dimension(component.getPreferredSize().width, height));
    }

    private void setSize(JComponent component, Dimension dimension) {
        component.setMinimumSize(dimension);
        component.setPreferredSize(dimension);
    }

    protected final JTextArea createTextArea(String message, String title, int height) {
        JTextArea text = new JTextArea(message);
        text.setBackground(null);
        text.setEditable(false);
        text.setLineWrap(false);
        text.setBorder(new TitledBorder(title));
        this.setHeight(text, height);
        return text;
    }

    protected final JComboBox createComboBox(Object[] items) {
        return new MyComboBox(items);
    }

    protected final String i18n(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key can't be null");
        }
        String value = this.getResource().getString(key);
        if (value == null) {
            throw new IllegalArgumentException("Can't find value for key '" + key + "'");
        }
        return value;
    }

    protected final String i18n(String key, String param1, String param2) {
        return MessageFormat.format(this.i18n(key), param1, param2);
    }

    protected final String i18n(String key, String param) {
        return MessageFormat.format(this.i18n(key), param);
    }

    protected final void a11y(Component component, String name, String description) {
        if (name != null) {
            component.getAccessibleContext().setAccessibleName(name);
        }
        if (description != null) {
            component.getAccessibleContext().setAccessibleDescription(description);
        }
    }

    protected final ImageIcon icon(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Icon name can't be null");
        }
        return new ImageIcon(Dialog.class.getResource("resources/" + name + ".gif"));
    }

    private ResourceBundle getResource() {
        if (this.myResourceBundle == null) {
            this.myResourceBundle = Ide.getIde().createResourceBundle(Dialog.class.getPackage().getName() + ".Bundle", Dialog.class.getClassLoader());
        }
        return this.myResourceBundle;
    }

    private static class CornerBorder
    extends EmptyBorder {
        private Icon myIcon;
        private static final int[] DATA = new int[]{71, 73, 70, 56, 57, 97, 12, 0, 12, 0, 247, 0, 0, 131, 131, 131, 211, 211, 200, 253, 253, 253, 0, 0, 0, 33, 249, 4, 1, 0, 0, 255, 0, 44, 0, 0, 0, 0, 12, 0, 12, 0, 64, 8, 52, 0, 255, 9, 28, 72, 240, 159, 128, 129, 2, 0, 0, 48, 168, 208, 96, 65, 129, 9, 23, 30, 124, 8, 177, 33, 193, 136, 12, 37, 54, 196, 136, 145, 98, 69, 143, 29, 11, 114, 92, 136, 112, 163, 197, 140, 40, 19, 142, 212, 184, 48, 32, 0, 59};
        private static final int SIZE = 855;
        private static final int INFIX = 756;
        private static final int PREFIX = 22;

        CornerBorder() {
            super(0, 3, 3, 3);
            this.createIcon();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            this.myIcon.paintIcon(c, g, w - this.myIcon.getIconWidth(), h - this.myIcon.getIconHeight());
        }

        private void createIcon() {
            int i;
            byte[] icon = new byte[855];
            int k = 0;
            for (i = 0; i < 22; ++i) {
                icon[k++] = (byte)DATA[i];
            }
            for (i = 0; i < 756; ++i) {
                icon[k++] = 1;
            }
            for (i = 22; i < DATA.length; ++i) {
                icon[k++] = (byte)DATA[i];
            }
            this.myIcon = new ImageIcon(icon);
        }
    }

    static abstract class ButtonAction
    extends AbstractAction {
        ButtonAction(String text, String toolTip) {
            this(text, null, toolTip);
        }

        ButtonAction(Icon icon, String toolTip) {
            this(null, icon, toolTip);
        }

        ButtonAction(String text) {
            this(text, null, text);
        }

        private ButtonAction(String text, Icon icon, String toolTip) {
            super(text, icon);
            this.putValue("ShortDescription", toolTip);
        }
    }

    private static class MyComboBox
    extends JComboBox
    implements FocusListener {
        private int myIndex;
        private String myPrefix;

        public MyComboBox(Object[] items) {
            super(items);
            this.initKeyChar();
            this.addFocusListener(this);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent event) {
                    int code = event.getKeyCode();
                    if (code != 37 && code != 39) {
                        return;
                    }
                    MyComboBox.this.initKeyChar();
                    int index = MyComboBox.this.getSelectedIndex();
                    if (code == 37) {
                        if (index != 0) {
                            --index;
                        }
                    } else if (index != MyComboBox.this.getItemCount() - 1) {
                        ++index;
                    }
                    MyComboBox.this.setSelectedIndex(index);
                }
            });
        }

        @Override
        public void focusGained(FocusEvent event) {
            this.initKeyChar();
        }

        @Override
        public void focusLost(FocusEvent event) {
            this.initKeyChar();
        }

        @Override
        public boolean selectWithKeyChar(char key) {
            this.processKeyChar(key);
            this.setSelectedIndex(this.myIndex);
            return true;
        }

        private void initKeyChar() {
            this.myIndex = 0;
            this.myPrefix = "";
        }

        private void processKeyChar(char key) {
            if (key == '\b') {
                this.initKeyChar();
                return;
            }
            this.myPrefix = this.myPrefix + key;
            this.myPrefix = this.myPrefix.toLowerCase();
            for (int i = this.myIndex; i < this.getItemCount(); ++i) {
                String item = this.getItemAt(i).toString().toLowerCase();
                if (!item.startsWith(this.myPrefix)) continue;
                this.myIndex = i;
                return;
            }
        }
    }
}

