/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.explorer.CellRendererAttributes;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.model.Attributes;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.resource.ExplorerArb;
import oracle.ideimpl.explorer.ExplorerNode;
import oracle.javatools.ui.Fonts;
import oracle.javatools.ui.themes.Themes;

final class CustomTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Color inactiveBackgroundSelectionColor;
    private Color inactiveTextSelectionColor;
    private Attributes _attributes;
    private HashMap fonts = new HashMap(4);
    private boolean treeHasFocus;
    private static final Integer PLAIN_STYLE = 0;
    private static final Integer ITALIC_STYLE = 2;
    private static final Integer BOLD_STYLE = 1;
    private static final Integer BOLD_ITALIC_STYLE = 3;

    public CustomTreeCellRenderer() {
        this.inactiveBackgroundSelectionColor = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground");
        if (this.inactiveBackgroundSelectionColor == null) {
            this.inactiveBackgroundSelectionColor = this.backgroundSelectionColor;
        }
        this.inactiveTextSelectionColor = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground");
        if (this.inactiveTextSelectionColor == null) {
            this.inactiveTextSelectionColor = this.textSelectionColor;
        }
    }

    @Override
    public Color getBackgroundNonSelectionColor() {
        if (Themes.isThemed()) {
            return null;
        }
        return super.getBackgroundNonSelectionColor();
    }

    @Override
    public Color getBackground() {
        if (Themes.isThemed()) {
            return null;
        }
        return super.getBackground();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.treeHasFocus = tree.hasFocus();
        ExplorerNode tnode = (ExplorerNode)value;
        Displayable displayable = CustomTreeCellRenderer.getDisplayable(tnode);
        this.setEnabled(tree.isEnabled());
        this.setFont(this.getFont(tree, tnode));
        if (displayable != null) {
            Icon icon = displayable.getIcon();
            if (icon == null) {
                icon = ExplorerArb.getIcon((int)6);
            }
            this.setIcon(icon);
            String label = this.getShortLabel(displayable, tnode);
            this.setText(label);
            String tooltip = displayable.getToolTipText();
            if (tooltip != null) {
                this.setToolTipText(tooltip);
            }
        }
        return this;
    }

    @Override
    public Icon getDisabledIcon() {
        Icon disabledIcon = super.getDisabledIcon();
        if (disabledIcon == null) {
            Icon defaultIcon = super.getIcon();
            if (defaultIcon instanceof ImageIcon) {
                Image grayImage = GrayFilter.createDisabledImage(((ImageIcon)defaultIcon).getImage());
                return new ImageIcon(grayImage);
            }
            if (defaultIcon instanceof OverlayIcon) {
                return CustomTreeCellRenderer.createDisabledIcon((OverlayIcon)defaultIcon);
            }
            return defaultIcon;
        }
        return disabledIcon;
    }

    @Override
    public Color getBackgroundSelectionColor() {
        return this.treeHasFocus ? super.getBackgroundSelectionColor() : this.inactiveBackgroundSelectionColor;
    }

    @Override
    public Color getTextSelectionColor() {
        return this.treeHasFocus ? super.getTextSelectionColor() : this.inactiveTextSelectionColor;
    }

    private String getShortLabel(Displayable displayable, ExplorerNode tnode) {
        String label = displayable.getShortLabel();
        if (label == null) {
            label = "<null>";
        } else if (this.getAttributes().isSet(CellRendererAttributes.HIDE_FILE_EXTENSIONS)) {
            Element element = (Element)tnode.getUserObject();
            if (!element.getAttributes().isSet(ElementAttributes.DECORATES_DATA_ELEMENT)) {
                element = tnode.getData();
            }
            if (element.getAttributes().isSet(ElementAttributes.HIDE_FILE_EXTENSION)) {
                int firstDot = label.lastIndexOf(46);
                label = firstDot > 0 ? label.substring(0, firstDot) : label;
            }
        }
        return label;
    }

    protected void setAttributes(Attributes attributes) {
        this._attributes = attributes;
    }

    protected Attributes getAttributes() {
        if (this._attributes == null) {
            this._attributes = new CellRendererAttributes();
        }
        return this._attributes;
    }

    private static Displayable getDisplayable(ExplorerNode tnode) {
        ChildFilter filter = tnode.getFilter();
        if (filter != null) {
            return filter;
        }
        Element element = (Element)tnode.getUserObject();
        if (element != null && !element.getAttributes().isSet(ElementAttributes.DECORATES_DATA_ELEMENT)) {
            return tnode.getData();
        }
        return element;
    }

    private static boolean isActive(ExplorerNode tnode) {
        Element element = tnode.getData();
        return tnode.isSet(ElementAttributes.ACTIVE) || element != null && element.getAttributes().isSet(ElementAttributes.ACTIVE);
    }

    private static Icon createDisabledIcon(OverlayIcon overlayIcon) {
        Collection icons = overlayIcon.getIcons();
        ArrayList<Icon> grayIcons = new ArrayList<Icon>(icons.size());
        for (Icon icon : icons) {
            if (icon != null && icon instanceof ImageIcon) {
                icon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
            }
            grayIcons.add(icon);
        }
        return new OverlayIcon(grayIcons);
    }

    private boolean isDirty(ExplorerNode tnode) {
        Element element = tnode.getData();
        if (element == null) {
            return false;
        }
        Attributes attributes = element.getAttributes();
        if (this.getAttributes().isSet(CellRendererAttributes.HIDE_FILE_EXTENSIONS) && attributes.isSet(ElementAttributes.COMPOSITE)) {
            return attributes.isSet(ElementAttributes.DIRTY_COMPOSITE);
        }
        return attributes.isSet(ElementAttributes.DIRTY);
    }

    private boolean boldActiveNode(JTree tree) {
        return tree.hasFocus() || this.getAttributes().isSet(CellRendererAttributes.ALWAYS_BOLD_ACTIVE_NODE);
    }

    private Integer getFontStyle(JTree tree, ExplorerNode tnode) {
        boolean bold = CustomTreeCellRenderer.isActive(tnode) && this.boldActiveNode(tree);
        boolean italic = this.isDirty(tnode);
        if (bold) {
            return italic ? BOLD_ITALIC_STYLE : BOLD_STYLE;
        }
        return italic ? ITALIC_STYLE : PLAIN_STYLE;
    }

    private Font getFont(JTree tree, ExplorerNode tnode) {
        Integer style = this.getFontStyle(tree, tnode);
        Object font = this.fonts.get(style);
        if (!(font instanceof Font)) {
            font = UIManager.getFont("Oracle.dirtyFont");
            if (font == null || (style & 2) != 2) {
                font = tree.getFont();
            }
            font = Fonts.deriveFont((Font)((Font)font), (int)style, (float)((Font)font).getSize2D());
            this.fonts.put(style, font);
        }
        return (Font)font;
    }
}

