/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListenersHook;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.explorer.AbstractExplorerInfo;
import oracle.ide.explorer.Explorer;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.ExplorerInfo;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ideimpl.explorer.BaseTreeExplorer;
import oracle.ideimpl.explorer.ExplorerWindowImpl;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.GraphicsUtils;
import oracle.javatools.util.Pair;

public class ExplorerManagerImpl
extends ExplorerManager
implements Addin {
    public static final int TOGGLE_EXPLORER_CMD_ID = Ide.findOrCreateCmdID((String)"Explorer.TOGGLE_EXPLORER_CMD_ID");
    public static final String EXPLORER_WINDOW_ID = "ExplorerWindow";
    public static final String SINGLETON = "SingletonExplorerWindow";
    private static final String SUPPORTERS_PROP = "Structure.structuredViews";
    private static final CopyOnWriteArrayList<MetaClass> STRUCTURE_SUPPORTERS = new CopyOnWriteArrayList();
    private static ContextMenu CONTEXT_MENU;
    private static final Map DATA_TYPE_TO_EXPLORER_TYPES;
    private static final Map EXPLORER_TYPE_TO_VIEW_TYPES;
    private static final Map EXPLORER_TYPE_TO_CAPTION;
    private static final Map EXPLORER_TYPE_TO_ICON;
    private static final Map DOC_INSTANCE_TO_EXPLORER_INSTANCES;
    private static final Map VIEW_INSTANCE_TO_EXPLORER_INSTANCES;
    private static final Map HOST_INSTANCE_TO_EXPLORER_INSTANCES;
    private static final Map EXPLORER_INSTANCE_TO_DOC_INSTANCE;
    private static final Map EXPLORER_INSTANCE_TO_VIEW_INSTANCES;
    private static final Map EXPLORER_INSTANCE_TO_HOST_INSTANCE;
    private static final List<ExplorerInfo> DYNAMIC_INFO;
    private static final List DELAYED_ICONS;
    private static final Object DELAYED_ICON;
    private static final Object DUMMY_ICON;
    private static final Object DUMMY_CAPTION;
    private static final Class DUMMY_DATA_TYPE;
    private static final Observer DOC_LISTENER;
    private static final ViewListener HOST_LISTENER;
    private static final ViewListener VIEW_LISTENER;

    protected ExplorerManagerImpl() {
        String[] builtinSupporters;
        ExplorerManager.setExplorerManager((ExplorerManager)this);
        this.initializeMgr();
        for (String supporter : builtinSupporters = new String[]{"oracle.ide.navigator.NavigatorWindow", "oracle.ide.editor.Editor"}) {
            this.addStructureSupportForClassName(supporter);
        }
        String supporters = Ide.getProperty((String)SUPPORTERS_PROP);
        if (supporters != null) {
            StringTokenizer tokenizer = new StringTokenizer(supporters, ";");
            while (tokenizer.hasMoreTokens()) {
                String supporter = tokenizer.nextToken();
                this.addStructureSupportForClassName(supporter);
            }
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int id = action != null ? action.getCommandId() : -1;
        switch (id) {
            case 70: {
                this.selectPreviousTabPage(context);
                break;
            }
            case 71: {
                this.selectNextTabPage(context);
                break;
            }
            case 67: {
                this.newWindow(context);
                break;
            }
            default: {
                return super.handleEvent(action, context);
            }
        }
        return true;
    }

    private ExplorerWindowImpl newWindow(Context context) {
        ExplorerWindowImpl window = (ExplorerWindowImpl)this.showView(null);
        if (window != null) {
            window.setContext(context);
            DockStation.getDockStation().activateDockable((Dockable)window);
        }
        return window;
    }

    public boolean update(IdeAction action, Context context) {
        if (action == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        if (cmdId == 70) {
            View view = context.getView();
            if (view instanceof ExplorerWindowImpl) {
                ExplorerWindowImpl window = (ExplorerWindowImpl)view;
                CustomTab tabs = window.getTabs();
                action.setEnabled(tabs != null && tabs.getSelectedPage() > 0);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == 71) {
            View view = context.getView();
            if (view instanceof ExplorerWindowImpl) {
                ExplorerWindowImpl window = (ExplorerWindowImpl)view;
                CustomTab tabs = window.getTabs();
                action.setEnabled(tabs != null && tabs.getSelectedPage() < tabs.getPageCount() - 1);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        return super.update(action, context);
    }

    public void initializeMgr() {
        Menubar menuMgr;
        super.initialize();
        Object object = menuMgr = Ide.getIdeArgs().getCreateUI() ? Ide.getMenubar() : null;
        if (null == menuMgr) {
            return;
        }
        IdeAction selectAction = IdeAction.find((String)"Explorer.SELECT_IN_STRUCTURE_CMD_ID");
        JMenuItem selectInStructureMenuItem = menuMgr.createMenuItem((ToggleAction)selectAction, MenuConstants.WEIGHT_NAVIGATE_SELECT_IN_STRUCTURE);
        JMenu navigateMenu = MenuManager.getJMenu((String)"Navigate");
        menuMgr.add((Component)selectInStructureMenuItem, navigateMenu, MenuConstants.SECTION_NAVIGATE_SELECT);
    }

    protected DockableView createDockableView(Context context, ViewId viewId) {
        ExplorerWindowImpl view = new ExplorerWindowImpl(viewId.getId());
        view.setContext(context);
        return view;
    }

    protected DockableFactory getDockableFactory() {
        return null;
    }

    protected IdeAction createShowAction() {
        return IdeAction.find((String)"Ide.EXPLORER_CMD_ID");
    }

    protected String getViewCategory() {
        return EXPLORER_WINDOW_ID;
    }

    protected String getAcceleratorFile() {
        return null;
    }

    protected String getDefaultName() {
        return SINGLETON;
    }

    public DockableView showView(Context context) {
        Class explorerType;
        DockableView view = super.showView(context);
        if (view != null && context != null && (explorerType = ExplorerContext.getExplorerType((Context)context)) != null) {
            ((ExplorerWindow)view).toggleExplorer(explorerType);
        }
        return view;
    }

    protected float getToggleToolbarMenuWeight() {
        return MenuConstants.WEIGHT_VIEW_STRUCTURE;
    }

    protected IdeAction createToggleToolbarAction() {
        return IdeAction.find((String)"Explorer.TOGGLE_TOOLBAR_CMD_ID");
    }

    protected DockableView getRelativeView(Context context, ViewId viewId) {
        String name = viewId != null ? viewId.getName() : null;
        NavigatorManager mgr = NavigatorManager.getWorkspaceNavigatorManager();
        if (name != null && name.equals(this.getDefaultName())) {
            return mgr != null ? mgr.getNavigatorWindow() : null;
        }
        DockableView last = this.getLastView();
        return last != null ? last : (mgr != null ? mgr.getNavigatorWindow() : null);
    }

    protected int getOrientation(ViewId view, DockableView relative) {
        NavigatorManager mgr = NavigatorManager.getWorkspaceNavigatorManager();
        if (relative == (mgr != null ? mgr.getNavigatorWindow() : null)) {
            return 3;
        }
        if (relative == null) {
            return 0;
        }
        return 4;
    }

    public boolean supportsStructure(View view) {
        if (view != null) {
            Class<?> cls = view.getClass();
            for (MetaClass ms : STRUCTURE_SUPPORTERS) {
                try {
                    Class supporter = ms.toClass();
                    if (cls != supporter && !supporter.isAssignableFrom(cls)) continue;
                    return true;
                }
                catch (Throwable e) {
                    FeedbackManager.reportException((Throwable)e);
                    return false;
                }
            }
        }
        return false;
    }

    public void addStructureSupportForClass(MetaClass metaClass) {
        try {
            Assert.printStackTrace((metaClass.toClass() == null ? 1 : 0) != 0, (String)("Class " + metaClass.toString() + " could not be loaded!"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        STRUCTURE_SUPPORTERS.addIfAbsent(metaClass);
    }

    public void removeStructureSupportForClass(MetaClass metaClass) {
        STRUCTURE_SUPPORTERS.remove(metaClass);
    }

    private void addStructureSupportForClassName(String className) {
        this.addStructureSupportForClass(new MetaClass(((Object)((Object)this)).getClass().getClassLoader(), className));
    }

    public final synchronized ContextMenu getContextMenu() {
        if (CONTEXT_MENU == null) {
            CONTEXT_MENU = new ContextMenu();
            ContextMenuListenersHook hook = (ContextMenuListenersHook)ExtensionRegistry.getExtensionRegistry().getHook(ContextMenuListenersHook.ELEMENT);
            if (hook != null) {
                CONTEXT_MENU.addContextMenuListener(hook.getListener("explorer"));
            }
        }
        return CONTEXT_MENU;
    }

    public void register(Class dataType, Class explorerType, Class viewType) {
        this.register(dataType, explorerType, viewType, null, null);
    }

    public synchronized void register(Class dataType, Class explorerType, Class viewType, String caption, ArrayResourceBundle bundle, int key) {
        if (dataType == null || explorerType == null) {
            return;
        }
        this.register(dataType, explorerType, viewType, caption, null);
        if (bundle != null && key >= 0) {
            int subIndex;
            for (int i = DELAYED_ICONS.indexOf(explorerType); i >= 0; i += subIndex + 4) {
                if (DELAYED_ICONS.get(i + 1) == dataType) {
                    DELAYED_ICONS.remove(i);
                    DELAYED_ICONS.remove(i);
                    DELAYED_ICONS.remove(i);
                    DELAYED_ICONS.remove(i);
                    break;
                }
                subIndex = DELAYED_ICONS.subList(i + 4, DELAYED_ICONS.size()).indexOf(explorerType);
                if (subIndex < 0) break;
            }
            DELAYED_ICONS.add(explorerType);
            DELAYED_ICONS.add(dataType);
            DELAYED_ICONS.add(bundle);
            DELAYED_ICONS.add(key);
            EXPLORER_TYPE_TO_ICON.put(new Pair((Object)explorerType, (Object)dataType), DELAYED_ICON);
        }
    }

    public void register(Class dataType, Class explorerType, Class viewType, String caption, ResourceBundle bundle, String key) {
        if (dataType == null || explorerType == null) {
            return;
        }
        this.register(dataType, explorerType, viewType, caption, null);
        key = key != null ? key.trim() : null;
        String string = key = key != null && key.length() > 0 ? key : null;
        if (bundle != null && key != null) {
            int subIndex;
            for (int i = DELAYED_ICONS.indexOf(explorerType); i >= 0; i += subIndex + 4) {
                if (DELAYED_ICONS.get(i + 1) == dataType) {
                    DELAYED_ICONS.remove(i);
                    DELAYED_ICONS.remove(i);
                    DELAYED_ICONS.remove(i);
                    DELAYED_ICONS.remove(i);
                    break;
                }
                subIndex = DELAYED_ICONS.subList(i + 4, DELAYED_ICONS.size()).indexOf(explorerType);
                if (subIndex < 0) break;
            }
            DELAYED_ICONS.add(explorerType);
            DELAYED_ICONS.add(dataType);
            DELAYED_ICONS.add(bundle);
            DELAYED_ICONS.add(key);
            EXPLORER_TYPE_TO_ICON.put(new Pair((Object)explorerType, (Object)dataType), DELAYED_ICON);
        }
    }

    public void register(Class dataType, Class explorerType, Class viewType, String caption, Icon icon) {
        if (dataType == null || explorerType == null) {
            return;
        }
        if (caption == null) {
            EXPLORER_TYPE_TO_CAPTION.put(new Pair((Object)explorerType, (Object)dataType), DUMMY_CAPTION);
        } else {
            EXPLORER_TYPE_TO_CAPTION.put(new Pair((Object)explorerType, (Object)dataType), caption);
        }
        if (icon == null) {
            EXPLORER_TYPE_TO_ICON.put(new Pair((Object)explorerType, (Object)dataType), DUMMY_ICON);
        } else {
            EXPLORER_TYPE_TO_ICON.put(new Pair((Object)explorerType, (Object)dataType), icon);
        }
        List<Object> list = (ArrayList<Class>)DATA_TYPE_TO_EXPLORER_TYPES.get(dataType);
        if (list == null) {
            list = new ArrayList<Class>(5);
            list.add(explorerType);
            DATA_TYPE_TO_EXPLORER_TYPES.put(dataType, list);
        } else if (!list.contains(explorerType)) {
            list.add(explorerType);
        }
        list = (List)EXPLORER_TYPE_TO_VIEW_TYPES.get(explorerType);
        if (list == null) {
            list = new ArrayList(5);
            EXPLORER_TYPE_TO_VIEW_TYPES.put(explorerType, list);
        } else if (list.isEmpty() || list.get(0) == null) {
            return;
        }
        if (viewType == null) {
            list.clear();
            list.add(null);
        } else if (!list.contains(viewType)) {
            list.add(viewType);
        }
    }

    public void registerDynamic(ExplorerInfo info) {
        Class explorerType;
        if (info != null && !DYNAMIC_INFO.contains(info) && (explorerType = info.getExplorerType()) != null) {
            Pair key = new Pair((Object)explorerType, (Object)DUMMY_DATA_TYPE);
            DYNAMIC_INFO.add(info);
            if (info.getExplorerCaption() != null) {
                EXPLORER_TYPE_TO_CAPTION.put(key, info.getExplorerCaption());
            }
            EXPLORER_TYPE_TO_ICON.put(key, info);
        }
    }

    public void unregister(ExplorerInfo info) {
        if (info != null && DYNAMIC_INFO.contains(info)) {
            DYNAMIC_INFO.remove(info);
        }
    }

    public List getExplorerTypes(Class dataType) {
        return this.getExplorerTypes(dataType, null, null);
    }

    public List getExplorerTypes(Element node) {
        return this.getExplorerTypes(node, null);
    }

    public List getExplorerTypes(Element node, Context context) {
        if (node != null) {
            Object data = node.getData();
            if (data == null) {
                data = node;
            }
            return this.getExplorerTypes(data.getClass(), node, context);
        }
        return Collections.emptyList();
    }

    private List getExplorerTypes(Class dataType, Element node, Context context) {
        if (dataType == null) {
            return Collections.emptyList();
        }
        final HashMap<Object, Float> types = new HashMap<Object, Float>();
        List list = (List)DATA_TYPE_TO_EXPLORER_TYPES.get(dataType);
        if (list == null) {
            for (Class superType = dataType.getSuperclass(); superType != null; superType = superType.getSuperclass()) {
                list = (List)DATA_TYPE_TO_EXPLORER_TYPES.get(superType);
                if (list == null) continue;
                DATA_TYPE_TO_EXPLORER_TYPES.put(dataType, list);
                break;
            }
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                types.put(list.get(i), new Float(0.5 - (double)i * 0.01));
            }
        }
        if (node != null) {
            for (int i = 0; i < DYNAMIC_INFO.size(); ++i) {
                ExplorerInfo info = DYNAMIC_INFO.get(i);
                Class type = info.getExplorerType();
                if (type == null || types.containsKey(type)) continue;
                float weight = Float.NaN;
                if (info instanceof AbstractExplorerInfo) {
                    weight = ((AbstractExplorerInfo)info).getExplorerWeigth(node, context);
                    if (Float.isNaN(weight)) {
                        weight = info.getExplorerWeight(node);
                    }
                } else {
                    weight = info.getExplorerWeight(node);
                }
                if (Float.isNaN(weight)) continue;
                types.put(type, new Float(weight));
            }
        }
        ArrayList result = new ArrayList(types.keySet());
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                Float value1 = (Float)types.get(o1);
                Float value2 = (Float)types.get(o2);
                return Float.compare(value2.floatValue(), value1.floatValue());
            }
        });
        return result;
    }

    public Icon getExplorerIcon(Class explorerType, Class dataType) {
        Class registeredType;
        Icon icon = null;
        if (explorerType != null) {
            if (registeredType != null) {
                Pair key = new Pair((Object)explorerType, (Object)registeredType);
                for (registeredType = dataType; registeredType != null; registeredType = registeredType.getSuperclass()) {
                    key.second = registeredType;
                    icon = EXPLORER_TYPE_TO_ICON.get(key);
                    if (icon == DUMMY_ICON) {
                        Set keys = EXPLORER_TYPE_TO_ICON.keySet();
                        for (Pair pair : keys) {
                            if (pair.first != explorerType) continue;
                            icon = EXPLORER_TYPE_TO_ICON.get(pair);
                            if (icon == DUMMY_ICON || pair.second == DUMMY_DATA_TYPE) {
                                icon = null;
                                continue;
                            }
                            if (icon == null) continue;
                            registeredType = (Class)pair.second;
                            break;
                        }
                    }
                    if (icon == null) {
                        continue;
                    }
                    break;
                }
            } else {
                icon = EXPLORER_TYPE_TO_ICON.get(new Pair((Object)explorerType, (Object)DUMMY_DATA_TYPE));
                if (icon != null) {
                    dataType = DUMMY_DATA_TYPE;
                    if (icon instanceof ExplorerInfo) {
                        icon = ((ExplorerInfo)icon).getExplorerIcon();
                    }
                }
            }
        }
        if (icon == DELAYED_ICON) {
            int i;
            int subIndex;
            for (i = DELAYED_ICONS.indexOf(explorerType); i >= 0 && DELAYED_ICONS.get(i + 1) != registeredType && (subIndex = DELAYED_ICONS.subList(i + 4, DELAYED_ICONS.size()).indexOf(explorerType)) >= 0; i += subIndex + 4) {
            }
            ++i;
            ResourceBundle bundle = (ResourceBundle)DELAYED_ICONS.get(++i);
            Object key = DELAYED_ICONS.get(++i);
            if (bundle instanceof ArrayResourceBundle) {
                icon = ((ArrayResourceBundle)bundle).getIconImpl(((Integer)key).intValue());
            } else {
                try {
                    ImageIcon imageIcon;
                    Image image;
                    URL url = bundle.getClass().getResource((String)key);
                    if (url != null && (image = Toolkit.getDefaultToolkit().createImage(url)) != null && (imageIcon = GraphicsUtils.createImageIcon((Image)image)).getImageLoadStatus() == 8) {
                        icon = imageIcon;
                    }
                }
                catch (Exception e) {
                    icon = null;
                }
            }
            EXPLORER_TYPE_TO_ICON.put(new Pair((Object)explorerType, registeredType), icon);
            DELAYED_ICONS.remove(i--);
            DELAYED_ICONS.remove(i--);
            DELAYED_ICONS.remove(i--);
            DELAYED_ICONS.remove(i);
        }
        if (icon != null) {
            if (registeredType != dataType) {
                if (icon instanceof ExplorerInfo && (icon = ((ExplorerInfo)icon).getExplorerIcon()) == null) {
                    icon = OracleIcons.getIcon((String)"structure.png");
                }
                EXPLORER_TYPE_TO_ICON.put(new Pair((Object)explorerType, (Object)dataType), icon);
            }
        } else {
            icon = OracleIcons.getIcon((String)"structure.png");
            EXPLORER_TYPE_TO_ICON.put(new Pair((Object)explorerType, (Object)dataType), icon);
        }
        return icon;
    }

    public String getExplorerCaption(Class explorerType, Class dataType) {
        if (explorerType == null) {
            return null;
        }
        String caption = null;
        Class registeredType = dataType;
        if (registeredType != null) {
            Pair key = new Pair((Object)explorerType, (Object)registeredType);
            while (registeredType != null) {
                key.second = registeredType;
                caption = EXPLORER_TYPE_TO_CAPTION.get(key);
                if (caption == DUMMY_CAPTION) {
                    Set keys = EXPLORER_TYPE_TO_CAPTION.keySet();
                    for (Pair pair : keys) {
                        if (pair.first != explorerType) continue;
                        caption = EXPLORER_TYPE_TO_CAPTION.get(pair);
                        if (caption == DUMMY_CAPTION) {
                            caption = null;
                            continue;
                        }
                        if (caption == null) continue;
                        registeredType = (Class)pair.second;
                        break;
                    }
                }
                if (caption == null) {
                    registeredType = registeredType.getSuperclass();
                    continue;
                }
                break;
            }
        } else {
            caption = (String)EXPLORER_TYPE_TO_CAPTION.get(new Pair((Object)explorerType, (Object)DUMMY_DATA_TYPE));
            if (caption != null) {
                dataType = DUMMY_DATA_TYPE;
            }
        }
        if (caption != null) {
            if (registeredType != dataType) {
                EXPLORER_TYPE_TO_CAPTION.put(new Pair((Object)explorerType, (Object)dataType), caption);
            }
        } else {
            caption = explorerType.getName();
            EXPLORER_TYPE_TO_CAPTION.put(new Pair((Object)explorerType, (Object)dataType), caption);
        }
        return caption;
    }

    public Explorer getExplorerForHost(View host, Context context) {
        Node node = context != null ? context.getNode() : null;
        List<Explorer> list = this.getExplorerTypes((Element)node, context);
        if (null == list || list.isEmpty() && null == node) {
            Element element = node = null != context ? context.getElement() : null;
            if (!(node instanceof Node)) {
                list = this.getExplorerTypes((Element)node, context);
            }
        }
        if (list == null) {
            return null;
        }
        Class preferred = ExplorerContext.getExplorerType((Context)context);
        View view = context.getView();
        Class explorerType = null;
        Iterator i = list.iterator();
        if (preferred != null) {
            while (i.hasNext()) {
                if (i.next() != preferred) continue;
                explorerType = preferred;
                break;
            }
        }
        if (explorerType == null) {
            Class<?> viewType;
            Class<?> clazz = viewType = view != null ? view.getClass() : null;
            if (viewType == null) {
                return null;
            }
            for (Object e : list) {
                list = (List)EXPLORER_TYPE_TO_VIEW_TYPES.get(e);
                if (list != null && !list.isEmpty()) {
                    if (list.contains(viewType)) {
                        explorerType = (Class)e;
                        break;
                    }
                    if (explorerType != null || list.get(0) != null) continue;
                    explorerType = (Class)e;
                    continue;
                }
                if (explorerType != null) continue;
                explorerType = (Class)e;
            }
        }
        if (explorerType == null) {
            return null;
        }
        Explorer explorer = null;
        list = (List)DOC_INSTANCE_TO_EXPLORER_INSTANCES.get(node);
        if (list != null) {
            for (Object e : list) {
                if (!explorerType.isAssignableFrom(e.getClass()) || EXPLORER_INSTANCE_TO_HOST_INSTANCE.get(e) != host) continue;
                ArrayList<Object> temp = (ArrayList<Object>)EXPLORER_INSTANCE_TO_VIEW_INSTANCES.get(e);
                if (!temp.contains(view)) {
                    temp.add(view);
                    temp = (List)VIEW_INSTANCE_TO_EXPLORER_INSTANCES.get(view);
                    if (temp == null) {
                        temp = new ArrayList<Object>(5);
                        VIEW_INSTANCE_TO_EXPLORER_INSTANCES.put(view, temp);
                        view.addViewListener(VIEW_LISTENER);
                    }
                    temp.add(e);
                }
                explorer = (Explorer)e;
                break;
            }
        } else {
            list = new ArrayList(5);
            DOC_INSTANCE_TO_EXPLORER_INSTANCES.put(node, list);
            if (node instanceof Subject) {
                ((Subject)node).attach(DOC_LISTENER);
            }
        }
        if (explorer == null) {
            try {
                explorer = (Explorer)explorerType.newInstance();
                list.add(explorer);
                EXPLORER_INSTANCE_TO_DOC_INSTANCE.put(explorer, node);
                list = (List)HOST_INSTANCE_TO_EXPLORER_INSTANCES.get(host);
                if (list == null) {
                    list = new ArrayList(5);
                    HOST_INSTANCE_TO_EXPLORER_INSTANCES.put(host, list);
                    host.addViewListener(HOST_LISTENER);
                }
                list.add(explorer);
                EXPLORER_INSTANCE_TO_HOST_INSTANCE.put(explorer, host);
                explorer.setOwner(host);
                list = (List)VIEW_INSTANCE_TO_EXPLORER_INSTANCES.get(view);
                if (list == null) {
                    list = new ArrayList(5);
                    VIEW_INSTANCE_TO_EXPLORER_INSTANCES.put(view, list);
                    view.addViewListener(VIEW_LISTENER);
                }
                list.add(explorer);
                list = new ArrayList(5);
                list.add((Explorer)view);
                EXPLORER_INSTANCE_TO_VIEW_INSTANCES.put(explorer, list);
            }
            catch (Exception exception) {
                Assert.printStackTrace((Throwable)exception);
                return null;
            }
        }
        explorer.setContext(context);
        return explorer;
    }

    public TreeExplorer createTreeExplorer(Folder folder) {
        BaseTreeExplorer tree = new BaseTreeExplorer();
        if (folder != null) {
            tree.setContext(Context.newIdeContext((Element)folder));
        }
        return tree;
    }

    private void selectPreviousTabPage(Context context) {
        this.selectAdjacentTabPage(context, -1);
    }

    private void selectNextTabPage(Context context) {
        this.selectAdjacentTabPage(context, 1);
    }

    private void selectAdjacentTabPage(Context context, int direction) {
        CustomTab tabs;
        View view = context.getView();
        if (view instanceof ExplorerWindowImpl && (tabs = ((ExplorerWindowImpl)view).getTabs()) != null) {
            tabs.setSelectedPage(tabs.getSelectedPage() + direction);
        }
    }

    static {
        DATA_TYPE_TO_EXPLORER_TYPES = new ConcurrentHashMap();
        EXPLORER_TYPE_TO_VIEW_TYPES = new ConcurrentHashMap();
        EXPLORER_TYPE_TO_CAPTION = new ConcurrentHashMap();
        EXPLORER_TYPE_TO_ICON = new ConcurrentHashMap();
        DOC_INSTANCE_TO_EXPLORER_INSTANCES = new ConcurrentHashMap();
        VIEW_INSTANCE_TO_EXPLORER_INSTANCES = new ConcurrentHashMap();
        HOST_INSTANCE_TO_EXPLORER_INSTANCES = new ConcurrentHashMap();
        EXPLORER_INSTANCE_TO_DOC_INSTANCE = new ConcurrentHashMap();
        EXPLORER_INSTANCE_TO_VIEW_INSTANCES = new ConcurrentHashMap();
        EXPLORER_INSTANCE_TO_HOST_INSTANCE = new ConcurrentHashMap();
        DYNAMIC_INFO = new ArrayList<ExplorerInfo>();
        DELAYED_ICONS = new ArrayList();
        DELAYED_ICON = new Object();
        DUMMY_ICON = new Object();
        DUMMY_CAPTION = new Object();
        DUMMY_DATA_TYPE = Object.class;
        DOC_LISTENER = new DocLsnr();
        HOST_LISTENER = new HostLsnr();
        VIEW_LISTENER = new ViewLsnr();
    }

    private static class ViewLsnr
    implements ViewListener {
        private ViewLsnr() {
        }

        public void viewActivated(ViewEvent e) {
        }

        public void viewDeactivated(ViewEvent e) {
        }

        public void viewClosed(ViewEvent e) {
            View view = e.getView();
            List list = (List)VIEW_INSTANCE_TO_EXPLORER_INSTANCES.get(view);
            if (list != null) {
                for (Explorer explorer : list) {
                    Object host = EXPLORER_INSTANCE_TO_HOST_INSTANCE.get(explorer);
                    Object node = EXPLORER_INSTANCE_TO_DOC_INSTANCE.get(explorer);
                    list = (List)EXPLORER_INSTANCE_TO_VIEW_INSTANCES.get(explorer);
                    if (null != list) {
                        list.remove(view);
                        if (!list.isEmpty()) continue;
                    }
                    explorer.stateChanged(2);
                    EXPLORER_INSTANCE_TO_DOC_INSTANCE.remove(explorer);
                    EXPLORER_INSTANCE_TO_HOST_INSTANCE.remove(explorer);
                    EXPLORER_INSTANCE_TO_VIEW_INSTANCES.remove(explorer);
                    list = (List)HOST_INSTANCE_TO_EXPLORER_INSTANCES.get(host);
                    if (null != list) {
                        list.remove(explorer);
                        if (list.isEmpty()) {
                            ((View)host).removeViewListener(HOST_LISTENER);
                            HOST_INSTANCE_TO_EXPLORER_INSTANCES.remove(host);
                        }
                    }
                    if (null == (list = (List)DOC_INSTANCE_TO_EXPLORER_INSTANCES.get(node))) continue;
                    list.remove(explorer);
                    if (!list.isEmpty()) continue;
                    DOC_INSTANCE_TO_EXPLORER_INSTANCES.remove(node);
                    if (!(node instanceof Subject)) continue;
                    ((Subject)node).detach(DOC_LISTENER);
                }
                VIEW_INSTANCE_TO_EXPLORER_INSTANCES.remove(view);
            }
            view.removeViewListener((ViewListener)this);
        }
    }

    private static class HostLsnr
    implements ViewListener {
        private HostLsnr() {
        }

        public void viewActivated(ViewEvent e) {
        }

        public void viewDeactivated(ViewEvent e) {
        }

        public void viewClosed(ViewEvent e) {
            View host = e.getView();
            if (null == host) {
                return;
            }
            List list = (List)HOST_INSTANCE_TO_EXPLORER_INSTANCES.get(host);
            if (null == list) {
                return;
            }
            for (Explorer explorer : list) {
                Object node = EXPLORER_INSTANCE_TO_DOC_INSTANCE.get(explorer);
                list = (List)EXPLORER_INSTANCE_TO_VIEW_INSTANCES.get(explorer);
                explorer.stateChanged(2);
                EXPLORER_INSTANCE_TO_DOC_INSTANCE.remove(explorer);
                EXPLORER_INSTANCE_TO_HOST_INSTANCE.remove(explorer);
                EXPLORER_INSTANCE_TO_VIEW_INSTANCES.remove(explorer);
                for (Object view : list) {
                    list = (List)VIEW_INSTANCE_TO_EXPLORER_INSTANCES.get(view);
                    list.remove(explorer);
                    if (!list.isEmpty()) continue;
                    ((View)view).removeViewListener(VIEW_LISTENER);
                    VIEW_INSTANCE_TO_EXPLORER_INSTANCES.remove(view);
                }
                list = (List)DOC_INSTANCE_TO_EXPLORER_INSTANCES.get(node);
                list.remove(explorer);
                if (!list.isEmpty()) continue;
                DOC_INSTANCE_TO_EXPLORER_INSTANCES.remove(node);
                if (!(node instanceof Subject)) continue;
                ((Subject)node).detach(DOC_LISTENER);
            }
            HOST_INSTANCE_TO_EXPLORER_INSTANCES.remove(host);
            host.removeViewListener((ViewListener)this);
        }
    }

    private static class DocLsnr
    implements Observer {
        private DocLsnr() {
        }

        public void update(final Object doc, final UpdateMessage change) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    int id = change.getMessageID();
                    if (id == UpdateMessage.OBJECT_CLOSED) {
                        Iterator i;
                        List master = (List)DOC_INSTANCE_TO_EXPLORER_INSTANCES.get(doc);
                        Iterator iterator = i = master != null ? master.iterator() : null;
                        if (i == null) {
                            return;
                        }
                        while (i.hasNext()) {
                            Explorer explorer = (Explorer)i.next();
                            Object host = EXPLORER_INSTANCE_TO_HOST_INSTANCE.get(explorer);
                            List detail = (List)EXPLORER_INSTANCE_TO_VIEW_INSTANCES.get(explorer);
                            explorer.stateChanged(2);
                            EXPLORER_INSTANCE_TO_DOC_INSTANCE.remove(explorer);
                            EXPLORER_INSTANCE_TO_VIEW_INSTANCES.remove(explorer);
                            EXPLORER_INSTANCE_TO_HOST_INSTANCE.remove(explorer);
                            for (Object view : detail) {
                                detail = (List)VIEW_INSTANCE_TO_EXPLORER_INSTANCES.get(view);
                                detail.remove(explorer);
                                if (!detail.isEmpty()) continue;
                                ((View)view).removeViewListener(VIEW_LISTENER);
                                VIEW_INSTANCE_TO_EXPLORER_INSTANCES.remove(view);
                            }
                            detail = (List)HOST_INSTANCE_TO_EXPLORER_INSTANCES.get(host);
                            detail.remove(explorer);
                            if (!detail.isEmpty()) continue;
                            ((View)host).removeViewListener(HOST_LISTENER);
                            HOST_INSTANCE_TO_EXPLORER_INSTANCES.remove(host);
                        }
                        master.clear();
                        DOC_INSTANCE_TO_EXPLORER_INSTANCES.remove(doc);
                        if (doc instanceof Subject) {
                            ((Subject)doc).detach(DOC_LISTENER);
                        }
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }
}

