/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator.delete.handler;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.refactoring.DeleteActionHandler;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ide.util.Assert;
import oracle.ideimpl.navigator.ConcurrencySupport;
import oracle.ideimpl.navigator.delete.model.DeleteFileVisitor;
import oracle.ideimpl.navigator.delete.model.FileSystemModelUtils;
import oracle.ideimpl.navigator.delete.model.IdeUtils;
import oracle.ideimpl.navigator.delete.model.ProjectModel;
import oracle.ideimpl.navigator.delete.ui.IdeModelTree;
import oracle.ideimpl.navigator.delete.ui.IdeModelTreeBuilder;
import oracle.ideimpl.navigator.delete.ui.UIUtils;
import oracle.javatools.icons.OracleIcons;

public final class DeleteProjectActionHandler
extends DeleteActionHandler<Project> {
    private final Workspace m_activeWorkspace;
    private volatile boolean m_startedBuildingContentsTree = false;
    private JPanel m_detailsPanel = null;
    private JScrollPane m_detailsContents = null;
    private JLabel m_detailsHint = null;
    private volatile JTree m_contentsTree = null;
    private volatile IdeModelTree m_ideModel = null;
    private JTree m_errorTree = null;
    private static final Logger LOG = Logger.getLogger(DeleteProjectActionHandler.class.getName());

    private boolean hasError() {
        return this.m_errorTree != null;
    }

    static final void collectProjectURLsForDeletion(ProjectModel projectModel, List<URL> exclusions, Collection<URL> urlsToDelete) {
        urlsToDelete.add(projectModel.getProject().getURL());
        urlsToDelete.add(URLFactory.newFileURL((File)projectModel.getOutputDirectory()));
        for (URL url : projectModel.getContentRootDirectories()) {
            if (exclusions.contains(url)) continue;
            urlsToDelete.add(url);
        }
    }

    public static void deleteProject(Project project, List<URL> exclusions, DeleteFileVisitor deletor) {
        if (DeleteActionHandler.getDefaultDeleteStrategy().delete((Element)project)) {
            ProjectModel projectModel = new ProjectModel(project);
            ArrayList<URL> urlsToDelete = new ArrayList<URL>();
            DeleteProjectActionHandler.collectProjectURLsForDeletion(projectModel, exclusions, urlsToDelete);
            FileSystemModelUtils.deleteRecursively((URL[])urlsToDelete.toArray(new URL[urlsToDelete.size()]), (DeleteFileVisitor)deletor);
            DeleteProjectActionHandler.deleteProjectBaseIfEmpty(projectModel, deletor);
        }
    }

    static final void deleteProjectBaseIfEmpty(ProjectModel projectModel, DeleteFileVisitor deletor) {
        File baseDirectory = projectModel.getProjectBaseDirectory();
        if (baseDirectory.exists() && FileSystemModelUtils.isFolderEmpty((File)baseDirectory)) {
            FileSystemModelUtils.deleteRecursively((URL[])new URL[]{URLFactory.newFileURL((File)baseDirectory)}, (DeleteFileVisitor)deletor);
        }
    }

    public DeleteProjectActionHandler(Context context) {
        super(context);
        this.m_activeWorkspace = context.getWorkspace();
        this.setDeleteStrategy(new ProjectDeleteStrategy());
    }

    public DeleteProjectActionHandler(List<Project> projects, Workspace workspace) {
        super(projects);
        this.m_activeWorkspace = workspace;
    }

    private void buildProjectContentsTree() {
        Runnable rebuildRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    IdeModelTreeBuilder treeBuilder = new IdeModelTreeBuilder();
                    for (Project p : DeleteProjectActionHandler.this.getNodes()) {
                        treeBuilder.project(p);
                    }
                    DeleteProjectActionHandler.this.m_ideModel = treeBuilder.build();
                    DeleteProjectActionHandler.this.m_contentsTree = treeBuilder.build().getTree();
                }
                catch (Throwable t) {
                    try {
                        DeleteProjectActionHandler.this.m_errorTree = UIUtils.createErrorTree((Throwable)t);
                        DeleteProjectActionHandler.this.m_contentsTree = DeleteProjectActionHandler.this.m_errorTree;
                        LOG.log(Level.WARNING, t.toString(), t);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DeleteProjectActionHandler.this.m_detailsContents.setViewportView(DeleteProjectActionHandler.this.m_contentsTree);
                                if (DeleteProjectActionHandler.this.m_ideModel != null && DeleteProjectActionHandler.this.m_ideModel.hasOptionalItems()) {
                                    DeleteProjectActionHandler.this.m_detailsHint.setText(DeleteDialogArb.getString((int)18));
                                }
                                DeleteProjectActionHandler.this.deleteDetailsAvailable(true);
                                DeleteProjectActionHandler.this.clearStatus();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        ConcurrencySupport.getSharedExecutor().execute(rebuildRunnable);
    }

    protected Component createDeleteDetailsComponent() {
        this.m_detailsPanel = new JPanel(new GridBagLayout());
        this.m_detailsHint = new JLabel();
        this.m_detailsContents = new JScrollPane();
        this.m_detailsPanel.add((Component)this.m_detailsContents, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_detailsPanel.add((Component)this.m_detailsHint, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(4, 0, 8, 0), 0, 0));
        return this.m_detailsPanel;
    }

    protected DeleteActionHandler.DetailsTextConfig getDetailsTextConfig() {
        List projectsToBeDeleted = this.getNodes();
        DeleteActionHandler.DetailsTextConfigBuilder textConfigBuilder = new DeleteActionHandler.DetailsTextConfigBuilder().title(DeleteDialogArb.getString((int)0)).showDetails(DeleteDialogArb.getString((int)7)).hideDetails(DeleteDialogArb.getString((int)8)).confirmTitle(DeleteDialogArb.getString((int)10)).confirmMessage(DeleteDialogArb.getString((int)11));
        if (projectsToBeDeleted.size() == 1) {
            textConfigBuilder.header(MessageFormat.format(DeleteDialogArb.getString((int)1), IdeModelTree.trimExtension((String)((Project)projectsToBeDeleted.get(0)).getShortLabel()))).description(MessageFormat.format(DeleteDialogArb.getString((int)2), this.m_activeWorkspace)).options(new String[]{DeleteDialogArb.getString((int)3), DeleteDialogArb.getString((int)5)});
        } else {
            textConfigBuilder.header(MessageFormat.format(DeleteDialogArb.getString((int)14), DeleteProjectActionHandler.buildProjectList(projectsToBeDeleted.toArray(new Project[projectsToBeDeleted.size()])))).description(MessageFormat.format(DeleteDialogArb.getString((int)15), IdeModelTree.trimExtension((String)this.m_activeWorkspace.getShortLabel()))).options(new String[]{DeleteDialogArb.getString((int)16), DeleteDialogArb.getString((int)17)});
        }
        textConfigBuilder.helpTopicId("f1_idedconfirmprojectdelete_html");
        return textConfigBuilder.build();
    }

    private static String buildProjectList(Project ... projects) {
        StringBuilder sb = new StringBuilder();
        for (Project p : projects) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(IdeModelTree.trimExtension((String)p.getShortLabel()));
        }
        return sb.toString();
    }

    protected void selectedOptionChanged(DeleteActionHandler.DeleteOption deleteOption) {
        if (deleteOption == DeleteActionHandler.DeleteOption.EraseFromDisk) {
            if (!this.doneBuildingProjectContentsTree()) {
                this.deleteDetailsAvailable(false);
                this.setStatus(DeleteDialogArb.getString((int)13), OracleIcons.getIcon((String)"throbber.gif"));
                if (!this.m_startedBuildingContentsTree) {
                    this.m_startedBuildingContentsTree = true;
                    this.buildProjectContentsTree();
                }
            } else {
                this.deleteDetailsAvailable(true);
                this.clearStatus();
            }
        } else {
            super.selectedOptionChanged(deleteOption);
        }
    }

    private boolean doneBuildingProjectContentsTree() {
        return this.m_contentsTree != null;
    }

    protected boolean hasOptions() {
        return true;
    }

    protected DeleteActionHandler.DeleteOption selectedOption(int optionIndex) {
        switch (optionIndex) {
            case -1: {
                return DeleteActionHandler.DeleteOption.Cancelled;
            }
            case 0: {
                return DeleteActionHandler.DeleteOption.RemoveFromParent;
            }
            case 1: {
                return DeleteActionHandler.DeleteOption.EraseFromDisk;
            }
        }
        throw new IllegalComponentStateException("Option Selected was in an unknown state:" + optionIndex);
    }

    protected void preLaunchDialog() {
        super.preLaunchDialog();
        super.setSelectedOption(0);
    }

    private class ProjectDeleteStrategy
    extends DeleteActionHandler.DeleteStrategy<Project> {
        private ProjectDeleteStrategy() {
        }

        public boolean delete(Project project) {
            if (DeleteProjectActionHandler.this.hasError()) {
                Assert.println((String)("Failed to delete " + project.getURL().getFile() + " due to " + ((DefaultMutableTreeNode)DeleteProjectActionHandler.this.m_errorTree.getModel().getRoot()).getUserObject()));
                return false;
            }
            IdeUtils.removeFromOwner((Node)project, (Context)DeleteProjectActionHandler.this.getContext());
            DeleteFileVisitor deletor = new DeleteFileVisitor();
            DeleteProjectActionHandler.deleteProject(project, DeleteProjectActionHandler.this.m_ideModel != null ? DeleteProjectActionHandler.this.m_ideModel.getExcludedURLs() : new ArrayList(), deletor);
            this.addAllToNondeleted(deletor.getUndeleted());
            return true;
        }
    }
}

