/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator.delete.handler;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.persistence.ApplicationCacheSettings;
import oracle.ide.persistence.Storages;
import oracle.ide.refactoring.DeleteActionHandler;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ide.util.Assert;
import oracle.ideimpl.navigator.ConcurrencySupport;
import oracle.ideimpl.navigator.delete.handler.DeleteProjectActionHandler;
import oracle.ideimpl.navigator.delete.model.DeleteFileVisitor;
import oracle.ideimpl.navigator.delete.model.FileSystemModelUtils;
import oracle.ideimpl.navigator.delete.model.ProjectModel;
import oracle.ideimpl.navigator.delete.model.WorkspaceModel;
import oracle.ideimpl.navigator.delete.ui.IdeModelTree;
import oracle.ideimpl.navigator.delete.ui.IdeModelTreeBuilder;
import oracle.ideimpl.navigator.delete.ui.UIUtils;
import oracle.javatools.icons.OracleIcons;

public class DeleteWorkspaceActionHandler
extends DeleteActionHandler<Workspace> {
    private volatile IdeModelTree m_ideModel = null;
    private volatile JTree m_contentsTree = null;
    private volatile JTree m_errorTree = null;
    private JPanel m_detailsPanel = null;
    private JScrollPane m_detailsContents = null;
    private JLabel m_detailsHint = null;

    private boolean hasError() {
        return this.m_errorTree != null;
    }

    public DeleteWorkspaceActionHandler(Context context) {
        super(context);
        this.setDeleteStrategy(new WorkspaceDeleteStrategy());
    }

    public DeleteWorkspaceActionHandler(List<Workspace> workspaces) {
        super(workspaces);
    }

    private static final void collectWorkspaceURLsForDeletion(WorkspaceModel workspaceModel, Map<Project, ProjectModel> projectModels, List<URL> exclusions, Collection<URL> urlsToDelete) {
        for (Project project : workspaceModel.getProjects()) {
            DeleteProjectActionHandler.collectProjectURLsForDeletion(projectModels.get(project), exclusions, urlsToDelete);
        }
        urlsToDelete.add(workspaceModel.getWorkspace().getURL());
        ApplicationCacheSettings settings = ApplicationCacheSettings.getInstance((Workspace)workspaceModel.getWorkspace());
        URL cacheDir = settings.getStorageURL();
        URL dataDir = URLFactory.newDirURL((URL)cacheDir, (String)".data");
        urlsToDelete.add(dataDir);
        for (URL contentRootDirectoryURL : workspaceModel.getContentRootDirectories()) {
            if (exclusions.contains(contentRootDirectoryURL)) continue;
            File contentRootDirectory = FileSystemModelUtils.urlToFile((URL)contentRootDirectoryURL);
            if (!contentRootDirectory.equals(workspaceModel.getWorkspaceBaseDirectory())) {
                urlsToDelete.add(URLFactory.newFileURL((File)contentRootDirectory));
                continue;
            }
            File[] files = contentRootDirectory.listFiles();
            if (files == null) continue;
            for (File file : files) {
                if (!file.isFile()) continue;
                urlsToDelete.add(URLFactory.newFileURL((File)file));
            }
        }
    }

    private void buildWorkspaceContentsTree() {
        Runnable buildAppTreeRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IdeModelTreeBuilder treeBuilder = new IdeModelTreeBuilder();
                try {
                    for (Workspace w : DeleteWorkspaceActionHandler.this.getNodes()) {
                        treeBuilder.workspace(w);
                    }
                    DeleteWorkspaceActionHandler.this.m_ideModel = treeBuilder.build();
                    DeleteWorkspaceActionHandler.this.m_contentsTree = DeleteWorkspaceActionHandler.this.m_ideModel.getTree();
                }
                catch (Throwable t) {
                    try {
                        DeleteWorkspaceActionHandler.this.m_errorTree = UIUtils.createErrorTree((Throwable)t);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DeleteWorkspaceActionHandler.this.m_detailsContents.setViewportView(DeleteWorkspaceActionHandler.this.m_contentsTree);
                                if (DeleteWorkspaceActionHandler.this.m_ideModel != null && DeleteWorkspaceActionHandler.this.m_ideModel.hasOptionalItems()) {
                                    DeleteWorkspaceActionHandler.this.m_detailsHint.setText(DeleteDialogArb.getString((int)28));
                                }
                                DeleteWorkspaceActionHandler.this.deleteDetailsAvailable(true);
                                DeleteWorkspaceActionHandler.this.clearStatus();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        ConcurrencySupport.getSharedExecutor().execute(buildAppTreeRunnable);
    }

    protected Component createDeleteDetailsComponent() {
        this.m_detailsPanel = new JPanel(new GridBagLayout());
        this.m_detailsHint = new JLabel();
        this.m_detailsContents = new JScrollPane();
        this.m_detailsPanel.add((Component)this.m_detailsContents, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_detailsPanel.add((Component)this.m_detailsHint, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(4, 0, 8, 0), 0, 0));
        return this.m_detailsPanel;
    }

    protected DeleteActionHandler.DetailsTextConfig getDetailsTextConfig() {
        return new DeleteActionHandler.DetailsTextConfigBuilder().title(DeleteDialogArb.getString((int)19)).header(MessageFormat.format(DeleteDialogArb.getString((int)20), this.getNodes().get(0))).description(DeleteDialogArb.getString((int)21)).showDetails(DeleteDialogArb.getString((int)22)).hideDetails(DeleteDialogArb.getString((int)23)).confirmTitle(DeleteDialogArb.getString((int)25)).confirmMessage(DeleteDialogArb.getString((int)26)).helpTopicId("f1_idedconfirmdeleteapp_html").build();
    }

    protected void preLaunchDialog() {
        super.preLaunchDialog();
        this.deleteDetailsAvailable(false);
        this.setStatus(DeleteDialogArb.getString((int)27), OracleIcons.getIcon((String)"throbber.gif"));
        this.buildWorkspaceContentsTree();
    }

    private static Context newWorkspaceContext(Context baseContext) {
        Context context = new Context(baseContext);
        Workspace workspace = baseContext.getWorkspace();
        context.setNode((Node)workspace);
        context.setElement((Element)workspace);
        context.setProject(null);
        ExplorerContext.setTNodes((Context)context, (TNode[])new TNode[0]);
        return context;
    }

    private class WorkspaceDeleteStrategy
    extends DeleteActionHandler.DeleteStrategy<Workspace> {
        private WorkspaceDeleteStrategy() {
        }

        public boolean delete(Workspace node) {
            if (DeleteWorkspaceActionHandler.this.hasError()) {
                Assert.println((String)("Failed to delete " + node.getURL().getFile() + " due to " + ((DefaultMutableTreeNode)DeleteWorkspaceActionHandler.this.m_errorTree.getModel().getRoot()).getUserObject()));
                return false;
            }
            WorkspaceModel workspaceModel = new WorkspaceModel(node);
            LinkedHashMap<Project, ProjectModel> projectModels = new LinkedHashMap<Project, ProjectModel>();
            for (Project project : workspaceModel.getProjects()) {
                projectModels.put(project, new ProjectModel(project));
            }
            if (DeleteActionHandler.getDefaultDeleteStrategy().delete((Element)node)) {
                IdeAction removeAction = IdeActions.getFileRemoveFromIDENoConfirmAction();
                try {
                    removeAction.performAction(DeleteWorkspaceActionHandler.newWorkspaceContext(DeleteWorkspaceActionHandler.this.getContext()));
                }
                catch (Exception e) {
                    Assert.println((String)"Failed to remove the application from its container. Continuing ");
                    Assert.printStackTrace((Throwable)e);
                }
                List exclusions = DeleteWorkspaceActionHandler.this.m_ideModel != null ? DeleteWorkspaceActionHandler.this.m_ideModel.getExcludedURLs() : new ArrayList();
                final DeleteFileVisitor deletor = new DeleteFileVisitor();
                final HashSet urlsToDelete = new HashSet();
                DeleteWorkspaceActionHandler.collectWorkspaceURLsForDeletion(workspaceModel, projectModels, exclusions, urlsToDelete);
                Storages.getApplicationStorage((Workspace)node).runWhileClosed(new Runnable(){

                    @Override
                    public void run() {
                        FileSystemModelUtils.deleteRecursively((URL[])urlsToDelete.toArray(new URL[urlsToDelete.size()]), (DeleteFileVisitor)deletor);
                    }
                });
                for (Project project : workspaceModel.getProjects()) {
                    DeleteProjectActionHandler.deleteProjectBaseIfEmpty((ProjectModel)projectModels.get(project), deletor);
                }
                File baseDirectory = workspaceModel.getWorkspaceBaseDirectory();
                if (baseDirectory.exists() && FileSystemModelUtils.isFolderEmpty((File)baseDirectory)) {
                    FileSystemModelUtils.deleteRecursively((URL[])new URL[]{URLFactory.newFileURL((File)baseDirectory)}, (DeleteFileVisitor)deletor);
                }
                this.addAllToNondeleted(deletor.getUndeleted());
                return true;
            }
            return false;
        }
    }
}

