/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.navigator;

import java.awt.Component;
import java.util.ArrayList;
import javax.ide.util.MetaClass;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.AsynchronousController;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.refactoring.DeleteActionHandler;
import oracle.ide.refactoring.DeleteHandlerService;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.ideimpl.navigator.RefreshSupport;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.SwingUtils;

final class NavigatorController
extends AsynchronousController {
    public NavigatorController() {
        super(true);
    }

    public final boolean handleEvent(IdeAction action, Context context) {
        if (super.handleEvent(action, context)) {
            return true;
        }
        if (action == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        if (cmdId == 67) {
            NavigatorWindow navWin;
            NavigatorManager navMgr;
            View view;
            if (context != null && (view = context.getView()) instanceof NavigatorWindow && (navMgr = (navWin = (NavigatorWindow)view).getManager()) != null) {
                navMgr.showView(context);
            }
            return true;
        }
        if (cmdId == 5) {
            try {
                CommandProcessor.getInstance().undo(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        if (cmdId == 6) {
            try {
                CommandProcessor.getInstance().redo(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    @AsynchronousController.Handler(ids={20})
    public boolean handleDelete(IdeAction action, Context context, AsynchronousController.TaskInfo info) {
        Command command;
        CommandProcessor cmdProc;
        block19: {
            MetaClass mc;
            block18: {
                cmdProc = CommandProcessor.getInstance();
                command = null;
                DeleteActionHandler deleteHandler = DeleteHandlerService.createDeleteHandler((Context)context);
                if (deleteHandler == null) break block18;
                DeleteActionHandler.DeleteOption deleteOption = deleteHandler.clarifyToDeleteOrToRemoveFromParentContainer((Component)Ide.getMainWindow());
                switch (deleteOption) {
                    case EraseFromDisk: {
                        MetaClass mc2;
                        context.setProperty(DeleteActionHandler.class.getName(), (Object)deleteHandler);
                        IdeAction removeFromDiskAction = IdeActions.getFileRemoveFromDiskAction();
                        if (removeFromDiskAction != null && (mc2 = removeFromDiskAction.getCommandMetaClass()) != null) {
                            command = CommandProcessor.createCommandFromMeta((MetaClass)mc2, (Context)context);
                            break;
                        }
                        break block19;
                    }
                    case RemoveFromParent: {
                        MetaClass mc3;
                        IdeAction removeFileAction = IdeAction.find((int)21);
                        if (removeFileAction != null && (mc3 = removeFileAction.getCommandMetaClass()) != null) {
                            command = CommandProcessor.createCommandFromMeta((MetaClass)mc3, (Context)context);
                            break;
                        }
                        break block19;
                    }
                    case Cancelled: {
                        return true;
                    }
                    default: {
                        throw new IllegalStateException("invalid enum value: " + deleteOption);
                    }
                }
                break block19;
            }
            TNode[] tnodes = ExplorerContext.getTNodes((Context)context);
            ArrayList<Element> nonDeleteFiles = new ArrayList<Element>();
            if (tnodes != null) {
                for (int i = 0; i < tnodes.length; ++i) {
                    TNode tnode = tnodes[i];
                    Element element = tnode.getData();
                    if (!(element instanceof Project) && !(element instanceof Workspace)) continue;
                    nonDeleteFiles.add(element);
                }
            }
            if (nonDeleteFiles.size() == 0) {
                IdeAction removeFromDiskAction = IdeActions.getFileRemoveFromDiskAction();
                if (removeFromDiskAction != null && (mc = removeFromDiskAction.getCommandMetaClass()) != null) {
                    command = CommandProcessor.createCommandFromMeta((MetaClass)mc, (Context)context);
                }
            } else if (MessageDialog.optionalConfirm((String)"oracle.ideri.NavigatorController.deleteRemove", (Component)SwingUtils.getMainWindow(), (Object)IdeArb.getString((int)456), (String)IdeArb.getString((int)457), null)) {
                IdeAction removeFileAction = IdeAction.find((int)21);
                if (removeFileAction != null && (mc = removeFileAction.getCommandMetaClass()) != null) {
                    command = CommandProcessor.createCommandFromMeta((MetaClass)mc, (Context)context);
                }
            } else {
                return true;
            }
        }
        if (command != null) {
            try {
                cmdProc.invoke(command);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    @AsynchronousController.Handler(ids={51})
    public boolean handleRefresh(IdeAction action, Context context, AsynchronousController.TaskInfo info) {
        if (context != null) {
            RefreshSupport.refresh(context, info);
            return true;
        }
        return false;
    }

    public final boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 20 || cmdId == 47 || cmdId == 21) {
            boolean enabled = false;
            if (context != null && !ExplorerContext.hasNonSiblingTNodes((Context)context)) {
                TNode[] tnodes = ExplorerContext.getTNodes((Context)context);
                if (tnodes != null && tnodes.length > 0) {
                    enabled = true;
                    for (int i = 0; i < tnodes.length; ++i) {
                        TNode tnode = tnodes[i];
                        if (tnode != null && !tnode.isRoot()) {
                            Element element = tnode.getData();
                            boolean canDelete = element.getAttributes().isSet(ElementAttributes.DELETEABLE);
                            boolean canErase = element.getAttributes().isSet(ElementAttributes.ERASEABLE);
                            boolean canRemove = element.getAttributes().isSet(ElementAttributes.REMOVEABLE);
                            if (!(canDelete || canErase || canRemove)) {
                                enabled = false;
                            } else {
                                if (element instanceof Node || element instanceof RelativeDirectoryContextFolder) {
                                    enabled = cmdId == 21 && (canDelete || canRemove) ? true : (cmdId == 47 && (canDelete || canErase) ? true : cmdId == 20 && (canDelete || canErase));
                                } else if (cmdId == 21) {
                                    enabled = false;
                                } else if (cmdId == 47) {
                                    enabled = false;
                                } else if (canDelete) {
                                    enabled = true;
                                }
                                if (enabled) {
                                    Folder parentFolder = null;
                                    TNode parNode = (TNode)tnode.getParent();
                                    if (parNode != null) {
                                        parentFolder = (Folder)parNode.getAncestor(Folder.class, true);
                                    }
                                    if (parentFolder != null && element != null && parentFolder.canRemove(element)) continue;
                                }
                            }
                        } else {
                            enabled = false;
                        }
                        break;
                    }
                } else {
                    Element[] selection = context.getSelection();
                    enabled = selection != null && selection.length > 0 && selection[0] instanceof Workspace;
                }
            }
            action.setEnabled(enabled);
            return true;
        }
        if (cmdId == 51) {
            TNode[] tnodes;
            boolean enabled = false;
            if (context != null && context.getProject() != null && (tnodes = ExplorerContext.getTNodes((Context)context)) != null && tnodes.length > 0) {
                TreeExplorer treeExplorer = tnodes[0].getOwner();
                enabled = treeExplorer != null ? treeExplorer.canRefresh(tnodes[0], Project.class) : false;
            }
            action.setEnabled(enabled);
            return true;
        }
        if (cmdId == 67) {
            boolean enabled = false;
            action.setEnabled(enabled);
            return true;
        }
        if (cmdId == 5) {
            CommandProcessor cp = CommandProcessor.getInstance();
            action.setEnabled(cp != null ? cp.canUndo(null) : false);
            action.putValue("Name", (Object)StringUtils.stripMnemonic((String)IdeArb.format((int)80, (Object)(cp != null ? cp.getUndoLabel(null) : ""))));
            return true;
        }
        if (cmdId == 6) {
            CommandProcessor cp = CommandProcessor.getInstance();
            action.setEnabled(cp != null ? cp.canRedo(null) : false);
            action.putValue("Name", (Object)StringUtils.stripMnemonic((String)IdeArb.format((int)83, (Object)(cp != null ? cp.getRedoLabel(null) : ""))));
            return true;
        }
        return false;
    }
}

