/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.sql.SQLException;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.ref.CachedStatement;
import sqlj.runtime.profile.ref.CachedStatementProfile;
import sqlj.runtime.profile.ref.ExecuteEventListener;
import sqlj.runtime.profile.ref.ProfileWrapper;

public class CachedStatementProfileHelper
extends ProfileWrapper
implements CachedStatementProfile {
    public CachedStatementProfileHelper(ConnectedProfile connectedProfile) {
        super(connectedProfile);
    }

    public CachedStatement getCachedStatement(int n) throws SQLException {
        return this.cacheStatement(this.getStatement(n));
    }

    public CachedStatement getCachedStatement(int n, BatchContext batchContext) throws SQLException {
        return this.cacheStatement(this.getStatement(n, batchContext));
    }

    protected CachedStatement cacheStatement(RTStatement rTStatement) {
        return new CachedStatementHelper(rTStatement);
    }

    public static class CachedStatementHelper
    implements CachedStatement {
        private RTStatement m_stmt;

        public CachedStatementHelper(RTStatement rTStatement) {
            this.m_stmt = rTStatement;
        }

        public boolean isReusable() {
            return false;
        }

        public void releaseStatement() {
        }

        public RTStatement getStatement(ExecuteEventListener executeEventListener) {
            RTStatement rTStatement = this.m_stmt;
            this.m_stmt = null;
            return rTStatement;
        }

        public RTStatement getStatement(ExecuteEventListener executeEventListener, BatchContext batchContext) {
            RTStatement rTStatement = this.m_stmt;
            this.m_stmt = null;
            return rTStatement;
        }
    }
}

