/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import sqlj.runtime.SQLNullException;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.ref.RTCallableStatement;
import sqlj.runtime.profile.ref.RTStatementJDBCBase;

public class RTStatementJDBCCallable
extends RTStatementJDBCBase
implements RTCallableStatement {
    public RTStatementJDBCCallable(CallableStatement callableStatement, Connection connection, Map map, EntryInfo entryInfo) {
        this(callableStatement, connection, true, map, entryInfo);
    }

    public RTStatementJDBCCallable(CallableStatement callableStatement, Connection connection, BatchContext batchContext, Map map, EntryInfo entryInfo) {
        this(callableStatement, connection, true, batchContext, map, entryInfo);
    }

    public RTStatementJDBCCallable(CallableStatement callableStatement, Connection connection, boolean bl, Map map, EntryInfo entryInfo) {
        super((PreparedStatement)callableStatement, connection, bl, map, entryInfo);
        this.callableStmt = callableStatement;
    }

    public RTStatementJDBCCallable(CallableStatement callableStatement, Connection connection, boolean bl, BatchContext batchContext, Map map, EntryInfo entryInfo) {
        super(callableStatement, connection, bl, batchContext, map, entryInfo);
        this.callableStmt = callableStatement;
    }

    public CallableStatement getJDBCCallableStatement() {
        return this.callableStmt;
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        if (this.callableStmt == null) {
            this.m_command.set(-23710, n, new Integer(n2));
        } else {
            this.callableStmt.registerOutParameter(n, n2);
        }
    }

    public String getString(int n) throws SQLException {
        return this.callableStmt.getString(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.callableStmt.getBytes(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
    }

    public Blob getBlob(int n) throws SQLException {
        return this.callableStmt.getBlob(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
    }

    public Clob getClob(int n) throws SQLException {
        return this.callableStmt.getClob(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
    }

    public Ref getRef(int n) throws SQLException {
        return this.callableStmt.getRef(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
    }

    public Date getDate(int n) throws SQLException {
        return this.callableStmt.getDate(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
    }

    public Time getTime(int n) throws SQLException {
        return this.callableStmt.getTime(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.callableStmt.getTimestamp(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
    }

    public boolean getBooleanNoNull(int n) throws SQLException {
        boolean bl = this.callableStmt.getBoolean(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
        if (this.callableStmt.wasNull()) {
            throw new SQLNullException();
        }
        return bl;
    }

    public byte getByteNoNull(int n) throws SQLException {
        byte by = this.callableStmt.getByte(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
        if (this.callableStmt.wasNull()) {
            throw new SQLNullException();
        }
        return by;
    }

    public short getShortNoNull(int n) throws SQLException {
        short s = this.callableStmt.getShort(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
        if (this.callableStmt.wasNull()) {
            throw new SQLNullException();
        }
        return s;
    }

    public int getIntNoNull(int n) throws SQLException {
        int n2 = this.callableStmt.getInt(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
        if (this.callableStmt.wasNull()) {
            throw new SQLNullException();
        }
        return n2;
    }

    public long getLongNoNull(int n) throws SQLException {
        long l = this.callableStmt.getLong(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
        if (this.callableStmt.wasNull()) {
            throw new SQLNullException();
        }
        return l;
    }

    public float getFloatNoNull(int n) throws SQLException {
        float f = this.callableStmt.getFloat(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
        if (this.callableStmt.wasNull()) {
            throw new SQLNullException();
        }
        return f;
    }

    public double getDoubleNoNull(int n) throws SQLException {
        double d = this.callableStmt.getDouble(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
        if (this.callableStmt.wasNull()) {
            throw new SQLNullException();
        }
        return d;
    }

    public Boolean getBooleanWrapper(int n) throws SQLException {
        boolean bl = this.callableStmt.getBoolean(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
        return this.callableStmt.wasNull() ? null : new Boolean(bl);
    }

    public Byte getByteWrapper(int n) throws SQLException {
        byte by = this.callableStmt.getByte(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
        return this.callableStmt.wasNull() ? null : new Byte(by);
    }

    public Short getShortWrapper(int n) throws SQLException {
        short s = this.callableStmt.getShort(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
        return this.callableStmt.wasNull() ? null : new Short(s);
    }

    public Integer getIntWrapper(int n) throws SQLException {
        int n2 = this.callableStmt.getInt(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
        return this.callableStmt.wasNull() ? null : new Integer(n2);
    }

    public Long getLongWrapper(int n) throws SQLException {
        long l = this.callableStmt.getLong(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
        return this.callableStmt.wasNull() ? null : new Long(l);
    }

    public Float getFloatWrapper(int n) throws SQLException {
        float f = this.callableStmt.getFloat(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
        return this.callableStmt.wasNull() ? null : new Float(f);
    }

    public Double getDoubleWrapper(int n) throws SQLException {
        double d = this.callableStmt.getDouble(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1]);
        return this.callableStmt.wasNull() ? null : new Double(d);
    }

    public Object getObject(int n, Class clazz) throws SQLException {
        Object object;
        n = this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1];
        int n2 = this.m_entryInfo.getParamInfo(n).getSQLType();
        if (n2 == 2002 || n2 == 2001 || n2 == 2000) {
            object = this.callableStmt.getObject(n, this.m_typeMap);
        } else {
            object = this.callableStmt.getObject(n);
            RTStatementJDBCCallable.checkObjectClass(object, clazz);
        }
        return object;
    }

    public static void checkObjectClass(Object object, Class clazz) throws SQLException {
        if (object == null) {
            return;
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            ProfileRefErrors.raise_INCOMPATIBLE_TYPE(clazz, object.getClass());
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return (BigDecimal)this.getObject(this.m_command == null ? n : (Integer)this.m_entryInfo.getMetaBinds()[n - 1], BigDecimal.class);
    }
}

