/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import jline.CandidateListCompletionHandler;
import jline.CompletionHandler;
import jline.Completor;
import jline.ConsoleOperations;
import jline.CursorBuffer;
import jline.History;
import jline.Terminal;

public class ConsoleReader
implements ConsoleOperations {
    String prompt;
    private boolean useHistory = true;
    public static final String CR = System.getProperty("line.separator");
    public static SortedMap KEYMAP_NAMES;
    private final short[] keybindings;
    private boolean bellEnabled = true;
    private Character mask = null;
    private static final Character NULL_MASK;
    private int autoprintThreshhold = Integer.getInteger("jline.completion.threshold", 100);
    private final Terminal terminal;
    private CompletionHandler completionHandler = new CandidateListCompletionHandler();
    InputStream in;
    final Writer out;
    final CursorBuffer buf = new CursorBuffer();
    static PrintWriter debugger;
    History history = new History();
    final List completors = new LinkedList();
    private Character echoCharacter = null;
    static /* synthetic */ Class class$jline$ConsoleReader;

    public ConsoleReader() throws IOException {
        this(new FileInputStream(FileDescriptor.in), new PrintWriter(System.out));
    }

    public ConsoleReader(InputStream in, Writer out) throws IOException {
        this(in, out, null);
    }

    public ConsoleReader(InputStream in, Writer out, InputStream bindings) throws IOException {
        this(in, out, bindings, Terminal.getTerminal());
    }

    public ConsoleReader(InputStream in, Writer out, InputStream bindings, Terminal term) throws IOException {
        this.terminal = term;
        this.setInput(in);
        this.out = out;
        if (bindings == null) {
            String bindingFile = System.getProperty("jline.keybindings", new File(System.getProperty("user.home", ".jlinebindings.properties")).getAbsolutePath());
            bindings = !new File(bindingFile).isFile() ? (class$jline$ConsoleReader == null ? (class$jline$ConsoleReader = ConsoleReader.class$("jline.ConsoleReader")) : class$jline$ConsoleReader).getResourceAsStream("keybindings.properties") : new FileInputStream(new File(bindingFile));
        }
        this.keybindings = new short[254];
        Arrays.fill(this.keybindings, (short)-99);
        if (bindings != null) {
            Properties p = new Properties();
            p.load(bindings);
            bindings.close();
            Iterator<Object> i = p.keySet().iterator();
            while (i.hasNext()) {
                String val = (String)i.next();
                try {
                    Short code = new Short(val);
                    String op = p.getProperty(val);
                    Short opval = (Short)KEYMAP_NAMES.get(op);
                    if (opval == null) continue;
                    this.keybindings[code.shortValue()] = opval;
                }
                catch (NumberFormatException nfe) {
                    this.consumeException(nfe);
                }
            }
        }
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public void setDebug(PrintWriter debugger) {
        ConsoleReader.debugger = debugger;
    }

    public void setInput(InputStream in) {
        this.in = in;
    }

    public InputStream getInput() {
        return this.in;
    }

    public String readLine() throws IOException {
        return this.readLine((String)null);
    }

    public String readLine(Character mask) throws IOException {
        return this.readLine(null, mask);
    }

    public void setBellEnabled(boolean bellEnabled) {
        this.bellEnabled = bellEnabled;
    }

    public boolean getBellEnabled() {
        return this.bellEnabled;
    }

    public int getTermwidth() {
        return Terminal.setupTerminal().getTerminalWidth();
    }

    public int getTermheight() {
        return Terminal.setupTerminal().getTerminalHeight();
    }

    public void setAutoprintThreshhold(int autoprintThreshhold) {
        this.autoprintThreshhold = autoprintThreshhold;
    }

    public int getAutoprintThreshhold() {
        return this.autoprintThreshhold;
    }

    int getKeyForAction(short logicalAction) {
        for (int i = 0; i < this.keybindings.length; ++i) {
            if (this.keybindings[i] != logicalAction) continue;
            return i;
        }
        return -1;
    }

    int clearEcho(int c) throws IOException {
        if (!this.terminal.getEcho()) {
            return 0;
        }
        int num = this.countEchoCharacters((char)c);
        this.back(num);
        this.drawBuffer(num);
        return num;
    }

    int countEchoCharacters(char c) {
        if (c == '\t') {
            int tabstop = 8;
            int position = this.getCursorPosition();
            return tabstop - position % tabstop;
        }
        return this.getPrintableCharacters(c).length();
    }

    StringBuffer getPrintableCharacters(char ch) {
        StringBuffer sbuff = new StringBuffer();
        if (ch >= ' ') {
            if (ch < '\u007f') {
                sbuff.append(ch);
            } else if (ch == '\u007f') {
                sbuff.append('^');
                sbuff.append('?');
            } else {
                sbuff.append('M');
                sbuff.append('-');
                if (ch >= '\u00a0') {
                    if (ch < '\u00ff') {
                        sbuff.append((char)(ch - 128));
                    } else {
                        sbuff.append('^');
                        sbuff.append('?');
                    }
                } else {
                    sbuff.append('^');
                    sbuff.append((char)(ch - 128 + 64));
                }
            }
        } else {
            sbuff.append('^');
            sbuff.append((char)(ch + 64));
        }
        return sbuff;
    }

    int getCursorPosition() {
        return (this.prompt == null ? 0 : this.prompt.length()) + this.buf.cursor;
    }

    public String readLine(String prompt) throws IOException {
        return this.readLine(prompt, null);
    }

    public void setDefaultPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getDefaultPrompt() {
        return this.prompt;
    }

    public String readLine(String prompt, Character mask) throws IOException {
        this.mask = mask;
        if (prompt != null) {
            this.prompt = prompt;
        }
        try {
            this.terminal.beforeReadLine(this, prompt, mask);
            if (prompt != null && prompt.length() > 0) {
                this.out.write(prompt);
                this.out.flush();
            }
            if (!this.terminal.isSupported()) {
                String string = this.readLine(this.in);
                return string;
            }
            while (true) {
                int[] next;
                if ((next = this.readBinding()) == null) {
                    String string = null;
                    return string;
                }
                int c = next[0];
                int code = next[1];
                if (c == -1) {
                    String string = null;
                    return string;
                }
                boolean success = true;
                switch (code) {
                    case -59: {
                        if (this.buf.buffer.length() == 0) {
                            String string = null;
                            return string;
                        }
                    }
                    case -58: {
                        success = this.complete();
                        break;
                    }
                    case -1: {
                        success = this.setCursorPosition(0);
                        break;
                    }
                    case -7: {
                        success = this.killLine();
                        break;
                    }
                    case -8: {
                        success = this.clearScreen();
                        break;
                    }
                    case -15: {
                        success = this.resetLine();
                        break;
                    }
                    case -6: {
                        this.printNewline();
                        String string = this.finishBuffer();
                        return string;
                    }
                    case -41: {
                        success = this.backspace();
                        break;
                    }
                    case -3: {
                        success = this.moveToEnd();
                        break;
                    }
                    case -4: {
                        success = this.moveCursor(-1) != 0;
                        break;
                    }
                    case -19: {
                        success = this.moveCursor(1) != 0;
                        break;
                    }
                    case -9: {
                        success = this.moveHistory(true);
                        break;
                    }
                    case -11: {
                        success = this.moveHistory(false);
                        break;
                    }
                    case -13: {
                        break;
                    }
                    case -60: {
                        success = this.paste();
                        break;
                    }
                    case -16: {
                        success = this.deletePreviousWord();
                        break;
                    }
                    case -43: {
                        success = this.previousWord();
                        break;
                    }
                    case -55: {
                        success = this.nextWord();
                        break;
                    }
                    default: {
                        this.putChar(c, true);
                    }
                }
                if (!success) {
                    this.beep();
                }
                this.flushConsole();
            }
        }
        finally {
            this.terminal.afterReadLine(this, prompt, mask);
        }
    }

    private String readLine(InputStream in) throws IOException {
        StringBuffer buf = new StringBuffer();
        int i;
        while ((i = in.read()) != -1 && i != 10 && i != 13) {
            buf.append((char)i);
        }
        return buf.toString();
    }

    private int[] readBinding() throws IOException {
        int c = this.readVirtualKey();
        if (c == -1) {
            return null;
        }
        int code = this.keybindings[c];
        if (debugger != null) {
            ConsoleReader.debug("    translated: " + c + ": " + code);
        }
        return new int[]{c, code};
    }

    private final boolean moveHistory(boolean next) throws IOException {
        if (next && !this.history.next()) {
            return false;
        }
        if (!next && !this.history.previous()) {
            return false;
        }
        this.setBuffer(this.history.current());
        return true;
    }

    public boolean paste() throws IOException {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard == null) {
            return false;
        }
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return false;
        }
        try {
            String value;
            Object content = transferable.getTransferData(DataFlavor.plainTextFlavor);
            if (content == null) {
                try {
                    content = new DataFlavor().getReaderForText(transferable);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (content == null) {
                return false;
            }
            if (content instanceof Reader) {
                value = "";
                String line = null;
                BufferedReader read = new BufferedReader((Reader)content);
                while ((line = read.readLine()) != null) {
                    if (value.length() > 0) {
                        value = value + "\n";
                    }
                    value = value + line;
                }
            } else {
                value = content.toString();
            }
            if (value == null) {
                return true;
            }
            this.putString(value);
            return true;
        }
        catch (UnsupportedFlavorException ufe) {
            if (debugger != null) {
                ConsoleReader.debug(ufe + "");
            }
            return false;
        }
    }

    public boolean killLine() throws IOException {
        int cp = this.buf.cursor;
        int len = this.buf.buffer.length();
        if (cp >= len) {
            return false;
        }
        int num = this.buf.buffer.length() - cp;
        this.clearAhead(num);
        for (int i = 0; i < num; ++i) {
            this.buf.buffer.deleteCharAt(len - i - 1);
        }
        return true;
    }

    public boolean clearScreen() throws IOException {
        if (!this.terminal.isANSISupported()) {
            return false;
        }
        this.printString("\u001b[2J");
        this.flushConsole();
        this.printString("\u001b[1;1H");
        this.flushConsole();
        this.redrawLine();
        return true;
    }

    private final boolean complete() throws IOException {
        Completor comp;
        if (this.completors.size() == 0) {
            return false;
        }
        LinkedList candidates = new LinkedList();
        String bufstr = this.buf.buffer.toString();
        int cursor = this.buf.cursor;
        int position = -1;
        Iterator i = this.completors.iterator();
        while (i.hasNext() && (position = (comp = (Completor)i.next()).complete(bufstr, cursor, candidates)) == -1) {
        }
        if (candidates.size() == 0) {
            return false;
        }
        return this.completionHandler.complete(this, candidates, position);
    }

    public CursorBuffer getCursorBuffer() {
        return this.buf;
    }

    public void printColumns(Collection stuff) throws IOException {
        if (stuff == null || stuff.size() == 0) {
            return;
        }
        int width = this.getTermwidth();
        int maxwidth = 0;
        Iterator i = stuff.iterator();
        while (i.hasNext()) {
            maxwidth = Math.max(maxwidth, i.next().toString().length());
        }
        StringBuffer line = new StringBuffer();
        Iterator i2 = stuff.iterator();
        while (i2.hasNext()) {
            String cur = (String)i2.next();
            if (line.length() + maxwidth > width) {
                this.printString(line.toString().trim());
                this.printNewline();
                line.setLength(0);
            }
            this.pad(cur, maxwidth + 3, line);
        }
        if (line.length() > 0) {
            this.printString(line.toString().trim());
            this.printNewline();
            line.setLength(0);
        }
    }

    private final void pad(String toPad, int len, StringBuffer appendTo) {
        appendTo.append(toPad);
        for (int i = 0; i < len - toPad.length(); ++i) {
            appendTo.append(' ');
        }
    }

    public boolean addCompletor(Completor completor) {
        return this.completors.add(completor);
    }

    public boolean removeCompletor(Completor completor) {
        return this.completors.remove(completor);
    }

    public Collection getCompletors() {
        return Collections.unmodifiableList(this.completors);
    }

    final boolean resetLine() throws IOException {
        if (this.buf.cursor == 0) {
            return false;
        }
        this.backspaceAll();
        return true;
    }

    public final boolean setCursorPosition(int position) throws IOException {
        return this.moveCursor(position - this.buf.cursor) != 0;
    }

    private final void setBuffer(String buffer) throws IOException {
        if (buffer.equals(this.buf.buffer.toString())) {
            return;
        }
        int sameIndex = 0;
        int l1 = buffer.length();
        int l2 = this.buf.buffer.length();
        for (int i = 0; i < l1 && i < l2 && buffer.charAt(i) == this.buf.buffer.charAt(i); ++i) {
            ++sameIndex;
        }
        int diff = this.buf.buffer.length() - sameIndex;
        this.backspace(diff);
        this.killLine();
        this.buf.buffer.setLength(sameIndex);
        this.putString(buffer.substring(sameIndex));
    }

    public final void redrawLine() throws IOException {
        this.printCharacter(13);
        this.flushConsole();
        this.drawLine();
    }

    public final void drawLine() throws IOException {
        if (this.prompt != null) {
            this.printString(this.prompt);
        }
        this.printString(this.buf.buffer.toString());
    }

    public final void printNewline() throws IOException {
        this.printString(CR);
        this.flushConsole();
    }

    final String finishBuffer() {
        String str = this.buf.buffer.toString();
        if (str.length() > 0) {
            if (this.mask == null && this.useHistory) {
                this.history.addToHistory(str);
            } else {
                this.mask = null;
            }
        }
        this.history.moveToEnd();
        this.buf.buffer.setLength(0);
        this.buf.cursor = 0;
        return str;
    }

    public final void putString(String str) throws IOException {
        this.buf.insert(str);
        this.printString(str);
        this.drawBuffer();
    }

    public final void printString(String str) throws IOException {
        this.printCharacters(str.toCharArray());
    }

    private final void putChar(int c, boolean print) throws IOException {
        this.buf.insert((char)c);
        if (print) {
            if (this.mask == null) {
                this.printCharacter(c);
            } else if (this.mask.charValue() != '\u0000') {
                this.printCharacter(this.mask.charValue());
            }
            this.drawBuffer();
        }
    }

    private final void drawBuffer(int clear) throws IOException {
        char[] chars = this.buf.buffer.substring(this.buf.cursor).toCharArray();
        this.printCharacters(chars);
        this.clearAhead(clear);
        this.back(chars.length);
        this.flushConsole();
    }

    private final void drawBuffer() throws IOException {
        this.drawBuffer(0);
    }

    private final void clearAhead(int num) throws IOException {
        if (num == 0) {
            return;
        }
        this.printCharacters(' ', num);
        this.flushConsole();
        this.back(num);
        this.flushConsole();
    }

    private final void back(int num) throws IOException {
        this.printCharacters('\b', num);
        this.flushConsole();
    }

    public final void beep() throws IOException {
        if (!this.getBellEnabled()) {
            return;
        }
        this.printCharacter(7);
        this.flushConsole();
    }

    private final void printCharacter(int c) throws IOException {
        this.out.write(c);
    }

    private final void printCharacters(char[] c) throws IOException {
        this.out.write(c);
    }

    private final void printCharacters(char c, int num) throws IOException {
        if (num == 1) {
            this.printCharacter(c);
        } else {
            char[] chars = new char[num];
            Arrays.fill(chars, c);
            this.printCharacters(chars);
        }
    }

    public final void flushConsole() throws IOException {
        this.out.flush();
    }

    private final int backspaceAll() throws IOException {
        return this.backspace(Integer.MAX_VALUE);
    }

    private final int backspace(int num) throws IOException {
        if (this.buf.cursor == 0) {
            return 0;
        }
        int count = 0;
        count = this.moveCursor(-1 * num) * -1;
        this.buf.buffer.delete(this.buf.cursor, this.buf.cursor + count);
        this.drawBuffer(count);
        return count;
    }

    public final boolean backspace() throws IOException {
        return this.backspace(1) == 1;
    }

    private final boolean moveToEnd() throws IOException {
        if (this.moveCursor(1) == 0) {
            return false;
        }
        while (this.moveCursor(1) != 0) {
        }
        return true;
    }

    private final boolean deleteCurrentCharacter() throws IOException {
        this.buf.buffer.deleteCharAt(this.buf.cursor);
        this.drawBuffer(1);
        return true;
    }

    private final boolean previousWord() throws IOException {
        while (this.isDelimiter(this.buf.current()) && this.moveCursor(-1) != 0) {
        }
        while (!this.isDelimiter(this.buf.current()) && this.moveCursor(-1) != 0) {
        }
        return true;
    }

    private final boolean nextWord() throws IOException {
        while (this.isDelimiter(this.buf.current()) && this.moveCursor(1) != 0) {
        }
        while (!this.isDelimiter(this.buf.current()) && this.moveCursor(1) != 0) {
        }
        return true;
    }

    private final boolean deletePreviousWord() throws IOException {
        while (this.isDelimiter(this.buf.current()) && this.backspace()) {
        }
        while (!this.isDelimiter(this.buf.current()) && this.backspace()) {
        }
        return true;
    }

    private final int moveCursor(int num) throws IOException {
        int where = num;
        if (this.buf.cursor == 0 && where < 0) {
            return 0;
        }
        if (this.buf.cursor == this.buf.buffer.length() && where > 0) {
            return 0;
        }
        if (this.buf.cursor + where < 0) {
            where = -this.buf.cursor;
        } else if (this.buf.cursor + where > this.buf.buffer.length()) {
            where = this.buf.buffer.length() - this.buf.cursor;
        }
        this.moveInternal(where);
        return where;
    }

    public static void debug(String str) {
        if (debugger != null) {
            debugger.println(str);
            debugger.flush();
        }
    }

    private final void moveInternal(int where) throws IOException {
        char c;
        this.buf.cursor += where;
        if (where < 0) {
            c = '\b';
        } else {
            if (this.buf.cursor == 0) {
                return;
            }
            c = this.buf.buffer.charAt(this.buf.cursor - 1);
        }
        if (NULL_MASK.equals(this.mask)) {
            return;
        }
        this.printCharacters(c, Math.abs(where));
    }

    public final int readVirtualKey() throws IOException {
        int c = this.terminal.readVirtualKey(this.in);
        if (debugger != null) {
            ConsoleReader.debug("keystroke: " + c + "");
        }
        this.clearEcho(c);
        return c;
    }

    public final int readCharacter(char[] allowed) throws IOException {
        char c;
        Arrays.sort(allowed);
        while (Arrays.binarySearch(allowed, c = (char)this.readVirtualKey()) == -1) {
        }
        return c;
    }

    public void setHistory(History history) {
        this.history = history;
    }

    public History getHistory() {
        return this.history;
    }

    public void setCompletionHandler(CompletionHandler completionHandler) {
        this.completionHandler = completionHandler;
    }

    public CompletionHandler getCompletionHandler() {
        return this.completionHandler;
    }

    public void setEchoCharacter(Character echoCharacter) {
        this.echoCharacter = echoCharacter;
    }

    public Character getEchoCharacter() {
        return this.echoCharacter;
    }

    private void consumeException(Throwable e) {
    }

    private boolean isDelimiter(char c) {
        return !Character.isLetterOrDigit(c);
    }

    public void setUseHistory(boolean useHistory) {
        this.useHistory = useHistory;
    }

    public boolean getUseHistory() {
        return this.useHistory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TreeMap<String, Short> names = new TreeMap<String, Short>();
        names.put("MOVE_TO_BEG", new Short(-1));
        names.put("MOVE_TO_END", new Short(-3));
        names.put("PREV_CHAR", new Short(-4));
        names.put("NEWLINE", new Short(-6));
        names.put("KILL_LINE", new Short(-7));
        names.put("PASTE", new Short(-60));
        names.put("CLEAR_SCREEN", new Short(-8));
        names.put("NEXT_HISTORY", new Short(-9));
        names.put("PREV_HISTORY", new Short(-11));
        names.put("REDISPLAY", new Short(-13));
        names.put("KILL_LINE_PREV", new Short(-15));
        names.put("DELETE_PREV_WORD", new Short(-16));
        names.put("NEXT_CHAR", new Short(-19));
        names.put("REPEAT_PREV_CHAR", new Short(-20));
        names.put("SEARCH_PREV", new Short(-21));
        names.put("REPEAT_NEXT_CHAR", new Short(-24));
        names.put("SEARCH_NEXT", new Short(-25));
        names.put("PREV_SPACE_WORD", new Short(-27));
        names.put("TO_END_WORD", new Short(-29));
        names.put("REPEAT_SEARCH_PREV", new Short(-34));
        names.put("PASTE_PREV", new Short(-36));
        names.put("REPLACE_MODE", new Short(-37));
        names.put("SUBSTITUTE_LINE", new Short(-38));
        names.put("TO_PREV_CHAR", new Short(-39));
        names.put("NEXT_SPACE_WORD", new Short(-40));
        names.put("DELETE_PREV_CHAR", new Short(-41));
        names.put("ADD", new Short(-42));
        names.put("PREV_WORD", new Short(-43));
        names.put("CHANGE_META", new Short(-44));
        names.put("DELETE_META", new Short(-45));
        names.put("END_WORD", new Short(-46));
        names.put("NEXT_CHAR", new Short(-19));
        names.put("INSERT", new Short(-48));
        names.put("REPEAT_SEARCH_NEXT", new Short(-49));
        names.put("PASTE_NEXT", new Short(-50));
        names.put("REPLACE_CHAR", new Short(-51));
        names.put("SUBSTITUTE_CHAR", new Short(-52));
        names.put("TO_NEXT_CHAR", new Short(-53));
        names.put("UNDO", new Short(-54));
        names.put("NEXT_WORD", new Short(-55));
        names.put("DELETE_NEXT_CHAR", new Short(-56));
        names.put("CHANGE_CASE", new Short(-57));
        names.put("COMPLETE", new Short(-58));
        names.put("EXIT", new Short(-59));
        KEYMAP_NAMES = new TreeMap(Collections.unmodifiableMap(names));
        NULL_MASK = new Character('\u0000');
    }
}

