/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.text;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.controller.IdeAction;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareViewBias;
import oracle.javatools.compare.view.CompareDrawer;
import oracle.javatools.compare.view.CompareViewAnnotate;
import oracle.javatools.compare.view.IdeCompareView;
import oracle.javatools.compare.view.IdeCompareViewAnnotate;
import oracle.javatools.compare.view.wedge.WedgeCompareView;
import oracle.jdeveloper.compare.CompareConstants;
import oracle.jdeveloper.history.PatchSupport;
import oracle.jdevimpl.resource.CompareApiArb;

public class TextCompareView
extends WedgeCompareView
implements IdeCompareView {
    public TextCompareView() {
    }

    public TextCompareView(CompareMode mode) {
        super(mode);
    }

    public TextCompareView(CompareMode mode, CompareViewBias bias) {
        super(mode, bias);
    }

    @Override
    public String getTitle() {
        return this.getTitleForType(CompareApiArb.get("SOURCE_COMPARE_TITLE"), IdeCompareViewAnnotate.AnnotateType.TEXT);
    }

    @Override
    public IdeAction[] getToolbarActions() {
        List<IdeAction> patchActions;
        ArrayList<IdeAction> actions = new ArrayList<IdeAction>();
        boolean patch = true;
        for (CompareViewAnnotate annotate : this.getAnnotations()) {
            IdeAction[] ac;
            if (!annotate.canAnnotate() || !(annotate instanceof IdeCompareViewAnnotate)) continue;
            for (IdeAction ia : ac = ((IdeCompareViewAnnotate)annotate).getToolbarActions()) {
                actions.add(ia);
            }
            if (ac.length > 0) {
                actions.add(null);
            }
            if (!patch) continue;
            patch = ((IdeCompareViewAnnotate)annotate).patchSupport();
        }
        actions.add(IdeAction.find((int)CompareConstants.GO_FIRST_CMD_ID));
        actions.add(IdeAction.find((int)CompareConstants.GO_PREVIOUS_CMD_ID));
        actions.add(IdeAction.find((int)CompareConstants.GO_NEXT_CMD_ID));
        actions.add(IdeAction.find((int)CompareConstants.GO_LAST_CMD_ID));
        if (patch && !(patchActions = PatchSupport.getPatchSupport().getToolbarActions()).isEmpty()) {
            actions.add(null);
            actions.addAll(patchActions);
        }
        return actions.toArray(new IdeAction[0]);
    }

    @Override
    public Component[] getToolbarComponents() {
        ArrayList<Component> comps = new ArrayList<Component>();
        for (CompareViewAnnotate annotate : this.getAnnotations()) {
            Component[] comp;
            if (!annotate.canAnnotate() || !(annotate instanceof IdeCompareViewAnnotate)) continue;
            for (Component cp : comp = ((IdeCompareViewAnnotate)annotate).getToolbarComponents()) {
                comps.add(cp);
            }
        }
        return comps.toArray(new Component[0]);
    }

    @Override
    public IdeAction[] getMenuOnlyActions() {
        ArrayList<IdeAction> actions = new ArrayList<IdeAction>();
        for (CompareViewAnnotate annotate : this.getAnnotations()) {
            IdeAction[] ac;
            if (!annotate.canAnnotate() || !(annotate instanceof IdeCompareViewAnnotate)) continue;
            for (IdeAction ia : ac = ((IdeCompareViewAnnotate)annotate).getMenuOnlyActions()) {
                actions.add(ia);
            }
            if (ac.length <= 0) continue;
            actions.add(null);
        }
        return actions.toArray(new IdeAction[0]);
    }

    @Override
    public void saveMergeModel(URL url) throws UnsupportedOperationException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompareDrawer getSecondaryDrawer() {
        throw new UnsupportedOperationException();
    }

    protected String getTitleForType(String title, IdeCompareViewAnnotate.AnnotateType type) {
        CompareViewAnnotate[] annotations;
        for (CompareViewAnnotate annotate : annotations = this.getAnnotations()) {
            if (!(annotate instanceof IdeCompareViewAnnotate) || !annotate.canAnnotate() || ((IdeCompareViewAnnotate)annotate).getStructureTitle(IdeCompareViewAnnotate.AnnotateType.JAVA) == null) continue;
            title = ((IdeCompareViewAnnotate)annotate).getTitle(type);
        }
        return title;
    }
}

