/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.ceditor.find.Bundle;
import oracle.ide.ceditor.find.FindDialog;
import oracle.ide.ceditor.find.FindIncrementalGhost;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.ceditor.find.FindToolbar;
import oracle.ide.ceditor.find.GotoLineDialog;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.find.Find;
import oracle.javatools.editor.find.FindCriteria;
import oracle.javatools.editor.find.FindResult;
import oracle.javatools.editor.find.FindUtils;
import oracle.javatools.editor.find.Finder;
import oracle.javatools.editor.find.Replacer;
import oracle.javatools.util.Copyable;

final class FindController
implements Controller {
    private static FindController INSTANCE;
    private static IdeAction ideSearchAgainAction;
    private static IdeAction ideSearchBackwardAction;
    private static final Integer FIND_NEXT_AT_CURSOR_CMD_ID;
    private static final Integer FIND_PREVIOUS_AT_CURSOR_CMD_ID;
    private GotoLineDialog gotoLiner;
    private FindIncrementalGhost findIncrementalGhost;
    static final String EDITOR_PROPERTY_FIND_CRITERIA = "find-criteria";
    static final String EDITOR_PROPERTY_FIND_RESULT = "find-result";

    private FindController() {
        ideSearchAgainAction = IdeActions.getSearchFindNextAction();
        ideSearchBackwardAction = IdeActions.getSearchFindPreviousAction();
        ideSearchAgainAction.addController((Controller)this);
        ideSearchBackwardAction.addController((Controller)this);
        IdeActions.getSearchFindAction().addController((Controller)this);
        IdeActions.getSearchReplaceAction().addController((Controller)this);
        IdeActions.getNavigateGoToLineAction().addController((Controller)this);
        IdeActions.getSearchIncrementalFindForwardAction().addController((Controller)this);
        IdeActions.getSearchIncrementalFindBackwardAction().addController((Controller)this);
        this.findIncrementalGhost = new FindIncrementalGhost(this);
        this.gotoLiner = new GotoLineDialog();
        FindOptions findOptions = FindOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        Ide.getSettings().putLegacyData("FindOptions", (Copyable)findOptions);
    }

    static FindController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FindController();
        }
        return INSTANCE;
    }

    void dispose() {
        IdeAction.find((int)23).removeController((Controller)this);
        ideSearchAgainAction.removeController((Controller)this);
        ideSearchBackwardAction.removeController((Controller)this);
        IdeAction.find((int)24).removeController((Controller)this);
        IdeAction.find((int)29).removeController((Controller)this);
        IdeAction.find((int)26).removeController((Controller)this);
        IdeAction.find((int)27).removeController((Controller)this);
        this.gotoLiner = null;
        this.findIncrementalGhost = null;
    }

    void updateSearchText(String text) {
        FindController.getFindOptions().setSearchText(text);
        ideSearchAgainAction.updateAction();
        ideSearchBackwardAction.updateAction();
    }

    String getSearchText() {
        return FindController.getFindOptions().getSearchText();
    }

    private static BasicEditorPane getBasicEditorPane(Context context) {
        View view;
        BasicEditorPane ret = null;
        if (context != null && (view = context.getView()) instanceof BasicEditorPaneContainer) {
            BasicEditorPaneContainer findableEditor = (BasicEditorPaneContainer)view;
            ret = findableEditor.getFocusedEditorPane();
        }
        return ret;
    }

    public boolean update(IdeAction action, Context context) {
        boolean canHandle;
        BasicEditorPane editorPane = FindController.getBasicEditorPane(context);
        int cmdId = action.getCommandId();
        if (editorPane == null) {
            return false;
        }
        if (cmdId == 23 || cmdId == FIND_NEXT_AT_CURSOR_CMD_ID || cmdId == FIND_PREVIOUS_AT_CURSOR_CMD_ID || cmdId == 24) {
            canHandle = true;
        } else if (cmdId == 25 || cmdId == 53) {
            String text = this.getSearchText();
            canHandle = text != null && text.length() > 0;
        } else if (cmdId == 29) {
            canHandle = this.gotoLiner.canPerformGotoLine(context);
        } else if (cmdId == 26) {
            canHandle = true;
        } else if (cmdId == 27) {
            canHandle = true;
        } else {
            return false;
        }
        action.setEnabled(canHandle);
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        BasicEditorPane editor = FindController.getBasicEditorPane(context);
        if (editor == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        FindCriteria criteria = (FindCriteria)editor.getProperty(EDITOR_PROPERTY_FIND_CRITERIA);
        if (cmdId == 23) {
            boolean isMenuActiviated = context.getEvent() != null && context.getEvent().getSource() instanceof JMenuItem;
            String text = Utilities.getCurrentWord((BasicEditorPane)editor);
            FindController.getInstance().updateSearchText(text);
            if (isMenuActiviated || !FindToolbar.activateSearch(editor, text)) {
                this.invokeFindDialog(context, editor, false);
            }
        } else if (cmdId == 25) {
            String iString = FindToolbar.getIncrementalSearchString(editor);
            if (iString.length() > 0) {
                this.updateSearchText(iString);
            }
            if (criteria == null) {
                criteria = FindOptions.criteriaFromOptions(editor);
            }
            criteria.setDirection(FindCriteria.Direction.FORWARD);
            criteria.setLocation(editor.getSelectionEnd());
            FindController.find(context, editor, criteria);
        } else if (cmdId == 53) {
            String iString = FindToolbar.getIncrementalSearchString(editor);
            if (iString.length() > 0) {
                this.updateSearchText(iString);
            }
            if (criteria == null) {
                criteria = FindOptions.criteriaFromOptions(editor);
            }
            criteria.setDirection(FindCriteria.Direction.BACKWARD);
            criteria.setLocation(editor.getSelectionStart());
            FindController.find(context, editor, criteria);
        } else if (cmdId == 24) {
            FindOptions options = FindController.getFindOptions();
            String text = Utilities.getCurrentWord((BasicEditorPane)editor);
            options.setSearchText(text);
            this.invokeFindDialog(context, editor, true);
        } else if (cmdId == FIND_NEXT_AT_CURSOR_CMD_ID || cmdId == FIND_PREVIOUS_AT_CURSOR_CMD_ID) {
            FindToolbar is;
            if (criteria == null) {
                criteria = FindOptions.criteriaFromOptions(editor);
            }
            criteria.setRegEx(false);
            if (cmdId == FIND_PREVIOUS_AT_CURSOR_CMD_ID) {
                criteria.setDirection(FindCriteria.Direction.BACKWARD);
            } else {
                criteria.setDirection(FindCriteria.Direction.FORWARD);
            }
            String text = Utilities.getCurrentWord((BasicEditorPane)editor);
            criteria.setText(text);
            FindController.find(context, editor, criteria);
            if (text != null && (is = FindToolbar.getFindToolbar(editor)) != null) {
                is.setSearchFieldText(text);
            }
        } else if (cmdId == 29) {
            this.gotoLiner.performGotoLine(context);
        } else if (cmdId == 26) {
            FindUtils.clearHighlights((BasicEditorPane)editor);
            this.findIncrementalGhost.performISearchForward(context);
        } else if (cmdId == 27) {
            FindUtils.clearHighlights((BasicEditorPane)editor);
            this.findIncrementalGhost.performISearchBackward(context);
        } else {
            return false;
        }
        return true;
    }

    static FindResult find(Context context, BasicEditorPane editor, FindCriteria criteria) {
        Finder finder = new Finder(editor);
        editor.putProperty(EDITOR_PROPERTY_FIND_CRITERIA, (Object)criteria);
        FindResult result = finder.find(criteria);
        editor.putProperty(EDITOR_PROPERTY_FIND_RESULT, (Object)result);
        FindController.updateFindCount(editor, result);
        if (result == null || result.getNext() == null) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            Find find = result.getNext();
            OffsetNavigationPoint point = new OffsetNavigationPoint(context, find.getStartOffset(), find.getEndOffset() - find.getStartOffset());
            NavigationManager navMan = NavigationManager.getNavigationManager();
            try {
                if (navMan != null) {
                    navMan.navigateTo((NavigationPoint)point);
                } else {
                    editor.select(find.getStartOffset(), find.getEndOffset());
                    editor.ensureCaretVisible();
                }
            }
            catch (Exception e) {
                Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
        return result;
    }

    private static void updateFindCount(BasicEditorPane editor, FindResult result) {
        FindToolbar findToolbar = FindToolbar.getFindToolbar(editor);
        if (findToolbar != null) {
            int index;
            int count = result == null ? 0 : result.getFinds().size();
            int n = index = count > 0 ? result.getFinds().indexOf(result.getNext()) + 1 : -1;
            if (count > 0 && result.getNext() == null) {
                if (((Find)result.getFinds().get(0)).getEndOffset() == editor.getCaretPosition()) {
                    index = 1;
                } else if (((Find)result.getFinds().get(result.getFinds().size() - 1)).getEndOffset() == editor.getCaretPosition()) {
                    index = result.getFinds().size();
                }
            }
            findToolbar.setFindCount(count, index);
        }
    }

    void invokeFindDialog(Context context, BasicEditorPane editor, boolean isReplace) {
        FindController.getFindOptions().setSearchSelected(false);
        FindDialog findDialog = new FindDialog();
        if (findDialog.showDialog(editor, isReplace)) {
            FindOptions options;
            FindCriteria criteria = FindOptions.criteriaFromOptions(editor);
            editor.putProperty(EDITOR_PROPERTY_FIND_CRITERIA, (Object)criteria);
            String searchText = criteria.getText();
            FindToolbar findToolbar = FindToolbar.getFindToolbar(editor);
            if (findToolbar != null) {
                findToolbar.setSearchFieldText(searchText);
            }
            if ((options = FindOptions.getInstance((PropertyStorage)Preferences.getPreferences())).getSearchFromBeginning()) {
                criteria.setLocation(0);
            } else if (!criteria.isWrap()) {
                if (criteria.getDirection() == FindCriteria.Direction.FORWARD) {
                    if (findDialog.isReplace()) {
                        criteria.setLocation(editor.getSelectionStart());
                        criteria.setLowerBound(editor.getSelectionStart());
                    } else {
                        criteria.setLocation(editor.getSelectionEnd());
                        criteria.setLowerBound(editor.getSelectionEnd());
                    }
                    criteria.setUpperBound(-1);
                } else if (findDialog.isReplace()) {
                    criteria.setLocation(editor.getSelectionEnd());
                    criteria.setLowerBound(0);
                    criteria.setUpperBound(editor.getSelectionEnd());
                } else {
                    criteria.setLocation(editor.getSelectionEnd());
                    criteria.setLowerBound(0);
                    criteria.setUpperBound(editor.getSelectionStart());
                }
            }
            if (options.getSearchSelected()) {
                criteria.setLowerBound(editor.getSelectionStart());
                criteria.setUpperBound(editor.getSelectionEnd());
            }
            if (findDialog.isReplace()) {
                Replacer.State state = Replacer.replace((BasicEditorPane)editor, (FindCriteria)criteria);
                if (state == Replacer.State.NOT_FOUND) {
                    FindController.showErrorDialog(editor, criteria.getText());
                }
                Finder finder = new Finder(editor);
                criteria = (FindCriteria)editor.getProperty(EDITOR_PROPERTY_FIND_CRITERIA);
                FindResult result = finder.find(criteria);
                editor.putProperty(EDITOR_PROPERTY_FIND_RESULT, (Object)result);
                FindController.updateFindCount(editor, result);
            } else {
                FindController.find(context, editor, criteria);
            }
        }
    }

    static FindOptions getFindOptions() {
        FindOptions ret = FindOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        return ret;
    }

    static void showErrorDialog(BasicEditorPane editor, String searchText) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        String notFoundText = Bundle.format("FD_NOTFOUND", searchText);
        String errorTitle = Bundle.get("FD_RESULT_TITLE");
        MessageDialog.information((Component)editor, (Object)notFoundText, (String)errorTitle, (String)"f1_idedfindreplacenotfound_html");
    }

    static {
        FIND_NEXT_AT_CURSOR_CMD_ID = Ide.findCmdID((String)"oracle.ide.ceditor.find.next");
        FIND_PREVIOUS_AT_CURSOR_CMD_ID = Ide.findCmdID((String)"oracle.ide.ceditor.find.previous");
    }
}

