/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.ceditor.find.Bundle;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.find.FindCriteria;
import oracle.javatools.editor.find.FindUtils;

final class FindDialog {
    private JComboBox findComboBox;
    private JEWTDialog dialog;
    private JCheckBox regexpCheckBox = new JCheckBox();
    private boolean replace = false;

    FindDialog() {
    }

    void setOptionReplace(boolean replace) {
        this.replace = replace;
    }

    boolean isReplace() {
        return this.replace;
    }

    boolean showDialog(BasicEditorPane editor, boolean isReplace) {
        FindOptions findOptions = FindOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        String findText = Bundle.get("FD_FIND_LABEL");
        JLabel findLabel = new JLabel(findText);
        String initialText = findOptions.getSearchText();
        List<String> historyList = findOptions.getSearchHistory();
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(historyList.toArray());
        this.findComboBox = new CappedComboBox(model, 300);
        if (!historyList.contains(initialText)) {
            model.insertElementAt(initialText, 0);
        }
        this.findComboBox.setSelectedItem(initialText);
        this.findComboBox.setEditable(true);
        this.findComboBox.getEditor().selectAll();
        Component findComboBoxEditor = this.findComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)findLabel, (Component)findComboBoxEditor, (String)findText);
        ((JTextComponent)findComboBoxEditor).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FindDialog.this.validateFind();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FindDialog.this.validateFind();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FindDialog.this.validateFind();
            }
        });
        String replaceText = Bundle.get("FD_CHECKBOX_REPLACE");
        final JCheckBox replaceCheckBox = new JCheckBox("", this.replace);
        ResourceUtils.resButton((AbstractButton)replaceCheckBox, (String)replaceText);
        replaceCheckBox.setSelected(isReplace);
        String replaceFieldText = StringUtils.stripMnemonic((String)replaceText);
        List<String> replaceHistory = findOptions.getReplaceHistory();
        final CappedComboBox replaceComboBox = new CappedComboBox(replaceHistory.toArray(), 300);
        replaceComboBox.setEditable(true);
        replaceComboBox.setSelectedItem(findOptions.getReplaceText());
        replaceComboBox.getEditor().selectAll();
        replaceComboBox.getAccessibleContext().setAccessibleName(replaceFieldText);
        ((JTextComponent)replaceComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FindDialog.this.validateFind();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FindDialog.this.validateFind();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FindDialog.this.validateFind();
            }
        });
        JPanel findPanel = new JPanel((LayoutManager)new MigLayout("ins 0 0 4 0, top, fillx", "[grow 0][grow 1]"));
        findPanel.add((Component)findLabel, "");
        findPanel.add((Component)this.findComboBox, "growx, wrap");
        findPanel.add((Component)replaceCheckBox, "");
        findPanel.add((Component)replaceComboBox, "growx");
        String matchCaseText = Bundle.get("FD_CHECKBOX_MATCHCASE");
        JCheckBox caseCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)caseCheckBox, (String)matchCaseText);
        caseCheckBox.setSelected(findOptions.getMatchCase());
        String wholeWordText = Bundle.get("FD_CHECKBOX_WHOLEWORD");
        JCheckBox wordCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)wordCheckBox, (String)wholeWordText);
        wordCheckBox.setSelected(findOptions.getWholeWordOnly());
        String fromStartText = Bundle.get("FD_CHECKBOX_FROMSTART");
        final JCheckBox startCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)startCheckBox, (String)fromStartText);
        startCheckBox.setSelected(findOptions.getSearchFromBeginning());
        String highlightText = Bundle.get("FD_CHECKBOX_HIGHLIGHT");
        JCheckBox highlightCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)highlightCheckBox, (String)highlightText);
        highlightCheckBox.setSelected(findOptions.getHighlightOccurrences());
        String wrapText = Bundle.get("FD_CHECKBOX_WRAP");
        final JCheckBox wrapCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)wrapCheckBox, (String)wrapText);
        wrapCheckBox.setSelected(findOptions.getWrapAround());
        String regexpText = Bundle.get("FD_CHECKBOX_REGEXP");
        ResourceUtils.resButton((AbstractButton)this.regexpCheckBox, (String)regexpText);
        this.regexpCheckBox.setSelected(findOptions.getRegexpSearch());
        String selectedText = Bundle.get("FD_CHECKBOX_SELECTED");
        final JCheckBox selectedCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)selectedCheckBox, (String)selectedText);
        selectedCheckBox.setSelected(findOptions.getSearchSelected());
        String preserveCaseText = Bundle.get("FD_CHECKBOX_PRESERVE_CASE");
        JCheckBox preserveCaseCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)preserveCaseCheckBox, (String)preserveCaseText);
        preserveCaseCheckBox.setSelected(findOptions.getPreserveCase());
        preserveCaseCheckBox.setToolTipText(Bundle.get("FD_CHECKBOX_PRESERVE_CASE_TOOLTIP"));
        String substituteText = Bundle.get("FD_CHECKBOX_SUBSTITUTE");
        JCheckBox substituteCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)substituteCheckBox, (String)substituteText);
        substituteCheckBox.setSelected(findOptions.getSubstituteSpecial());
        substituteCheckBox.setToolTipText(Bundle.get("FD_CHECKBOX_SUBSTITUTE_TOOLTIP"));
        boolean hasSelection = editor.hasSelection();
        if (!hasSelection) {
            selectedCheckBox.setEnabled(false);
            selectedCheckBox.setSelected(false);
        }
        JPanel optionsPanel = new JPanel((LayoutManager)new MigLayout("wrap 1, ins 0 8 0 0, gapy 0, top"));
        String optionsText = Bundle.get("FD_GROUP_OPTIONS");
        TitledBorder optionsBorder = BorderFactory.createTitledBorder(optionsText);
        optionsPanel.setBorder(optionsBorder);
        optionsPanel.add((Component)caseCheckBox, "");
        optionsPanel.add((Component)startCheckBox, "");
        optionsPanel.add((Component)highlightCheckBox, "");
        optionsPanel.add((Component)wrapCheckBox, "");
        optionsPanel.add((Component)wordCheckBox, "");
        optionsPanel.add((Component)this.regexpCheckBox, "");
        optionsPanel.add((Component)selectedCheckBox, "");
        optionsPanel.add((Component)new JLabel(Bundle.get("FD_LABEL_REPLACE_OPTIONS")), "gaptop 6");
        optionsPanel.add((Component)preserveCaseCheckBox, "");
        optionsPanel.add((Component)substituteCheckBox, "");
        String forwardText = Bundle.get("FD_RADIO_FORWARD");
        final JRadioButton forwardRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)forwardRadio, (String)forwardText);
        String backwardText = Bundle.get("FD_RADIO_BACKWARD");
        final JRadioButton backwardRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)backwardRadio, (String)backwardText);
        ButtonGroup directionGroup = new ButtonGroup();
        directionGroup.add(forwardRadio);
        directionGroup.add(backwardRadio);
        JRadioButton selectedRadio = findOptions.getSearchForward() ? forwardRadio : backwardRadio;
        selectedRadio.setSelected(true);
        JPanel directionPanel = new JPanel((LayoutManager)new MigLayout("ins 0 8, top, wrap 1, gapy 0"));
        String directionText = Bundle.get("FD_GROUP_DIRECTION");
        TitledBorder directionBorder = BorderFactory.createTitledBorder(directionText);
        directionPanel.setBorder(directionBorder);
        directionPanel.add(forwardRadio);
        directionPanel.add(backwardRadio);
        String singleText = Bundle.get("FD_RADIO_SINGLE");
        final JRadioButton singleRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)singleRadio, (String)singleText);
        String promptedText = Bundle.get("FD_RADIO_PROMPTED");
        final JRadioButton promptedRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)promptedRadio, (String)promptedText);
        String globalText = Bundle.get("FD_RADIO_GLOBAL");
        final JRadioButton globalRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)globalRadio, (String)globalText);
        ButtonGroup scopeGroup = new ButtonGroup();
        scopeGroup.add(singleRadio);
        scopeGroup.add(promptedRadio);
        scopeGroup.add(globalRadio);
        selectedRadio = findOptions.getScope() == 3 ? globalRadio : (findOptions.getScope() == 2 ? promptedRadio : singleRadio);
        selectedRadio.setSelected(true);
        JPanel scopePanel = new JPanel((LayoutManager)new MigLayout("ins 0 8 0 0, top, gapy 0, wrap 1"));
        String scopeText = Bundle.get("FD_GROUP_SCOPE");
        TitledBorder scopeBorder = BorderFactory.createTitledBorder(scopeText);
        scopePanel.setBorder(scopeBorder);
        scopePanel.add(singleRadio);
        scopePanel.add(promptedRadio);
        scopePanel.add(globalRadio);
        ItemListener tracker = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean replaceActive = replaceCheckBox.isSelected() && replaceCheckBox.isEnabled();
                replaceComboBox.setEnabled(replaceActive);
                singleRadio.setEnabled(replaceActive);
                promptedRadio.setEnabled(replaceActive);
                globalRadio.setEnabled(replaceActive);
                boolean selectedActive = selectedCheckBox.isSelected() && selectedCheckBox.isEnabled();
                startCheckBox.setEnabled(!selectedActive);
                boolean startActive = startCheckBox.isSelected() && startCheckBox.isEnabled();
                boolean enableForwardBackward = !startActive;
                forwardRadio.setEnabled(enableForwardBackward);
                backwardRadio.setEnabled(enableForwardBackward);
                boolean enableWrap = !selectedActive && !startActive;
                wrapCheckBox.setEnabled(enableWrap);
                FindDialog.this.validateFind();
            }
        };
        replaceCheckBox.addItemListener(tracker);
        this.regexpCheckBox.addItemListener(tracker);
        selectedCheckBox.addItemListener(tracker);
        startCheckBox.addItemListener(tracker);
        preserveCaseCheckBox.addItemListener(tracker);
        substituteCheckBox.addItemListener(tracker);
        caseCheckBox.addItemListener(tracker);
        tracker.itemStateChanged(null);
        JPanel mainPanel = new JPanel((LayoutManager)new MigLayout("nogrid, fill, ins 2, top, gapx 0, gapy 0", "", ""));
        mainPanel.add((Component)findPanel, "north");
        mainPanel.add((Component)optionsPanel, "west");
        mainPanel.add((Component)directionPanel, "north");
        mainPanel.add((Component)scopePanel, "north");
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic((JComponent)mainPanel, "f1_idedfindreplacetext_html");
        }
        this.validateFind();
        boolean result = this.runDialog(mainPanel, findComboBoxEditor, isReplace);
        if (result) {
            findOptions.setSearchText((String)this.findComboBox.getEditor().getItem());
            findOptions.setReplaceText((String)replaceComboBox.getEditor().getItem());
            findOptions.setMatchCase(caseCheckBox.isSelected());
            findOptions.setPreserveCase(preserveCaseCheckBox.isSelected());
            findOptions.setSubstituteSpecial(substituteCheckBox.isSelected());
            findOptions.setWholeWordOnly(wordCheckBox.isSelected());
            findOptions.setSearchFromBeginning(startCheckBox.isSelected());
            findOptions.setSearchForward(forwardRadio.isSelected());
            findOptions.setHighlightOccurrences(highlightCheckBox.isSelected());
            findOptions.setWrapAround(wrapCheckBox.isSelected());
            if (hasSelection) {
                findOptions.setSearchSelected(selectedCheckBox.isSelected());
            }
            this.setOptionReplace(replaceCheckBox.isSelected());
            findOptions.setRegexpSearch(this.regexpCheckBox.isSelected());
            if (globalRadio.isSelected()) {
                findOptions.setScope(3);
            } else if (promptedRadio.isSelected()) {
                findOptions.setScope(2);
            } else {
                findOptions.setScope(1);
            }
            String text = (String)this.findComboBox.getEditor().getItem();
            if (text != null && text.length() > 0) {
                findOptions.setSearchText(text);
            }
            if ((text = (String)replaceComboBox.getEditor().getItem()) != null && text.length() > 0) {
                findOptions.setReplaceText(text);
            }
            if (findOptions.getRegexpSearch()) {
                try {
                    FindUtils.getRegExPattern((FindCriteria)FindOptions.criteriaFromOptions());
                }
                catch (PatternSyntaxException patternEx) {
                    this.showInvalidRegexpDialog((Component)editor, patternEx.getPattern(), patternEx.getDescription());
                    return false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runDialog(JComponent content, Component defaultComp, boolean isReplace) {
        boolean canOK;
        String title = isReplace ? Bundle.get("FD_TITLE_REPLACE") : Bundle.get("FD_TITLE");
        this.dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)content, (Component)defaultComp, (String)title);
        String searchText = (String)this.findComboBox.getEditor().getItem();
        boolean bl = canOK = searchText != null && searchText.length() > 0;
        if (this.dialog != null) {
            this.dialog.setOKButtonEnabled(canOK);
        }
        try {
            boolean bl2 = this.dialog.runDialog();
            return bl2;
        }
        finally {
            this.dialog.dispose();
        }
    }

    private void validateFind() {
        if (this.dialog != null) {
            String findText = (String)this.findComboBox.getEditor().getItem();
            this.dialog.setOKButtonEnabled(findText.length() > 0);
            JTextComponent findEditor = (JTextComponent)this.findComboBox.getEditor().getEditorComponent();
            if (this.regexpCheckBox.isSelected()) {
                try {
                    FindUtils.getRegExPattern((FindCriteria)FindOptions.criteriaFromOptions());
                    findEditor.setForeground(UIManager.getColor("ComboBox.foreground"));
                    findEditor.setSelectedTextColor(UIManager.getColor("ComboBox.selectionForeground"));
                }
                catch (PatternSyntaxException patternEx) {
                    findEditor.setForeground(Color.RED);
                    findEditor.setSelectedTextColor(Color.RED);
                }
            } else {
                findEditor.setForeground(UIManager.getColor("ComboBox.foreground"));
                findEditor.setSelectedTextColor(UIManager.getColor("ComboBox.selectionForeground"));
            }
        }
    }

    private void showInvalidRegexpDialog(Component parent, String regexpText, String regexpErrorText) {
        String invalidRegexpText = Bundle.format("FD_INVALID_REGEXP", regexpText, regexpErrorText);
        String errorTitle = Bundle.get("FD_ERROR_TITLE");
        MessageDialog.error((Component)parent, (Object)invalidRegexpText, (String)errorTitle, (String)"f1_idedfindreplaceinvalidregexp_html");
    }

    private static final class CappedComboBox
    extends JComboBox {
        private int maxWidth;

        private CappedComboBox(ComboBoxModel model, int maxWidth) {
            super(model);
            this.maxWidth = maxWidth;
        }

        private CappedComboBox(Object[] items, int maxWidth) {
            super(items);
            this.maxWidth = maxWidth;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension prefSize = new Dimension();
            Dimension defaultPrefSize = super.getPreferredSize();
            prefSize.height = defaultPrefSize.height;
            prefSize.width = Math.min(this.maxWidth, defaultPrefSize.width);
            return prefSize;
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension maxSize = new Dimension();
            Dimension defaultMaxSize = super.getMaximumSize();
            maxSize.height = defaultMaxSize.height;
            maxSize.width = Math.min(this.maxWidth, defaultMaxSize.width);
            return maxSize;
        }
    }
}

