/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultFocusManager;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.find.Bundle;
import oracle.ide.ceditor.find.FindController;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.ceditor.find.FindToolbarOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controls.Toolbar;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.find.FindCriteria;
import oracle.javatools.editor.find.FindUtils;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.internal.Exceptions;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class FindToolbar
implements EditorPlugin {
    private static final String INCREMENTAL_SEARCH_PROPERTY = "incremental_search_property";
    private Listeners _listeners = new Listeners();
    private BasicEditorPane _editor;
    private SearchField _searchField;
    private int _searchLocation = 0;
    private int _lowerBound = -1;
    private int _upperBound = -1;
    private Popup _notFoundPopup;
    private FindToolbarOptions _optionPopup;
    private Action _showOptionsAction;

    static boolean activateSearch(BasicEditorPane editor, String text) {
        JTextField textField;
        FindToolbar incrementalSearch = FindToolbar.getFindToolbar(editor);
        if (incrementalSearch != null && (textField = FindToolbar.getTextField((Container)incrementalSearch._searchField)).isShowing() && editor == DefaultFocusManager.getCurrentManager().getPermanentFocusOwner()) {
            if (text != null) {
                incrementalSearch._searchField.setText(text, false);
            }
            textField.requestFocus();
            return true;
        }
        return false;
    }

    static FindToolbar getFindToolbar(BasicEditorPane editorPane) {
        return (FindToolbar)editorPane.getProperty(INCREMENTAL_SEARCH_PROPERTY);
    }

    static String getIncrementalSearchString(BasicEditorPane editorPane) {
        FindToolbar incrementalSearch = FindToolbar.getFindToolbar(editorPane);
        if (incrementalSearch != null && incrementalSearch._searchField.isShowing() && incrementalSearch._searchField.getText().length() > 0) {
            return incrementalSearch._searchField.getText();
        }
        return "";
    }

    private void whenInvokeFindDialog(BasicEditorPane editorPane) {
        FindController findController = FindController.getInstance();
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)editorPane);
        if (codeEditor != null) {
            Context context = codeEditor.getContext();
            findController.invokeFindDialog(context, editorPane, false);
            this._editor.requestFocus();
        }
    }

    private static JTextField getTextField(Container parent) {
        if (parent instanceof JTextField) {
            JTextField jTextField = (JTextField)parent;
            return jTextField;
        }
        Component[] children = parent.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Container container;
            JTextField textField;
            Component child = children[i];
            if (!(child instanceof Container) || (textField = FindToolbar.getTextField(container = (Container)child)) == null) continue;
            return textField;
        }
        return null;
    }

    private void navigate(String searchText) {
        if (searchText.length() == 0) {
            return;
        }
        FindCriteria criteria = FindOptions.criteriaFromOptions(this._editor);
        criteria.setText(searchText);
        criteria.setLocation(criteria.getDirection() == FindCriteria.Direction.FORWARD ? this._editor.getSelectionEnd() : this._editor.getSelectionStart());
        if (!criteria.isWrap()) {
            if (criteria.getDirection() == FindCriteria.Direction.FORWARD) {
                criteria.setLowerBound(this._searchLocation);
                criteria.setUpperBound(this._editor.getDocument().getLength());
            } else {
                criteria.setLowerBound(0);
                criteria.setUpperBound(this._editor.getSelectionEnd());
            }
        }
        if (this._editor.hasSelection()) {
            this._lowerBound = this._editor.getSelectionStart();
            this._upperBound = this._editor.getSelectionEnd();
        } else {
            this._lowerBound = -1;
            this._upperBound = -1;
        }
        if (FindOptions.getInstance((PropertyStorage)Preferences.getPreferences()).getSearchSelected()) {
            if (this._lowerBound != -1) {
                criteria.setLowerBound(this._lowerBound);
            }
            if (this._upperBound != -1) {
                criteria.setUpperBound(this._upperBound);
            }
        }
        criteria.setLocation(this._searchLocation);
        Context context = CodeEditor.getContext((BasicEditorPane)this._editor);
        FindController.find(context, this._editor, criteria);
        FindController findController = FindController.getInstance();
        findController.updateSearchText(searchText);
        this.updateSearchActions();
    }

    private void updateSearchActions() {
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)this._editor);
        codeEditor.updateVisibleActions();
    }

    private void findNext(boolean forward) {
        String text = this._searchField.getText();
        if (text.length() == 0) {
            return;
        }
        FindOptions findOptions = FindController.getFindOptions();
        findOptions.setSearchText(text);
        FindCriteria criteria = (FindCriteria)this._editor.getProperty("find-criteria");
        if (criteria == null) {
            criteria = FindOptions.criteriaFromOptions(this._editor);
        }
        criteria.setLocation(forward ? this._editor.getSelectionEnd() : this._editor.getSelectionStart());
        criteria.setDirection(forward ? FindCriteria.Direction.FORWARD : FindCriteria.Direction.BACKWARD);
        Context context = CodeEditor.getContext((BasicEditorPane)this._editor);
        FindController.find(context, this._editor, criteria);
    }

    private void showOptionPanel() {
        this._searchField.requestFocus();
        this._optionPopup = new FindToolbarOptions(this._editor);
        this._searchField.setCategoriesPopup((JPopupMenu)this._optionPopup);
        InputMap inputMap = this._optionPopup.getInputMap(1);
        ActionMap actionMap = this._optionPopup.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(40, 8), "showOptions");
        inputMap.put(KeyStroke.getKeyStroke(38, 8), "showOptions");
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "showOptions");
        actionMap.put("showOptions", this._showOptionsAction);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancelOptions");
        actionMap.put("cancelOptions", new MyAction('o'));
        if (this._optionPopup.isShowing()) {
            this._optionPopup.setVisible(false);
            this._optionPopup.saveOptions();
            this._searchField.requestFocus();
            return;
        }
        this._optionPopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.update(true);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.update(false);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            private void update(boolean searchAgain) {
                FindToolbar.this._optionPopup.removePopupMenuListener(this);
                FindToolbar.this._optionPopup.saveOptions();
                if (searchAgain) {
                    String searchText = FindToolbar.this._searchField.getText();
                    try {
                        FindToolbar.this.navigate(searchText);
                    }
                    catch (ExpiredTextBufferException expiredTextBufferException) {
                        // empty catch block
                    }
                }
                FindToolbar.this.validateRegExp();
            }
        });
        this._optionPopup.show((Component)this._searchField, 3, this._searchField.getHeight() + 3);
    }

    private void hideOptionPanel() {
        JTextField textField = FindToolbar.getTextField((Container)this._searchField);
        textField.requestFocus();
    }

    private void whenAccept() {
        FindOptions findOptions = FindController.getFindOptions();
        String searchedText = this._searchField.getText();
        if (searchedText.length() > 0) {
            findOptions.setSearchText(searchedText);
        }
        this._editor.requestFocus();
        this.updateSearchActions();
    }

    private void whenCancel() {
        if (this._notFoundPopup == null) {
            FindUtils.clearHighlights((BasicEditorPane)this._editor);
            this._editor.requestFocus();
            this.updateSearchActions();
        }
    }

    private void whenSearchEnds() {
        if (this._optionPopup != null) {
            this._optionPopup.setVisible(false);
        }
    }

    public void install(BasicEditorPane editor) {
        Toolbar toolbar;
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)editor);
        if (codeEditor != null && (toolbar = codeEditor.getToolbar()) != null) {
            this._showOptionsAction = new MyAction('O');
            this._showOptionsAction.putValue("SmallIcon", OracleIcons.getIcon((String)"find.png"));
            KeyStroke keyStroke = KeyStroke.getKeyStroke("alt DOWN");
            this._showOptionsAction.putValue("AcceleratorKey", keyStroke);
            String tooltip = MessageFormat.format(Bundle.get("FD_TOOLBAR_OPTIONS_HINT"), KeyUtil.toString((KeyStroke)keyStroke));
            this._showOptionsAction.putValue("ShortDescription", tooltip);
            this._searchField = new SearchField();
            this._searchField.setStyle(SearchField.Style.FIND);
            this._searchField.setAutoFind(true);
            Listeners listeners = this._listeners;
            this._searchField.addSearchListener((SearchListener)listeners);
            this._searchField.setPopDownAction(this._showOptionsAction);
            this._searchField.setPrompt(Bundle.get("FD_TOOLBAR_PROMPT"));
            JTextField textField = FindToolbar.getTextField((Container)this._searchField);
            InputMap inputMap = textField.getInputMap(0);
            ActionMap actionMap = textField.getActionMap();
            MyAction cancelAction = new MyAction('C');
            inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelAction);
            actionMap.put(cancelAction, cancelAction);
            actionMap.put(this._showOptionsAction, this._showOptionsAction);
            textField.addFocusListener(listeners);
            Dimension preferredSize = this._searchField.getPreferredSize();
            this._searchField.setMaximumSize(new Dimension(270, preferredSize.height));
            this._searchField.setPreferredSize(new Dimension(Math.max(preferredSize.width, 270), preferredSize.height));
            this._searchField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FindToolbar.this.validateRegExp();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FindToolbar.this.validateRegExp();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    FindToolbar.this.validateRegExp();
                }
            });
            toolbar.add((Component)this._searchField, 0);
            toolbar.addComponentListener((ComponentListener)this._listeners);
            codeEditor.addViewListener((ViewListener)this._listeners);
            editor.addCaretListener((CaretListener)this._listeners);
            this._editor = editor;
            editor.putProperty(INCREMENTAL_SEARCH_PROPERTY, (Object)this);
        }
    }

    public void deinstall(BasicEditorPane editor) {
        this.hideOptionPanel();
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)editor);
        if (codeEditor != null) {
            Toolbar toolbar = codeEditor.getToolbar();
            if (toolbar != null) {
                toolbar.remove((Component)this._searchField);
                toolbar.removeComponentListener((ComponentListener)this._listeners);
            }
            codeEditor.removeViewListener((ViewListener)this._listeners);
        }
        editor.removeCaretListener((CaretListener)this._listeners);
        editor.putProperty(INCREMENTAL_SEARCH_PROPERTY, null);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private void validateRegExp() {
        FindOptions findOptions = FindController.getFindOptions();
        if (findOptions.getRegexpSearch()) {
            try {
                FindCriteria criteria = FindOptions.criteriaFromOptions(this._editor);
                criteria.setText(this._searchField.getText());
                FindUtils.getRegExPattern((FindCriteria)criteria);
                this._searchField.setForeground(UIManager.getColor("ComboBox.foreground"));
            }
            catch (PatternSyntaxException patternEx) {
                this._searchField.setForeground(Colors.FIELD_ERROR_TEXT);
            }
        } else {
            this._searchField.setForeground(UIManager.getColor("ComboBox.foreground"));
        }
    }

    void setSearchFieldText(String text) {
        this._searchField.setText(text, true);
    }

    void setFindCount(int count, int index) {
        this._searchField.setInfoText(index > 0 ? Bundle.format("FD_FIND_COUNT", index, count) : Bundle.format("FD_FIND_COUNT", 0, 0));
    }

    private class MyAction
    extends AbstractAction {
        private char _type;

        public MyAction(char type) {
            this._type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (this._type) {
                case 'A': {
                    FindToolbar.this.whenAccept();
                    break;
                }
                case 'C': {
                    FindToolbar.this.whenCancel();
                    break;
                }
                case 'O': {
                    FindToolbar.this.showOptionPanel();
                    break;
                }
                case 'o': {
                    FindToolbar.this.showOptionPanel();
                }
            }
        }
    }

    private class Listeners
    implements SearchListener,
    FocusListener,
    PropertyChangeListener,
    ViewListener,
    ComponentListener,
    CaretListener {
        private int _hasGlobalFocusListener;

        private Listeners() {
        }

        private void installFocusListener() {
            ++this._hasGlobalFocusListener;
            KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            currentKeyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this);
        }

        private void deinstallFocusListener() {
            KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            currentKeyboardFocusManager.removePropertyChangeListener("permanentFocusOwner", this);
            --this._hasGlobalFocusListener;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Component focusedComponent;
            String propertyName = evt.getPropertyName();
            if ("permanentFocusOwner".equals(propertyName) && (focusedComponent = (Component)evt.getNewValue()) != null) {
                boolean isInSearchFields = false;
                if (SwingUtilities.isDescendingFrom(focusedComponent, (Component)FindToolbar.this._searchField)) {
                    isInSearchFields = true;
                } else if (FindToolbar.this._optionPopup != null && SwingUtilities.isDescendingFrom(focusedComponent, FindToolbar.this._optionPopup)) {
                    isInSearchFields = true;
                }
                if (!isInSearchFields) {
                    this.deinstallFocusListener();
                    FindToolbar.this.whenSearchEnds();
                }
            }
        }

        public void searchPerformed(SearchEvent se) {
            if (FindToolbar.this._searchField.getText().length() == 0) {
                FindToolbar.this._searchField.setInfoText("");
                FindUtils.clearHighlights((BasicEditorPane)FindToolbar.this._editor);
            }
            try {
                if (se.isTriggeredByKeypress()) {
                    FindToolbar.this._searchLocation = FindToolbar.this._editor.getSelectionStart();
                    String searchText = se.getSearchText();
                    FindToolbar.this.navigate(searchText);
                } else {
                    SearchEvent.Direction direction = se.getDirection();
                    FindToolbar.this.findNext(direction == SearchEvent.Direction.FORWARD);
                }
            }
            catch (ExpiredTextBufferException e) {
                Exceptions.swallow((Throwable)e);
            }
        }

        public void searchCategoryChanged(SearchEvent se) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            JTextField textField = FindToolbar.getTextField((Container)FindToolbar.this._searchField);
            textField.selectAll();
            CodeEditor.updateToolbarActions((Toolbar)Ide.getToolbar());
            CodeEditor ce = CodeEditor.getCodeEditor((BasicEditorPane)FindToolbar.this._editor);
            if (ce != null) {
                ce.updateVisibleActions();
                if (this._hasGlobalFocusListener == 0) {
                    this.installFocusListener();
                }
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getOppositeComponent() == FindToolbar.this._editor) {
                CodeEditor.updateToolbarActions((Toolbar)Ide.getToolbar());
                CodeEditor ce = CodeEditor.getCodeEditor((BasicEditorPane)FindToolbar.this._editor);
                if (ce != null) {
                    ce.updateVisibleActions();
                }
            }
        }

        public void viewActivated(ViewEvent e) {
        }

        public void viewDeactivated(ViewEvent e) {
        }

        public void viewClosed(ViewEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            FindOptions.getInstance((PropertyStorage)Preferences.getPreferences()).setSearchSelected(false);
        }
    }
}

