/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.ceditor.find.Bundle;
import oracle.ide.ceditor.find.FindController;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.controller.IdeAction;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.find.FindResult;
import oracle.javatools.editor.find.FindUtils;
import oracle.javatools.ui.JCheckBoxMenuItemNoClose;

class FindToolbarOptions
extends JPopupMenu {
    private AbstractButton _matchCase;
    private AbstractButton _wrap;
    private AbstractButton _backward;
    private AbstractButton _wholeWord;
    private AbstractButton _highlight;
    private AbstractButton _regexp;
    private AbstractButton _selected;
    private AbstractButton _dialog;

    FindToolbarOptions(final BasicEditorPane editor) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.WHITE);
        this._matchCase = this.buildCheckBox(Bundle.get("ISEARCH_OPTION_MATCH_CASE"));
        this._wholeWord = this.buildCheckBox(Bundle.get("ISEARCH_OPTION_WHOLE_WORD"));
        this._highlight = this.buildCheckBox(Bundle.get("ISEARCH_OPTION_HIGHLIGHT_ALL"));
        this._regexp = this.buildCheckBox(Bundle.get("ISEARCH_OPTION_REGEXP"));
        this._selected = this.buildCheckBox(Bundle.get("ISEARCH_OPTION_SELECTED"));
        this._wrap = this.buildCheckBox(Bundle.get("ISEARCH_OPTION_WRAP"));
        this._backward = this.buildCheckBox(Bundle.get("ISEARCH_OPTION_BACKWARD"));
        this.buildDialogChoice();
        this.add(this._matchCase);
        this.add(this._wholeWord);
        this.add(this._highlight);
        this.add(this._regexp);
        this.add(this._selected);
        this.add(this._wrap);
        this.add(this._backward);
        this.addSeparator();
        this.add(this._dialog);
        this._selected.setEnabled(editor.hasSelection());
        this._highlight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FindToolbarOptions.this._highlight.isSelected()) {
                    FindResult result = (FindResult)editor.getProperty("find-result");
                    if (result != null && result.getFinds() != null) {
                        FindUtils.highlight((BasicEditorPane)editor, (List)result.getFinds());
                    } else {
                        FindUtils.clearHighlights((BasicEditorPane)editor);
                    }
                } else {
                    FindUtils.clearHighlights((BasicEditorPane)editor);
                }
            }
        });
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                FindToolbarOptions.this.loadOptions();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                FindToolbarOptions.this.saveOptions();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private void buildDialogChoice() {
        this._dialog = new JMenuItem();
        ResourceUtils.resButton((AbstractButton)this._dialog, (String)Bundle.get("ISEARCH_OPTION_DIALOG"));
        this._dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    IdeAction.get((int)23).performAction();
                }
                catch (Exception f) {
                    Logger.getLogger("global").log(Level.SEVERE, f.getLocalizedMessage());
                }
            }
        });
    }

    private JCheckBoxMenuItem buildCheckBox(String label) {
        JCheckBoxMenuItemNoClose ret = new JCheckBoxMenuItemNoClose();
        ResourceUtils.resButton((AbstractButton)ret, (String)label);
        return ret;
    }

    private void loadOptions() {
        FindOptions findOptions = FindController.getFindOptions();
        this._matchCase.setSelected(findOptions.getMatchCase());
        this._wholeWord.setSelected(findOptions.getWholeWordOnly());
        this._highlight.setSelected(findOptions.getHighlightOccurrences());
        this._regexp.setSelected(findOptions.getRegexpSearch());
        this._selected.setSelected(findOptions.getSearchSelected());
        this._wrap.setSelected(findOptions.getWrapAround());
        this._backward.setSelected(!findOptions.getSearchForward());
    }

    void saveOptions() {
        FindOptions findOptions = FindController.getFindOptions();
        findOptions.setMatchCase(this._matchCase.isSelected());
        findOptions.setWholeWordOnly(this._wholeWord.isSelected());
        findOptions.setHighlightOccurrences(this._highlight.isSelected());
        findOptions.setRegexpSearch(this._regexp.isSelected());
        findOptions.setSearchSelected(this._selected.isSelected());
        findOptions.setWrapAround(this._wrap.isSelected());
        findOptions.setSearchForward(!this._backward.isSelected());
    }
}

