/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EnumSet;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.ceditor.find.Bundle;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.help.HelpSystem;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.GhostPaletteUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.ghost.GhostBuilder;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;

final class GotoLineDialog {
    private static boolean OFFSETS_UI = Boolean.getBoolean("ceditor.offsets.ui");
    private boolean offsetMode;
    private Context context;
    private GhostBuilder.GhostBuiltPalette gp;
    private JLabel errorLabel;

    GotoLineDialog() {
    }

    public void performGotoLine(Context context) {
        this.context = context;
        BasicEditorPane editor = ((BasicEditorPaneContainer)context.getView()).getFocusedEditorPane();
        int position = editor.getCaretPosition();
        BasicDocument document = (BasicDocument)editor.getDocument();
        LineMap lineMap = document.getLineMap();
        int line = lineMap.getLineFromOffset(position) + 1;
        this.showDialog(editor, line, position);
    }

    private void goToLine(int requestedLine) {
        BasicEditorPane editor = ((BasicEditorPaneContainer)this.context.getView()).getFocusedEditorPane();
        BasicDocument document = (BasicDocument)editor.getDocument();
        LineMap lineMap = document.getLineMap();
        if (this.offsetMode) {
            int newOffset = requestedLine;
            if (newOffset >= 0 && newOffset < document.getLength()) {
                NavigationManager mgr = NavigationManager.getNavigationManager();
                OffsetNavigationPoint point = new OffsetNavigationPoint(this.context, newOffset, 0);
                try {
                    if (mgr != null) {
                        mgr.navigateTo((NavigationPoint)point);
                    } else {
                        point.navigate();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.gp.fadeInOut(false);
                editor.requestFocus();
            } else {
                this.errorLabel.setText(Bundle.get("GOTOLINE_OFFSET_DIALOG_BADLINE"));
                this.errorLabel.setVisible(true);
            }
        } else {
            int newLine = requestedLine;
            if (newLine > 0 && newLine <= lineMap.getLineCount()) {
                int lineStart = lineMap.getLineStartOffset(--newLine);
                NavigationManager mgr = NavigationManager.getNavigationManager();
                OffsetNavigationPoint point = new OffsetNavigationPoint(this.context, lineStart, 0);
                try {
                    if (mgr != null) {
                        mgr.navigateTo((NavigationPoint)point);
                    } else {
                        point.navigate();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.gp.fadeInOut(false);
                editor.requestFocus();
            } else {
                this.errorLabel.setText(Bundle.get("GOTOLINE_DIALOG_BADLINE"));
                this.errorLabel.setVisible(true);
            }
        }
    }

    public boolean canPerformGotoLine(Context context) {
        return true;
    }

    private void showDialog(BasicEditorPane editor, final int currentLine, final int currentOffset) {
        final JPanel gotoPanel = new JPanel((LayoutManager)new MigLayout("nogrid, ins 2 4 0 2"));
        String gotoTitle = Bundle.get("GOTOLINE_DIALOG_TITLE");
        final String lineText = Bundle.get("GOTOLINE_DIALOG_LABEL");
        final String offsetText = Bundle.get("GOTOLINE_OFFSET_DIALOG_LABEL");
        final JLabel gotoLabel = new JLabel();
        final WholeNumberField gotoField = new WholeNumberField(currentLine, 6);
        gotoField.selectAll();
        ResourceUtils.resLabel((JLabel)gotoLabel, (Component)gotoField, (String)(this.offsetMode ? offsetText : lineText));
        this.gp = GhostBuilder.build(EnumSet.of(GhostBuilder.Features.LOOK_LIGHT, GhostBuilder.Features.HELP_BUTTON, GhostBuilder.Features.GO_BUTTON, GhostBuilder.Features.HELP_BUTTON), (JComponent)gotoPanel, (String)gotoTitle);
        this.gp.setOwningComponent((JComponent)editor);
        this.gp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() == "HELP_ACTION_CMD") {
                    HelpSystem.getHelpSystem().showHelp((JComponent)gotoPanel);
                } else if (e.getActionCommand() == "OK_ACTION_CMD") {
                    try {
                        GotoLineDialog.this.goToLine(gotoField.getValue());
                    }
                    catch (NullPointerException npe) {
                        GotoLineDialog.this.goToLine(-1);
                    }
                }
            }
        });
        this.errorLabel = new JLabel();
        this.errorLabel.setForeground(Colors.HINT_TEXT);
        this.errorLabel.putClientProperty(UIConstants.VETO_CONVERSION, true);
        this.errorLabel.setVisible(false);
        gotoPanel.add((Component)gotoLabel, "");
        gotoPanel.add((Component)gotoField, "");
        gotoPanel.add((Component)this.gp.getOKButton(), "wrap");
        gotoPanel.add((Component)this.gp.getHelpButton(), "");
        gotoPanel.add(Box.createHorizontalGlue(), "growx");
        gotoPanel.add((Component)this.errorLabel, "right");
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic((JComponent)this.gp, "f1_idedgotolinenum_html");
        }
        gotoField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                GotoLineDialog.this.errorLabel.setVisible(false);
                if (OFFSETS_UI) {
                    if (e.getKeyChar() != 'o') {
                        return;
                    }
                    GotoLineDialog.this.offsetMode = !GotoLineDialog.this.offsetMode;
                    ResourceUtils.resLabel((JLabel)gotoLabel, (Component)gotoField, (String)(GotoLineDialog.this.offsetMode ? offsetText : lineText));
                    gotoField.setValue(GotoLineDialog.this.offsetMode ? currentOffset : currentLine);
                    gotoField.selectAll();
                    gotoPanel.revalidate();
                }
            }
        });
        this.gp.pack();
        GhostPaletteUtil.show((GhostPalette)this.gp, (String)"ide.go.to.line", (boolean)true);
    }
}

