/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.saveactions;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.FocusManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.saveactions.SaveActionsOptions;
import oracle.ide.cmd.SaveCommandListener;
import oracle.ide.cmd.SaveCommandsManger;
import oracle.ide.config.Preferences;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ideimpl.ceditor.saveactions.SaveActionDescription;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

public final class SaveActionsPlugin
implements EditorPlugin,
SaveCommandListener {
    private static boolean isExecuting = false;
    private Map<Node, CodeEditor> openNodes = new ConcurrentHashMap<Node, CodeEditor>();
    private static final SaveActionsPlugin _INSTANCE = new SaveActionsPlugin();

    private SaveActionsPlugin() {
    }

    public static final SaveActionsPlugin getInstance() {
        return _INSTANCE;
    }

    public void registerSaveCommandListener() {
        SaveCommandsManger.registerSaveCommandListener((SaveCommandListener)this);
    }

    public void install(BasicEditorPane editor) {
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)editor);
        Node node = codeEditor.getContext().getNode();
        this.openNodes.put(node, codeEditor);
    }

    public void deinstall(BasicEditorPane editor) {
        Node node = CodeEditor.getCodeEditor((BasicEditorPane)editor).getContext().getNode();
        this.openNodes.remove(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSaveActions(Node node) {
        block9: {
            if (isExecuting) {
                return;
            }
            Context context = new Context(this.openNodes.get(node).getContext());
            context.setBoolean("NavigationManager.VETO_NAVIGATION", Boolean.TRUE.booleanValue());
            try {
                isExecuting = true;
                Editor originalEditor = EditorManager.getEditorManager().getCurrentEditor();
                Component originalFocusComponent = FocusManager.getCurrentManager().getPermanentFocusOwner();
                SaveActionsOptions saOptions = SaveActionsOptions.getInstance((PropertyStorage)Preferences.getPreferences());
                List<SaveActionDescription> currentActions = saOptions.getExecutableSaveActions();
                for (SaveActionDescription desc : currentActions) {
                    Integer cmdId;
                    if (!desc.getExecuteBeforeSave() || (cmdId = Integer.valueOf(Ide.findOrCreateCmdID((String)desc.getId()))) == null) continue;
                    this.doAction(context, cmdId);
                }
                Editor currentEditor = EditorManager.getEditorManager().getCurrentEditor();
                if (originalEditor == currentEditor) break block9;
                for (EditorInfo editorInfo : EditorManager.getEditorManager().getEditorsInfo()) {
                    if (editorInfo._getEditor() != originalEditor) continue;
                    EditorManager.getEditorManager().activateEditor(editorInfo);
                    editorInfo._getEditor().getGUI().requestFocus();
                    if (originalFocusComponent != null) {
                        originalFocusComponent.requestFocus();
                    }
                    break;
                }
            }
            catch (ExpiredTextBufferException expiredTextBufferException) {
            }
            finally {
                isExecuting = false;
            }
        }
    }

    private void doAction(Context context, int commandID) {
        try {
            IdeAction action = IdeAction.get((int)commandID);
            if (action != null) {
                action.updateAction(context);
                if (action.isEnabled()) {
                    action.performAction(context);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isExecuting() {
        return isExecuting;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void nodeWillBeSaved(Node node) {
        if (this.openNodes.containsKey(node)) {
            this.runSaveActions(node);
        }
    }
}

