/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.color;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import oracle.ewt.color.BaseColorEditor;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.spinBox.NumericSpinBox;
import oracle.ewt.spinBox.SpinBoxEvent;
import oracle.ewt.spinBox.SpinBoxListener;
import oracle.ewt.util.StringUtils;

class CMYComponent
extends BaseColorEditor {
    private static final String _SUFFIX = String.valueOf('%');
    private static final Insets _INSETS = new Insets(0, 0, 3, 3);
    private static final String _KEY_CYAN = "COLORCHOOSER.CYAN_LABEL";
    private static final String _KEY_MAGENTA = "COLORCHOOSER.MAGENTA_LABEL";
    private static final String _KEY_YELLOW = "COLORCHOOSER.YELLOW_LABEL";
    private static final String _KEY_CYAN_DESC = "COLORCHOOSER.CYAN_DESCRIPTION";
    private static final String _KEY_MAGENTA_DESC = "COLORCHOOSER.MAGENTA_DESCRIPTION";
    private static final String _KEY_YELLOW_DESC = "COLORCHOOSER.YELLOW_DESCRIPTION";
    private boolean _ignoreEvents;
    private LWLabel _cyanLabel;
    private LWLabel _magentaLabel;
    private LWLabel _yellowLabel;
    private LWLabel _cyanSuffix;
    private LWLabel _magentaSuffix;
    private LWLabel _yellowSuffix;
    private NumericSpinBox _cyan;
    private NumericSpinBox _magenta;
    private NumericSpinBox _yellow;

    public CMYComponent() {
        Listener listener = new Listener();
        this._cyan = new NumericSpinBox(0, 100);
        this._cyan.addSpinBoxListener(listener);
        this._magenta = new NumericSpinBox(0, 100);
        this._magenta.addSpinBoxListener(listener);
        this._yellow = new NumericSpinBox(0, 100);
        this._yellow.addSpinBoxListener(listener);
        this._cyanLabel = new LWLabel("");
        this._cyanLabel.setLabelFor(this._cyan);
        this._cyanSuffix = new LWLabel(_SUFFIX);
        this._magentaLabel = new LWLabel("");
        this._magentaLabel.setLabelFor(this._magenta);
        this._magentaSuffix = new LWLabel(_SUFFIX);
        this._yellowLabel = new LWLabel("");
        this._yellowLabel.setLabelFor(this._yellow);
        this._yellowSuffix = new LWLabel(_SUFFIX);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.insets = _INSETS;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this._cyanLabel, gridBagConstraints);
        this.add(this._cyanLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this._cyan, gridBagConstraints);
        this.add(this._cyan);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this._cyanSuffix, gridBagConstraints);
        this.add(this._cyanSuffix);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this._magentaLabel, gridBagConstraints);
        this.add(this._magentaLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this._magenta, gridBagConstraints);
        this.add(this._magenta);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this._magentaSuffix, gridBagConstraints);
        this.add(this._magentaSuffix);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this._yellowLabel, gridBagConstraints);
        this.add(this._yellowLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this._yellow, gridBagConstraints);
        this.add(this._yellow);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this._yellowSuffix, gridBagConstraints);
        this.add(this._yellowSuffix);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._cyanLabel.setEnabled(bl);
        this._magentaLabel.setEnabled(bl);
        this._yellowLabel.setEnabled(bl);
        this._cyan.setEnabled(bl);
        this._magenta.setEnabled(bl);
        this._yellow.setEnabled(bl);
        this._cyanSuffix.setEnabled(bl);
        this._magentaSuffix.setEnabled(bl);
        this._yellowSuffix.setEnabled(bl);
    }

    @Override
    protected void colorChanged(Color color) {
        this._ignoreEvents = true;
        int[] nArray = ColorUtils.colorToCMY(color);
        this._cyan.setIntValue(nArray[0]);
        this._magenta.setIntValue(nArray[1]);
        this._yellow.setIntValue(nArray[2]);
        this._ignoreEvents = false;
    }

    @Override
    protected void updateLabels(Locale locale) {
        String string = CMYComponent.__getTranslatedString(locale, _KEY_CYAN);
        this._cyanLabel.setText(StringUtils.stripMnemonic(string));
        this._cyanLabel.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        string = CMYComponent.__getTranslatedString(locale, _KEY_MAGENTA);
        this._magentaLabel.setText(StringUtils.stripMnemonic(string));
        this._magentaLabel.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        string = CMYComponent.__getTranslatedString(locale, _KEY_YELLOW);
        this._yellowLabel.setText(StringUtils.stripMnemonic(string));
        this._yellowLabel.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
    }

    @Override
    protected void updateAccessibleNames() {
        String string = this.__getTranslatedString(_KEY_CYAN_DESC);
        this._cyan.getAccessibleContext().setAccessibleName(string);
        string = this.__getTranslatedString(_KEY_YELLOW_DESC);
        this._yellow.getAccessibleContext().setAccessibleName(string);
        string = this.__getTranslatedString(_KEY_MAGENTA_DESC);
        this._magenta.getAccessibleContext().setAccessibleName(string);
    }

    private void _updateColor() {
        int n = this._cyan.getIntValue();
        int n2 = this._magenta.getIntValue();
        int n3 = this._yellow.getIntValue();
        this.storeColor(ColorUtils.cmyToColor(n, n2, n3));
    }

    private class Listener
    implements SpinBoxListener {
        private Listener() {
        }

        @Override
        public void spinBoxValueChanged(SpinBoxEvent spinBoxEvent) {
            if (!CMYComponent.this._ignoreEvents) {
                CMYComponent.this._updateColor();
            }
        }
    }
}

