/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import oracle.ewt.UIManager;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.color.CMYComponent;
import oracle.ewt.color.ColorComponent;
import oracle.ewt.color.ColorEditor;
import oracle.ewt.color.HSBComponent;
import oracle.ewt.color.HSLComponent;
import oracle.ewt.color.HTMLHexComponent;
import oracle.ewt.color.ImageComponent;
import oracle.ewt.color.OLAFDialog;
import oracle.ewt.color.RGBComponent;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;
import oracle.ewt.util.WindowUtils;

public class ColorChooserPane
extends LWComponent
implements Accessible {
    public static final String PROPERTY_COLOR = "color";
    public static final String PROPERTY_COLOR_NAME = "colorName";
    public static final int COLOR_PICKER_RGB = 1;
    public static final int COLOR_PICKER_HSB = 2;
    public static final int COLOR_PICKER_HSL = 4;
    public static final int COLOR_PICKER_HTMLHEX = 8;
    public static final int COLOR_PICKER_CMYK = 16;
    public static final int COLOR_PICKER_CMY = 16;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    private static final String _RESOURCE = "oracle.ewt.color.resource.ColorBundle";
    private static final String _KEY_TITLE = "COLORCHOOSER.TITLE";
    private static final String _KEY_COLOR_NAME = "COLORCHOOSER.COLOR_NAME";
    private static final int _DEFAULT_PICKERS = 11;
    private Listener _listener = new Listener();
    private LWContainer _colorEditorPanel;
    private ColorComponent _colorComponent;
    private ImageComponent _imageComponent = new ImageComponent();
    private HSBComponent _hsbComponent;
    private HSLComponent _hslComponent;
    private RGBComponent _rgbComponent;
    private HTMLHexComponent _htmlComponent;
    private CMYComponent _cmyComponent;
    private LWTextField _colorName;
    private LWLabel _colorNameLabel;
    private LWContainer _colorNameComponent;
    private PropertyChangeSupport _propertyChangeSupport;

    public static int showDialog(Component component, ColorChooserPane colorChooserPane) {
        return ColorChooserPane.showDialog(component, colorChooserPane, null, false);
    }

    public static int showDialog(Component component, ColorChooserPane colorChooserPane, String string, boolean bl) {
        if (colorChooserPane == null) {
            throw new IllegalArgumentException("ColorChooserPane must be non-null");
        }
        OLAFDialog oLAFDialog = new OLAFDialog(WindowUtils.parentFrame(component));
        if (string == null) {
            Locale locale = LocaleUtils.getDefaultableLocale(colorChooserPane);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, LocaleUtils.getTranslationLocale(locale));
            string = resourceBundle.getString(_KEY_TITLE);
        }
        oLAFDialog.setTitle(string);
        oLAFDialog.setContent(colorChooserPane);
        oLAFDialog.setCenterOver(component);
        oLAFDialog.setResizable(bl);
        return oLAFDialog.runDialog() ? 1 : 2;
    }

    public ColorChooserPane() {
        this(Color.black, 11);
    }

    public ColorChooserPane(Color color, int n) {
        this._imageComponent.addPropertyChangeListener(this._listener);
        this._colorComponent = new ColorComponent();
        this._colorComponent.addPropertyChangeListener(this._listener);
        this._colorName = new LWTextField();
        this._colorName.addTextListener(this._listener);
        this._colorNameLabel = new LWLabel("");
        this._colorNameLabel.setLabelFor(this._colorName);
        this._colorNameComponent = new LWContainer();
        this._colorNameComponent.setLayout(new BorderLayout(5, 5));
        this._colorNameComponent.add("West", this._colorNameLabel);
        this._colorNameComponent.add("Center", this._colorName);
        this._hsbComponent = new HSBComponent();
        this._hsbComponent.addPropertyChangeListener(this._listener);
        this._hslComponent = new HSLComponent();
        this._hslComponent.addPropertyChangeListener(this._listener);
        this._rgbComponent = new RGBComponent();
        this._rgbComponent.addPropertyChangeListener(this._listener);
        this._htmlComponent = new HTMLHexComponent();
        this._htmlComponent.addPropertyChangeListener(this._listener);
        this._cmyComponent = new CMYComponent();
        this._cmyComponent.addPropertyChangeListener(this._listener);
        this.setLayout(new BorderLayout(5, 5));
        LWContainer lWContainer = new LWContainer(new BorderLayout(5, 5));
        lWContainer.add("West", this._imageComponent);
        this.add("West", lWContainer);
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setHgap(10);
        this._colorEditorPanel = new LWContainer(flowLayout);
        this._colorEditorPanel.setBorderPainter(UIManager.createGroupBoxPainter(""));
        this._colorEditorPanel.add(this._rgbComponent);
        this._colorEditorPanel.add(this._hsbComponent);
        this._colorEditorPanel.add(this._cmyComponent);
        this._colorEditorPanel.add(this._hslComponent);
        LWContainer lWContainer2 = new LWContainer(new BorderLayout(5, 5));
        lWContainer2.add("Center", this._colorEditorPanel);
        lWContainer2.add("North", this._htmlComponent);
        LWContainer lWContainer3 = new LWContainer(new BorderLayout(5, 5));
        LWContainer lWContainer4 = new LWContainer(new BorderLayout());
        lWContainer4.add("West", this._colorComponent);
        lWContainer3.add("North", lWContainer4);
        lWContainer3.add("Center", lWContainer2);
        lWContainer3.add("South", this._colorNameComponent);
        this.add("East", lWContainer3);
        this.setColorPickerMask(n);
        this.setColor(color);
    }

    public void setColor(Color color) {
        if (color == null) {
            color = Color.black;
        }
        this._updateEditors(null, color, this.getColor());
    }

    public Color getColor() {
        return this._imageComponent.getColor();
    }

    public void setOriginalColor(Color color) {
        this._colorComponent.setOriginalColor(color);
        this._revalidate();
    }

    public Color getOriginalColor() {
        return this._colorComponent.getOriginalColor();
    }

    public void setColorName(String string) {
        this._colorName.setText(string);
    }

    public String getColorName() {
        return this._colorName.getText();
    }

    public void setColorNameVisible(boolean bl) {
        this._colorNameComponent.setVisible(bl);
        this._revalidate();
    }

    public boolean isColorNameVisible() {
        return this._colorNameComponent.isVisible();
    }

    public void setColorPickerMask(int n) {
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (n & 4) != 0;
        boolean bl4 = (n & 8) != 0;
        boolean bl5 = (n & 0x10) != 0;
        Color color = this.getColor();
        this._rgbComponent.setVisible(bl);
        if (bl) {
            this._rgbComponent.setColor(color);
        }
        this._hsbComponent.setVisible(bl2);
        if (bl2) {
            this._hsbComponent.setColor(color);
        }
        this._hslComponent.setVisible(bl3);
        if (bl3) {
            this._hslComponent.setColor(color);
        }
        this._htmlComponent.setVisible(bl4);
        if (bl4) {
            this._htmlComponent.setColor(color);
        }
        this._cmyComponent.setVisible(bl5);
        if (bl5) {
            this._cmyComponent.setColor(color);
        }
        this._colorEditorPanel.setVisible(bl | bl2 | bl3 | bl5);
        this._revalidate();
    }

    public int getColorPickerMask() {
        int n = 0;
        if (this._rgbComponent.isVisible()) {
            n |= 1;
        }
        if (this._hsbComponent.isVisible()) {
            n |= 2;
        }
        if (this._hslComponent.isVisible()) {
            n |= 4;
        }
        if (this._htmlComponent.isVisible()) {
            n |= 8;
        }
        if (this._cmyComponent.isVisible()) {
            n |= 0x10;
        }
        return n;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._imageComponent.getComponent().setEnabled(bl);
        this._colorComponent.getComponent().setEnabled(bl);
        this._colorNameLabel.setEnabled(bl);
        this._colorName.setEnabled(bl);
        this._hsbComponent.getComponent().setEnabled(bl);
        this._hslComponent.getComponent().setEnabled(bl);
        this._rgbComponent.getComponent().setEnabled(bl);
        this._htmlComponent.getComponent().setEnabled(bl);
        this._cmyComponent.getComponent().setEnabled(bl);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._setText(this.getLocale());
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new AccessibleLWComponent(this);
    }

    @Override
    protected void updateLocale(Locale locale, Locale locale2) {
        super.updateLocale(locale, locale2);
        this._setText(locale);
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    private void _revalidate() {
        this.invalidate();
        this.repaint();
    }

    private void _updateEditors(ColorEditor colorEditor, Color color, Color color2) {
        if (colorEditor != this._imageComponent) {
            this._imageComponent.setColor(color);
        }
        if (colorEditor != this._colorComponent) {
            this._colorComponent.setColor(color);
        }
        if (colorEditor != this._hsbComponent && this._hsbComponent.getComponent().isVisible()) {
            this._hsbComponent.setColor(color);
        }
        if (colorEditor != this._hslComponent && this._hslComponent.getComponent().isVisible()) {
            this._hslComponent.setColor(color);
        }
        if (colorEditor != this._rgbComponent && this._rgbComponent.getComponent().isVisible()) {
            this._rgbComponent.setColor(color);
        }
        if (colorEditor != this._htmlComponent && this._htmlComponent.getComponent().isVisible()) {
            this._htmlComponent.setColor(color);
        }
        if (colorEditor != this._cmyComponent && this._cmyComponent.getComponent().isVisible()) {
            this._cmyComponent.setColor(color);
        }
        this.firePropertyChange(PROPERTY_COLOR, color2, color);
    }

    private static String _getTranslatedString(Locale locale, String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, LocaleUtils.getTranslationLocale(locale));
        return resourceBundle.getString(string);
    }

    private void _fireNameChanged(String string) {
        this.firePropertyChange(PROPERTY_COLOR_NAME, "", string);
    }

    private void _setText(Locale locale) {
        String string = ColorChooserPane._getTranslatedString(locale, _KEY_COLOR_NAME);
        this._colorNameLabel.setText(StringUtils.stripMnemonic(string));
        this._colorNameLabel.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
    }

    private class Listener
    implements PropertyChangeListener,
    TextListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (ColorChooserPane.PROPERTY_COLOR.equals(string)) {
                ColorEditor colorEditor = (ColorEditor)propertyChangeEvent.getSource();
                ColorChooserPane.this._updateEditors(colorEditor, (Color)propertyChangeEvent.getNewValue(), (Color)propertyChangeEvent.getOldValue());
            }
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            ColorChooserPane.this._fireNameChanged(ColorChooserPane.this._colorName.getText());
        }
    }
}

