/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeChildManager;
import oracle.ewt.dTree.DTreeDeferredChild;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemFactory;
import oracle.ewt.dTree.DTreeSparseChildManager;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.plaf.TreeUI;

public abstract class DTreeDeferredParent
extends DTreeDeferredChild
implements DTreeDeferringParent {
    private OneDDataSource _datasrc;
    private DTreeChildManager _childmgr;
    private boolean _expanded;

    protected DTreeDeferredParent(OneDDataSource oneDDataSource) {
        this._datasrc = oneDDataSource;
        this._childmgr = null;
    }

    @Override
    public void childExpansionChanged(DTreeItem dTreeItem) {
        this._childmgr.childExpansionChanged(dTreeItem);
    }

    @Override
    public Object getChildData(int n) {
        return this._datasrc.getData(n);
    }

    @Override
    public int getChildHeight() {
        DTree dTree = this.getTree();
        TreeUI treeUI = (TreeUI)dTree.getUI();
        return treeUI.getDeferredChildHeight(dTree, this.getPaintContext(), this, this.getChildIconHeight());
    }

    @Override
    public int getChildX(int n) {
        return this._childmgr.getChildX(n);
    }

    @Override
    public int getChildY(int n) {
        return this._childmgr.getChildY(n);
    }

    @Override
    public OneDDataSource getDataSource() {
        return this._datasrc;
    }

    @Override
    public DTreeItem getItem(int n) {
        if (this._childmgr == null) {
            this._childmgr = this.createChildManager();
        }
        return this._childmgr.getItem(n);
    }

    @Override
    public DTreeItem getItemAt(int n, int n2) {
        return this._childmgr.getItemAt(n, n2);
    }

    @Override
    public int getItemCount() {
        return this._datasrc.getItemCount();
    }

    @Override
    public abstract DTreeItemFactory getItemFactory();

    @Override
    public DTreeItem getNextExpandedChild(DTreeItem dTreeItem) {
        return this._childmgr.getNextExpandedChild(dTreeItem);
    }

    @Override
    public DTreeItem getNextInstantiatedChild(DTreeItem dTreeItem) {
        if (this._childmgr == null) {
            return null;
        }
        return this._childmgr.getNextInstantiatedChild(dTreeItem);
    }

    @Override
    public int getSubTreeHeight() {
        if (this.isExpanded()) {
            return this._childmgr.getSubTreeHeight();
        }
        return this.getSize().height;
    }

    @Override
    public boolean isExpanded() {
        return this._expanded;
    }

    @Override
    public void layout(int n, int n2) {
        this._childmgr.layout(n, n2);
    }

    @Override
    public void setExpanded(boolean bl) {
        if (bl == this.isExpanded()) {
            return;
        }
        DTree dTree = this.getTree();
        if (dTree == null) {
            this._expanded = bl;
        } else if (!dTree.itemExpansionChanging(this, bl)) {
            DTreeDeferringParent dTreeDeferringParent;
            this._expanded = bl;
            if (bl && this._childmgr == null) {
                this._childmgr = this.createChildManager();
            }
            if ((dTreeDeferringParent = this.getDeferringParent()) != null) {
                dTreeDeferringParent.childExpansionChanged(this);
            }
            dTree.itemExpansionChanged(this, bl);
        }
    }

    protected DTreeChildManager createChildManager() {
        return new DTreeSparseChildManager(this);
    }

    protected int getChildIconHeight() {
        return 18;
    }
}

