/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.awt.Component;
import java.awt.Image;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeBaseItem;
import oracle.ewt.dTree.DTreeChildManager;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemFactory;
import oracle.ewt.dTree.DTreeRootItem;
import oracle.ewt.dTree.DTreeSparseChildManager;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.plaf.TreeUI;

public class DTreeDeferringRoot
extends DTreeBaseItem
implements DTreeDeferringParent,
DTreeRootItem {
    private OneDDataSource _datasrc;
    private DTreeItemFactory _factory;
    private DTree _tree;
    private DTreeChildManager _childmgr;
    private String _label;
    private Image _icon;
    private int _y;
    private boolean _expanded;

    public DTreeDeferringRoot(String string, Image image, OneDDataSource oneDDataSource, DTreeItemFactory dTreeItemFactory) {
        this._label = string;
        this._icon = image;
        this._datasrc = oneDDataSource;
        this._factory = dTreeItemFactory;
        this._childmgr = this.createChildManager();
    }

    @Override
    public void childExpansionChanged(DTreeItem dTreeItem) {
        this._childmgr.childExpansionChanged(dTreeItem);
    }

    @Override
    public boolean commitEdit(Component component) {
        this.setLabel(((LWTextField)component).getText());
        return true;
    }

    @Override
    public Object getChildData(int n) {
        return this._datasrc.getData(n);
    }

    @Override
    public int getChildHeight() {
        DTree dTree = this.getTree();
        TreeUI treeUI = (TreeUI)dTree.getUI();
        return treeUI.getDeferredChildHeight(dTree, this.getPaintContext(), this, this.getChildIconHeight());
    }

    @Override
    public int getChildX(int n) {
        return this._childmgr.getChildX(n);
    }

    @Override
    public int getChildY(int n) {
        return this._childmgr.getChildY(n);
    }

    @Override
    public OneDDataSource getDataSource() {
        return this._datasrc;
    }

    @Override
    public Image getIcon() {
        return this._icon;
    }

    @Override
    public DTreeItem getItem(int n) {
        return this._childmgr.getItem(n);
    }

    @Override
    public DTreeItem getItemAt(int n, int n2) {
        return this._childmgr.getItemAt(n, n2);
    }

    @Override
    public int getItemCount() {
        return this._datasrc.getItemCount();
    }

    @Override
    public DTreeItemFactory getItemFactory() {
        return this._factory;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public DTreeItem getNextExpandedChild(DTreeItem dTreeItem) {
        return this._childmgr.getNextExpandedChild(dTreeItem);
    }

    @Override
    public DTreeItem getNextInstantiatedChild(DTreeItem dTreeItem) {
        return this._childmgr.getNextInstantiatedChild(dTreeItem);
    }

    @Override
    public int getSubTreeHeight() {
        if (this.isExpanded()) {
            return this._childmgr.getSubTreeHeight();
        }
        return this.getSize().height;
    }

    @Override
    public DTree getTree() {
        DTreeItem dTreeItem = this.getParent();
        if (dTreeItem != null) {
            return dTreeItem.getTree();
        }
        return this._tree;
    }

    @Override
    public int getY() {
        return this._y;
    }

    @Override
    public boolean isExpanded() {
        return this._expanded;
    }

    @Override
    public void layout(int n, int n2) {
        this._y = n2;
        this._childmgr.layout(n, n2);
    }

    @Override
    public void setExpanded(boolean bl) {
        DTree dTree = this.getTree();
        if (bl == this.isExpanded()) {
            return;
        }
        if (dTree == null) {
            this._expanded = bl;
        } else if (!dTree.itemExpansionChanging(this, bl)) {
            this._expanded = bl;
            dTree.itemExpansionChanged(this, bl);
        }
    }

    public void setIcon(Image image) {
        if (image != this._icon) {
            this._icon = image;
            DTree dTree = this.getTree();
            if (dTree != null) {
                dTree.itemsInvalidated(this.getParent(), this.getIndex(), 1);
            }
        }
    }

    public void setLabel(String string) {
        if (string != this._label) {
            this._label = string;
            DTree dTree = this.getTree();
            if (dTree != null) {
                dTree.itemsInvalidated(this.getParent(), this.getIndex(), 1);
            }
        }
    }

    @Override
    public void setTree(DTree dTree) {
        this._tree = dTree;
    }

    protected DTreeChildManager createChildManager() {
        return new DTreeSparseChildManager(this);
    }

    protected int getChildIconHeight() {
        return 18;
    }
}

